{ ****************************************************************** }
{                                                                    }
{   Thread component demo #5                                         }
{                                                                    }
{   Illustration of coordinated thread components sharing a          }
{   resource that is encapsulated in a TResourceFlag descendant.     }
{                                                                    }
{   For illustration purposes, the TCounterResource component        }
{   treats its counting cycle as a process that only one thread      }
{   can access at a time.                                            }
{                                                                    }
{   The TSharingCounterThread component must be linked to a          }
{   TCounterResource component via its ResourceFlag property.        }
{   TSharingCounterThread calls the WaitForResource and              }
{   DoneWithResource methods to coordinate with any other thread     }
{   components linked to the same TCounterResource component.        }
{                                                                    }
{   On this form, the two TThreadTestPanel components are each       }
{   linked to one of the thread components via their Thread          }
{   properties.  The two TSharingCounterThread components, in turn,  }
{   are both linked to the same TCounterResource component.          }
{                                                                    }
{   The TSharingCounterThread component is a descendant of           }
{   TSharingThread.                                                  }
{   TSharingCounterThread is in unit Counter2.pas, which was         }
{   generated in Component Create from definition file Counter2.cd.  }
{                                                                    }
{   The TCounterResource component is a descendant of TResourceFlag. }
{   TCounterResource is in unit Countres.pas, which was generated    }
{   in Component Create from definition file Countres.cd.            }
{                                                                    }
{   Thread components require Delphi 2.0 or later.                   }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{   Distributed with Thread Component Toolset (tm)                   }
{   A product of Potomac Document Software, Inc.                     }
{   http://www.compcreate.com                                        }
{                                                                    }
{ ****************************************************************** }

unit Th_form5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, ExtCtrls, StdCtrls, Thredtst, Ccthread, Counter2, CountRes;

type
  TForm1 = class(TForm)
    SharingCounterThread1: TSharingCounterThread;
    SharingCounterThread2: TSharingCounterThread;
    ThreadTestPanel1: TThreadTestPanel;
    ThreadTestPanel2: TThreadTestPanel;
    ProgressBar1: TProgressBar;
    ProgressBar2: TProgressBar;
    Label1: TLabel;
    CounterResource1: TCounterResource;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
     if SharingCounterThread1.Running or SharingCounterThread2.Running then
        begin
        ShowMessage('Please terminate the threads by pressing '
                    + 'the "Request Stop" buttons before closing.');
        Action := caNone
        end
end;

end.
