{ ****************************************************************** }
{                                                                    }
{   Thread component demo #4                                         }
{                                                                    }
{   This demo shows the use of a thread component's ExceptionName    }
{   and ExceptionString properties to check for an exception that    }
{   occurred in the component's Execute method, but was not handled  }
{   there.  As the demo illustrates, an exception handler            }
{   (a try...except block) in the application cannot handle          }
{   exceptions raised within the thread's Execute method.            }
{                                                                    }
{   The TPassExceptionThread component is a descendant of TNewThread.}
{   TPassExceptionThread is in unit Except1.pas, which was generated }
{   in Component Create from definition file Except1.cd.             }
{                                                                    }
{   Thread components require Delphi 2.0 or later.                   }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{   Distributed with Thread Component Toolset (tm)                   }
{   A product of Potomac Document Software, Inc.                     }
{   http://www.compcreate.com                                        }
{                                                                    }
{ ****************************************************************** }

unit Th_form4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Ccthread, Except1;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Label2: TLabel;
    PassExceptionThread1: TPassExceptionThread;
    procedure Button1Click(Sender: TObject);
    procedure PassExceptionThread1Terminate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}


procedure TForm1.Button1Click(Sender: TObject);
begin
     try
        { This thread component just raises an exception
          in its Execute method }
        PassExceptionThread1.Start;
     except
        { This handler will not be reached }
        on Exception do Showmessage('Thread exception handled');
     end
end;

procedure TForm1.PassExceptionThread1Terminate(Sender: TObject);
begin
     with PassExceptionThread1 do
          if ExceptionString = '' then
             Showmessage('Thread done without any un-handled exceptions.')
          else
              Showmessage('Exception class name: '
                          + ExceptionName + '; '
                          + 'Exception string: "'
                          + ExceptionString
                          + '"')
end;

end.
