{ ****************************************************************** }
{                                                                    }
{   Thread component demo #2                                         }
{                                                                    }
{   After the user presses the "Load image" button and selects a     }
{   graphics file (BMP, ICO, or EMF), the form starts its            }
{   TGraphicsFileThread component, which loads the file into its     }
{   memory -- an internal TPicture object -- while running as a      }
{   separate thread.  The form's OnTerminate handler for the         }
{   thread component then copies the image into its TImage           }
{   for display.                                                     }
{                                                                    }
{   You can make the multi-threaded nature of this application       }
{   especially evident by loading a large bitmap from a CD-ROM.      }
{                                                                    }
{   The TGraphicsFileThread component is a descendant of TNewThread. }
{   TGraphicsFileThread is in unit Graphthd.pas, which was generated }
{   in Component Create from definition file Graphthd.cd.            }
{                                                                    }
{   Thread components require Delphi 2.0 or later.                   }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{   Distributed with Thread Component Toolset (tm)                   }
{   A product of Potomac Document Software, Inc.                     }
{   http://www.compcreate.com                                        }
{                                                                    }
{ ****************************************************************** }

unit Th_form2;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Ccthread, Graphthd;

type
  TForm1 = class(TForm)
    GraphicsFileThread1: TGraphicsFileThread;
    Button1: TButton;
    Image1: TImage;
    OpenDialog1: TOpenDialog;
    Memo1: TMemo;
    procedure Button1Click(Sender: TObject);
    procedure GraphicsFileThread1Terminate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
     if GraphicsFileThread1.Running then
        begin
        ShowMessage('Graphics file thread is already running.');
        Exit
        end;
     if OpenDialog1.Execute then
        begin
        { Have the thread component load the graphics file }
        GraphicsFileThread1.FileName := OpenDialog1.FileName;
        GraphicsFileThread1.Start
        end
end;

procedure TForm1.GraphicsFileThread1Terminate(Sender: TObject);
begin
     { Copy the image from the thread component to the
       image display component }
     Image1.Picture.Assign(GraphicsFileThread1.Picture)
end;

end.
