{ ****************************************************************** }
{                                                                    }
{   Thread component demo #1                                         }
{                                                                    }
{   Pressing both "Start" buttons shows simultaneous                 }
{   execution of two thread components within application.           }
{                                                                    }
{   The TCounterThread component is a descendant of TNewThread.      }
{   TCounterThread is in unit Counter.pas, which was generated       }
{   in Component Create from definition file Counter.cd.             }
{                                                                    }
{   Thread components require Delphi 2.0 or later.                   }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{   Distributed with Thread Component Toolset (tm)                   }
{   A product of Potomac Document Software, Inc.                     }
{   http://www.compcreate.com                                        }
{                                                                    }
{ ****************************************************************** }

unit th_form1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, ComCtrls, Ccthread, Counter;

type
  TThreadTestForm = class(TForm)
    Panel1: TPanel;
    StartButton1: TButton;
    SuspendButton1: TButton;
    ResumeButton1: TButton;
    StopButton1: TButton;
    Panel2: TPanel;
    StartButton2: TButton;
    SuspendButton2: TButton;
    ResumeButton2: TButton;
    StopButton2: TButton;
    HeaderLabel1: TLabel;
    HeaderLabel2: TLabel;
    ProgressBar1: TProgressBar;
    ProgressBar2: TProgressBar;
    Label1: TLabel;
    Label2: TLabel;
    MyThread2: TCounterThread;
    MyThread1: TCounterThread;
    Memo1: TMemo;
    StatusButton: TButton;
    procedure StartButton1Click(Sender: TObject);
    procedure SuspendButton1Click(Sender: TObject);
    procedure ResumeButton1Click(Sender: TObject);
    procedure StopButton1Click(Sender: TObject);
    procedure MyThread1Terminate(Sender: TObject);
    procedure MyThread2Terminate(Sender: TObject);
    procedure StartButton2Click(Sender: TObject);
    procedure SuspendButton2Click(Sender: TObject);
    procedure ResumeButton2Click(Sender: TObject);
    procedure StopButton2Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure StatusButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  ThreadTestForm: TThreadTestForm;

implementation

{$R *.DFM}

procedure TThreadTestForm.StartButton1Click(Sender: TObject);
begin
     StartButton1.Enabled := False;
     SuspendButton1.Enabled := True;
     ResumeButton1.Enabled := True;
     StopButton1.Enabled := True;
     MyThread1.Start
end;

procedure TThreadTestForm.SuspendButton1Click(Sender: TObject);
begin
     MyThread1.Suspend;
     StopButton1.Enabled := False;
end;

procedure TThreadTestForm.ResumeButton1Click(Sender: TObject);
begin
     MyThread1.Resume;
     StopButton1.Enabled := True;
end;

procedure TThreadTestForm.StopButton1Click(Sender: TObject);
begin
     MyThread1.RequestStop;
     StartButton1.Enabled := True;
     SuspendButton1.Enabled := False;
     ResumeButton1.Enabled := False;
     StopButton1.Enabled := False
end;

procedure TThreadTestForm.MyThread1Terminate(Sender: TObject);
begin
     ShowMessage('Thread #1 terminated')
end;

procedure TThreadTestForm.StartButton2Click(Sender: TObject);
begin
     StartButton2.Enabled := False;
     SuspendButton2.Enabled := True;
     ResumeButton2.Enabled := True;
     StopButton2.Enabled := True;
     MyThread2.Start
end;

procedure TThreadTestForm.SuspendButton2Click(Sender: TObject);
begin
     MyThread2.Suspend;
     StopButton2.Enabled := False;
end;

procedure TThreadTestForm.ResumeButton2Click(Sender: TObject);
begin
     MyThread2.Resume;
     StopButton2.Enabled := True;
end;

procedure TThreadTestForm.StopButton2Click(Sender: TObject);
begin
     MyThread2.RequestStop;
     StartButton2.Enabled := True;
     SuspendButton2.Enabled := False;
     ResumeButton2.Enabled := False;
     StopButton2.Enabled := False
end;

procedure TThreadTestForm.MyThread2Terminate(Sender: TObject);
begin
     ShowMessage('Thread #2 terminated')
end;

procedure TThreadTestForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
     if MyThread1.Running or MyThread2.Running then
        begin
        ShowMessage('Please terminate the threads by pressing '
                    + 'the "Request Stop" buttons before closing.');
        Action := caNone
        end
end;

procedure TThreadTestForm.StatusButtonClick(Sender: TObject);
var
   S1, S2 : String;

   function ThreadStateName(TS : ThreadStateType) : String;
   { Internal function }
   begin
        case TS of
        thdInactive : Result := 'inactive';
        thdSuspended : Result := 'suspended';
        thdActive : Result := 'active'
        end
   end;

begin
     ShowMessage('Thread 1 is '
                 + ThreadStateName(MyThread1.ThreadState)
                 + '.  Thread 2 is '
                 + ThreadStateName(MyThread2.ThreadState)
                 + '.')
end;

end.
