{ ****************************************************************** }
{                                                                    }
{   Delphi component TGraphicsFileThread                             }
{                                                                    }
{   Loads and saves graphics files while running as a separate thread }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\delphi\threads\graphthd.cd         }
{   on 21 Jan 1997 at 14:56                                          }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{ ****************************************************************** }

unit Graphthd;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Ccthread;

{ Unit-wide declarations }
type
    FileOperation = (foLoadImage, foSaveImage);

type
  TGraphicsFileThread = class(TNewThread)
    private
      { Private fields of TGraphicsFileThread }
        FPicture : TPicture;
        FOperation : FileOperation;
        FFileName : String;

      { Private methods of TGraphicsFileThread }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;
        procedure SetPicture(Value : TPicture);

    protected
      { Protected fields of TGraphicsFileThread }

      { Protected methods of TGraphicsFileThread }
        { Termination of thread }
        procedure Terminate(Sender : TObject); override;
        procedure Loaded; override;
        { Method for thread to execute when started }
        procedure Execute(Sender : TObject); override;

    public
      { Public fields and properties of TGraphicsFileThread }

      { Public methods of TGraphicsFileThread }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        procedure Start; override;

    published
      { Published properties of TGraphicsFileThread }
        { Termination of thread }
        property OnTerminate;
        property Picture : TPicture read FPicture write SetPicture;
        { File operation to perform }
        property Operation : FileOperation
             read FOperation write FOperation
             default foLoadImage;
        property FileName : String read FFileName write FFileName;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TGraphicsFileThread with Thread as its
       default page on the Delphi component palette }
     RegisterComponents('Thread', [TGraphicsFileThread]);
end;

{ Method to set variable and property values and create objects }
procedure TGraphicsFileThread.AutoInitialize;
begin
     FPicture := TPicture.Create;
     FOperation := foLoadImage;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TGraphicsFileThread.AutoDestroy;
begin
     FPicture.Free;
end; { of AutoDestroy }

procedure TGraphicsFileThread.SetPicture(Value : TPicture);
begin
     { Use Assign method because TPicture is an object type }
     FPicture.Assign(Value);
end;

{ Termination of thread }
procedure TGraphicsFileThread.Terminate(Sender : TObject);
begin
     inherited Terminate(Sender);
end;

constructor TGraphicsFileThread.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

destructor TGraphicsFileThread.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TGraphicsFileThread.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }

end;

{ Method for thread to execute when started }
procedure TGraphicsFileThread.Execute(Sender : TObject);
begin
     { Call method in parent class }
     inherited Execute(Sender);

     { Code to define component's behavior when thread is running }
     if FOperation = foLoadImage then
        begin
        if FileExists(FFileName) then
           FPicture.LoadFromFile(FileName)
        end
    else
        if FOperation = foSaveImage then
           FPicture.SaveToFile(FileName)
end;

procedure TGraphicsFileThread.Start;
begin
     { Check properties for validity and perform other
       error checking before the thread starts }
     if FFileName = '' then
        raise ThreadError.Create('No file name');

     { Run the Execute method as a separate thread }
     inherited Start;
end;


end.
