{ ****************************************************************** }
{                                                                    }
{   Delphi component TGoodExceptionThread                            }
{                                                                    }
{   Shows handling of exception inside thread                        }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\delphi\threads\except2.cd          }
{   on 25 Jan 1997 at 14:52                                          }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{ ****************************************************************** }

unit Except2;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Ccthread;

type
     ErrorKind = (efNoError, efDivByZero, efFileError, efOtherError);


type
  TGoodExceptionThread = class(TNewThread)
    private
      { Private fields of TGoodExceptionThread }
        { Storage for property ErrorString }
        FErrorString : String;

      { Private methods of TGoodExceptionThread }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;

    protected
      { Protected fields of TGoodExceptionThread }
        ErrorFlag : ErrorKind;

      { Protected methods of TGoodExceptionThread }
        { Termination of thread }
        procedure Terminate(Sender : TObject); override;
        { Method for thread to execute when started }
        procedure Execute(Sender : TObject); override;

    public
      { Public fields and properties of TGoodExceptionThread }

      { Public methods of TGoodExceptionThread }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
      { Published properties of TGoodExceptionThread }
        { Termination of thread }
        property OnTerminate;
        property ErrorString : String read FErrorString write FErrorString;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TGoodExceptionThread with Thread as its
       default page on the Delphi component palette }
     RegisterComponents('Thread', [TGoodExceptionThread]);
end;

{ Method to set variable and property values and create objects }
procedure TGoodExceptionThread.AutoInitialize;
begin
     ErrorFlag := efNoError;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TGoodExceptionThread.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Termination of thread }
procedure TGoodExceptionThread.Terminate(Sender : TObject);
begin
     inherited Terminate(Sender);
end;

constructor TGoodExceptionThread.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

destructor TGoodExceptionThread.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

{ Method for thread to execute when started }
procedure TGoodExceptionThread.Execute(Sender : TObject);
begin
     { Call method in parent class }
     inherited Execute(Sender);

     { Code to define component's behavior when thread is running }
     ErrorFlag := efNoError;
     try
        { ... do something ... }

        { An error occurred, so raise an exception }
        raise Exception.Create('An exception inside the thread');

        { ... do something ... }
     except
        on EDivByZero do
           { If we want to do something special for divide-by-zero errors }
           begin
           ErrorFlag := efDivByZero;
           ErrorString := 'Divide by zero error'
           end;
        on Ex : EInOutError do
           { If we want to do something else for file access errors }
           begin
           ErrorFlag := efFileError;
           { Record the error message string of this exception }
           ErrorString := Ex.Message;
           end;
        on Ex : Exception do
           { Handle all other exception types }
           begin
           ErrorFlag := efOtherError;
           { Record the error message string of this exception }
           ErrorString := Ex.Message
           end
     end;
end;


end.
