{ ****************************************************************** }
{                                                                    }
{   Delphi component TPassExceptionThread                            }
{                                                                    }
{   Shows effect of not handling exception inside thread             }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\delphi\threads\except1.cd          }
{   on 25 Jan 1997 at 23:13                                          }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{ ****************************************************************** }

unit Except1;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Ccthread;



type
  TPassExceptionThread = class(TNewThread)
    private
      { Private fields of TPassExceptionThread }

      { Private methods of TPassExceptionThread }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;

    protected
      { Protected fields of TPassExceptionThread }

      { Protected methods of TPassExceptionThread }
        { Termination of thread }
        procedure Terminate(Sender : TObject); override;
        { Method for thread to execute when started }
        procedure Execute(Sender : TObject); override;

    public
      { Public fields and properties of TPassExceptionThread }

      { Public methods of TPassExceptionThread }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;

    published
      { Published properties of TPassExceptionThread }
        { Termination of thread }
        property OnTerminate;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TPassExceptionThread with Thread as its
       default page on the Delphi component palette }
     RegisterComponents('Thread', [TPassExceptionThread]);
end;

{ Method to set variable and property values and create objects }
procedure TPassExceptionThread.AutoInitialize;
begin
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TPassExceptionThread.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Termination of thread }
procedure TPassExceptionThread.Terminate(Sender : TObject);
begin
     inherited Terminate(Sender);
end;

constructor TPassExceptionThread.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

destructor TPassExceptionThread.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

{ Method for thread to execute when started }
procedure TPassExceptionThread.Execute(Sender : TObject);
begin
     { Call method in parent class }
     inherited Execute(Sender);

     { Raise an exception in the thread.  Because the exception is not handled
       within this method, its class name ("EXCEPTION") will be placed
       in the component's ExceptionName property and its message string
       will be placed in the component's ExceptionString property. }
     raise Exception.Create('An exception inside the thread');
end;


end.
