{ ****************************************************************** }
{                                                                    }
{   Delphi component TCounterResource                                }
{                                                                    }
{   Simple illus. of maintaining a shared resource in a TResourceFlag }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\delphi\threads\countres.cd         }
{   on 9 Feb 1997 at 16:07                                           }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{ ****************************************************************** }

unit CountRes;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Ccthread;

type
  TCounterResource = class(TResourceFlag)
    private
      { Private fields of TCounterResource }
        FCount : Integer;
        FMaxValue : Integer;

      { Private methods of TCounterResource }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;

    protected
      { Protected fields of TCounterResource }

      { Protected methods of TCounterResource }

    public
      { Public fields and properties of TCounterResource }
        property Count : Integer read FCount;

      { Public methods of TCounterResource }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        procedure Increment;
        procedure Clear;

    published
      { Published properties of TCounterResource }
        property MaxValue : Integer
             read FMaxValue write FMaxValue
             default 1000;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TCounterResource with Thread as its
       default page on the Delphi component palette }
     RegisterComponents('Thread', [TCounterResource]);
end;

{ Method to set variable and property values and create objects }
procedure TCounterResource.AutoInitialize;
begin
     FMaxValue := 1000;
end; { of AutoInitialize }

{ Method to free any objects created by AutoInitialize }
procedure TCounterResource.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

constructor TCounterResource.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     { Code to perform other tasks when the component is created }
     FCount := 0;
end;

destructor TCounterResource.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TCounterResource.Increment;
begin
     Inc(FCount);
     if FCount > FMaxValue then
        FCount := 0
end;

procedure TCounterResource.Clear;
begin
     FCount := 0;
end;


end.
