{ ****************************************************************** }
{                                                                    }
{   Delphi component TSharingCounterThread                           }
{                                                                    }
{   Illustration of WaitForResource and DoneWithResource             }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\delphi\threads\counter2.cd         }
{   on 9 Feb 1997 at 18:40                                           }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{ ****************************************************************** }

unit Counter2;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Ccthread, Stdctrls, Comctrls, Countres;

type
  TSharingCounterThread = class(TSharingThread)
    private
      { Private fields of TSharingCounterThread }
        FDisplayLabel : TLabel;
        FProgress : TProgressBar;
        LocalCount : Integer;

      { Private methods of TSharingCounterThread }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;

    protected
      { Protected fields of TSharingCounterThread }

      { Protected methods of TSharingCounterThread }
        { Resets prop of component type if referenced component deleted }
        procedure Notification(AComponent : TComponent; Operation : TOperation); override;
        { Termination of thread }
        procedure Terminate(Sender : TObject); override;
        procedure Loaded; override;
        { Method for thread to execute when started }
        procedure Execute(Sender : TObject); override;

    public
      { Public fields and properties of TSharingCounterThread }

      { Public methods of TSharingCounterThread }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        { Show thread status on attached label and progress bar, if any }
        procedure DisplayStatus;
        procedure Start; override;

    published
      { Published properties of TSharingCounterThread }
        { Termination of thread }
        property OnTerminate;
        property DisplayLabel : TLabel read FDisplayLabel write FDisplayLabel;
        property Progress : TProgressBar read FProgress write FProgress;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TSharingCounterThread with Thread as its
       default page on the Delphi component palette }
     RegisterComponents('Thread', [TSharingCounterThread]);
end;

{ Method to set variable and property values and create objects }
procedure TSharingCounterThread.AutoInitialize;
begin
     FDisplayLabel := nil;
     FProgress := nil;
end; { of AutoInitialize }

{ Resets prop of component type if referenced component deleted }
procedure TSharingCounterThread.Notification(AComponent : TComponent; Operation : TOperation);
begin
     inherited Notification(AComponent, Operation);
     if Operation <> opRemove then
        Exit;
     { Has a component referenced by a property of 
       this component been deleted?  If so, update 
       the property. }
     if AComponent = FDisplayLabel then
        FDisplayLabel := nil;
     if AComponent = FProgress then
        FProgress := nil;
end;

{ Method to free any objects created by AutoInitialize }
procedure TSharingCounterThread.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Termination of thread }
procedure TSharingCounterThread.Terminate(Sender : TObject);
begin
     inherited Terminate(Sender);
end;

constructor TSharingCounterThread.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

destructor TSharingCounterThread.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TSharingCounterThread.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }
     if DisplayLabel <> nil then
        DisplayLabel.Caption := '0';
     if Progress <> nil then
        begin
        Progress.Min := 0;
        Progress.Max := 1000;
        Progress.Position := 0
        end
end;

{ Method for thread to execute when started }
procedure TSharingCounterThread.Execute(Sender : TObject);
var
     I : Integer;
begin
     { Call the method in the parent class }
     inherited Execute(Sender);

     { Until the application asks us to stop, keep incrementing
       the shared counter "resource" and displaying its value.
       We lock the counter, increment it ten times, then release it
       for any other waiting threads.  Then we repeat. }
     repeat
          { Make sure the resource flag hasn't been destroyed
            while we've been running. }
          if ResourceFlag = nil then
             Exit;

          { Increment the attached TCounterResource ten times.
            Stop early if the application requests that the thread stop.
            Display the progress through the cycle on the attached label
            and progress bar, if any were selected with the DisplayLabel
            and Progress properties. }
          for I := 1 to 10 do
              begin

              { Wait for any other counting threads to stop -- if they
                are linked to the same TCountingResource component as us
                through their ResourceFlag properties. }
              WaitForResource;

              { Update the counter and retrieve its value }
              (ResourceFlag as TCounterResource).Increment;
              LocalCount := (ResourceFlag as TCounterResource).Count;

              { Release the counter "resource" for now }
              DoneWithResource;

              { Have we been asked to stop early? }
              if StopRequested then
                 Exit;

              { Use Synchronize method to call DisplayStatus
                because DisplayStatus calls the VCL.
                Note that we could speed up the routine
                by calling Synchronize(DisplayStatus) less
                often, e.g., every 5th or 10th cycle. }
              Synchronize(DisplayStatus);
              end; { for }

     { Start the cycle again, unless we have been asked to stop }
     until StopRequested
end;

{ Show thread status on attached label and progress bar, if any }
procedure TSharingCounterThread.DisplayStatus;
begin
     if DisplayLabel <> nil then
        DisplayLabel.Caption := IntToStr(LocalCount);
     if Progress <> nil then
        Progress.Position := LocalCount
end;

procedure TSharingCounterThread.Start;
begin
     { Make sure we have a TCounterResource component attached.
       Make sure it is not just a generic TResourceFlag, or
       some other descendant.  We need the ResourceFlag property
       linked to a TCounterResource because that class contains
       the make-believe "resource" we are sharing. }
     if ResourceFlag = nil then
        raise Exception.Create('No TCounterResource attached');
     if not (ResourceFlag is TCounterResource) then
        raise Exception.Create('The resource flag is not a TCounterResource');

     { Update the maximum setting of the attached progress bar, if any }
     if Progress <> nil then
        Progress.Max := (ResourceFlag as TCounterResource).MaxValue;

     { Run the Execute method as a separate thread }
     inherited Start;
end;


end.
