{ ****************************************************************** }
{                                                                    }
{   Delphi component TCounterThread                                  }
{                                                                    }
{   Thread comp. that counts, updating attached label, progress bar  }
{                                                                    }
{   Code generated by Component Create for Delphi                    }
{                                                                    }
{   Generated from source file c:\delphi\demos\coderobt\counter.cd   }
{   on 17 Jan 1997 at 15:04                                          }
{                                                                    }
{   Copyright  1997 by David A. Price                               }
{                                                                    }
{ ****************************************************************** }

unit Counter;

interface

uses WinTypes, WinProcs, Messages, SysUtils, Classes, Controls, 
     Forms, Graphics, Ccthread, Stdctrls, Comctrls;

type
  TCounterThread = class(TNewThread)
    private
      { Private fields of TCounterThread }
        FDisplayLabel : TLabel;
        FProgress : TProgressBar;
        Count : Integer;

      { Private methods of TCounterThread }
        { Method to set variable and property values and create objects }
        procedure AutoInitialize;
        { Method to free any objects created by AutoInitialize }
        procedure AutoDestroy;

    protected
      { Protected fields of TCounterThread }

      { Protected methods of TCounterThread }
        { Resets prop of component type if referenced component deleted }
        procedure Notification(AComponent : TComponent; Operation : TOperation); override;
        { Termination of thread }
        procedure Terminate(Sender : TObject); override;
        procedure Loaded; override;
        { Method for thread to execute when started }
        procedure Execute(Sender : TObject); override;

    public
      { Public fields and properties of TCounterThread }

      { Public methods of TCounterThread }
        constructor Create(AOwner: TComponent); override;
        destructor Destroy; override;
        { Show thread status on attached label and progress bar, if any }
        procedure DisplayStatus;

    published
      { Published properties of TCounterThread }
        { Termination of thread }
        property OnTerminate;
        property DisplayLabel : TLabel read FDisplayLabel write FDisplayLabel;
        property Progress : TProgressBar read FProgress write FProgress;

  end;

procedure Register;

implementation

procedure Register;
begin
     { Register TCounterThread with Thread as its
       default page on the Delphi component palette }
     RegisterComponents('Thread', [TCounterThread]);
end;

{ Method to set variable and property values and create objects }
procedure TCounterThread.AutoInitialize;
begin
     FDisplayLabel := nil;
     FProgress := nil;
end; { of AutoInitialize }

{ Resets prop of component type if referenced component deleted }
procedure TCounterThread.Notification(AComponent : TComponent; Operation : TOperation);
begin
     inherited Notification(AComponent, Operation);
     if Operation <> opRemove then
        Exit;
     { Has a component referenced by a property of 
       this component been deleted?  If so, update 
       the property. }
     if AComponent = FDisplayLabel then
        FDisplayLabel := nil;
     if AComponent = FProgress then
        FProgress := nil;
end;

{ Method to free any objects created by AutoInitialize }
procedure TCounterThread.AutoDestroy;
begin
     { No objects from AutoInitialize to free }
end; { of AutoDestroy }

{ Termination of thread }
procedure TCounterThread.Terminate(Sender : TObject);
begin
     inherited Terminate(Sender);
end;

constructor TCounterThread.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     AutoInitialize;

     { Code to perform other tasks when the component is created }

end;

destructor TCounterThread.Destroy;
begin
     AutoDestroy;
     inherited Destroy;
end;

procedure TCounterThread.Loaded;
begin
     inherited Loaded;

     { Perform any component setup that depends on the property
       values having been set }
     if DisplayLabel <> nil then
        DisplayLabel.Caption := '0';
     if Progress <> nil then
        begin
        Progress.Min := 0;
        Progress.Max := 1000;
        Progress.Position := 0
        end
end;

{ Method for thread to execute when started }
procedure TCounterThread.Execute(Sender : TObject);
begin
     { Call the method in the parent class }
     inherited Execute(Sender);

     { Cycle through numbers 1-1000 until the application
       requests that the thread stop.  Display the progress
       through each cycle on the attached label and progress bar,
       if any were selected with the DisplayLabel and Progress
       properties. }
     repeat
          Count := 0;
          while Count < 1000 do
                begin
                Inc(Count);
                { Use Synchronize method to call DisplayStatus
                  because DisplayStatus calls the VCL.
                  Note that we could speed up the routine
                  by calling Synchronize(DisplayStatus) less
                  often, e.g., every 5th or 10th cycle. }
                Synchronize(DisplayStatus);
                { Has the application asked the thread to stop? }
                if StopRequested then
                   Exit
                end
     until StopRequested
end;

{ Show thread status on attached label and progress bar, if any }
procedure TCounterThread.DisplayStatus;
begin
     if DisplayLabel <> nil then
        DisplayLabel.Caption := IntToStr(Count);
     if Progress <> nil then
        Progress.Position := Count
end;


end.
