{------------------------------------------------------------------------------
  Unit     : fisThreadEdit.pas
  Purpose  : TEdit derivative that introduces a new ThreadChange event which
             fires off change events on a thread to avoid slowing up the UI
             on intensive operations.
  Status   : Freeware
  Copyright : First Internet Software House 2000
  Contact   : http://www.fishouse.com (email: support@fishouse.com)  
 ------------------------------------------------------------------------------

  History:

  Date                By      Comments
  ----                ----    --------
  27 March 2000       ME      Created, converted from C++ Builder

}
unit fisThreadEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, fisThread;

type
  TfisThreadEdit = class(TEdit)
  private
    { Private declarations }
    FOnThreadChange: TNotifyEvent;
    thrEditThread: TfisThread;
    procedure SetOnThreadChange(const Value: TNotifyEvent);
  protected
    { Protected declarations }
    procedure Change; override;
  public
    { Public declarations }
  published
    { Published declarations }
    constructor Create(Owner: TComponent); override;
    destructor Destroy; override;
    property OnThreadChange: TNotifyEvent read FOnThreadChange write SetOnThreadChange;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('FISH', [TfisThreadEdit]);
end;

{ TfisThreadEdit }

constructor TfisThreadEdit.Create(Owner: TComponent);
begin
  inherited Create(Owner);
  thrEditthread := nil;
  if not (csDesigning in ComponentState) then
  begin
    thrEditThread := TfisThread.Create;
  end;
end;

destructor TfisThreadEdit.Destroy;
begin
  if Assigned(thrEditThread) then
  begin
    thrEditThread.Free;
    thrEditThread := nil;
  end;
  inherited;
end;

procedure TfisThreadEdit.SetOnThreadChange(const Value: TNotifyEvent);
begin
  FOnThreadChange := Value;
  if Assigned(thrEditThread) then
  begin
    thrEditThread.SetNotification(Value, self);
  end;
end;

procedure TfisThreadEdit.Change;
begin
  if (assigned(fOnThreadChange) and (not(csDesigning in ComponentState))) then
  begin
    thrEditThread.Changing;
  end;
  inherited Change;
end;


end.
