{------------------------------------------------------------------------------
  Unit     : fisThread.pas
  Purpose  : TThread wrapper
  Project  : TfisThreadEdit
  Copyright: First Internet Software House 2000
  Status   : Freeware
  Contact  : http://www.fishouse.com (email: support@fishouse.com)
 ------------------------------------------------------------------------------

  History:

  Date                By      Comments
  ----                ----    --------
  27 March 2000       ME   Created

}
unit fisThread;

interface

uses Windows, Classes;

type
  TfisThread = class(TThread)
    private
      prExecute: THandle;
      prTerminate: THandle;
      prNotifyEvent: TNotifyEvent;
      prNotifyObj: TObject;
    protected
      procedure Execute; override;
    public
      constructor Create;
      Destructor Destroy; override;
      procedure Changing;
      procedure SetNotification(aNotifyEvent: TNotifyEvent; aNotifyObj: TObject);
  end;

implementation

{ TfisThread }

constructor TfisThread.Create;
begin
  inherited Create(false);
  prExecute := CreateEvent(nil, false, false, nil);
  prTerminate := CreateEvent(nil, false, false, nil);
end;

destructor TfisThread.Destroy;
begin
  SetEvent(prTerminate);
  CloseHandle(prExecute);
  CloseHandle(prTerminate);
  inherited;  
end;

procedure TfisThread.Execute;
var
  Events: array[0..1] of THandle;
begin
  Events[0] := prExecute;
  Events[1] := prTerminate;
  while(WaitForMultipleObjects(2, @Events, false, INFINITE) <> WAIT_OBJECT_0 + 1) do
  begin
    if Assigned(prNotifyEvent) then prNotifyEvent(prNotifyObj);
  end;
end;

procedure TfisThread.Changing;
begin
  SetEvent(prExecute);
end;

procedure TfisThread.SetNotification(aNotifyEvent: TNotifyEvent;
  aNotifyObj: TObject);
begin
  prNotifyEvent := aNotifyEvent;
  prNotifyObj := aNotifyObj;
end;

end.
