/*-----------------------------------------------------------------------------
  Unit     : TfisThreadEdit.cpp
  Copyright:  First Internet Software House 2000, http://www.fishouse.com
  Status   : Freeware
  Contact  : support@fishouse.com
 ----------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TfisThreadEdit.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
// ValidCtrCheck is used to assure that the components created do not have
// any pure virtual functions.
//

static inline void ValidCtrCheck(TfisThreadEdit *)
{
    new TfisThreadEdit(NULL);
}
//---------------------------------------------------------------------------
__fastcall TfisThreadEdit::TfisThreadEdit(TComponent* Owner)
    : TEdit(Owner)
{
    if(!ComponentState.Contains(csDesigning))
    {
        thrEditThread = new TfisThread;
    }
}
//---------------------------------------------------------------------------
__fastcall TfisThreadEdit::~TfisThreadEdit(void)
{
    if(!ComponentState.Contains(csDesigning))
    {
        delete thrEditThread;
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisThreadEdit::SetOnThreadChange(TNotifyEvent aNotifyEvent)
{
    FOnThreadChange = aNotifyEvent;
    if(!ComponentState.Contains(csDesigning))
    {
        thrEditThread->SetNotification(aNotifyEvent, this);
    }
}
//---------------------------------------------------------------------------
void __fastcall TfisThreadEdit::Change(void)
{
    if(FOnThreadChange && !ComponentState.Contains(csDesigning))
    {
        thrEditThread->Changing();
    }
    TEdit::Change();
}
//---------------------------------------------------------------------------
namespace Tfisthreadedit
{
    void __fastcall PACKAGE Register()
    {
         TComponentClass classes[1] = {__classid(TfisThreadEdit)};
         RegisterComponents("FISH", classes, 0);
    }
}
//---------------------------------------------------------------------------
