/*-----------------------------------------------------------------------------
  Unit     : TfisThread.cpp
  Copyright:  First Internet Software House 2000, http://www.fishouse.com
  Status   : Freeware
  Contact  : support@fishouse.com
 ----------------------------------------------------------------------------*/

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "TfisThread.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
void __fastcall TfisThread::Execute(void)
{
    HANDLE Events[2];
    Events[0] = prExecute;
    Events[1] = prTerminate;
    while(WaitForMultipleObjects(2, Events, false, INFINITE) !=
        WAIT_OBJECT_0 + 1)
    {
        if(prNotifyEvent)
        {
            prNotifyEvent(prNotifyObj);
        }
    }
}
//---------------------------------------------------------------------------
__fastcall TfisThread::TfisThread(void) : TThread(false)
{
    prExecute = CreateEvent(NULL, false, false, NULL);
    prTerminate = CreateEvent(NULL, false, false, NULL);
}
//---------------------------------------------------------------------------
__fastcall TfisThread::~TfisThread(void)
{
    SetEvent(prTerminate);
    CloseHandle(prExecute);
    CloseHandle(prTerminate);
}
//---------------------------------------------------------------------------
void __fastcall TfisThread::Changing(void)
{
    SetEvent(prExecute);
}
//---------------------------------------------------------------------------
void __fastcall TfisThread::SetNotification(TNotifyEvent aNotifyEvent,
    TObject *aNotifyObj)
{
    prNotifyObj = aNotifyObj;
    prNotifyEvent = aNotifyEvent;
}
//---------------------------------------------------------------------------

