unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DB, Grids, DBGrids, DBTables, StdCtrls, WThread;

type
  TForm1 = class(TForm)
    WinThread1: TWinThread;
    Button1: TButton;
    Query1: TQuery;
    Query2: TQuery;
    Session1: TSession;
    Session2: TSession;
    Database1: TDatabase;
    Database2: TDatabase;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    DataSource1: TDataSource;
    DataSource2: TDataSource;
    procedure Button1Click(Sender: TObject);
    function WinThread1ThreadProc(Sender: TComponent;
      ThreadInfo: TWinThreadParam): Integer;
    function WinThread1ThreadTerminate(Sender: TComponent;
      ThreadInfo: TWinThreadParam): Integer;
    procedure WinThread1ThreadException(Sender: TComponent;
      ThreadInfo: TWinThreadInfo; E: Exception);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
  DataSource1.DataSet := nil;
  DataSource2.DataSet := nil;
  with WinThread1 do
  begin
    SpawnThread(Query1);
    SpawnThread(Query2);
  end;
end;

function TForm1.WinThread1ThreadProc(Sender: TComponent;
  ThreadInfo: TWinThreadParam): Integer;
begin
  with TQuery(ThreadInfo.ThreadParam) do
  begin
    Active := False;
    Active := True;
  end;
end;

function TForm1.WinThread1ThreadTerminate(Sender: TComponent;
  ThreadInfo: TWinThreadParam): Integer;
var
  aDS: TDataSource;
begin
  if ThreadInfo.ThreadParam = Query1 then aDS := DataSource1
  else aDS := DataSource2;
  aDS.DataSet := TQuery(ThreadInfo.ThreadParam);
end;

procedure TForm1.WinThread1ThreadException(Sender: TComponent;
  ThreadInfo: TWinThreadInfo; E: Exception);
begin
  ShowMessage(E.Message);
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := WinThread1.CanClose;
  if not CanClose then
    ShowMessage('Threads still executing... cannot close');
end;

end.
