unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WThread, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    WinThread1: TWinThread;
    Button1: TButton;
    ListBox1: TListBox;
    Button2: TButton;
    Button5: TButton;
    Button3: TButton;
    procedure WinThread1SafeExecCode(Param: Longint);
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    function WinThread1ThreadProc(Sender: TComponent;
      ThreadInfo: TWinThreadParam): Integer;
    function WinThread1ThreadTerminate(Sender: TComponent;
      ThreadInfo: TWinThreadParam): Integer;
    procedure Button5Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Button3Click(Sender: TObject);
    procedure WinThread1ThreadException(Sender: TComponent;
      ThreadInfo: TWinThreadInfo; E: Exception);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  T1, T2, T3, T4: Integer;

implementation

{$R *.DFM}

procedure TForm1.WinThread1SafeExecCode(Param: Longint);
begin
  {
    This thread is executed by the main application when SafeExec or WaitExec are called
    WaitExec causes the thread to wait until the main application processes the code,
    whereas SafeExec allows the thread to continue executing.
  }
  ListBox1.Items.Add('Thread Slept: ' + IntToStr(Param) + ' ms');
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  WaitRes: LongInt;
begin
  { Spawn 8 threads passing varying parameters to each }
  with WinThread1 do
  begin
    SpawnThread(@T1);
    SpawnThread(@T2);
    SpawnThread(@T3);
    SpawnThread(@T4);
    SpawnThread(@T1);
    SpawnThread(@T2);
    SpawnThread(@T3);
    SpawnThread(@T4);
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  T1 := 1;
  T2 := 2;
  T3 := 3;
  T4 := 4;
  Random(33);
end;

function TForm1.WinThread1ThreadProc(Sender: TComponent;
  ThreadInfo: TWinThreadParam): Integer;
var
  Param: Integer;
begin
  { This code is executed in a thread when SpawnThread is called }
  Param := LongInt(ThreadInfo.ThreadParam^);
  Param := Random(1000 * Param);
  Sleep(Param); // this thread will sleep for a random amount of time based upon the param
  WinThread1.SafeExec(Param);  // Execute SafeExecCode in main application
end;

function TForm1.WinThread1ThreadTerminate(Sender: TComponent;
  ThreadInfo: TWinThreadParam): Integer;
begin
  { This code is executed by the main application when a thread terminates }
  ListBox1.Items.Add('Thread Handle: ' + IntToStr(ThreadInfo.ThreadHandle) + ' Terminated')
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  { kill any active threads }
  WinThread1.KillThreads;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  {
    check to see if any threads are active.  If any threads are active, see
    if user would like to kill them.  If user does not want to kill active threads
    then do not exit...

    Also, if threads could not be kill (KillThreads returns false) then do not exit.
  }
  CanClose := False;
  if (WinThread1.Count > 0) then
  begin
    if MessageDlg(
          IntToStr(WinThread1.Count) + ' thread(s) still active, kill them?',
          mtConfirmation,
          [mbYes, mbNo, mbCancel],
          0) = mrYes then CanClose := WinThread1.KillThreads;
  end
  else CanClose := True;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  { set caption to number of active threads }
  Caption := IntToStr(WinThread1.Count);
end;

procedure TForm1.WinThread1ThreadException(Sender: TComponent;
  ThreadInfo: TWinThreadInfo; E: Exception);
begin
  { This code is executed by the main application when an exception escapes from a thread }
  ShowMessage(E.Message);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  ListBox1.Clear;
end;

end.














