unit Acronicom_Main_Form;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  GMP_Cutdown, ExtCtrls, Menus, Math;

const
     COURTYARD = 25;
     WALLS = 1;
     PATH = 2;
     GRASS = 3;
     SPIKES1 = 4;
     SPIKES2 = 5;
     SPIKES3 = 6;
     LEFT   =  17;
     RIGHT  =  80;
     MAIN   =  9;
     Left2 = 26;
     Right2 = 27;
     Main2 = 28;
     ArchWay = 29;
     YANLEFT = 10;
     YANRIGHT = 11;
     TREE = 12;
     WELL = 13;
     wellrope = 20;
     wellroof = 21;
     wellpos = 22;
     wellhandle = 23;
     wellbase = 24;
     liftpal = 40;

     lamp = 44;
     parlour = 41;
     churchway = 42;
     Transporter = 43;

type
  TForm1 = class(TForm)
    GMP: TGMPCutdown;
    Timer1: TTimer;
    MainMenu1: TMainMenu;
    Detail1: TMenuItem;
    Highest1: TMenuItem;
    Medium1: TMenuItem;
    Low1: TMenuItem;
    Lowest1: TMenuItem;
    UltraLow1: TMenuItem;
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Highest1Click(Sender: TObject);
    procedure Medium1Click(Sender: TObject);
    procedure Low1Click(Sender: TObject);
    procedure Lowest1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure UltraLow1Click(Sender: TObject);
    procedure Test1Click(Sender: TObject);
  private
    { Private declarations }
    CamPos, CamRot : TPoint3D;
    LightPos : TPos4;
    X,Y,Z, gateRot: Single;
    CLOSING : BOOLEAN;
  public
    { Public declarations }
    NumberOfPoly : Integer;
    Textures : array [0..2] of TPoint3D;
  end;

var
  Form1: TForm1;

implementation

uses Texture;

{$R *.DFM}


procedure TForm1.FormShow(Sender: TObject);
begin
     {Initialise the camera position and rotation}
     {CamPos.X := 107.7;
     CamPos.Y := 22.9;
     CamPos.Z := 141;  {Moves camera 5 backwards }
     CamPos.X := 19.25;
     CamPos.Y := -12;
     CamPos.Z := -106;
     CamRot.X := 0;
     CamRot.Y := 0;
     CamRot.Z := 0;
     X := 19.25;
     Y := -12;
     Z := -106;
     GateRot := 0;
     Closing := False;
     NumberOfPoly := 0;
     {LightPosition}
     LightPos.x := -730; {Will set light to world coordinates (5,10,10}
     LightPos.Y := 730;
     LightPos.Z := 650;
     LightPos.W := 1;

     {This must be called first!}
     GMP.Start3D := True;

     {Now set the position of your viewing window within your Delphi window}
     GMP.SetViewPort(0, 0, Form1.Width , Form1.Height);

     {Set up your camera position and rotation}
     GMP.SetCamera(CamPos, CamRot);

     {Set up a light}
     GMP.SetLight(True,LightPos, GMP.Ambient_Default, GMP.Diffuse_Default, GMP.Specular_Default);
     GMP.GMPSMOOTH(False);

     {Loads both objects into GMP3DA}
     GMP.Load_Compile_GEOObject('c:\objects\models\Walls.geo', WALLS, False);
     GMP.Load_Compile_GEOObject('c:\objects\models\grass.geo', GRASS,False);
     GMP.Load_Compile_GeoObject('c:\objects\models\path.geo', PATH, False);
     GMP.Load_Compile_geoObject('c:\objects\models\spikes.geo', SPIKES1, FALSE);
     GMP.Load_Compile_geoObject('c:\objects\models\gateleft.geo', LEFT, TRUE);
     GMP.Load_Compile_geoObject('c:\objects\models\gaterigh.geo', RIGHT, TRUE);
     GMP.Load_Compile_geoObject('c:\objects\models\gatemain.geo', MAIN, TRUE);
     GMP.Load_Compile_geoObject('c:\objects\models\tree2.geo', TREE, TRUE);
     GMP.Load_Compile_GeoObject('c:\objects\models\court.geo', COURTYARD, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\well-rop.geo', wellrope, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\well-roo.geo', wellroof, TRUE);
     GMP.Load_Compile_GeoObject('c:\objects\models\well-pos.geo', wellpos, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\Well-han.geo', wellhandle, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\Well-bas.geo', wellbase, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\gate2lef.geo', left2, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\gate2rig.geo', right2, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\gate2mai.geo', main2, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\archway.geo', archway, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\liftpalo.geo', liftpal, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\liftparl.geo', parlour, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\churchwa.geo', churchway, False);
     GMP.Load_Compile_GeoObject('c:\objects\models\transpor.geo', transporter, True);
     GMP.Load_Compile_GeoObject('c:\objects\models\lamp.geo', lamp, True);

     Textures[0].X := 0;
     Textures[0].Y := 0;
     Textures[1].X := 0;
     Textures[1].Y := 0;
     Textures[2].X := 0;
     Textures[2].Y := 0;


end;

procedure TForm1.Timer1Timer(Sender: TObject);
const
     FrameRate : Single = 0.0;
     Counter : Integer = 0;
     First : DWord = 0;
     Last : DWord = 0;
begin
     {Clear the BackBuffer}
     GMP.ClearBuffer;

     GMP.ClearModelMatrix;
     GMP.SetScale(2, 2, 2);
     If Highest1.Checked = True then GMP.SetCurrentTexture7('c:\objects\textures\stonlite.bmp', True);
     GMP.SetBuiltInMaterial('Pewter');
     GMP.DrawCompiledGeoObject(churchway);
     GMP.DrawCompiledGeoObject(transporter);
     If Highest1.Checked = True then GMP.SetCurrentTexture7('c:\objects\textures\stonlite.bmp', False);
     GMP.DrawCompiledGeoObject(parlour);
     GMP.DrawCompiledGeoObject(liftpal);


{     GMP.SetPosition(0,-35,-80);
     GMP.SetRotation(1,0,0,-90); {The object is held in a raw file and is incorecty rotated}

     {The Grass First}
     GMP.SetBuiltInMaterial('DarkGreen');
     If Highest1.Checked = True then GMP.SetCurrentTexture1('c:\objects\textures\grass.bmp', true);
     GMP.DrawCompiledGeoObject(GRASS);
     If Highest1.Checked = True then GMP.SetCurrentTexture1('c:\objects\textures\grass.bmp', False);

     {Now the Path}
     If Highest1.Checked = True then GMP.SetCurrentTexture2('c:\objects\textures\path.bmp', True);
     If Highest1.Checked <> True then GMP.SetBuiltInMaterial('LightBrown') else GMP.SetBuiltInMaterial('Silver');
     GMP.DrawCompiledGeoObject(PATH);
     If Highest1.Checked = True then GMP.SetCurrentTexture2('c:\objects\textures\path.bmp', False);
     GMP.SetPosition(0, -21.25,0);
     If Highest1.Checked = True then GMP.SetCurrentTexture7('c:\objects\textures\stonlite.bmp', True);
     GMP.DrawCompiledGeoObject(Courtyard);
     If Highest1.Checked = True then GMP.SetCurrentTexture7('c:\objects\textures\stonlite.bmp', False);

     {Next the Spikes}
     GMP.SetBuiltInMaterial('Silver');
     GMP.SetPosition(0, 1.25,0);
     If (UltraLow1.Checked <> True) and (Lowest1.Checked <> true) then GMP.DrawCompiledGeoObject(SPIKES1);

     {Now the Walls}
     GMP.SetPosition(0, 20,0);
     if (Low1.Checked <> True) and (Lowest1.Checked <> True) and (UltraLow1.Checked <> True) then GMP.SetCurrentTexture3('c:\objects\textures\brick.bmp', true);
     GMP.SetBuiltInMaterial('Pewter');
     GMP.DrawCompiledGeoObject(WALLS);
    { DrawWall;}
     if (Low1.Checked <> True) and (Lowest1.Checked <> True) and (UltraLow1.Checked <> True) then GMP.SetCurrentTexture3('c:\objects\textures\brick.bmp', False);

     {Now Draw Well}
     GMP.SetPosition(0, -20.75,0);
     GMP.SetBuiltInMaterial('WoodBrown');
     GMP.DrawCompiledGeoObject(WellRope);
     GMP.DrawCompiledGeoObject(Wellpos);
     GMP.DrawCompiledGeoObject(WellHandle);
     If (Low1.Checked <> True) and (Lowest1.Checked <> TRUE) and (UltraLow1.Checked <> True) then GMP.SetCurrentTexture5('c:\objects\textures\roof.bmp', True);
     GMP.SetBuiltInMaterial('Silver');
     GMP.DrawCompiledgeoObject(wellroof);
     If (Low1.Checked <> True) and (Lowest1.Checked <> TRUE) and (UltraLow1.Checked <> True) then GMP.SetCurrentTexture5('c:\objects\textures\roof.bmp', False);
     If (Low1.Checked <> True) and (Lowest1.Checked <> TRUE) and (UltraLow1.Checked <> True) then GMP.SetCurrentTexture6('c:\objects\textures\brick2.bmp', True);
     GMP.DrawCompiledgeoObject(wellbase);
     If (Low1.Checked <> True) and (Lowest1.Checked <> TRUE) and (UltraLow1.Checked <> True) then GMP.SetCurrentTexture6('c:\objects\textures\brick2.bmp', False);

     GMP.SetBuiltInMaterial('Ebony');
     GMP.ClearModelMatrix;
     GMP.SetScale(2,2,2);
     GMP.DrawCompiledGeoObject(ArchWay);
     GMP.DrawCompiledgeoObject(Main);
     GMP.DrawCompiledGeoObject(Main2);
     GMP.SetPosition(-13.8, 4.75, 37.62);
     GMP.SetRotation(0,1,0,GateRot);
     GMP.DrawCompiledgeoObject(Left);
     GMP.SetRotation(0,1,0,-GateRot);
     GMP.SetPosition(13.8, -4.75, -37.62);
     GMP.SetPosition(-5.349, 4.75, 37.62);
     GMP.SetRotation(0,1,0,-GateRot);
     GMP.DrawCompiledgeoObject(Right);
     GMP.SetRotation(0,1,0,GateRot);

     GMP.ClearModelMatrix;
     GMP.SetScale(2,2,2);
     GMP.SetPosition(-30.963, -20.4, -31.58);
     GMP.SetRotation(0,1,0,GateRot);
     GMP.DrawCompiledgeoObject(Left2);
     GMP.SetRotation(0,1,0,-GateRot);
     GMP.SetPosition(30.963, 20.4, 31.58);
     GMP.SetPosition(-25.5, -20.3, -34.336);
     GMP.SetRotation(0,1,0,-GateRot);
     GMP.DrawCompiledgeoObject(Right2);
     GMP.SetRotation(0,1,0,GateRot);



     {Next the trees}
     If UltraLow1.Checked <> TRUE then
     begin
          GMP.ClearModelMatrix;
          GMP.SetScale(2,2,2);
          If Highest1.Checked = true then GMP.SetCurrentTexture4('c:\objects\textures\bark.bmp', True);
          If Highest1.Checked <> True then GMP.SetBuiltInMaterial('WoodBrown') else GMP.SetBuiltInMaterial('Silver');
          GMP.SetPosition(-2.4, 0, -3.7);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(2.4, 0, 3.7);


          GMP.SetPosition(-21.1, 0, -16.1);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(21.1, 0, 16.1);

          GMP.SetPosition(10.5, 0, -20.1);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(-10.5, 0, 20.1);


          GMP.SetPosition(1.9, 0, -27.5);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(-1.9, 0, 27.5);

          GMP.SetPosition(18.7, 0, -24.4);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(-18.7, 0, 24.4);

          GMP.SetPosition(13.409, 0, -30.404);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(-13.409, 0, 30.404);


          GMP.SetPosition(28.1, 0, -29.2);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(-28.1, 0, 29.2);


          GMP.SetPosition(-14.552, 0, -26.851);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(-14.552, 0, 26.851);

          GMP.SetPosition(-30.9, 0, -25.7);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(30.9, 0, 25.7);

          GMP.SetPosition(27.168, 0, -38.092);
          GMP.DrawCompiledGeoObject(TREE);
          GMP.SetPosition(-27.168, 0, 38.092);







         If Highest1.Checked = true then GMP.SetCurrentTexture4('c:\objects\textures\bark.bmp', False);

     end;









     {Show the back buffer}
     GMP.SwapBackBuffer;
     Inc(Counter);
     If counter = 5 then
     begin
          last := GetTickCount;
          Framerate := (Last - First) / 1000;
          Form1.caption := 'Frame Rate : ' + FloatToStr(5 / FrameRate) + ' per sec';
          Counter := 0;
          First := GetTickCount;

     end;


end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
     If key = VK_F1 then GateRot := GateRot + 1;
     If key = VK_F2 then GateRot := GateRot - 1;;

     If key = VK_F3 then Y := Y - 2;
     If key = VK_F4 then Y := Y + 2;

     If key = VK_LEFT then CamRot.Y := CamRot.Y - 1;
     If key = VK_RIGHT then CamRot.Y := CamRot.Y + 1;
     If CamRot.Y > 360 then CamRot.Y := 0;
     If CamRot.Y < 0 then CamRot.Y := 360;

     If Key = VK_UP then
     begin
          CamPos.X := CamPos.X - (2 * sin(degtorad(CamRot.Y)));
          CamPos.Z := CamPos.Z + (2 * cos(degtorad(CamRot.Y)));
     end;


     If Key = VK_DOWN then
     begin
          CamPos.X := CamPos.X + (2 * sin(degtorad(CamRot.Y)));
          CamPos.Z := CamPos.Z - (2 * cos(degtorad(CamRot.Y)));
     end;

     If CamRot.Y > 360 then CamRot.Y := 0;
     If CamRot.Y < -360 then CamRot.Y := 0;
     CamPos.Y := Y;

     If GateRot > 90 then GateRot := 90;
     If GateRot < 0 then GateRot := 0;
     GMP.SetCamera(CamPos, CamRot);


end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Closing := True;

ShowMessage(FloatToStr(X) + ' ' + FloatToStr(y) + ' ' + FloatToStr(z))
end;

procedure TForm1.Highest1Click(Sender: TObject);
begin
Highest1.Checked := True;
Medium1.Checked := False;
Low1.Checked := False;
Lowest1.Checked := False;
UltraLow1.Checked := False;

end;

procedure TForm1.Medium1Click(Sender: TObject);
begin
Highest1.Checked := False;
Medium1.Checked := True;
Low1.Checked := False;
Lowest1.Checked := False;
UltraLow1.Checked := False;
end;

procedure TForm1.Low1Click(Sender: TObject);
begin
Highest1.Checked := False;
Medium1.Checked := False;
Low1.Checked := True;
UltraLow1.Checked := False;
Lowest1.Checked := False;
end;

procedure TForm1.Lowest1Click(Sender: TObject);
begin
Highest1.Checked := False;
Medium1.Checked := False;
Low1.Checked := False;
Lowest1.Checked := True;
UltraLow1.Checked := False;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
     If Closing = False then
     begin
     GMP.SetViewPort(0, 0, Form1.Width , Form1.Height);
     GMP.SetCamera(CamPos, CamRot);
          {Loads both objects into GMP3DA}
     {GMP.Load_Compile_rawObject('c:\objects\Walls.raw', WALLS, FALSE);
     GMP.Load_Compile_rawObject('c:\objects\grass.raw', GRASS, TRUE);
     GMP.Load_Compile_rawObject('c:\objects\path.raw', PATH, TRUE);
     GMP.Load_Compile_rawObject('c:\objects\spikes1.raw', SPIKES1, FALSE);
     GMP.Load_Compile_rawObject('c:\objects\spikes2.raw', SPIKES2, FALSE);
     GMP.Load_Compile_rawObject('c:\objects\spikes3.raw', SPIKES3, FALSE);
     GMP.Load_Compile_rawObject('c:\objects\gateleft.raw', LEFT, FALSE);
     GMP.Load_Compile_rawObject('c:\objects\gateright.raw', RIGHT, FALSE);
     GMP.Load_Compile_rawObject('c:\objects\gatemain.raw', MAIN, FALSE);
     GMP.Load_Compile_rawObject('c:\objects\yan-left.raw', YANLEFT, FALSE);
     GMP.Load_Compile_rawObject('c:\objects\yan-right.raw', YANRIGHT, FALSE);
     GMP.Load_Compile_rawObject('c:\objects\tree.raw', TREE, TRUE);
     GMP.Load_Compile_GeoObject('c:\objects\box.Geo', WELL, TRUE); }

     end;

end;

procedure TForm1.UltraLow1Click(Sender: TObject);
begin
Highest1.Checked := False;
Medium1.Checked := False;
Low1.Checked := False;
Lowest1.Checked := False;
UltraLow1.Checked := True;
end;

procedure TForm1.Test1Click(Sender: TObject);
begin
Form2.Show;
Form2.Edit1.Text := FloatToStr(Textures[0].X);
Form2.Edit2.Text := FloatToStr(Textures[0].Y);
Form2.Edit3.Text := FloatToStr(Textures[1].X);
Form2.Edit4.Text := FloatToStr(Textures[1].Y);
Form2.Edit5.Text := FloatToStr(Textures[2].X);
Form2.Edit6.Text := FloatToStr(Textures[2].Y);
Form2.Edit7.Text := IntToStr(NumberOfPoly);

end;

end.
