
{*******************************************************}
{                                                       }
{       Animated Menus                                  }
{       Add-On Menu Components                          }
{       TFolderMenu2000 Component                       }
{                                                       }
{       Copyright  1997-2000 by Andrew Cher            }
{                                                       }
{*******************************************************}

//
//  For technical information and latest versions please visit
//  http://www.animatedmenus.com/support/tfoldermenu2000/
//

unit FolderMenu2000;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ShellApi, am2000, am2000menuitem;

type
  TFileClickEvent = procedure(const Filename: String; var Execute: Boolean) of object;

  TFileSortType = (stName, stExtension, stDate, stSize, stUnsorted);

  TFolderMenu2000 = class(TPopupMenu2000)
  private
    FRoot: String;
    FOnClick: TFileClickEvent;

    LastFile: Integer;
    LastFolder: Integer;
    FFolderBitmap: TBitmap;
    FFoldersFirst: Boolean;
    FExtractFileIcon: Boolean;
    FSortBy: TFileSortType;
    FMask: String;

    FirstItem: TMenuItem2000;
    TempBitmap: TBitmap;

    procedure OpenFolder1Click(Sender: TObject);
    procedure OpenFile1Click(Sender: TObject);
    procedure ClearMenuItem(Item: TMenuItem2000);
    function NewFolderItem(Caption, Location: String): TMenuItem2000;
    function NewFileItem(Caption, Location, Hint: String): TMenuItem2000;
    procedure SetFolderBitmap(const Value: TBitmap);
    function GetLocation(Item: TObject): String;
    procedure DrawFolderItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);
    procedure DrawFileItem(Sender: TObject; ACanvas: TCanvas; ARect: TRect; Selected: Boolean);

  protected
    procedure Loaded; override;

    function GetComponentItemsCaption: String; override;
    procedure CreateComponentItems(Items: TMenuItem2000; AddEmpty: Boolean); override;

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

  published
    property Root: String
      read FRoot write FRoot;
    property OnClick: TFileClickEvent
      read FOnClick write FOnClick;
    property FolderBitmap: TBitmap
      read FFolderBitmap write SetFolderBitmap;
    property FoldersFirst: Boolean
      read FFoldersFirst write FFoldersFirst default True;
    property SortBy: TFileSortType
      read FSortBy write FSortBy default stName;
    property Mask: String
      read FMask write FMask;
    property ExtractFileIcon: Boolean
      read FExtractFileIcon write FExtractFileIcon default True;

  end;

procedure Register;

implementation

uses
  CommCtrl,
  am2000options, am2000cache;

{$R FolderMenu2000.res}

procedure Register;
begin
  RegisterComponents('Animated Menus', [TFolderMenu2000]);
end;

function Replace(const S, S1, S2: String): String;
var
  L1, L2, O: Integer;
  P, PS, PF: PChar;
begin
  Result:= S;
  PS:= PChar(Result);
  PF:= PChar(S1);
  L1:= Length(S1);
  L2:= Length(S2);
  P:= StrPos(PS, PF);
  while P <> nil do begin
    O:= Integer(P) - Integer(PChar(Result));
    Delete(Result, O +1, L1);
    Insert(S2, Result, O +1);
    PS:= PChar(Integer(PChar(Result)) + O + L2);

    P:= StrPos(PS, PF);
  end;
end;


{ TFolderMenu2000 }

constructor TFolderMenu2000.Create(AOwner: TComponent);
begin
  inherited;

  FFoldersFirst:= True;
  FExtractFileIcon:= True;
  FRoot:= '\';
  FMask:= '*.*';

  FFolderBitmap:= TBitmap.Create;

  TempBitmap:=  TBitmap.Create;
  TempBitmap.Width:= 16;
  TempBitmap.Height:= 16;
  TempBitmap.Canvas.Brush.Color:= clFuchsia;
  TempBitmap.Canvas.Brush.Style:= bsSolid;
end;

destructor TFolderMenu2000.Destroy;
begin
  FFolderBitmap.Free;
  TempBitmap.Free;
  inherited;
end;

procedure TFolderMenu2000.Loaded;
begin
  inherited;
  if FFolderBitmap.Empty
  and (not (csDesigning in ComponentState))
  then FFolderBitmap.LoadFromResourceName(hInstance, 'BMP_PL2000_FILEFOLDER');
end;

procedure TFolderMenu2000.ClearMenuItem(Item: TMenuItem2000);
begin
  while Item.Count > 0 do
    Item[Item.Count -1].Free;
end;

function TFolderMenu2000.NewFolderItem(Caption, Location: String): TMenuItem2000;
begin
  Inc(LastFolder);
  Result:= TMenuItem2000.Create(Owner);
  Result.Caption:= Caption;
  Result.Default:= True;
  Result.OnClick:= OpenFolder1Click;
  Result.OnDrawItem:= DrawFolderItem;

  Result.Add(NewItem(SEmptyCaption, 0, False, False, nil, 0, ''));
end;

function TFolderMenu2000.NewFileItem(Caption, Location, Hint: String): TMenuItem2000;
begin
  Result:= TMenuItem2000.Create(Owner);
  Result.Caption:= Caption;
  Result.OnClick:= OpenFile1Click;
  Result.Hint:= Hint;
  Result.OnDrawItem:= DrawFileItem;
end;

procedure TFolderMenu2000.CreateComponentItems(Items: TMenuItem2000; AddEmpty: Boolean);
begin
  LastFile:= 0;
  LastFolder:= 0;
  OpenFolder1Click(Items);
  FirstItem:= Items[0];

  inherited;
end;

procedure TFolderMenu2000.OpenFolder1Click(Sender: TObject);
var
  SI: TSearchRec;
  L: TStringList;
  R, I: Integer;
  S, E, Root: String;
  faNA: Integer;

  function ArrangeFilename(S: String; Folder: Boolean): String;
  begin
    if S = UpperCase(S) then begin
      Result:= LowerCase(S);
      if Folder then Result[1]:= S[1];
    end
    else
      Result:= S;
  end;

  function SortBy(SI: TSearchRec): String;
  begin
    case FSortBy of
      stName: Result:= UpperCase(SI.Name);
      stExtension: Result:= UpperCase(ExtractFileExt(SI.Name));
      stDate: Result:= DateTimeToStr(FileDateToDateTime(SI.Time));
      stSize:
        begin
          Result:= IntToStr(SI.Size);
          while Length(Result) < 10 do Result:= '0' + Result; 
        end;
      else
        Result:= '';
    end;
  end;

begin
  ClearMenuItem(TMenuItem2000(Sender));

  Screen.Cursor:= crHourglass;
  L:= TStringList.Create;

  L.Sorted:= True;
  L.Duplicates:= dupIgnore;
  faNA:= faVolumeID or faHidden or faSysFile;
  if FFoldersFirst then faNa:= faNa or faDirectory;

  Root:= GetLocation(Sender);
  if (Root = '')
  or (Root[Length(Root)] <> '\')
  then AppendStr(Root, '\');

  with TMenuItem2000(Sender)
  do begin
    if FFoldersFirst
    then begin
      // folders
      R:= FindFirst(Root + '*.*', faDirectory, SI);
      while R = 0
      do begin
        if (SI.Attr and faDirectory <> 0)
        and (SI.name[1] <> '.')
        then
          L.Add(ArrangeFilename(SI.Name, True));

        R:= FindNext(SI);
      end;
      FindClose(SI);


      for I:= 0 to L.Count -1 do
        Add(NewFolderItem(L[I], Root + L[I] + '\'));

      // clear
      L.Clear;
    end;

    // add sorting
    L.Sorted:= FSortBy <> stUnsorted;

    // add files
    R:= FindFirst(Root + FMask, faAnyFile, SI);
    while (R = 0) and (L.Count < 100)
    do begin
      if (SI.Attr and faNA = 0)
      then
        L.AddObject(
          SortBy(SI) + #13 +
          ArrangeFilename(SI.Name, False) + #13 +
          IntToStr(SI.Size) + ' bytes', //#13 +
//          DateTimeToStr(FileDateToDateTime(SI.Time)),
          TObject(SI.Attr and faDirectory));

      R:= FindNext(SI);
    end;
    FindClose(SI);

    // add to menu
    for I:= 0 to L.Count -1 do begin
      S:= Copy(L[I], Pos(#13, L[I]) +1, MaxInt);
      E:= Copy(S, 1, Pos(#13, S) -1);

      // create item
      if L.Objects[I] <> nil
      then Add(NewFolderItem(E, Root + E + '\'))
      else Add(NewFileItem(E, Root + E, S));
    end;

    if Count = 0 then
      Add(NewItem('( Empty )', 0, False, False, nil, 0, ''));
  end;

  L.Free;
  Screen.Cursor:= crDefault;
end;

procedure TFolderMenu2000.OpenFile1Click(Sender: TObject);
var
  zFileName: array[0..255] of Char;
  Execute: Boolean;
begin
  Execute:= True;

  if Assigned(FOnClick)
  then FOnClick(GetLocation(Sender), Execute);

  if Execute
  then
    ShellExecute(Application.MainForm.Handle, nil,
      StrPCopy(zFileName, GetLocation(Sender)), nil, nil, sw_ShowNormal);
end;

procedure TFolderMenu2000.SetFolderBitmap(const Value: TBitmap);
begin
  FFolderBitmap.Assign(Value);
end;

function TFolderMenu2000.GetComponentItemsCaption: String;
begin
  Result:= 'Folder Menu Items';
end;

function TFolderMenu2000.GetLocation(Item: TObject): String;
var
  MI: TMenuItem2000;
begin
  if Item = nil
  then begin
    Result:= FRoot;
    Exit;
  end;

  MI:= TMenuItem2000(Item);
  Result:= MI.Caption;
  MI:= MI.Parent;

  while (MI <> nil)
  and (MI <> FirstItem.Parent)
  do begin
    Result:= MI.Caption + '\' + Result;
    MI:= MI.Parent;
  end;

  if (FRoot <> '')
  and (FRoot[Length(FRoot)] <> '\')
  then Result:= '\' + Result;

  Result:= FRoot + Result;
end;

procedure TFolderMenu2000.DrawFileItem(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
var
  Bmp: HBitmap;
  sfi: TShFileInfo;
  il: HImageList;
begin
  Bmp:= 0;
  if FExtractFileIcon
  then begin
    // extract icon
    il:= ShGetFileInfo(PChar(GetLocation(Sender)), 0, sfi, SizeOf(sfi), SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
    if il <> 0
    then begin
      TempBitmap.Canvas.FillRect(Rect(0, 0, 16, 16));
      ImageList_Draw(il, sfi.iIcon, TempBitmap.Canvas.Handle, 0, 0, ild_Transparent);
      TempBitmap.Canvas.Pixels[0, 15]:= clFuchsia;
      Bmp:= TempBitmap.Handle;
    end;
  end;

  with TMenuItem2000(Sender), PaintParams
  do
    DrawTextItem(ACanvas, Options, Replace(Caption, '&', '&&'), '', Bmp, -1,
      -1, 1, State, MouseState, mir, nil);
end;

procedure TFolderMenu2000.DrawFolderItem(Sender: TObject; ACanvas: TCanvas;
  ARect: TRect; Selected: Boolean);
var
  ItemState: T_AM2000_ItemState;
begin
  ItemState:= [isDefault, isSubmenu];
  if Selected
  then Include(ItemState, isSelected);

  with TMenuItem2000(Sender), PaintParams
  do
    DrawTextItem(ACanvas, Options, Replace(Caption, '&', '&&'), '', FFolderBitmap.Handle, -1,
      -1, 4, ItemState, MouseState, mir, nil);
end;

end.

