unit Fmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, ExtCtrls, Buttons, Finger;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    QueryEdit: TEdit;
    Label1: TLabel;
    Terminal: TMemo;
    FingerButton: TBitBtn;
    CancelButton: TBitBtn;
    Finger1: TFinger;
    procedure FingerButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
  private
    { Private declarations }
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.DisableControls;
begin
  QueryEdit.Enabled:=false;
  FingerButton.Enabled:=false;
  CancelButton.Enabled:=true;
  Terminal.Cursor:=crHourGlass;
end;

procedure TForm1.EnableControls;
begin
  QueryEdit.Enabled:=true;
  FingerButton.Enabled:=true;
  CancelButton.Enabled:=false;
  Terminal.Cursor:=crDefault;
end;

procedure TForm1.FingerButtonClick(Sender: TObject);
begin
  DisableControls;
  try
    Finger1.Query:=QueryEdit.Text;
    Finger1.Execute;
    Terminal.Lines.Assign(Finger1.RecvLines);
  finally
    EnableControls;
  end;
end;

procedure TForm1.CancelButtonClick(Sender: TObject);
begin
  Finger1.Cancel;
end;

end.
