unit F_tn;

interface

uses sysutils;

    function Ltrim(Cadena: string): string;
    function Rtrim(Cadena: string): string;
    function Alltrim(Cadena: string): string;
    function Space(I: Integer): string;
    function Saca1(var Cadena: string): string;
    function AlineaDcha(Cadena: string;K:Integer): string;
    function AlineaIzqda(Cadena: string;K:Integer): string;
    function Left(Cadena: string;K: Integer): string;
    function Hay(Cadena : String; Mayor : Integer): Boolean;
    function StrToPChar(S: string): Pchar;
    function ExitInteger(Cadena: string): string;

var
 Retorno : String;

implementation

{ Elimina los espacios a la izquierda de una cadena }
function Ltrim(Cadena: string): string;
begin
  while pos(' ',Cadena) = 1 do
   begin
      Cadena := Copy(Cadena,2,Length(Cadena)-1);
  end;
  Result:= Cadena;
end;

{ Elimina los espacios a la derecha de una cadena }
function Rtrim(Cadena: string): string;
begin
  while Copy(Cadena,Length(Cadena),1) = ' ' do
  begin
    Cadena := Copy(Cadena,1,Length(Cadena) - 1);
  end;
  Result:= Cadena;
end;

{ Elimina los espacios a la Izqda. y derecha de una cadena }
function Alltrim(Cadena: string): string;
begin
  Result:= Ltrim(Rtrim(Cadena));
end;

{ Inserta I espacios }
function Space(I: Integer): String;
var
k      : Integer;
Cadena : string;
begin
  k      := 0;
  Cadena := '';
  while k < I do
  begin
    Cadena := Cadena + ' ';
    k      := K + 1;
  end;
  Result := Cadena;
end;

{ devuelve el primer caracter de la cadena y lo elimina de la cadena que se le pasa}
function Saca1(var Cadena: string): string;
var
 Primero : String;
begin
  if Length(Cadena) = 0 then Primero := '';

  if Length(Cadena) > 0 then Primero := Copy(Cadena,1,1);

  if Length(Cadena) > 1 then Cadena  := Copy(Cadena,2,Length(Cadena) - 1)
  else Cadena := '';

  Result  := Primero;
end;
{ Alinea a la derecha rellenando espacios hasta completar longitud K }
function AlineaDcha(Cadena: string;K: Integer): string;
begin
  if k = 0 then k := Length(Cadena);
  if k < Length(Cadena) then k := Length(Cadena);
  Cadena := Rtrim(Cadena);
  Cadena := Space(k - Length(Cadena)) + Cadena;
  Result := Cadena;
end;

{ Alinea a la Izquierda rellenando espacios hasta completar longitud K }
function AlineaIzqda(Cadena: string;K: Integer): string;
begin
  if k = 0 then k := Length(Cadena);
  if k < Length(Cadena) then k := Length(Cadena);
  Cadena := Ltrim(Cadena);
  Cadena := Cadena + Space(k - Length(Cadena));
  Result := Cadena;
end;

Function Left(Cadena: string;K: Integer): string;
{-Si la longitud pedida es mayor que la de la cadena, devuelve la cadena
  con espacios al final con la longitud de K.
 -Si la longitud de la Cadena es mayor que la de K, devuelve la cadena
  de la longitud de K igual que en dBase }
var
  LCadena : Integer;
begin
  LCadena := Length(Cadena);
  if (K > 0) and (LCadena > 0) then
    if LCadena < K then
       Cadena := Cadena + Space(K - LCadena)
      else
       Cadena := Copy(Cadena,1,K);

 Result := Cadena;
end;

{Devuelve True si la cadena tiene una longitud > que Mayor}
function Hay(Cadena : String; Mayor : Integer): Boolean;
begin
 if Length(AllTrim(Cadena)) > Mayor then Result := True else Result := False;
end;

{ Convierte una String en PChar directamente}
function StrToPChar(S: string): Pchar;
var
  Ps,P : PChar;
begin
  GetMem(P,Length(S) + 1);
  StrPCopy(P,S);
  Ps     := P;
  FreeMem(P,Length(S) + 1);
  Result := Ps;
end;

function ExitInteger(Cadena: string): string;
var
  K,Longitud : Integer;
  D,S        : String;
begin
 {Funcion de ambito general que interpreta y convierte una cadena de texto en
  valor preparado para convertirlo con StrToInteger() sin dar errores. Cambia los
  caracteres alfabeticos por 0 y elimina los valores decimales de 0,..}

 Longitud := Length(Cadena);         {guardar longitud original}
 Cadena   := Ltrim(Rtrim(Cadena));
 if Length(Ltrim(Cadena)) > 0 then begin {if 1}
  if Pos('.',Cadena) > 0 then      {Elimina lo que hay a partir del punto}
   Cadena := Copy(Cadena,1,Pos('.',Cadena) - 1);

  if Pos(',',Cadena) > 0 then      {Elimina lo que hay a partir de la coma}
   Cadena := Copy(Cadena,1,Pos(',',Cadena) - 1);

  if Length(Cadena) = 0 then begin {Si todavia hay caracteres a controlar}
   Cadena := '0';
   Cadena := AlineaIzqda(Cadena,Longitud);
   Result:= Cadena;
   Exit;
  end;

  K := 1;
  while K <= Length(Cadena) do begin {for 2}
   D := Copy(Cadena,K,1);
   if K = 1 then begin {Control del primer caracter con el signo}
    if not ((D = '+') or (D = '-') or (D = '0') or (D = '1') or
            (D = '2') or (D = '3') or (D = '4') or (D = '5') or
            (D = '6') or (D = '7') or (D = '8') or (D = '9')) then
     if Length(Cadena) > 1 then begin   {if 4}
      Cadena := Copy(Cadena,2,Length(Cadena) - 1);
      K      := 0;
     end else Cadena := '0';    {if 4-}
   end;                           {if 3-}

   if Length(Cadena) > K then S := Copy(Cadena,K + 1,1); {Caracter siguiente}

   if (K > 1) then  {Control del resto de los caracteres}
    if not ((D = '0') or (D = '1') or (D = '2') or (D = '3') or
            (D = '4') or (D = '5') or (D = '6') or (D = '7') or
            (D = '8') or (D = '9')) then
     if Length(Cadena) > K then
      Cadena := Copy(Cadena,1,K-1) + '0' +
                Copy(Cadena,K + 1,Length(Cadena) - K)
     else Cadena := Copy(Cadena,1,K-1) + '0';

   K := K + 1;
  end;
 end else Cadena := '0';
 Cadena := AlineaIzqda(Cadena,Longitud);
 Result:= Cadena;
end;

end.
