{
 Test232n
 --------

 Commentaries and program in Ingles and Spanish
 Comentarios y programa en Ingles y Espaol

 Autor   : (c) Jos Mara Gas.  All rights reserved.
 Versin : 2.0

 ** Freeware **

 Fecha   : 14.06.97
 Delphi 2 and 3
 Windows 95 - Windows NT

 ## The previous versin 1.0 'Test232' is for Delphi 1 with TMsComm component
    La versin anterior 1.0 'Test232' es para Delphi 1 con el componente TMsComm
 -------------------------------------------------------------------------------

 CREDIT  -  COMPONENT
 ---------------------
  ComDrv32.pas (see ComDrv16.pas for Delphi 1.0)

  v1.02/32 - Jun 5th, 1997

  COM Port Driver for Delphi 2.0

  Written by Marco Cocco
  Copyright (c) 1996-97 by Marco Cocco. All rights reseved.
  Copyright (c) 1996-97 by d3k The Artisan Of Ware. All rights reseved.

  Please send comments to d3k@mdnet.it
  URL: http://www.mdlive.com/d3k/

---------------------
  Mjwcrt.pas

  TMJWcrt component - version 1.00b

  Copyright 1996 (c) by Michael Wilcox
  Email:  mwilcox@economat.demon.co.uk

-------------------------------------------------------------------------------
 # My gratefulness to the authors of these appraised two components
   Mi agradecimiento a los autores de estos dos apreciados componentes
-------------------------------------------------------------------------------
- Test of communications in Ports Series and development assistance of
  applications in those which are employed communications series.

- Test de comunicaciones en Puertos Serie y ayuda al desarrollo de aplicaciones
  en las que se emplean comunicaciones serie.
-------------------------------------------------------------------------------

 #
  - Program that permits to listen the simultaneous Communications by 2 ports
    series, and to send cables by one of 2 ports in a way simultaneous, using the
   component CommDrv for the control of ports.

  - To listen 2 ports in a way simultaneous, requires to construct a thief
   of  9 or 25 pin for the locus in quo is connected and 2 tappings, a for each
   port respectively with the Tx and Rx of the thief.

   Prepared for the standard Communications intercalating the thief in a cable
   RS232 with two-way communication.

               LINE RS232     PC
               ----------  ---------
                 Tx Rx 0V
   Sub D  9 Pin  2  3  5        Pin
   Sub D 25 Pin  3  2  7       9  25
                            |  |
                 |  |  |
                 --------- | 3  2 --> Tx - Port 1 -  |COM1 PC
                 |  |  --- | 5  7                    |
                 |  |  |
                 |  ------ | 3  2 --> Rx - Port 2 -  |COM2 PC
                 |  |  --- | 5  7                    |
                 |  |  |
                            |  |
   Sub D 25 Pin  3  2  7       9  25
   Sub D  9 Pin  2  3  5        Pin
                 Tx Rx 0V

 - Configuration of initial Ports  9600,8,1,n

 - In the file F.Pas they are found some functions of developed common use
   for the author for the treatment of strings and several

 - Can be configured until 4 characters awaiting be received by each
   port, having to indicate the value in decimal.

 - Can be assigned text files in a way simple, for proofs of
   operation of the port, having to activate the control of flow by Soft,
   Xon-Xoff or by Hard. It is not incorporated any transfer protocol.

 - In this version, it has been adding a delay time between the acceptance of
   data by the port, guided mainly to the ports that are derived from
   Terminal Server of the Nets, that tend to have arrears.

 - In the options of "to Send" implemented, there are several examples of
   simulation of the send of cables by the port selected. This option is thought
   for design time, in the one which can simulate send it of data as if
   we were communicating actually with an external equipment.

#
 - Programa que permite escuchar las comunicaciones simultneas por 2 puertos
   serie, y enviar telegramas por uno de los 2 puertos de forma simultanea,
   utilizando el componente CommDrv para el control de puertos.

 - Para escuchar los 2 puertos de forma simultnea, requiere construir un ladrn
   de 9 o 25 pines para el lugar donde se conecte y 2 derivaciones, una para cada
   puerto respectivamente con el Tx y Rx del ladrn.

   Preparado para las comunicaciones estandar intercalando el ladrn en un cable
   RS232 con comunicacin bidireccional.

               LINE RS232     PC
               ----------  ---------
                 Tx Rx 0V
   Sub D  9 Pin  2  3  5        Pin
   Sub D 25 Pin  3  2  7       9  25
                            |  |
                 |  |  |
                 --------- | 3  2 --> Tx - Puerto 1 -  |COM1 PC
                 |  |  --- | 5  7                      |
                 |  |  |
                 |  ------ | 3  2 --> Rx - Puerto 2 -  |COM2 PC
                 |  |  --- | 5  7                      |
                 |  |  |
                            |  |
   Sub D 25 Pin  3  2  7       9  25
   Sub D  9 Pin  2  3  5        Pin
                 Tx Rx 0V

- Configuracin de Puertos inicial  9600,8,1,n

- En el fichero F.Pas se encuentran algunas funciones de uso comn desarrolladas
  por el autor para el tratamiento de strings y varios.

- Se pueden configurar hasta 4 caracteres en espera de ser recibidos por cada
  puerto, debiendo indicar el valor en decimal.

- Se pueden traspasar ficheros de texto de forma simple, para pruebas de
  funcionamiento del puerto, debiendo activar el control de flujo por Soft,
  Xon-Xoff o por Hard. No se incorpora ningn protocolo de transferencia.

- En esta versin, se ha aadido un tiempo de retardo entre la recepcin de
  datos por el puerto, orientada principalmente a los puertos que se derivan de
  Terminal Server de las Redes, que suelen tener retrasos.

- En las opciones de "Enviar" implementadas, hay varios ejemplos de simulacin
  del envio de telegramas por el puerto seleccionado. Esta opcin esta pensada
  para tiempo de diseo, en el cual podemos simular el envio de datos como si
  estuvieramos comunicando realmente con un equipo externo.

}

unit Escuchar;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, F_tn, ExtCtrls, Mask, Menus, Mjwcrt, Spin, ComDrv32;

type
  TFmEscuchar = class(TForm)
    EditFichero: TEdit;
    GBPuerto1: TGroupBox;
    EditCaracter1: TEdit;
    EditCaracter2: TEdit;
    EditCaracter3: TEdit;
    EditCaracter4: TEdit;
    GBPuerto2: TGroupBox;
    EditCaracter11: TEdit;
    EditCaracter13: TEdit;
    EditCaracter12: TEdit;
    EditCaracter14: TEdit;
    MainMenu1: TMainMenu;
    Archivo1: TMenuItem;
    Nuevo1: TMenuItem;
    Cerrar1: TMenuItem;
    N1: TMenuItem;
    Salir1: TMenuItem;
    Configurar1: TMenuItem;
    ConfigurarPuerto1: TMenuItem;
    ConfigurarPuerto2: TMenuItem;
    Puertos1: TMenuItem;
    AbrirPuerto1: TMenuItem;
    AbrirPuerto2: TMenuItem;
    Enviar1: TMenuItem;
    FechayHora1: TMenuItem;
    TLGTipo1: TMenuItem;
    CerrarPuerto1: TMenuItem;
    N3: TMenuItem;
    CerrarPuerto2: TMenuItem;
    OpenDialog1: TOpenDialog;
    EditLng: TEdit;
    Ayuda1: TMenuItem;
    CarcteresdeControl1: TMenuItem;
    Label1: TLabel;
    Label2: TLabel;
    Acercade1: TMenuItem;
    GBSend: TGroupBox;
    EditTlg: TEdit;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Cortar1: TMenuItem;
    Label8: TLabel;
    Timer1: TTimer;
    RBPuerto1: TRadioButton;
    RBPuerto2: TRadioButton;
    Ver1: TMenuItem;
    AsciiHexadecimal1: TMenuItem;
    Hexadecimal1: TMenuItem;
    BorrarPantalla1: TMenuItem;
    TLGTipo2: TMenuItem;
    Port1: TCommPortDriver;
    Port2: TCommPortDriver;
    ScrollBox1: TScrollBox;
    Mjw: TMJWcrt;
    SEFrecuencia: TSpinEdit;
    BloqueTlg: TMenuItem;
    BitBtn1: TBitBtn;
    Idioma1: TMenuItem;
    Espaol1: TMenuItem;
    CtrlASCIIHexadecimal1: TMenuItem;
    TlgTest1: TMenuItem;
    FicheroTexto1: TMenuItem;
    TimerTrocear: TTimer;
    Polling1: TMenuItem;
    Label9: TLabel;
    SEDelay: TSpinEdit;
    TimerDelay: TTimer;
    ModoTerminal1: TMenuItem;
    CaracteresAscii1: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure EditCaracter1Change(Sender: TObject);
    procedure ConfigurarPuerto1Click(Sender: TObject);
    procedure ConfigurarPuerto2Click(Sender: TObject);
    procedure AbrirPuerto1Click(Sender: TObject);
    procedure AbrirPuerto2Click(Sender: TObject);
    procedure CerrarPuerto1Click(Sender: TObject);
    procedure CerrarPuerto2Click(Sender: TObject);
    procedure Salir1Click(Sender: TObject);
    procedure Nuevo1Click(Sender: TObject);
    procedure Cerrar1Click(Sender: TObject);
    procedure CarcteresdeControl1Click(Sender: TObject);
    procedure Acercade1Click(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FechayHora1Click(Sender: TObject);
    procedure Cortar1Click(Sender: TObject);
    procedure EditTiempoChange(Sender: TObject);
    procedure Hexadecimal1Click(Sender: TObject);
    procedure AsciiHexadecimal1Click(Sender: TObject);
    procedure BorrarPantalla1Click(Sender: TObject);
    procedure TLGTipo1Click(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure TLGTipo2Click(Sender: TObject);
    procedure Port2ReceiveData(Sender: TObject; DataPtr: Pointer;
      DataSize: Integer);
    procedure Port1ReceiveData(Sender: TObject; DataPtr: Pointer;
      DataSize: Integer);
    procedure BloqueTlgClick(Sender: TObject);
    procedure Espaol1Click(Sender: TObject);
    procedure SEFrecuenciaChange(Sender: TObject);
    procedure CtrlASCIIHexadecimal1Click(Sender: TObject);
    procedure TlgTest1Click(Sender: TObject);
    procedure FicheroTexto1Click(Sender: TObject);
    procedure TimerTrocearTimer(Sender: TObject);
    procedure Polling1Click(Sender: TObject);
    procedure SEDelayChange(Sender: TObject);
    procedure TimerDelayTimer(Sender: TObject);
    procedure ModoTerminal1Click(Sender: TObject);
    procedure MjwKeyPress(Sender: TObject; var Key: Char);
    procedure CaracteresAscii1Click(Sender: TObject);
  private
    procedure OpenPort1;
    procedure ClosePort1;
    procedure OpenPort2;
    procedure ClosePort2;
    procedure ConfiguraEnvio;
    procedure EnviaFichero(FileText : String);
    procedure EnviaPolling;
    procedure WriteInMjWinCrt(DataPtr: Pointer; DataSize: Integer);
    procedure Pack1;
    procedure Pack2;
    procedure Pack3;
    procedure Pack4;
    procedure Pack5;
    procedure Pack6;
    function  RandG(Mean, StdDev: Extended): Extended;
  public
   Tlg,C,strFic,Paquete,Temp : String;
   Car : Char;
   C1,C2,C3,C4,C11,C12,C13,C14,Lng,Valor,Ind,nPollingMax,nPollingActual : Integer;
   Fic,Enviar,Hexa,Ctrl,Activo,Bloque : Boolean;
   OutFile : TextFile;
   PuertoReceive,PuertoUltimo  : String;
   ContinuaTlg : Boolean;
  end;

const
  CharCtrl  : array [0..31] of string[5] =
             ('<NUL>','<SOH>','<STX>','<ETX>','<EOT>','<ENQ>','<ACK>','<BEL>',
              '<BS>','<SH>','<LF>','<VT','<FF>','<CR>','<SO>','<SI>','<DLE>',
              '<DC1>','<DC2>','<DC3>','<DC4>','<NAK>','<SYN>','<ETB>','<CAN>',
              '<EM>','<SUB>','<ESC>','<FS>','<GS>','<RS>','<US>');

  {#Characters of control of the communication. It is not used in the example,
    but it is a profit to configure I send it of simulated cables.
   #Caracteres de control de la comunicacion. No se utiliza en el ejemplo, pero
    es una utilidad para configurar el envio de telegramas simulados}
  NUL = #0; SOH = #1; STX = #2; ETX = #3; EOT = #4; ENQ = #5; ACK = #6; BEL = #7;
  BS  = #8; SH  = #9; LF  = #10; VT  = #11; FF  = #12; CR  = #13; SO  = #14;
  SI  = #15; DLE = #16; DC1 = #17; DC2 = #18; DC3 = #19; DC4 = #20; NAK = #21;
  SYN = #22; ETB = #23; CAN = #24; EM  = #25; SUB = #26; ESC = #27; FS  = #28;
  GS  = #29; RS  = #30; US  = #31;

var
  FmEscuchar: TFmEscuchar;

implementation

{$R *.DFM}

uses Config,Config2,Car_Ctrl,Acercade, Car_Ascc;

procedure TFmEscuchar.Salir1Click(Sender: TObject);
begin
 {#Close the Form and exit
  #Cerrar el formulario y salir}
 Close;
end;

procedure TFmEscuchar.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 {#To close the ports and the file if they are opened
  #Cerrar los puertos y el fichero si estn abiertos}
 ClosePort1;
 ClosePort2;
 Cerrar1Click(nil); {Text File}
 Release;
end;

procedure TFmEscuchar.AbrirPuerto1Click(Sender: TObject);
begin
 {#Open Port 1
  #Abrir el puerto 1}
 OpenPort1;
end;

procedure TFmEscuchar.AbrirPuerto2Click(Sender: TObject);
begin
 {#Open Port 2
  #Abrir el puerto 2}
 OpenPort2;
end;

procedure TFmEscuchar.CerrarPuerto1Click(Sender: TObject);
begin
 {#Close Port 1
  #Cerrar el puerto 1}
 ClosePort1;
end;

procedure TFmEscuchar.CerrarPuerto2Click(Sender: TObject);
begin
 {#Close Port 2
  #Cerrar el puerto 2}
 ClosePort2;
end;

procedure TFmEscuchar.OpenPort1;
begin
 {#Open Port 1
  #Abrir el puerto 1}
 Port1.Connect;
 if Port1.Connected then begin
  AbrirPuerto1.Enabled  := False;
  CerrarPuerto1.Enabled := True;
 end else begin
  ShowMessage('No puedo Abrir el Puerto 1' + #13 +
              'I can not Open the Port 1');
  ClosePort1;
 end;
end;

procedure TFmEscuchar.ClosePort1;
begin
 {#Close Port 1
  #Cerrar el Puerto 1}
 Port1.Disconnect;
 AbrirPuerto1.Enabled  := True;
 CerrarPuerto1.Enabled := False;
end;

procedure TFmEscuchar.OpenPort2;
begin
 {#Open Port2
  #Abrir el puerto 2}
 Port2.Connect;
 if Port2.Connected then begin
  AbrirPuerto2.Enabled  := False;
  CerrarPuerto2.Enabled := True;
 end else begin
  ShowMessage('No puedo Abrir el Puerto 2' + #13 +
              'I can not Open the Port 2');
  ClosePort2;
 end;
end;

procedure TFmEscuchar.ClosePort2;
begin
 {#Close Port 2
  #Cerrar el Puerto 2}
 Port2.Disconnect;
 AbrirPuerto2.Enabled  := True;
 CerrarPuerto2.Enabled := False;
end;

procedure TFmEscuchar.EditCaracter1Change(Sender: TObject);
begin
 {#To Get the values of the characters to dial in each port
  #Coger los valores de los carcteres a escuchar en cada puerto}

 if Ltrim(EditCaracter1.Text) <> ''  then
  C1 := StrToInt(Ltrim(Rtrim(EditCaracter1.Text)))   else C1  := 0;
 if Ltrim(EditCaracter2.Text) <> ''  then
  C2 := StrToInt(Ltrim(Rtrim(EditCaracter2.Text)))   else C2  := 0;
 if Ltrim(EditCaracter3.Text) <> ''  then
  C3 := StrToInt(Ltrim(Rtrim(EditCaracter3.Text)))   else C3  := 0;
 if Ltrim(EditCaracter4.Text) <> ''  then
  C4 := StrToInt(Ltrim(Rtrim(EditCaracter4.Text)))   else C4  := 0;
 if Ltrim(EditCaracter11.Text) <> '' then
  C11 := StrToInt(Ltrim(Rtrim(EditCaracter11.Text))) else C11 := 0;
 if Ltrim(EditCaracter12.Text) <> '' then
  C12 := StrToInt(Ltrim(Rtrim(EditCaracter12.Text))) else C12 := 0;
 if Ltrim(EditCaracter13.Text) <> '' then
  C13 := StrToInt(Ltrim(Rtrim(EditCaracter13.Text))) else C13 := 0;
 if Ltrim(EditCaracter14.Text) <> '' then
  C14 := StrToInt(Ltrim(Rtrim(EditCaracter14.Text))) else C14 := 0;

 EditCaracter1.Text  := IntToStr(C1);
 EditCaracter2.Text  := IntToStr(C2);
 EditCaracter3.Text  := IntToStr(C3);
 EditCaracter4.Text  := IntToStr(C4);
 EditCaracter11.Text := IntToStr(C11);
 EditCaracter12.Text := IntToStr(C12);
 EditCaracter13.Text := IntToStr(C13);
 EditCaracter14.Text := IntToStr(C14);
end;

procedure TFmEscuchar.ConfigurarPuerto1Click(Sender: TObject);
begin
  {#To read the current configuration of the Port 1
   #Leer la configuracin actual del Puerto 1}
  ConfigPort1.cboPort.Enabled     := AbrirPuerto1.Enabled;
  ConfigPort1.cboPort.ItemIndex   := Ord(Port1.ComPort)+1;
  ConfigPort1.cboBaud.ItemIndex   := Ord(Port1.ComPortSpeed);
  ConfigPort1.cboData.ItemIndex   := Ord(Port1.ComPortDataBits);
  ConfigPort1.cboParity.ItemIndex := Ord(Port1.ComPortParity);
  ConfigPort1.cboStop.ItemIndex   := Ord(Port1.ComPortStopBits);
  ConfigPort1.cboHand.ItemIndex   := Ord(Port1.ComPortHwHandshaking);
  ConfigPort1.cboFlow.ItemIndex   := Ord(Port1.ComPortSwHandshaking);

  {#Settings Form Port 1
   #Formulario de configuracin del Puerto 1}
  ConfigPort1.ShowModal;

  {#To update the configuration of the port
   #Actualizar la configuracin del puerto}
  case ConfigPort1.cboPort.ItemIndex of
    1: Port1.ComPort := pnCom1;
    2: Port1.ComPort := pnCom2;
    3: Port1.ComPort := pnCom3;
    4: Port1.ComPort := pnCom4;
  end;

  case ConfigPort1.cboBaud.ItemIndex of
    0:  begin Port1.ComPortSpeed := br110;    TimerTrocear.Interval := 980; end;
    1:  begin Port1.ComPortSpeed := br300;    TimerTrocear.Interval := 900; end;
    2:  begin Port1.ComPortSpeed := br600;    TimerTrocear.Interval := 820; end;
    3:  begin Port1.ComPortSpeed := br1200;   TimerTrocear.Interval := 740; end;
    4:  begin Port1.ComPortSpeed := br2400;   TimerTrocear.Interval := 660; end;
    5:  begin Port1.ComPortSpeed := br4800;   TimerTrocear.Interval := 580; end;
    6:  begin Port1.ComPortSpeed := br9600;   TimerTrocear.Interval := 500; end;
    7:  begin Port1.ComPortSpeed := br14400;  TimerTrocear.Interval := 420; end;
    8:  begin Port1.ComPortSpeed := br19200;  TimerTrocear.Interval := 340; end;
    9:  begin Port1.ComPortSpeed := br38400;  TimerTrocear.Interval := 260; end;
    10: begin Port1.ComPortSpeed := br56000;  TimerTrocear.Interval := 180; end;
    11: begin Port1.ComPortSpeed := br57600;  TimerTrocear.Interval := 140; end;
    12: begin Port1.ComPortSpeed := br115200; TimerTrocear.Interval := 80;  end;
  end;

  case ConfigPort1.cboParity.ItemIndex of
    0: Port1.ComPortParity := ptNone;
    1: Port1.ComPortParity := ptOdd;
    2: Port1.ComPortParity := ptEven;
    3: Port1.ComPortParity := ptMark;
    4: Port1.ComPortParity := ptSpace;
  end;

  case ConfigPort1.cboData.ItemIndex of
    0: Port1.ComPortDataBits := db5Bits;
    1: Port1.ComPortDataBits := db6Bits;
    2: Port1.ComPortDataBits := db7Bits;
    3: Port1.ComPortDataBits := db8Bits;
  end;

  case ConfigPort1.cboStop.ItemIndex of
    0: Port1.ComPortStopBits := sb1Bits;
    1: Port1.ComPortStopBits := sb1HalfBits;
    2: Port1.ComPortStopBits := sb2Bits;
  end;

  case ConfigPort1.cboFlow.ItemIndex of
    0: Port1.ComPortSwHandshaking := shNone;
    1: Port1.ComPortSwHandshaking := shXONXOFF;
  end;

  case ConfigPort1.cboHand.ItemIndex of
    0: Port1.ComPortHwHandshaking := hhNone;
    1: Port1.ComPortHwHandshaking := hhRtsCts;
  end;
end;

procedure TFmEscuchar.ConfigurarPuerto2Click(Sender: TObject);
begin
  {#To read the current configuration of the Port 2
   #Leer la configuracin actual del Puerto 2}
  ConfigPort2.cboPort.Enabled     := AbrirPuerto2.Enabled;
  ConfigPort2.cboPort.ItemIndex   := Ord(Port2.ComPort)+1;
  ConfigPort2.cboBaud.ItemIndex   := Ord(Port2.ComPortSpeed);
  ConfigPort2.cboData.ItemIndex   := Ord(Port2.ComPortDataBits);
  ConfigPort2.cboParity.ItemIndex := Ord(Port2.ComPortParity);
  ConfigPort2.cboStop.ItemIndex   := Ord(Port2.ComPortStopBits);
  ConfigPort2.cboHand.ItemIndex   := Ord(Port2.ComPortHwHandshaking);
  ConfigPort2.cboFlow.ItemIndex   := Ord(Port2.ComPortSwHandshaking);

  {#Settings Form Port 2
   #Formulario de configuracin del Puerto 2}
  ConfigPort2.ShowModal;

  {#To update the configuration of the port
   #Actualizar la configuracin del puerto}
  case ConfigPort2.cboPort.ItemIndex of
    1: Port2.ComPort := pnCom1;
    2: Port2.ComPort := pnCom2;
    3: Port2.ComPort := pnCom3;
    4: Port2.ComPort := pnCom4;
  end;

  case ConfigPort2.cboBaud.ItemIndex of
    0:  begin Port2.ComPortSpeed := br110;    TimerTrocear.Interval := 880; end;
    1:  begin Port2.ComPortSpeed := br300;    TimerTrocear.Interval := 800; end;
    2:  begin Port2.ComPortSpeed := br600;    TimerTrocear.Interval := 720; end;
    3:  begin Port2.ComPortSpeed := br1200;   TimerTrocear.Interval := 640; end;
    4:  begin Port2.ComPortSpeed := br2400;   TimerTrocear.Interval := 560; end;
    5:  begin Port2.ComPortSpeed := br4800;   TimerTrocear.Interval := 480; end;
    6:  begin Port2.ComPortSpeed := br9600;   TimerTrocear.Interval := 400; end;
    7:  begin Port2.ComPortSpeed := br14400;  TimerTrocear.Interval := 320; end;
    8:  begin Port2.ComPortSpeed := br19200;  TimerTrocear.Interval := 240; end;
    9:  begin Port2.ComPortSpeed := br38400;  TimerTrocear.Interval := 160; end;
    10: begin Port2.ComPortSpeed := br56000;  TimerTrocear.Interval := 80;  end;
    11: begin Port2.ComPortSpeed := br57600;  TimerTrocear.Interval := 65;  end;
    12: begin Port2.ComPortSpeed := br115200; TimerTrocear.Interval := 40;  end;
  end;

  case ConfigPort2.cboParity.ItemIndex of
    0: Port2.ComPortParity := ptNone;
    1: Port2.ComPortParity := ptOdd;
    2: Port2.ComPortParity := ptEven;
    3: Port2.ComPortParity := ptMark;
    4: Port2.ComPortParity := ptSpace;
  end;

  case ConfigPort2.cboData.ItemIndex of
    0: Port2.ComPortDataBits := db5Bits;
    1: Port2.ComPortDataBits := db6Bits;
    2: Port2.ComPortDataBits := db7Bits;
    3: Port2.ComPortDataBits := db8Bits;
  end;

  case ConfigPort2.cboStop.ItemIndex of
    0: Port2.ComPortStopBits := sb1Bits;
    1: Port2.ComPortStopBits := sb1HalfBits;
    2: Port2.ComPortStopBits := sb2Bits;
  end;

  case ConfigPort2.cboFlow.ItemIndex of
    0: Port2.ComPortSwHandshaking := shNone;
    1: Port2.ComPortSwHandshaking := shXONXOFF;
  end;

  case ConfigPort2.cboHand.ItemIndex of
    0: Port2.ComPortHwHandshaking := hhNone;
    1: Port2.ComPortHwHandshaking := hhRtsCts;
  end;
end;


procedure TFmEscuchar.Nuevo1Click(Sender: TObject);
begin
 {# To define a file to happen to you the data.
  # Definir un fichero para pasarle los datos.}

 OpenDialog1.Execute;
 EditFichero.Text := OpenDialog1.FileName;
 EditFichero.Text := AllTrim(EditFichero.Text); {#We eliminate spaces before and after
                                                 #Eliminamos espacios antes y despues}
 EditLng.Text     := '';  {# Init the length of Bytes received
                           # Inicializamos la longitud de Bytes recibidos}
 if EditFichero.Text = '' then begin
  ShowMessage('I need de name of file to receive. Thanks' + #13 +
              'Necesito el Nombre del fichero a recibir. Gracias');
  Exit;
 end;

 if FileExists(EditFichero.Text) then begin
   if Espaol1.Caption = '&English' then begin
     if MessageDlg('El Fichero ' + EditFichero.Text + ' ya existe. Sustituimos ?',
                   mtInformation, [mbYes, mbNo], 0) = mrNo
     then begin
      EditFichero.Text := '';
      Exit;
     end;
   end else if MessageDlg('The File ' + EditFichero.Text + ' exists. Replace ?',
                          mtInformation, [mbYes, mbNo], 0) = mrNo
            then begin
             EditFichero.Text := '';
             Exit;
            end;
 end;

 if Length(AllTrim(EditFichero.Text)) > 0 then begin
  AssignFile(OutFile, AllTrim(EditFichero.Text));
  {$I-}
  ReWrite(OutFile);
  {$I+}
  {# Function - IOresult - returns 0 if the file function is correct
   # Funcion -IOresult- devuelve 0 si la funcin de archivo es correcta}
  if IOResult <> 0 then begin
   if Espaol1.Caption = '&English' then
    MessageBox(0, 'No puedo abrir el archivo solicitado.' ,
                  'Error de Archivo', MB_ICONSTOP)
   else
    MessageBox(0, 'I can not open the solicited file.' ,
                  'File error', MB_ICONSTOP);

   Fic := False;
   Exit;
  end;
  Fic             := True;
  Nuevo1.Enabled  := False;
  Cerrar1.Enabled := True;
 end;

end;

procedure TFmEscuchar.Cerrar1Click(Sender: TObject);
begin
 {# Proceeding of closing the file
  # Procedimiento de cerrar el fichero}
 if Fic then CloseFile(OutFile);
 EditFichero.Text     := '';
 Fic                  := False;
 Nuevo1.Enabled       := True;
 Cerrar1.Enabled      := False;
end;

procedure TFmEscuchar.CarcteresdeControl1Click(Sender: TObject);
begin
 {# Small help to show the characters of ASCII control
  # Pequea ayuda para mostrar los caracteres de control ASCII}
 CaracteresDeControl.ShowModal;
end;

procedure TFmEscuchar.Acercade1Click(Sender: TObject);
begin
 {# Show About window
  # Mostrar ventana de Acerca de}
 FmAcercaDe.ShowModal;
end;

procedure TFmEscuchar.Timer1Timer(Sender: TObject);
var
  Sigma   : Extended;
  i       : Integer;
begin
  {# Security of the fact that we have configured I send it
   # Seguridad de que tenemos configurado el envio}
  if not Enviar then Exit;

  {# To de-activate the Timer to initiate it again upon ending of sending the package
   # Desactivar el Timer para iniciarlo otra vez al terminar de enviar el paquete}
  Timer1.Enabled := False;

  {#  General for the aleatory cable Packages of example

   The commission of these packages is that of to simulate I send it of
   Communications from a PC, as if they would be the sent actually additionally
   middle.

   For example, we suppose that we have a weigh scale that by means of
   a cellular with load send the value of heavy, and in the development of the
   application we wish power to prove if our program operates correctly. For this,
   we should capture previously the cable that sends, and after with a function
   of I calculate aleatory ( in this case is simulated with a function of
   statistic calculation with the one which the securitiess will be within a
   range of Sigma = x ) we send packages or cables simulating sent them by the
   cited scale.

   This is germane to any type of communication cable that we could
   to need, simply one must to adapt it.

   # General para los Paquetes de telegrama aleatorios de ejemplo

   La misin de estos paquetes es la de simular el envio de comunicaciones desde
   un PC, como si fueran los enviados realmente por otro medio.

   Por ejemplo, supongamos que tenemos una bscula de pesaje que por medio de
   una celula de carga envia el valor de pesado, y en el desarrollo de la aplicacin
   deseamos poder probar si nuestro programa funciona correctamente. Para ello,
   debemos capturar previamente el telegrama que enva, y despues con una
   funcin de calculo aleatorio ( En este caso se simula con una funcin de
   clculo estadstico con la cual los valores estarn dentro de un rango de
   Sigma = x ) enviamos paquetes o telegramas simulando los enviados por la
   bscula citada.

   Esto es aplicable a cualquier tipo de telegrama de comunicacin que podamos
   necesitar, simplemente hay que adaptarlo.
  }

  Sigma := 0.63455; {# Aleatory value
                     # Valor aleatorio.}
  Temp  := AlineaDcha(FLoatToStr(RandG(23.0,Sigma)),5);

  if Pos(',',Temp) > 0 then
   Temp := Copy(Temp,1,Pos(',',Temp)-1) + '.' +
           Copy(Temp,Pos(',',Temp)+1,Length(Temp)-Pos(',',Temp)+1);

  {******************************************}
  {#  Package dated as of and Hour
   # Paquete de Fecha y Hora }

  Pack1;

  {******************************************}
  {# Package of  Tlg Type 1 of example
   # Paquete de TLG Tipo 1 de ejemplo}

  Pack2;

  {******************************************}
  {# Package of  Tlg Type 2 of example
   # Paquete de TLG Tipo 2 de ejemplo}

  Pack3;

  {******************************************}
  {# Package of TLG Test, send the gambling of 255 ASCII Characters
   # Paquete de TLG Test, envia el juego de los 255 Caracteres ASCII}

  Pack4;

  {******************************************}
  {# To send a Text File
   # Enviar un Fichero de Texto}

  Pack5;

  {******************************************}
  {# To send a Polling
   # Enviar un Polling}

  Pack6;

  {******************************************}
  {# it be Insured of the fact that the Package has something that send
   # Asegurarse de que el Paquete tiene algo que enviar}
  if Length(AllTrim(Paquete)) = 0 then Exit;

  {# Curl of I send general of the Package - Tlg
   # Bucle de envio general del Paquete - Tlg}
  for i := 1 to Length(Paquete) do begin
   {# To convert the character to type Char to send it
    # Convertir el carcter a tipo Char para enviarlo}
   Car := Paquete[i];

   {# To send each character by the port selected
    # Enviar cada caracter por el puerto seleccionado}
   if RBPuerto1.Checked then Port1.SendData(@Car,SizeOf(Car))
   else Port2.SendData(@Car,SizeOf(Car));

   {# To write in the visor. Below Decimal 32 or above 175 is not will show the
      characters, by something which we show them  in  Hexadecimal
    # Escribir en el visor. Por debajo de Decimal 32 o por encima de 175 no se
      mostrarn los caracteres, por lo cual los mostramos en Hexadecimal}

   Valor := Ord(Car);
   if (Valor < 32) or (Valor > 175) or Hexa then begin
    if (Valor < 32) and Ctrl then Mjw.Write(CharCtrl[Valor])
    else Mjw.Write('(' + IntToHex(Valor,2) + ')'); {# Show Valor in Hexadecimal}
   end else Mjw.WriteChar(Car);                    {# Show Caracter ASCII}
  end;

  if Bloque then begin
   Mjw.WriteLn('');
   if Fic then Write(OutFile,Chr(13)+Chr(10)); {# Jump from 1 line in the file
                                                # Salto de 1 linea en el fichero}
  end;

  Timer1.Enabled := True;

end;

procedure TFmEscuchar.FechayHora1Click(Sender: TObject);
begin
 {# To define I send dated as of and hour
  # Definir envio de Fecha y hora}
 EditTlg.Text        := 'Fecha - Hora';
 ConfiguraEnvio;
 if not Bloque then BloqueTlgClick(nil);
end;

procedure TFmEscuchar.Cortar1Click(Sender: TObject);
begin
 {# To cut I send it of Tlg
  # Cortar el envio de Tlg}
 Timer1.Enabled          := False;
 TimerTrocear.Enabled    := False;
 Enviar                  := False;
 Application.ProcessMessages;
 Cortar1.Enabled         := False;
 FechayHora1.Enabled     := True;
 TLGTipo1.Enabled        := True;
 TLGTipo2.Enabled        := True;
 TLGTest1.Enabled        := True;
 Polling1.Enabled        := True;
 FicheroTexto1.Enabled   := True;
end;

procedure TFmEscuchar.EditTiempoChange(Sender: TObject);
begin
 {# Configuration of time frequency of I send of the Tlg. 1" := 1000
  # Configuracin de frecuencia de tiempo de envio del Tlg. 1" := 1000}
 Timer1.Interval := SeFrecuencia.Value;
end;

procedure TFmEscuchar.ConfiguraEnvio;
begin
 {# Control of the opening of ports before sending the Tlg
  # Control de la apertura de puertos antes de enviar el Tlg}
 if RBPuerto1.Checked and not CerrarPuerto1.Enabled then begin
  ShowMessage('The Port 1 is not opened.' + #13 +
              'El Puerto 1 no est abierto.');
  Exit;
 end;

 if RBPuerto2.Checked and not CerrarPuerto2.Enabled then begin
  ShowMessage('The Port 2 is not opened.' + #13 +
              'El Puerto 2 no est abierto.');
  Exit;
 end;

 {# To accuse the time of I send of the Cable
  # Acusar el tiempo de envio del Telegrama}
 EditTiempoChange(nil);

 {# To configure and to activate the Timer
  # Configurar y activar el Timer}
 Enviar                  := True;
 Cortar1.Enabled         := True;
 FechayHora1.Enabled     := False;
 TLGTipo1.Enabled        := False;
 TLGTipo2.Enabled        := False;
 TLGTest1.Enabled        := False;
 Polling1.Enabled        := False;
 FicheroTexto1.Enabled   := False;
 Timer1.Enabled          := True;

end;

procedure TFmEscuchar.Hexadecimal1Click(Sender: TObject);
begin
 {# To configure the Show in manner 100% Hexadecimal
  # Configurar el Show en modo 100% Hexadecimal}
 Hexa := True;
 Ctrl := False;
 Hexadecimal1.Enabled          := False;
 AsciiHexadecimal1.Enabled     := True;
 CtrlASCIIHexadecimal1.Enabled := True;
 Mjw.SetFocus;
end;

procedure TFmEscuchar.AsciiHexadecimal1Click(Sender: TObject);
begin
 {# To configure the Show in ASCII merged manner and Hexadecimal
  # Configurar el Show en modo combinado ASCII y Hexadecimal}
 Hexa := False;
 Ctrl := False;
 Hexadecimal1.Enabled          := True;
 AsciiHexadecimal1.Enabled     := False;
 CtrlASCIIHexadecimal1.Enabled := True;
 Mjw.SetFocus;
end;

procedure TFmEscuchar.BorrarPantalla1Click(Sender: TObject);
begin
 {# Clear screen
  # Borrar el visor}
 Mjw.ClrScr;
 Mjw.SetFocus;
end;

procedure TFmEscuchar.TLGTipo1Click(Sender: TObject);
begin
 {# To Send Tlg format that we define as Type 1 according to our necessities
  # Enviar Tlg formato que definamos como Tipo 1 segn nuestras necesidades}
 EditTlg.Text        := 'TLG Tipo 1';
 ConfiguraEnvio;
 if not Bloque then BloqueTlgClick(nil);
end;

procedure TFmEscuchar.TLGTipo2Click(Sender: TObject);
begin
 {# To Send Tlg format that we define as Type 2 according to our necessities
  # Enviar Tlg formato que definamos como Tipo 2 segn nuestras necesidades}
 EditTlg.Text        := 'TLG Tipo 2';
 ConfiguraEnvio;
 if not Bloque then BloqueTlgClick(nil);
end;

function TFmEscuchar.RandG(Mean, StdDev: Extended): Extended;
{# Algoritmo de Marsaglia-Bray  }
var
  U1, S2: Extended;
begin
  repeat
    U1 := 2*Random - 1;
    S2 := Sqr(U1) + Sqr(2*Random-1);
  until S2 < 1;
  Result := Sqrt(-2*Ln(S2)/S2) * U1 * StdDev + Mean;
end;

procedure TFmEscuchar.FormActivate(Sender: TObject);
begin

 Espaol1Click(nil);
 {# Conditions of beginning in RunTime
  # Condiciones de inicio en RunTime}
 FmEscuchar.Top  := 0;
 FmEscuchar.Left := 0;
 AbrirPuerto1Click(nil);
 AbrirPuerto2Click(nil);
 Mjw.ClrScr;

 FmEscuchar.SetFocus;
 Fic    := False;
 Hexa   := False;
 EditCaracter1Change(nil);
end;

procedure TFmEscuchar.Port1ReceiveData(Sender: TObject;
  DataPtr: Pointer; DataSize: Integer);
begin
 {# Reading proceeding of the port 1 and data processing
  # Procedimiento de lectura del puerto 2 y procesamiento de datos}
 PuertoReceive := '1';
 WriteInMjWinCrt(DataPtr, DataSize);
end;

procedure TFmEscuchar.Port2ReceiveData(Sender: TObject;
  DataPtr: Pointer; DataSize: Integer);
begin
 {# Reading proceeding of the port 2 and data processing
  # Procedimiento de lectura del puerto 2 y procesamiento de datos}
 PuertoReceive := '2';
 WriteInMjWinCrt(DataPtr, DataSize);
end;

procedure TFmEscuchar.WriteInMjWinCrt(DataPtr: Pointer; DataSize: Integer);
var
 p     : pchar;
 aChar : Char;
 bCtrl : Boolean;
 Valor,Hour,Min,Sec,MSec : Word;
begin
{# Reading proceeding of the port 1 and data processing
 # Procedimiento de lectura del puerto 1 y procesamiento de datos}

 DecodeTime(Time,Hour,Min,Sec,MSec);  {Coger la hora hasta los Milisegundos}

 {# Example of utilization of the data deed received  by the Port
  # Ejemplo de utilizacin de la escritura de datos recibidos por el Puerto

 procedure TFmEscuchar.Port1ReceiveData(Sender: TObject;
   DataPtr: Pointer; DataSize: Integer);
 var
  s: string;
  p := DataPtr;
 begin
  s := '';
  while DataSize > 0 do
   s := s + p^;
   dec( DataSize );
   inc( p );
  end;
 end;
 }

 {#Write sample
  #Ejemplo de escritura

  CommPortDriver.SendData( pchar(s), length(s) );
  CommPortDriver.SendData( @Key, 1 );
 }

 bCtrl := True;
 p     := DataPtr;
 while DataSize > 0 do {# Curl by the characters received in the event
                        # Bucle por los caracteres recibidos en el evento}
 begin

  if (not ContinuaTlg) or (PuertoUltimo <> PuertoReceive) then begin

   if Bloque and bCtrl then begin
    BCtrl := False;               {# Variable of control so that alone is performed 1 time to the beginning of the Tlg
                                   # Variable de control para que solo se ejecute 1 vez al inicio del Tlg}
    Mjw.WriteChar(Chr(13));       {# To jump of line in the visor
                                   # Saltar de linea en el visor}
    Mjw.WriteChar(Chr(13));
    Mjw.WriteLn('- P1 - ' +
            IntToStr(Hour) + ':' +
            IntToStr(Min)  + ':' +
            IntToStr(Sec)  + ':' +
            IntToStr(MSec) + '  -> ');

    if Fic then begin                {# If we have defined file, we wrote in the
                                      # Si tenemos fichero definido, escribimos en el}
     Write(OutFile,Chr(13)+Chr(10)); {# Salto de 2 lineas en el fichero}
     Write(OutFile,Chr(13)+Chr(10)); {# Jump from 2 lines in the file}
     Write(OutFile,'- P1 - ' +
           IntToStr(Hour) + ':' +
           IntToStr(Min)  + ':' +
           IntToStr(Sec)  + ':' +
           IntToStr(MSec) + '  -> ');
     Write(OutFile,Chr(13) + Chr(10));
    end;
   end;
  end;

  {# Reading of a character of the port on 'aChar'
   # Lectura de un caracter del puerto sobre 'aChar'}
  aChar := p^;
  dec( DataSize );
  inc( p );
  Lng   := Lng + 1;   {# Quantity of characters received. Adds 2 ports
                       # Cantidad de caracteres recibidos. Suma los 2 puertos}
  Valor := Ord(aChar);
  {# It has read a character in the port and we wrote it in file and crt
   # Ha leido un caracter en el puerto y lo escribimos en fichero y visor}
  if aChar <> Chr(0) then begin {Si vale mas de 0, vemos si el caracter es de escucha}
   if ((C1 > 0) and (Valor = C1)) OR
      ((C2 > 0) and (Valor = C2)) OR
      ((C3 > 0) and (Valor = C3)) OR
      ((C4 > 0) and (Valor = C4)) then
   begin

   {# Write in crt
    # Escribir en el visor}
   Mjw.WriteChar(Chr(13));
   Mjw.WriteLn('## [' + IntToStr(Valor) + ']' );

   {# Write in file
    # Escribir en el fichero}
   if Fic then begin
    Write(OutFile,Chr(13) + Chr(10));
    Write(OutFile,'## [' + IntToStr(Valor) + '] ');
    Write(OutFile,Chr(13) + Chr(10));
   end;
  end;
 end;

 {# To write in the visor. Below Decimal 32 or above 175 is not
    will show the characters, by something which we show them  in Hexadecimal
  # Escribir en el visor. Por debajo de Decimal 32 o por encima de 175 no se
    mostrarn los caracteres, por lo cual los mostramos en Hexadecimal}
 if (Valor < 32) or (Valor > 175) or Hexa then begin
  if (Valor < 32) and Ctrl then Mjw.Write(CharCtrl[Valor])
   else Mjw.Write('(' + IntToHex(Valor,2) + ')'); {Show Valor en Hexadecimal}
 end else Mjw.WriteChar(aChar);                   {Show Caracter ASCII}

 {# Write in file
  # Escribir en el fichero}
 if Fic then
  if (Valor < 32) or (Valor > 175) or Hexa then begin
   if (Valor < 32) and Ctrl then Write(OutFile,CharCtrl[Valor])
   else Write(OutFile,'(' + IntToHex(Valor,2) + ')')
  end else Write(OutFile, aChar);

 end;
 EditLng.Text := IntToStr(Lng); {# To indicate the length of bytes read
                                 # Indicar la longitud de bytes leidos}

 PuertoUltimo := PuertoReceive; {# Last Port, to control the Lag between characters
                                 # Ultimo Puerto, para controlar el Retraso entre caracteres}

 {# We activate the control of lag between characters
  # Activamos el control de retraso entre caracteres}
 TimerDelay.Enabled := False;
 TimerDelay.Enabled := True;
 ContinuaTlg        := True;
end;

procedure TFmEscuchar.BloqueTlgClick(Sender: TObject);
begin
 {# To jump of line each data block received
  # Saltar de linea cada bloque de datos recibido}
 if not Bloque then begin
  Bloque := True;
  if Espaol1.Caption = '&Espaol' then
   BloqueTlg.Caption := '&No Line jump for Tlg'
  else BloqueTlg.Caption := '&No Saltar de Linea por Tlg';

 end else begin
  Bloque := False;
  if Espaol1.Caption = '&Espaol' then
   BloqueTlg.Caption := '&Line jump for Tlg'
  else BloqueTlg.Caption := '&Saltar de Linea por Tlg';
 end;
 Mjw.SetFocus;
end;

procedure TFmEscuchar.Espaol1Click(Sender: TObject);
begin
 if Espaol1.Caption = '&Espaol' then begin
 {# To configure the menus of the program in Spanish
  # Configurar los menus del programa en espaol}
  Espaol1.Caption             := '&English';
  GBSend.Caption              := ' Enviar Telegramas ' ;
  GBPuerto1.Caption           := ' Escuchar Port 1 ';
  GBPuerto2.Caption           := ' Escuchar Port 2 ';
  Label1.Caption              := 'Fichero';
  Label2.Caption              := 'Recibidos';
  Label3.Caption              := 'Valores en Decimal';
  Label4.Caption              := 'Valores en Decimal';
  Label5.Caption              := 'Puerto';
  Label6.Caption              := 'Tipo Tlg. Envio';
  Archivo1.Caption            := '&Archivo';
  Nuevo1.Caption              := '&Nuevo';
  Cerrar1.Caption             := '&Cerrar';
  Acercade1.Caption           := '&Acerca de';
  Salir1.Caption              := '&Salir';
  Configurar1.Caption         := '&Configurar';
  ConfigurarPuerto1.Caption   := 'Puerto &1';
  ConfigurarPuerto2.Caption   := 'Puerto &2';
  Puertos1.Caption            := '&Puertos';
  AbrirPuerto1.Caption        := '&Abrir Puerto 1';
  AbrirPuerto2.Caption        := 'A&brir Puerto 2';
  CerrarPuerto1.Caption       := '&Cerrar Puerto 1';
  CerrarPuerto2.Caption       := 'C&errar Puerto 2';
  Ver1.Caption                := '&Ver';
  BloqueTlg.Caption           := '&Saltar de Linea por Tlg';
  ModoTerminal1.Caption       := 'Modo &Terminal';
  BorrarPantalla1.Caption     := '&Borrar Pantalla';
  Enviar1.Caption             := '&Enviar';
  FechayHora1.Caption         := '&Fecha y Hora';
  TLGTipo1.Caption            := 'TLG Tipo &1';
  TLGTipo2.Caption            := 'TLG Tipo &2';
  FicheroTexto1.Caption       := '&Fichero Texto';
  Cortar1.Caption             := '&Cortar';
  Idioma1.Caption             := '&Idioma';
  Ayuda1.Caption              := 'A&yuda';
  CarcteresdeControl1.Caption := '&Caracteres de Control';
  CaracteresAscii1.Caption    := 'Caracteres &Ascii';
 end else begin

 {# To configure the menus of the program in English
  # Configurar los menus del programa en Ingles}
  Espaol1.Caption             := '&Espaol';
  GBSend.Caption              := ' Send Messages ' ;
  GBPuerto1.Caption           := ' Read Port 1 ';
  GBPuerto2.Caption           := ' Read Port 2 ';
  Label1.Caption              := 'File Txt';
  Label2.Caption              := 'Receive';
  Label3.Caption              := 'Decimal Value';
  Label4.Caption              := 'Decimal Value';
  Label5.Caption              := 'Port';
  Label6.Caption              := 'Type Msg. Send';
  Archivo1.Caption            := '&File';
  Nuevo1.Caption              := '&New';
  Cerrar1.Caption             := '&Close';
  Acercade1.Caption           := '&About..';
  Salir1.Caption              := '&Exit';
  Configurar1.Caption         := '&Settings';
  ConfigurarPuerto1.Caption   := 'Port &1';
  ConfigurarPuerto2.Caption   := 'Port &2';
  Puertos1.Caption            := '&Port';
  AbrirPuerto1.Caption        := '&Open Port 1';
  AbrirPuerto2.Caption        := 'O&pen Port 2';
  CerrarPuerto1.Caption       := '&Close Port 1';
  CerrarPuerto2.Caption       := 'C&lose Port 2';
  Ver1.Caption                := '&View';
  BloqueTlg.Caption           := '&Line jump for Tlg';
  ModoTerminal1.Caption       := '&Terminal Mode';
  BorrarPantalla1.Caption     := '&Clear Screen';
  Enviar1.Caption             := '&Send';
  FechayHora1.Caption         := '&Date and Time';
  TLGTipo1.Caption            := 'TLG Type &1';
  TLGTipo2.Caption            := 'TLG Type &2';
  FicheroTexto1.Caption       := '&File Text';
  Cortar1.Caption             := '&Cut';
  Idioma1.Caption             := '&Language';
  Ayuda1.Caption              := '&Help';
  CarcteresdeControl1.Caption := '&Characters of Control ';
  CaracteresAscii1.Caption    := 'Characters &Ascii';
 end;
end;

procedure TFmEscuchar.SEFrecuenciaChange(Sender: TObject);
var
 TimerStatus : Boolean;
begin
 {# To configure the time of I send of cables
  # Configurar el tiempo de envio de telegramas}
 TimerStatus     := Timer1.Enabled;
 Timer1.Enabled  := False;
 try
  if SEFrecuencia.Value > 0 then Timer1.Interval := SEFrecuencia.Value;
 except
  SEFrecuencia.Value := 10;
 end;
 Timer1.Enabled  := TimerStatus;
end;

procedure TFmEscuchar.CtrlASCIIHexadecimal1Click(Sender: TObject);
begin
 {# To configure the Show in merged manner Characters of Ctrl, ASCII and Hexadecimal
  # Configurar el Show en modo combinado Caracteres de Ctrl, ASCII y Hexadecimal}
 Hexa := False;
 Ctrl := True;
 Hexadecimal1.Enabled          := True;
 AsciiHexadecimal1.Enabled     := True;
 CtrlASCIIHexadecimal1.Enabled := False;
 Mjw.SetFocus;

end;

procedure TFmEscuchar.TlgTest1Click(Sender: TObject);
begin
 {# To Send Tlg format that we define as Type 1 according to our necessities
  # Enviar Tlg formato que definamos como Tipo 1 segn nuestras necesidades}
 EditTlg.Text        := 'TLG Test';
 ConfiguraEnvio;
 if not Bloque then BloqueTlgClick(nil);
end;

procedure TFmEscuchar.FicheroTexto1Click(Sender: TObject);
begin
 {# To advise of the fact that it must be established a control of flow of the port
  # Avisar de que debe establecerse un control de flujo del puerto}

 ShowMessage('El Control de Flujo del Puerto, debe ser XON/XOFF o RTS/CTS.' + #13 +
             'The Flow Control of the Port, it must be XON/XOFF or RTS/CTS');
 {# To define the file that we go to transmit.
  # Definir el fichero que vamos a transmitir.}
 OpenDialog1.Execute;
 EditFichero.Text := OpenDialog1.FileName;
 EditFichero.Text := AllTrim(EditFichero.Text); {# We eliminate spaces before and after
                                                 # Eliminamos espacios antes y despues}
 if EditFichero.Text = '' then begin
  ShowMessage('Necesito el nombre del fichero a transmitir. Gracias' + #13 +
              'I need the name of the file to transmit. Thanks.');
  Exit;
 end;
 {# To send a text file
  # Enviar un fichero de texto}
 EditTlg.Text        := 'Fic.Texto';
 ConfiguraEnvio;

end;

procedure TFmEscuchar.EnviaFichero(FileText : String);
var
 Fic     : File of Byte;
 InFic   : TextFile;
 i       : Integer;
 Car     : Char;
begin
 {# This proceeding serves solely for the I send of text files, and by
    it so much will not operate with binary files or of other type
  # Este procedimiento sirve unicamente para el envio de ficheros de texto, y por
    lo tanto no funcionar con ficheros binarios o de otro tipo}

(*
 {# To obtain the size from the file. Not used in this example
  # Obtener el tamao del fichero. No utilizado en este ejemplo}
 AssignFile(Fic,FileText);
 Reset(Fic);
 EditLng.Text := IntToStr(FileSize(Fic));
 CloseFile(Fic);
 *)

 AssignFile(InFic,FileText);
 {$I-}
 Reset(InFic);
 {$I+}

 if IOResult <> 0 then begin
  ShowMessage('Incapaz de leer el fichero' + #13 +
              'Unable to read the file');
  Exit;
 end;

 {# We happen the content of the file to a String
  # Pasamos el contenido del fichero a un String}
 StrFic := '';
 while not Eof(InFic) do begin
  Read(InFic, Car);
  StrFic := StrFic + Car;
 end;
 CloseFile(InFic);

(*
 {# This would be other simple form of sending the file, but we would lose the
    control of the application while send it.
  # Esta sera otra forma simple de enviar el fichero, pero perderamos el control
    de la aplicacin mientras lo envia.}

 if RBPuerto1.Checked then Port1.SendString(StrFic)
 else Port2.SendString(StrFic);

 Exit;
*)

 Lng := Length(StrFic); {# Length of the file
                         # Longitud del fichero}
 Ind := 1; {# Position index of the file
            # Indice de posicin del fichero}

 TimerTrocearTimer(nil); {# To activate I send it of the file
                          # Activar el envio del fichero}

end;

procedure TFmEscuchar.TimerTrocearTimer(Sender: TObject);
var
 Ultimo : Boolean;
 i      : Integer;
 Car    : Char;
begin
 {# In this proceeding is sent the file by parts for power to follow having the
    control of the application. If is wished to transfer the file between 2
    principals, it can be established a protocol employing a size head-board
    fixed codifying the beginning, size, name, etc. of the same, so that is
    coordinate what is sent and is received. In this example there is no
    implemented no type of protocol.


  # En este procedimiento se envia el fichero por partes para poder seguir
    teniendo el control de la aplicacin. Si se desea transferir el fichero entre 2
    ordenadores, se puede establecer un protocolo empleando una cabecera de tamao
    fijo codificando el inicio, tamao, nombre, etc. del mismo, de forma que se
    coordine lo que se envia y se recibe. En este ejemplo no hay implementado ningn
    tipo de protocolo.}

 TimerTrocear.Enabled := False;
 if not Enviar then Exit;

 for i := Ind to Ind + 254 do begin
  if Ind > Lng then begin
   EditLng.Text := IntToStr(Ind);
   Cortar1Click(nil);
   Exit;
  end;

  Car := StrFic[i];
  Inc(Ind);
  Application.ProcessMessages;

  {# To send each character by the port selected
   # Enviar cada caracter por el puerto seleccionado}
  if RBPuerto1.Checked then Port1.SendData(@Car,SizeOf(Car))
  else Port2.SendData(@Car,SizeOf(Car));

  {# To write in the visor. Below Decimal 32 or above 175 is not
     will show the characters, by something which we show them  in Hexadecimal
   # Escribir en el visor. Por debajo de Decimal 32 o por encima de 175 no se
     mostrarn los caracteres, por lo cual los mostramos en Hexadecimal}
  Valor := Ord(Car);
  if (Valor < 32) or (Valor > 175) or Hexa then begin
   if (Valor < 32) and Ctrl then Mjw.Write(CharCtrl[Valor])
   else Mjw.Write('(' + IntToHex(Valor,2) + ')'); {Show Valor en Hexadecimal}
  end else Mjw.WriteChar(Car);                    {Show Caracter ASCII}
 end;
 EditLng.Text := IntToStr(Ind);
 EditLng.Refresh;
 TimerTrocear.Enabled := True;
end;

procedure TFmEscuchar.Polling1Click(Sender: TObject);
var
 sPollingTmp : String;
begin
 {# To Send Tlg format that we define as Type 2 according to our necessities
  # Enviar Tlg formato que definamos como Tipo 2 segn nuestras necesidades}
 EditTlg.Text   := 'Polling';
 sPollingTmp    := ExitInteger(InputBox('Polling','N Estaciones','6'));
 if sPollingTmp <> '0' then nPollingMax := StrToInt(sPollingTmp) else nPollingMax := 6;
 nPollingActual := 1;
 ConfiguraEnvio;
 if not Bloque then BloqueTlgClick(nil);
end;

procedure TFmEscuchar.EnviaPolling;
begin
 {# I send of Polling to a number of given stations
  # Envio de Polling a un nmero de estaciones determinado}
 nPollingActual := nPollingActual + 1;
 if nPollingActual > nPollingMax then nPollingActual := 1;
 Paquete := DLE + ENQ + Chr(nPollingActual);
end;

procedure TFmEscuchar.SEDelayChange(Sender: TObject);
var
 TimerStatus : Boolean;
begin
 {# Lag in the acceptance of characters by the port. Some Communications
    of industrial type, or where there are Nets and distributing of ports, delay
    the continuity of the communication

  # Retraso en la recepcin de caracteres por el puerto. Algunas comunicaciones
    de tipo industrial, o donde hay Redes y repartidores de puertos, retrasan la
    continuidad de la comunicacin}

 TimerStatus         := TimerDelay.Enabled;
 TimerDelay.Enabled  := False;
 try
  if SEDelay.Value > 0 then TimerDelay.Interval := SEDelay.Value;
 except
  SEDelay.Value := 300;
 end;
 TimerDelay.Enabled  := TimerStatus;
end;

procedure TFmEscuchar.TimerDelayTimer(Sender: TObject);
begin
 ContinuaTlg := False;
end;

procedure TFmEscuchar.ModoTerminal1Click(Sender: TObject);
begin
 {# To alternate the Terminal Manner Menu to Monitor Manner and conversely
  # Alternar el Men de Modo Terminal a Modo Monitor y viceversa}

 if      ModoTerminal1.Caption = 'Modo &Monitor'  then ModoTerminal1.Caption := 'Modo &Terminal'
 else if ModoTerminal1.Caption = 'Modo &Terminal' then ModoTerminal1.Caption := 'Modo &Monitor'
 else if ModoTerminal1.Caption = '&Monitor Mode'  then ModoTerminal1.Caption := '&Terminal Mode'
 else if ModoTerminal1.Caption = '&Terminal Mode' then ModoTerminal1.Caption := '&Monitor Mode';

 if Pos('Monitor',ModoTerminal1.Caption) > 0 then Mjw.SetFocus;
end;

procedure TFmEscuchar.MjwKeyPress(Sender: TObject; var Key: Char);
begin
 {# Operation of the Port in Terminal Manner, sending the written characters
    for the port selected
  # Funcionamiento del Puerto en Modo Terminal, enviando los caracteres escritos
    por el puerto seleccionado}
 if Pos('Monitor',ModoTerminal1.Caption) > 0 then begin
  if RBPuerto1.Checked then Port1.SendData(@Key, 1)
  else Port2.SendData(@Key, 1);
  Mjw.Write(Char(Key));
 end;
end;

procedure TFmEscuchar.CaracteresAscii1Click(Sender: TObject);
begin
 {# Help screen showing the gambling of characters Ascii
  # Pantalla de ayuda mostrando el juego de caracteres Ascii}
 FCarAscii.ShowModal;
end;

procedure TFmEscuchar.Pack1;
begin
 {#  Package dated as of and Hour
  # Paquete de Fecha y Hora }
 if EditTlg.Text = 'Fecha - Hora' then begin
  Paquete := DateToStr(Date)+ ' ' +  TimeToStr(Time);
  if Bloque then Paquete := Paquete + Chr(13) + Chr(10);
 end;
 
end;

procedure TFmEscuchar.Pack2;
begin
 {# Package of  Tlg Type 1 of example
  # Paquete de TLG Tipo 1 de ejemplo}
 if EditTlg.Text = 'TLG Tipo 1' then begin
  Temp := AlineaDcha(Copy(Temp,1,5),5);
  if Pos(',',Temp) > 0 then
   Temp := Copy(Temp,1,Pos(',',Temp)-1) + '.' +
           Copy(Temp,Pos(',',Temp)+2,Length(Temp)-Pos(',',Temp)+2);
  Paquete := Temp + ' Kg';
  if Bloque then Paquete := Paquete + Chr(13) + Chr(10);
 end;
end;

procedure TFmEscuchar.Pack3;
begin
 {# Package of  Tlg Type 2 of example
  # Paquete de TLG Tipo 2 de ejemplo}
 if EditTlg.Text = 'TLG Tipo 2' then begin
  Temp := AlineaDcha(Copy(Temp,1,4),5);
  if Pos(',',Temp) > 0 then
   Temp := Copy(Temp,1,Pos(',',Temp)-1) + '.' +
           Copy(Temp,Pos(',',Temp)+1,Length(Temp)-Pos(',',Temp)+1);

  Paquete := DateToStr(Date) +' '+ Copy(TimeToStr(Time),1,5) +' '+ Temp + ' Kg';
  if Bloque then Paquete := Paquete + Chr(13) + Chr(10);
 end;
end;

procedure TFmEscuchar.Pack4;
var
 i : Integer;
begin
 {# Package of TLG Test, send the gambling of 255 ASCII Characters
  # Paquete de TLG Test, envia el juego de los 255 Caracteres ASCII}
 if EditTlg.Text = 'TLG Test' then begin
  Paquete := '';
  for i := 0 to 254 do Paquete := Paquete + Chr(i);
  if Bloque then Paquete := Paquete + Chr(13) + Chr(10);
 end;
end;

procedure TFmEscuchar.Pack5;
begin
 {# To send a Text File
  # Enviar un Fichero de Texto}

 if EditTlg.Text = 'Fic.Texto' then begin
  Paquete := '';
  EnviaFichero(EditFichero.Text);
 end;

end;

procedure TFmEscuchar.Pack6;
begin
 {# To send a Polling
  # Enviar un Polling}

 if EditTlg.Text = 'Polling' then begin
  Paquete := '';
  EnviaPolling;
 end;
end;

end.
