{
TCEdit Timecode entry edit box component V1.0. Freeware.
Delphi 2.0. (C) May 1998, by Martin R Coster. Email: mrc@pacific.net.sg
Please see TCEdit.txt for more info.
}
unit TCEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, Buttons, DsgnIntf, stdctrls;

type
  TTCEdit = class(TEdit)
  private
    FMilisecs: integer;
    FDoFrames: boolean;
    FOffset: boolean;
    FFrameRate : byte;
    FMaxHours : byte;
    FMaxMins : byte;
    FMaxSecs : byte;
    FHours : byte;
    FMins : byte;
    FSecs : byte;
    FFrames : byte;
    FDblClickClr : boolean;
  public
    constructor Create(AOwner: TComponent); override;
    procedure KeyPress(var Key: Char); override;
    procedure DblClick; override;
    procedure DoEnter; override;
    procedure DoExit; override;
    function TCToMili(TimeString: string) : Integer;
    function MiliToTC(TCTime: integer) : string;
    procedure GetMilisecs(NewValue : integer);
    procedure GetHours(NewValue : byte);
    procedure GetMins(NewValue : byte);
    procedure GetSecs(NewValue : byte);
    procedure GetFrames(NewValue : byte);
    procedure BuildHMSF;
    procedure BadTime;
  published
    property Milisecs: integer read FMilisecs write GetMilisecs;
    property DoFrames: boolean read FDoFrames write FDoFrames;
    property Offset: boolean read FOffset write FOffset;
    property FrameRate: byte read FFrameRate write FFrameRate;
    property MaxHours: byte read FMaxHours write FMaxHours;
    property MaxMins: byte read FMaxMins write FMaxMins;
    property MaxSecs: byte read FMaxSecs write FMaxSecs;
    property Hours: byte read FHours write GetHours;
    property Mins: byte read FMins write GetMins;
    property Secs: byte read FSecs write GetSecs;
    property Frames: byte read FFrames write GetFrames;
    property DblClickClr: boolean read FDblClickClr write FDblClickClr;
    Property Text;
  end;

procedure Register;

implementation

constructor TTCEdit.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Width          := 65;
  Text           := '00:00:00.00';
  fMilisecs      := 0;
  fHours         := 0;
  fMins          := 0;
  fSecs          := 0;
  fFrames        := 0;
  fDoFrames      := false;
  fOffset        := false;
  fFrameRate     := 25;
  fMaxHours      := 23;
  fMaxMins       := 59;
  fMaxSecs       := 59;
  fDblClickClr   := false;
end;

procedure TTCEdit.GetMilisecs;
begin
     If fMilisecs <> NewValue then
     begin
        fMilisecs := NewValue;
        Text := MiliToTC(Milisecs); //Coverts it to a formatted string
     end;
end;

procedure TTCEdit.GetHours;
begin
     If (fHours <> NewValue) and (NewValue >= 0) and (NewValue <= MaxHours) then
     begin
        fHours := NewValue;
        BuildHMSF;
     end;
end;

procedure TTCEdit.GetMins;
begin
     If (fMins <> NewValue) and (NewValue >= 0) and (NewValue <= MaxMins) then
     begin
        fMins := NewValue;
        BuildHMSF;
     end;
end;

procedure TTCEdit.GetSecs;
begin
     If (fSecs <> NewValue) and (NewValue >= 0) and (NewValue <= MaxSecs) then
     begin
        fSecs := NewValue;
        BuildHMSF;
     end;
end;

procedure TTCEdit.GetFrames;
begin
     If (fFrames <> NewValue) and (NewValue >= 0) and (NewValue <= (fFrameRate-1)) then
     begin
        fFrames := NewValue;
        BuildHMSF;
     end;
end;

procedure TTCEdit.BuildHMSF;
begin
     text := Format('%.2d', [fHours]) + ':' +
             Format('%.2d', [fMins]) + ':' +
             Format('%.2d', [fSecs]) + '.' +
             Format('%.2d', [fFrames]);

     fMilisecs := TcToMili(text);
end;

//This will optionally auto clear the timecode if the user double clicks it
procedure TTCEdit.DblClick;
begin
     If fDblClickClr then
     begin
          Text := '00:00:00.00';
          fMilisecs := 0;
          fDoFrames := false;
          fOffset := false;
     end;
     inherited;
end;

//When user enters TCEdit, make sure we're in H,M,S fields
procedure TTCEdit.DoEnter;
begin
     fDoFrames := false;
     inherited;
end;

//Validates TC box and updates Milisecs
procedure TTCEdit.DoExit;
begin
     If (Copy(text,3,1) <> ':') or
        (Copy(text,6,1) <> ':') or
        (Copy(text,9,1) <> '.') then BadTime
     else
     begin
          Try
             If (StrToInt(Copy(Text,1,2)) > fMaxHours) or
                (StrToInt(Copy(Text,4,2)) > fMaxMins) or
                (StrToInt(Copy(Text,7,2)) > fMaxSecs) or
                (StrToInt(Copy(Text,10,2)) > (fFrameRate - 1)) Then
                begin
                     fMilisecs := -1;
                     MessageDlg('Invalid timecode entered!', mtError, [mbOk], 0);
                end
             else fMilisecs := TcToMili(Text); //Return miliseconds of timecode string
          except
             else BadTime;
          end;
          inherited;
     end;
end;

procedure TTCEdit.BadTime;
begin
     fMilisecs := -1;
     MessageDlg('Error in timecode format!', mtError, [mbOk], 0);
     Text := '00:00:00.00';
     fDoFrames := false;
     fOffset := false;
end;

//Validate each keypress, and format text in edit box...
procedure TTCEdit.KeyPress(var Key: Char);
Var
   TimeC : string;
   Frames : string;
begin
   TimeC := Copy(Text,1,2) + Copy(Text,4,2) + Copy(Text,7,2); //Get the H,M,S part without the ':'
   Frames := Copy(Text,10,2); //And get the frames

   case Key of  //Now work out what to do...
        '+': Offset := True;
        '*': Offset := false;
       	'.': DoFrames := True;
	'0'..'9':
	begin
             If fDoFrames = true Then    //ie; if user has previously typed . then now do the frames
	     begin
	          Frames := Frames + Key;	//Add the new character to the frames bit
		  If Length(Frames) > 2 Then Delete(Frames,1,1); //Only 2 digits allowed!
             end
	     else    //Otherwise we're doing the H,M,S bit
	     begin
	          TimeC := TimeC + Key;
		  If Length(TimeC) > 6 Then Delete(TimeC,1,1);
             end;
	     Text := Copy(TimeC,1,2) + ':' + //Hours
                     Copy(TimeC,3,2) + ':' + //Mins
                     Copy(TimeC,5,2) + '.' + //Secs
                     Frames;                 //You guessed it!
        end;
   end;
   fMilisecs := TcToMili(Text); //Return miliseconds of timecode string
   Key := Chr(0); //Stop windoze doing it's stuff
end;

//Converts a time in miliseconds into a formatted timecode string
//This is messy, yet somehow I can't work out any simpler way!
function TTCEdit.MiliToTC(TCTime: integer): String;
var
     TempTime, H, M, S, F: integer;
     x : String;
begin
     If TCTime > 0 then
     begin
          TempTime := TCTime Div 1000;
          H := TempTime Div 3600;
          M := (TempTime - (H * 3600)) Div 60;
          S := TempTime - (H * 3600) - (M * 60);
          x := IntToStr(TCTime);
          If Length(x) > 3 then x := Copy(x,Length(x)-2,3);
          F := StrToInt(x) Div (1000 Div FrameRate);
          MiliToTC := Format('%.2d', [H]) + ':' +
                      Format('%.2d', [M]) + ':' +
                      Format('%.2d', [S]) + '.' +
                      Format('%.2d', [F]);
     end
     else MiliToTC := '00:00:00.00';
end;

//Converts a formatted timecode string into milisecs integer
function TTCEdit.TCToMili(TimeString: string) : Integer;
Begin
     Try
        TCToMili := (StrToInt(Copy(TimeString,1,2)) * 3600000) +  //Hours
                    (StrToInt(Copy(TimeString,4,2)) * 60000) +    //Minutes
                    (StrToInt(Copy(TimeString,7,2)) * 1000) +     //Seconds
                    (StrToInt(Copy(TimeString,10,2)) * (1000 Div FrameRate));//Frames
     except
        else TCToMili := -1;  //If anything screws up then return a -1
     end;
end;

procedure Register;
begin
     RegisterComponents('Additional', [TTCEdit]);
end;

end.
