unit TbPrintV;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin, Printers;

type
  TPrintPreview = class(TForm)
    PrinterPanel: TPanel;
    ModoImpresion: TRadioGroup;
    LPrinter: TLabel;
    ActualPrinter: TComboBox;
    LTamanio: TLabel;
    LSize: TLabel;
    LCopias: TLabel;
    Copias: TSpinEdit;
    BtnPropiedades: TButton;
    ButtonPanel: TPanel;
    LPag: TLabel;
    LPagN: TLabel;
    LTotPag: TLabel;
    LZoom: TLabel;
    ZoomShower: TSpinEdit;
    BtnReal: TButton;
    BtnAncho: TButton;
    BtnCompleta: TButton;
    BtnPagPri: TButton;
    BtnPagAnt: TButton;
    BtnPagSig: TButton;
    BtnPagUlt: TButton;
    BtnImpActual: TButton;
    BtnImpTodo: TButton;
    BtnCancelar: TButton;
    Scroller: TScrollBox;
    Shower: TPaintBox;
    BtnExcel: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure CopiasChange(Sender: TObject);
    procedure ZoomShowerChange(Sender: TObject);
    procedure ShowerPaint(Sender: TObject);
    procedure BtnRealClick(Sender: TObject);
    procedure BtnAnchoClick(Sender: TObject);
    procedure BtnCompletaClick(Sender: TObject);
    procedure BtnPagPriClick(Sender: TObject);
    procedure BtnPagAntClick(Sender: TObject);
    procedure BtnPagSigClick(Sender: TObject);
    procedure BtnPagUltClick(Sender: TObject);
    procedure BtnCancelarClick(Sender: TObject);
    procedure BtnImpActualClick(Sender: TObject);
    procedure BtnImpTodoClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ShowerMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ModoImpresionClick(Sender: TObject);
    procedure ActualPrinterChange(Sender: TObject);
    procedure BtnPropiedadesClick(Sender: TObject);
  private
    { Private declarations }
    FPagina : integer;
    FZoom : Double;
    TbPrinter : TComponent;
    procedure EscribirTamanioPapel;
    procedure SetZoom(Valor : integer);
  public
    Hoja : TMetaFile;
    { Public declarations }
  end;

var
  PrintPreview: TPrintPreview;

implementation

{$R *.DFM}

uses TbPrint;

procedure TPrintPreview.FormCreate(Sender: TObject);
begin
  Width := Screen.Width - 30;
  Height := Screen.Height - 30;
  Left := 0;
  Top := 0;
  Screen.Cursors[1] := LoadCursor(hInstance,'TBZOOM');
  TbPrinter := Owner;
  FPagina := 1;
  Hoja := TMetaFile.Create;
  Hoja.Width := Round(TTbPrinter(TbPrinter).PageWidthP * 80); // div 4; // 640;
  Hoja.Height := Round(TTbPrinter(TbPrinter).PageHeightP * 80); // div 4; // 1056;
  if TTbPrinter(TbPrinter).Mode = pmWindows then
    begin
      ModoImpresion.ItemIndex := 1;
      ActualPrinter.Items := Printer.Printers;
      ActualPrinter.ItemIndex := Printer.PrinterIndex;
    end
  else
    begin
      ModoImpresion.ItemIndex := 0;
      TTbPrinter(TbPrinter).GetModelos(ActualPrinter.Items);
      ActualPrinter.ItemIndex := Ord(TTbPrinter(TbPrinter).FastPrinter);
    end;
  EscribirTamanioPapel;
  if not assigned(TTbPrinter(TbPrinter).SendToExcel) then
    BtnExcel.Enabled := False;
  Shower.Width := Shower.Canvas.TextWidth('X')*80+20;
  Shower.Height := Shower.Canvas.TextHeight('X')*66+20;
  WindowState := wsMaximized;
end;

procedure TPrintPreview.FormDestroy(Sender: TObject);
begin
  if assigned(TTbPrinter(TbPrinter).SendToExcel) then
    BtnExcel.Free;
  Hoja.Free;
end;

procedure TPrintPreview.SetZoom(Valor : integer);
begin
  FZoom := Valor;
  ZoomShower.Value := Valor;
end;

procedure TPrintPreview.EscribirTamanioPapel;
var
  PAncho, PAlto, Tmp : Double;
begin
  PAncho := GetDeviceCaps(Printer.Handle, PHYSICALWIDTH)/GetDeviceCaps(Printer.Handle, LOGPIXELSX);
  PAlto := GetDeviceCaps(Printer.Handle, PHYSICALHEIGHT)/GetDeviceCaps(Printer.Handle, LOGPIXELSY);
  if PAncho > PAlto then
    begin
       Tmp := PAncho;
       PAncho := PAlto;
       PAlto := Tmp;
    end;
  if (PANCHO = 8.5) and (PALTO = 14) then LSize.Caption := 'Oficio (8,5" x 14")'
  else if (PANCHO = 8.5) and (PALTO = 11) then LSize.Caption := 'Carta (8,5" x 11")'
  else if (PANCHO = 7.25) and (PALTO = 10.5) then LSize.Caption := 'Ejecutivo (7,25" x 10,5")'
  else if (Round(PANCHO*100) = 433) and (Round(PALTO*100) = 866) then LSize.Caption := 'Sobre europeo (4,33" x 8,66")'
  else if (Round(PANCHO*100) = 827) and (Round(PALTO*100) >= 1167)and(Round(PALTO*100) <= 1169) then LSize.Caption := 'A4 (8,27" x 11,68")'
  else if (Round(PANCHO*100) = 413) and (Round(PALTO*10) = 95) then LSize.Caption := 'Sobre americano (4,13" x 9,5")'
  else LSize.Caption := 'Otro ('+FormatFloat('.00',PAncho)+'" x '+FormatFloat('.00',PAlto)+'")'
end;

procedure TPrintPreview.CopiasChange(Sender: TObject);
begin
  TTbPrinter(TbPrinter).Copies := Copias.Value;
end;

procedure TPrintPreview.ZoomShowerChange(Sender: TObject);
begin
  FZoom := ZoomShower.Value;
  ShowerPaint(self);
end;

procedure TPrintPreview.ShowerPaint(Sender: TObject);
var
  Rect : TRect;
begin
  if FZoom = 100 then
    begin
      Shower.Width := Hoja.Width+20;
      Shower.Height := Hoja.Height+20;
      Shower.Canvas.Draw(10,10,Hoja);
    end
  else
    begin
      Rect.Left := 10;
      Rect.Top := 10;
      Rect.Right := Round(Hoja.Width*FZoom/100);
      Rect.Bottom := Round(Hoja.Height*FZoom/100);
      Shower.Width := Round(Hoja.Width*FZoom/100)+10;
      Shower.Height := Round(Hoja.Height*FZoom/100)+10;
      Shower.Canvas.StretchDraw(Rect,Hoja);
    end;
end;

procedure TPrintPreview.BtnRealClick(Sender: TObject);
begin
  if Screen.Width = 640 then
    ZoomShower.Value := 88
  else if Screen.Width = 800 then
    ZoomShower.Value := 110
  else if Screen.Width = 1024 then
    ZoomShower.Value := 138
  else
    ZoomShower.Value := 154;
end;

procedure TPrintPreview.BtnAnchoClick(Sender: TObject);
begin
  ZoomShower.Value := Round((Scroller.Width-36)*100/(Hoja.Width));
end;

procedure TPrintPreview.BtnCompletaClick(Sender: TObject);
var
  ZoomAncho, ZoomAlto : Double;
begin
  ZoomAncho := (Scroller.ClientWidth-15)*100/(Hoja.Width);
  ZoomAlto := (Scroller.ClientHeight-15)*100/(Hoja.Height);
  if ZoomAncho < ZoomAlto then
    ZoomShower.Value := Round(ZoomAncho)
  else
    ZoomShower.Value := Round(ZoomAlto);
end;

procedure TPrintPreview.BtnPagPriClick(Sender: TObject);
begin
  if FPagina > 1 then
    begin
      FPagina := 1;
      TTbPrinter(TbPrinter).HacerHoja(FPagina,Hoja,False);
      LPagN.Caption := FormatFloat('00',FPagina);
      ShowerPaint(self);
      BtnPagPri.Enabled := False;
      BtnPagAnt.Enabled := False;
      if TTbPrinter(TbPrinter).Paginas > FPagina then
        begin
          BtnPagSig.Enabled := True;
          BtnPagUlt.Enabled := True;
        end;
    end;
end;

procedure TPrintPreview.BtnPagAntClick(Sender: TObject);
begin
  if FPagina > 1 then
    begin
      Dec(FPagina);
      TTbPrinter(TbPrinter).HacerHoja(FPagina,Hoja,False);
      LPagN.Caption := FormatFloat('00',FPagina);
      ShowerPaint(self);
      if FPagina = 1 then
        begin
          BtnPagPri.Enabled := False;
          BtnPagAnt.Enabled := False;
        end;
      if TTbPrinter(TbPrinter).Paginas > FPagina then
        begin
          BtnPagSig.Enabled := True;
          BtnPagUlt.Enabled := True;
        end;
    end;
end;

procedure TPrintPreview.BtnPagSigClick(Sender: TObject);
begin
  if FPagina < TTbPrinter(TbPrinter).Paginas then
    begin
      Inc(FPagina);
      TTbPrinter(TbPrinter).HacerHoja(FPagina,Hoja,False);
      LPagN.Caption := FormatFloat('00',FPagina);
      ShowerPaint(self);
      if FPagina = TTbPrinter(TbPrinter).Paginas then
        begin
          BtnPagSig.Enabled := False;
          BtnPagUlt.Enabled := False;
        end;
      if FPagina > 1 then
        begin
          BtnPagAnt.Enabled := True;
          BtnPagPri.Enabled := True;
        end;
    end;
end;

procedure TPrintPreview.BtnPagUltClick(Sender: TObject);
begin
  if FPagina < TTbPrinter(TbPrinter).Paginas then
    begin
      BtnPagSig.Enabled := False;
      BtnPagUlt.Enabled := False;
      FPagina := TTbPrinter(TbPrinter).Paginas;
      TTbPrinter(TbPrinter).HacerHoja(FPagina,Hoja,False);
      LPagN.Caption := FormatFloat('00',FPagina);
      ShowerPaint(self);
      if FPagina > 1 then
        begin
          BtnPagAnt.Enabled := True;
          BtnPagPri.Enabled := True;
        end;
    end;
end;

procedure TPrintPreview.BtnCancelarClick(Sender: TObject);
begin
  Close;
end;

procedure TPrintPreview.BtnImpActualClick(Sender: TObject);
begin
  TTbPrinter(TbPrinter).ImprimirPagina(FPagina);
end;

procedure TPrintPreview.BtnImpTodoClick(Sender: TObject);
begin
  TTbPrinter(TbPrinter).ImprimirTodo;
  Close;
end;

procedure TPrintPreview.FormShow(Sender: TObject);
var
  ZoomAncho,ZoomAlto : double;
begin
  FPagina := 1;
  if TTbPrinter(TbPrinter).Paginas = 1 then
    begin
      BtnPagPri.Enabled := False;
      BtnPagAnt.Enabled := False;
      BtnPagSig.Enabled := False;
      BtnPagUlt.Enabled := False;
      BtnImpActual.Enabled := False;
    end
  else
    begin
      BtnPagPri.Enabled := False;
      BtnPagAnt.Enabled := False;
    end;
  LTotPag.Caption := '/ '+FormatFloat('00',TTbPrinter(TbPrinter).Paginas);
  TTbPrinter(TbPrinter).HacerHoja(FPagina,Hoja,False);
  if TTbPrinter(TbPrinter).Zoom = zReal then
    BtnRealClick(Sender)
  else if TTbPrinter(TbPrinter).Zoom = zWidth then
    ZoomShower.Value := Round((Screen.Width-PrinterPanel.Width-36)*100/(Hoja.Width))
  else // a lo alto
    begin
      ZoomAncho := (Screen.Width-PrinterPanel.Width)*100/(Hoja.Width);
      ZoomAlto := (Scroller.Height-10)*100/(Hoja.Height);
      if ZoomAncho < ZoomAlto then
        ZoomShower.Value := Round(ZoomAncho)
      else
        ZoomShower.Value := Round(ZoomAlto);
    end;
  Copias.Value := TTbPrinter(TbPrinter).Copies;
  BtnImpTodo.SetFocus;
end;

procedure TPrintPreview.ShowerMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  RealPositionH : integer;
  RealPositionV : integer;
  Muestra : integer;
begin
  RealPositionH := {Scroller.HorzScrollBar.ScrollPos +} X;
  RealPositionV := {Scroller.VertScrollBar.Position +} Y;
  if (Button = mbLeft) and (fZoom+40 <= ZoomShower.MaxValue) then
    SetZoom(Round(fZoom) + 40)
  else if (Button = mbLeft) and (fZoom < ZoomShower.MaxValue) then
    SetZoom(ZoomShower.MaxValue)
  else if (Button = mbRight)and (fZoom-40 >= ZoomShower.MinValue) then
    SetZoom(Round(fZoom) - 40)
  else if (Button = mbRight)and (fZoom > ZoomShower.MinValue) then
    SetZoom(ZoomShower.MinValue);
  if Scroller.HorzScrollBar.Visible then
    begin // HAY MOVIMIENTO HORIZONTAL
      Muestra := Scroller.Width;
      if Shower.Width < Muestra then
        Muestra := Shower.Width;
      if RealPositionH < (Muestra * 0.5) then
        Scroller.HorzScrollBar.Position := 0
      else
        Scroller.HorzScrollBar.Position := RealPositionH - (Muestra div 2);
    end;
  if Scroller.VertScrollBar.Visible then
    begin // HAY MOVIMIENTO VERTICAL
      Muestra := Scroller.Height;
      if Shower.Height < Muestra then
        Muestra := Shower.Height;
      if RealPositionV < (Muestra * 0.5) then
        Scroller.VertScrollBar.Position := 0
      else
        Scroller.VertScrollBar.Position := RealPositionV - (Muestra div 2);
    end;
end;

procedure TPrintPreview.ModoImpresionClick(Sender: TObject);
begin
  if ModoImpresion.ItemIndex = 0 then
    TTbPrinter(TbPrinter).Mode := pmFast
  else
    TTbPrinter(TbPrinter).Mode := pmWindows;
  if TTbPrinter(TbPrinter).Mode = pmWindows then
    begin
      ActualPrinter.Items := Printer.Printers;
      ActualPrinter.ItemIndex := Printer.PrinterIndex;
    end
  else
    begin
      TTbPrinter(TbPrinter).GetModelos(ActualPrinter.Items);
      ActualPrinter.ItemIndex := Ord(TTbPrinter(TbPrinter).FastPrinter);
    end;
end;

procedure TPrintPreview.ActualPrinterChange(Sender: TObject);
var
  ADevice, ADriver, APort : array [0..255] of char;
  DeviceMode : THandle;
  ImpresoraAnterior : integer;
begin
  if TTbPrinter(TbPrinter).Mode = pmWindows then
    begin
      ImpresoraAnterior := Printer.PrinterIndex;
     try
      Printer.PrinterIndex := ActualPrinter.ItemIndex;
      TTbPrinter(TbPrinter).WinPrinter := ActualPrinter.Items[ActualPrinter.ItemIndex];
      TTbPrinter(TbPrinter).PageOrientation := Printer.Orientation;
      TTbPrinter(TbPrinter).PageWidth := GetDeviceCaps(Printer.Handle, PHYSICALWIDTH);
      TTbPrinter(TbPrinter).PageHeight := GetDeviceCaps(Printer.Handle, PHYSICALHEIGHT);
      TTbPrinter(TbPrinter).PageWidthP := TTbPrinter(TbPrinter).PageWidth/GetDeviceCaps(Printer.Handle, LOGPIXELSX);
      TTbPrinter(TbPrinter).PageHeightP := TTbPrinter(TbPrinter).PageHeight/GetDeviceCaps(Printer.Handle, LOGPIXELSY);
      TTbPrinter(TbPrinter).Lineas := Trunc(TTbPrinter(TbPrinter).PageHeightP*6)-2;
      Printer.GetPrinter(ADevice, ADriver, APort, DeviceMode);
      TTbPrinter(TbPrinter).WinPort := APort;
      TTbPrinter(TbPrinter).WinPrinter := ADevice;
      EscribirTamanioPapel;
     except
      MessageDlg('El controlador de la impresora seleccionada no funciona adecuadamente. Se recomienda reinstalar el controlador de la impresora.',mtError,[mbOk],0);
      ActualPrinter.ItemIndex := ImpresoraAnterior;
      Printer.PrinterIndex := ImpresoraAnterior;
      TTbPrinter(TbPrinter).WinPrinter := ActualPrinter.Items[ImpresoraAnterior];
     end;
    end
  else
    TTbPrinter(TbPrinter).SetModeloName(ActualPrinter.Items[ActualPrinter.ItemIndex]);
  TTbPrinter(TbPrinter).HacerHoja(FPagina,Hoja,False);
end;

procedure TPrintPreview.BtnPropiedadesClick(Sender: TObject);
var
  ADevice, ADriver, APort : array [0..255] of char;
  DeviceMode : THandle;
  PrnSet : TPrinterSetupDialog;
begin
  PrnSet := TPrinterSetupDialog.Create(self);
  PrnSet.Execute;
  PrnSet.Free;
  if TTbPrinter(TbPrinter).Mode = pmWindows then
    ActualPrinter.ItemIndex := Printer.PrinterIndex;
  try
    TTbPrinter(TbPrinter).PageOrientation := Printer.Orientation;
    TTbPrinter(TbPrinter).PageWidth := GetDeviceCaps(Printer.Handle, PHYSICALWIDTH);
    TTbPrinter(TbPrinter).PageHeight := GetDeviceCaps(Printer.Handle, PHYSICALHEIGHT);
    TTbPrinter(TbPrinter).PageWidthP := TTbPrinter(TbPrinter).PageWidth/GetDeviceCaps(Printer.Handle, LOGPIXELSX);
    TTbPrinter(TbPrinter).PageHeightP := TTbPrinter(TbPrinter).PageHeight/GetDeviceCaps(Printer.Handle, LOGPIXELSY);
    Printer.GetPrinter(ADevice, ADriver, APort, DeviceMode);
    TTbPrinter(TbPrinter).WinPort := APort;
    TTbPrinter(TbPrinter).WinPrinter := ADevice;
    EscribirTamanioPapel;
    if TTbPrinter(TbPrinter).Lineas <> Trunc(TTbPrinter(TbPrinter).PageHeightP*6)-2 then
      begin
        TTbPrinter(TbPrinter).Lineas := Trunc(TTbPrinter(TbPrinter).PageHeightP*6)-2;
        if assigned(TTbPrinter(TbPrinter).ReGenerate)then
          begin
            TTbPrinter(TbPrinter).ReGenerate;
            if FPagina > TTbPrinter(TbPrinter).Paginas then
              begin
                FPagina := TTbPrinter(TbPrinter).Paginas;
                LPagN.Caption := FormatFloat('00',FPagina);
              end;
          end;
      end;
  except
  end;
  Hoja.Free;
  Hoja := TMetaFile.Create;
  Hoja.Width := Round(TTbPrinter(TbPrinter).PageWidthP * 80); // div 4; // 640;
  Hoja.Height := Round(TTbPrinter(TbPrinter).PageHeightP * 80); // div 4; // 1056;
  TTbPrinter(TbPrinter).HacerHoja(FPagina,Hoja,False);
  Shower.Invalidate;
end;

end.
