unit TbPrint;

{
==========================================================================
Fecha: 24/2/1998
Versin: 0.91
Autor: Horacio Jamilis
E-Mail: jhoracio@cvtci.com.ar
==========================================================================
Documentado primero en Espaol y luego en Ingles.
Documented in Spanish first and next in English (or something like that).
==========================================================================
Este es un componente que permite utilizar la impresora con una impresin
rpida similar a DOS o con la mismo contenido imprimir utilizando un
driver de Windows.
-------------------------------------------------------------------------
Este componente es de libre distribucin en tanto no se modifique.
Puede ser utilizado libremente en software freeware. Para poder ser utilizado
en otro tipo de software (shareware, comercial, etc.) debe ser registrado con
un valor de $ 15.-
De cualquier manera no existen garantas de que el componente funcione en todas
las circunstancias. Uselo a su cuenta y riesgo.
--------------------------------------------------------------------------
Comentarios, alabanzas y agradecimiento enterno,... sern bien recibidos.
--------------------------------------------------------------------------
Le tengo que pedir un favor. Necesito saber de donde consigue la gente este
conjunto de componentes. Por favor escribame a jhoracio@cvtci.com.ar para
informarme.
==========================================================================
Nuevo en esta version:
  - Se corrigieron errores de impresion con fuente comprimida en modo rapido.
  - Se corrigieron errores de preparacion de imagen con fuente comprimida para
    la presentacion preliminar.
  - Se corrigieron errores de impresion de fuente comprimida en modo Windows.
  - Se separo el print preview a un modulo diferente (TbPrintV) para lograr
    compatibilidad con C++ builder y facilitar la traduccion de la pantalla
    a los diferentes lenguajes.
  - Se agrego un componente: TTbCustomReport como interface para facilitar la
    creacion de impresiones personalizadas.
  - Se establecio como fuente para impresion y presentacion preliminar Courier
    en lugar de monospaced.
  - Se agrego un programa de demostracion de la mayoria de las cualidades.
  - Se termina de traducir esta ayuda al ingles.
==========================================================================
DESCRIPCION DEL CONJUNTO DE COMPONENTES
==========================================================================
TTbPrinter: es el componente que se ocupa de las comunicaciones con la impresora
            o driver de impresion de Windows. Usted puede mandar un conjunto
            de lineas de texto a imprimir y este componente se ocupara de que
            lleguen al papel de la manera apropiada.
Propiedades:
     CompanyData: Es una linea de texto utilizada en todos los reportes enviados por esta
                  impresora (lo usa TTbReport).
     Copies: es la cantidad de copias que se imprimiran del trabajo.
     FastFont: Es la tipografa de la impresora utilizada por default, se puede utilizar:
          Normal = [], Negrita, Italica, Subrayada, Comprimida o cualquier combinacion de
          ellas.
     FastPort: es el puerto de impresin al que esta conectada la impresora (ej: 'LPT1')
     FastPrinter: es el modelo de su impresora cuando se saltea el driver
            de Windows y se escribe directamente al puerto de impresin (igual que en DOS)
     Mode: es la forma de funcionamiento del componente,
           pmFast = envia el texto directamente al puerto de la impresora sin activar
                    el controlador de impresin de Windows (haciendo la impresion ms
                    rpida)
           pmWindows = utilizando el controlador de impresin de Windows (logrando
                       compatibilidad con virtualmente cualquier tipo de impresora.
     Preview: Establezcalo en True para ver una presentacin preliminar antes de imprimir
              o en False para evitar que aparezca e imprima directamente.
     Title: Es la linea de texto que describe el trabajo en el controlador de impresin
            cuando se utiliza la modalidad pmWindows.
     WinPort: es el nombre del puerto de impresion al imprimir en modo pmWindows.
     WinPrinter: Es el nombre de la impresora de Windows que se va a utilizar en el modo
                 pmWindows.
     Zoom: Es el nivel de ampliacin inicial al aparecer la ventana de presentacin
           preliminar. Puede ser zReal, zWidth (Ancho de hoja) o zHeight (Alto de hoja).
     Columnas: (solo lectura) Cantidad de columnas de la pagina (80)
     Paginas: (solo lectura) Cantidad de paginas en el buffer
     PrintingWidth: (solo lectura) es el ancho de la pagina
     PrintingHeight: (solo lectura) es el alto de la pgina
Eventos:
  OnPrinterError: es un evento que se genera al fallar el intento de impresin dandole al
                  usuario una oportunidad de cambiar el mensaje de error.
Metodos:
  Comenzar: se debe utilizar para comenzar una nueva impresin. Crea la primer pgina.
    Sintaxis: Comenzar;
  Finalizar: se debe utilizar al finalizar una impresin. Elimina su informacin del buffer.
    Sintaxis: Finalizar;
  EscribirStd: Escribe en la columna X, linea Y el TEXTO con la fuente especificada en FastFont.
    Sintaxis: EscribirStd(X,Y,TEXTO);
  Escribir: Escribe TEXTO en la linea Y, columna X con la fuente FUENTE.
    Sintaxis: Escribir(X,Y,TEXTO,FUENTE);
  Cuadro: Realiza un cuadro en la hoja (solo funciona en modo pmFast) con las coordenadas
    especificadas y el tipo de linea que puede ser Simple o Doble.
    Sintaxis: Cuadro(X1,Y1,X2,Y2,TIPOLINEA);
  LineaHorizontal: realiza una linea horizontal segun las coordenadas y el tipo de linea.
    Sintaxis: LineaHorizontal(X1,X2,Y,TIPOLINEA);
  LineaVertical: realiza una linea vertical segun las coordenadas y el tipo de linea.
    Sintaxis: LineaVertical(X,Y1,Y2,TIPOLINEA);
  Imprimir: Envia la impresion a la impresora. Si Preview es verdadero realiza la
    presentacin preliminar. Si es falso envia la impresin a la impresora directamente
    si el modo es pmFast, o a traves del driver de Windows si es pmWindows.
    Sintaxis: Imprimir;
  NuevaPagina: Crea una nueva pagina (no se debe utilizar inmediatamente despues de comenzar)
    Sintaxis: NuevaPagina;
  SetModeloName: Establece el modelo de la impresora para el modo pmFast por su nombre.
    Sintaxis: SetModeloName(NOMBRE);
  GetModeloName: Devuelve el nombre del modelo de impresora seleccionado para el modo pmFast.
    Sintaxis: GetModeloName;
  GetModelos: Completa una lista de cadenas (TStrings) con los nombres de los modelos
    disponibles para el modo pmFast. Se utiliza para darle al usuario la posibilidad de
    seleccionar su modelo de impresora.
    Sintaxis: GetModelos(LISTADEMODELOS);
==========================================================================
TTbReport: Genera un listado utilizando un TTbPrinter y posiblemente una TTable.
           Tambien tiene la posibilidad de enviarlo a Microsoft Excel.
Propiedades:
     Printer: es la impresora en la que va a salir el reporte (TTbPrinter)
     Tabla: es la tabla de la que saldran los datos si la informacion proviene de una TTable.
     TablaFiltro: el un filtro para la tabla (opcional). Si no se establece se utiliza
                  el filtro activo.
     TablaIndice: es el nombre del indice de la tabla utilizado durante la generacin del
                  reporte (opcional). Si no se establece se utiliza el indice activo.
     Lineas: es la cantidad de lineas por hoja del reporte.
     MargenDerecho: Es la posicion del margen derecho (depende de la tipografia)
     MargenIzquierdo: Es la posicion del margen izquierdo.
     NumerarPaginas: si se desea imprimir el numero de pgina en cada pagina.
     EscribirFechaHora: si se desea que se imprima la fecha y hora de generacion del
                        reporte en cada pagina.
     SeparacionDeColumnas: es la distancia deseada entre las columnas (en caracteres).
     Titulo: es el titulo del reporte. Aparece al principio de cada hoja y, en modo
             pmWindows, en la lista de trabajos pendientes de la impresora.
             Antes del titulo aparece la linea CompanyData establecida en la impresora.
     LineaDeTitulo: es la linea de la hoja en la que aparece el titulo.
     SubTitulo: es el subtitulo del reporte. Aparece en cada hoja.
     LineaDeSubtitulo: es la linea de la hoja en que aparecera el subtitulo.
     ColumnaDeTitulo: es la columna en que comienza el titulo en la pagina.
     ColumnaDeSubtitulo: es la columna en que comienza el subtitulo en la pagina.
     ColumnaDePieDePagina: es la columna en que comienza el pie de pagina.
     PieDePagina: es el texto que aparece al pie de cada pagina.
     Fuente: la tipografia para el reporte (FastFont)
     Preview: Si se desea que se vea una presentacion preliminar antes de imprimir.
     TablaAutoFirst: Si se desea que el reporte utilice todos los registros de la tabla.
     ModoImpresion: el modo de impresion que utilizara la impresora (pmFast o pmWindows)
Eventos:
     OnEndQuery: se genera despues de imprimir cada linea para ver si es la ltima o
                 hay mas informacin. Indispensable para reportes no basados en tablas.
Metodos:
     Execute: genera el repote y lo muestra en la pantalla (si preview esta activo) o lo
              imprime (en otro caso).
     ExportToExcel: envia el repote a una planilla en Microsoft Excel.
==========================================================================
TTbReportColumn: columna de reporte para TTbReport. Los reportes estan compuestos por
                 columnas de informacin. Deber poner un objeto de estos por cada columna
                 que desee incluir en el reporte.
Propiedades:
     Indice: Numero de columna. La columna que tiene el indice ms chico va a la izquierda.
             La columna con indice 1 es la primer columna del reporte. Si no se asigna a
             ningun reporte vale 0 (cero).
     Reporte: es el reporte del que forma parte (TTbReport).
     Titulo: es el titulo de la columna en el reporte. Si no se establece un titulo y se
             establece un campo de la tabla, se usara el titulo del campo.
     Ancho: es el ancho de la columna en caracteres
     SumaColumna: establece si desea un total de todos los registros procesados.
     Formato: es un formato para el campo si proviene de una TTable.
Eventos:
     OnGetText: se genera antes de imprimir el contenido del campo. Si la columna recibe
                informacion de una tabla contendr al ejecutarse este evento el valor del
                campo para el registro que se esta procesando. Aqu puede modificar ese
                valor. Si la impresin no proviene de una tabla, aqu debe establecer el
                texto que se va a imprimir en esta columna.
==========================================================================
TTbReportGroup: Grupo para el reporte TTbReport. Si desea que la impresin realice
                agrupaciones debe utilizar este componente para ello.
Propiedades:
     Indice: es el orden del grupo dentro del reporte. Si no tiene asignado reporte
             valdra 0 (cero).
     Reporte: es el reporte al que afectar.
     SaltaDeHoja: si desea que al cambiar de grupo se salte a una nueva hoja.
     TextoEncabezado: texto del encabezado de cada nuevo grupo.
     CampoClaveDeAgrupacion: nombre del campo que sera la clave de agrupacin.
     Totaliza: si desea tomar totales para el grupo.
     FormatoTotal: Formato de impresin del total.
     Titulo: Titulo del grupo.
Eventos:
     OnEndGroupQuery: se genera al completar un grupo.
==========================================================================
TTbCustomReport: componente que facilita la creacion de listados personalizados.
Propiedades:
     ModoImpresion: modalidad de impresion por omision.
                    rmWindows=modo Windows, rmFast=modo rapido,
                    rmDefault=el establecido en Printer.
     Preview: modalidad de muestra de presentacion preliminar.
              pYes=muestra presentacion preliminar, pNo=no lo muestra,
              pDefault=muestra la presentacion preliminar si esta especificada en Printer.
     Printer: impresora (TTbPrinter) en que se imprimira el listado.
Motodos:
     Execute: metodo para arrancar la impresion.
Events:
     OnSendToExcel: se genera cuando el usuario presiona el boton Export to Excel en el
                    dialogo de presentacion preliminar. Si no se asigna un procedimiento
                    el boton aparece grisado (deshabilitado).
     OnGenerate: se genera al llamar a Execute o, si dentro de la presentacion preliminar
                 se cambia el tamao de la hoja o el modelo de impresora (en modo Windows).
==========================================================================
TTbExcel: componente que permite facilmente enviar datos a Excel (utilizado por TTbReport)
Metodos:
     Connect: establece la comunicacion con Excel. Si lo logra devuelve True.
     Disconnect: concluye la comunicacion con Excel.
     StartExport: comienza el envio de informacion a Excel.
     EndExport: finaliza el envio de informacion a Excel.
     Seleccionar: selecciona un conjunto de celdas de Excel.
       Sintaxis: Seleccionar(X1,Y1,X2,Y2);
     Alinear: Alinea la celda seleccionada de acuerdo al parametro tipo byte.
       Sintaxis: Alinear(ALINEACION);
     SetStr: Establece el contenido de una celda.
       Sintaxis: SetStr(X,Y,TEXTO)
     AnchoColumna: Establece el ancho de la/s columna/s seleccionada/s.
==========================================================================
ENGLISH SECTION
==========================================================================
This component let's you use the printer like you did in DOS or send the same
information through the Windows driver.
--------------------------------------------------------------------------
This component could be freely distributed while not modified.
You could use it freely in any freeware software. To use it in any other type
of software (shareware, comercial, etc.) you should register it in u$s 15.-
Any way, there are not warranties about the way the component works in all the
cases. Use it at your own risk.
--------------------------------------------------------------------------
Comentaries, goodies and appreciation for ever,... will be wellcome.
--------------------------------------------------------------------------
I have to ask you a favor. I need to know where the people gets this component
set from. Please write me to jhoracio@cvtci.com.ar to inform me.
==========================================================================
New on this version:
 - Fixed some errors on printing with compressed font in fast printing mode.
 - Fixed some errors on preparation of image with comppresed font for print
   preview.
 - It was separated the print preview to a new module (TbPrintV) to get
   compatibility with C++ builder and make easy to translate the form to
   any other language.
 - It was added a new component: TTbCustomReport to make easy to create a
   new personal printing.
 - It was established as font to print in Windows mode and for print preview
   Courier in place of monospaced.
 - It was added a demostration program showing most of the posibilities.
 - It was completelly translated to english (or something like that).
==========================================================================
COMPONENT SET DESCRIPTION
==========================================================================
TTbPrinter: this is the component that takes care of the communication with the printer
            or the Windows printer driver. You could send a couple of text lines for
            printing and this component will take care that this be on the paper in
            the way you want.
Properties:
     CompanyData: Is a text line used in all the reports sent throw this printer (by TTbReport).
     Copies: is the number of copies that will print of this job.
     FastFont: is the printer font for default. You could use:
          Normal = [], Negrita (Bold), Italica (italic), Subrayada (subscript),
          Comprimida (compressed) or any other combination of them.
     FastPort: is the printer port on which the printer is connected to (ej: 'LPT1').
     FastPrinter: is the printer model when used the component in pmFast mode bypassing
            Windows and writing directly the de printer port (as you do in DOS).
     Mode: is the way the component works,
           pmFast = sends the text directly to de printer port, not using the Windows
                    printer driver (making the printing faster).
           pmWindows = using the Windows printer driver (having compatibility with virtually
                       any type of printer).
     Preview: set it to True to see a print preview before printing or to False if you don't
              want it, and prefer to print directly.
     Title: is a text line wich describes the job in the Windows printer spooler when use
            the pmWindows mode.
     WinPort: is the name of the printer port when printing in pmWindows mode.
     WinPrinter: is the name of the printer when printing in pmWindows mode.
     Zoom: is the initial zoom level when showing the print preview form.
           It could be zReal, zWidth (Page Width) o zHeight (Page Height).
     Columnas: (read only) Number of character columns on the page (80).
     Paginas: (read only) Number of pages in the buffer.
     PrintingWidth: (read only) is the page Width.
     PrintingHeight: (read only) is the page Height.
Events:
  OnPrinterError: it works when fails a printer try giving the user the oportunity
                  to change de error message.
Methods:
  Comenzar: you should call it to start a new job. It creates the first page..
    Sintaxis: Comenzar;
  Finalizar: you should call it to end the job (after printing). It cleans the buffer.
    Sintaxis: Finalizar;
  EscribirStd: Writes in the column X, line Y the TEXT with the font especified in FastFont.
    Sintaxis: EscribirStd(X,Y,TEXT);
  Escribir: Writes TEXT in the line Y, column X with the fastfont FONT.
    Sintaxis: Escribir(X,Y,TEXT,FONT);
  Cuadro: Writes a rect on the page (only works in pmFast mode) using the coordinates
    and the line type (Simple -single- o Doble -double-) especified.
    Sintaxis: Cuadro(X1,Y1,X2,Y2,LINETYPE);
  LineaHorizontal: writes an horizontal line using the coordinates and line type.
    Sintaxis: LineaHorizontal(X1,X2,Y,LINETYPE);
  LineaVertical: writes a vertical line.
    Sintaxis: LineaVertical(X,Y1,Y2,LINETYPE);
  Imprimir: Sends the printing to the printer. If Preview is True shows the print preview
    form. Else sends the printing directly to the printer (if mode is pmFast)
    or to the Windows driver (if mode is pmWindows).
    Sintaxis: Imprimir;
  NuevaPagina: Creates a new page (you shouldn't use it inmediatelly next to Comenzar)
    Sintaxis: NuevaPagina;
  SetModeloName: Sets the printer model for the pmFast mode by name.
    Sintaxis: SetModeloName(NAME);
  GetModeloName: Returns the selected printer model name for de pmFast mode.
    Sintaxis: GetModeloName;
  GetModelos: Fill a string list (TStrings) with the model names availables for the pmFast
    mode. It is used to give the user the posibility to select his/her printer model.
    Sintaxis: GetModelos(MODELSLIST);
==========================================================================
TTbReport: Generates a report using a TTbPrinter and posibly a TTable.
           It has also the hability to send it to Microsoft Excel.
Properties:
     Printer: is the printer on which the report will goes out (TTbPrinter)
     Tabla: is the TTable from where the information comes if used one.
     TablaFiltro: is a table filter (optional). If you don't set one will use
                  the actual filter.
     TablaIndice: is the table index name used while generating the report (opcional).
                  if you don't set it is used the actual one.
     Lineas: is the number of lines per page for the report.
     MargenDerecho: is the right margin position in characters (depends of font).
     MargenIzquierdo: is the left margin position.
     NumerarPaginas: if you want to print the page number on each page.
     EscribirFechaHora: if you want to print the generation date and time in each page.
     SeparacionDeColumnas: is the distance between columns (in characters).
     Titulo: is the report title. Apears at the begining of each page and, in pmWindows mode,
             in the pending jobs list for the printer spooler.
             Before the title apears the text set in CompanyData for the printer.
     LineaDeTitulo: is the line of the page where goes the title.
     SubTitulo: is the report subtitle. Goes in each page.
     LineaDeSubtitulo: is the line of the page where goes the subtitle.
     ColumnaDeTitulo: is the page column where goes the title.
     ColumnaDeSubtitulo: is the page column where goes the subtitle.
     ColumnaDePieDePagina: is the page column where goes the foot page.
     PieDePagina: is the foot page text which goes on every page.
     Fuente: is the fonr used in the report (FastFont)
     Preview: if you want to see the print preview form before printing.
     TablaAutoFirst: if you want to include all the table records (or only the records
       that comes after the actual one).
     ModoImpresion: is the printer mode used for this report (pmFast o pmWindows).
Events:
     OnEndQuery: ir works after printing each line to ask if this is the last one or
                 not. Useful when writing reports not based on tables.
Methods:
     Execute: generates the report and then shows it on the screen (if preview is set) or
              sends it to the printer (if not).
     ExportToExcel: sends the report to a Microsoft Excel work sheet.
==========================================================================
TTbReportColumn: is a report column for TTbReport. The reports are made with information
                 columns. You should put one object of this for each column you wish to
                 include in the report.
Properties:
     Indice: Column number. The column that has the littier number goes to the left.
             The column with index 1 is the first one (on the left). If you don't assing
             a report it's value is 0 (zero).
     Reporte: is the report the column is part (TTbReport).
     Titulo: is the column report title. If you don't set one and set a Table Field, it will
             use it's field title.
     Ancho: is the column width in characters.
     SumaColumna: if you want to sum the column.
     Formato: is the format to the field used when Table Field is set.
Events:
     OnGetText: it works before sending the information to the printer. If the column has
                it's information from a table it will have when running this events the field
                value for the current record. Here you could change that value. If the printing
                doesn't come from e table, here you must set the text that the column will print.
==========================================================================
TTbReportGroup: Grup for the TTbReport report. If you want to make groups in the printing
                you should use it for this.
Properties:
     Indice: is the order of the group in the report. If there are not asigned report
             this will have 0 (zero).
     Reporte: is the report it will modify.
     SaltaDeHoja: if you want to change page when the group is changing.
     TextoEncabezado: title text wich will be writen on each new group.
     CampoClaveDeAgrupacion: name of the field that will be grouping key.
     Totaliza: if you want to sum columns per group.
     FormatoTotal: format for printing of totals.
     Titulo: group title.
Events:
     OnEndGroupQuery: it runs when finishing a group.
==========================================================================
TTbCustomReport: component that will make easy to create personal reports or printings.
Properties:
     ModoImpresion: default printing mode.
                    rmWindows=Windows mode, rmFast=Fast mode,
                    rmDefault=de printer default (TTbPrinter.Mode).
     Preview: default print preview showing mode.
              pYes=shows the print preview, pNo=doesn't show it,
              pDefault=Shows is if especified in the printer (TTbPrinter.Preview).
     Printer: impresora (TTbPrinter) en que se imprimira el listado.
Motodos:
     Execute: call it to run the printing.
Events:
     OnSendToExcel: if runs when the user presses the Export to Excel button on the print
                    preview form. If you don't assign a method to this the button appears
                    grayed (disabled).
     OnGenerate: it runs on calling to Execute or, is called to if in the print preview
                 dialog the user changes de paper size or the Windows printer model.
==========================================================================
TTbExcel: this component makes easy to send information to MS Excel (used by TTbReport)
Methods:
     Connect: establish connection to Excel. If it could, returns True.
     Disconnect: ends the connection with Excel.
     StartExport: starts the information sending process to Excel. This locks Excel.
     EndExport: ends the sending information to Excel process. This unlocks Excel.
     Seleccionar: select a cells group in Excel.
       Sintaxis: Seleccionar(X1,Y1,X2,Y2);
     Alinear: Sets cells justification on selected cells.
       Sintaxis: Alinear(JUSTIFICATION);
     SetStr: Sets the cell content.
       Sintaxis: SetStr(X,Y,TEXT)
     AnchoColumna: Sets the column width for the selected cells.
==========================================================================
}

interface

{$R TBPRINT.RES}

uses
  Windows, Messages, SysUtils, CommDlg, Classes, Graphics, Controls, Forms, Dialogs,
  DBTables, DB, DDEMan, Spin, ExtCtrls, StdCtrls, Consts, Printers{, dsgnintf}, TbPrintV;

type
  ReportTableType = TTable; // TTbTable
  ReportFieldType = TField;   // string

  TStatus = (Lista,OffLine,SinPapel,Apagada,Desconocido);

  TModelo = (Cannon_F60,Cannon_Laser,Epson_FX,HP_Deskjet,HP_Laserjet,HP_Thinkjet,IBM_Color_Jet,IBM_PC_Graphics,IBM_Proprinter,NEC_3500,NEC_Pinwriter);

  TPrinterMode = (pmFast,pmWindows);

  TLinea = (Simple,Doble);

  TTipoFuente = (Negrita,Italica,Subrayado,Comprimido);
  TFuente = Set of TTipoFuente;

  PPagina = ^TPagina;
  TPagina = record
    Escritura : TList;
    LineasVerticales : TList;
    LineasHorizontales : TList;
    LineasImpresas : byte;
  end;

  PEscritura = ^TEscritura;
  TEscritura = record
    X : byte;
    Y : byte;
    Fuente : TFuente;
    Texto : string;
  end;

  PHorizLine = ^THorizLine;
  THorizLine = record
    X1 : byte;
    X2 : byte;
    Y : byte;
    Tipo : TLinea;
  end;

  PVertLine = ^TVertLine;
  TVertLine = record
    X : byte;
    Y1 : byte;
    Y2 : byte;
    Tipo : TLinea;
  end;

  EPrinterError = class( Exception );
  EReportError = class( Exception );

  TTbPrinter = class;

  TInitialZoom = (zReal,zWidth,zHeight);

  TTbPrinter = class(TComponent)
  private
    { Private declarations }
    fOnPrinterError : TNotifyEvent;
    FDatosEmpresa : String;      // INFORMACION QUE SE IMPRIME EN TODOS LOS REPORTES
    FModelo : TModelo;           // MODELO DE IMPRESORA
    FFastPuerto : string;         // PUERTO DE LA IMPRESORA
    FLineas : byte;              // CANTIDAD DE LINEAS POR PAGINA
    FColumnas : byte;            // CANTIDAD DE COLUMNAS EN LA PAGINA
    FFuente : TFuente;           // TIPO DE LETRA
    FModo : TPrinterMode;        // MODO DE IMPRESION (NORMAL/MEJORADO)
    LasPaginas : TList;             // Almacenamiento de las pginas
    FCopias : integer;
    PRNNormal : string;
    PRNBold : string;
    PRNItalics : string;
    PRNULineON : string;
    PRNULineOFF : string;
    PRNCompON : string;
    PRNCompOFF : string;
    PRNSetup : string;
    PRNReset : string;
    FPreview : boolean;
    FZoom : TInitialZoom;
    FTitulo : string;
    PreviewForm : TPrintPreview;
    FWinPrinter : string;        // NOMBRE DE LA IMPRESORA EN WINDOWS
    FWinPort : string;
    function GetModeloRealName(Model : TModelo) : String;
    procedure SetModelo(Nombre : TModelo);
    procedure SetFastPuerto(Puerto : string);
    function GetPaginas : byte;
    procedure Clear;
    procedure PreviewReal;                            // MUESTRA LA IMPRESION EN PANTALLA
    function ImprimirPaginaFast(Numero:integer) : boolean;// MANDA UNA PAGINA A LA IMPRESORA
  protected
    { Protected declarations }
  public
    { Public declarations }
    PaginaActual : byte;        // PAGINA ACTUAL
    PageWidth,             // ANCHO DE PAGINA EN PIXELS
    PageHeight : integer;  // ALTO DE PAGINA EN PIXELS
    PageWidthP,            // ANCHO DE PAGINA EN PULGADAS
    PageHeightP : double;  // ALTO DE PAGINA EN PULGADAS
    PageOrientation : TPrinterOrientation; // ORIENTACION DE LA PAGINA
    ReGenerate : Procedure of object;
    SendToExcel : Procedure of object;
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Comenzar;  // PARA COMENZAR UNA NUEVA IMPRESION
    procedure Finalizar; // ELIMINA LA INFORMACION DE LAS PAGINAS AL FINALIZAR
    procedure EscribirStd(X,Y : byte; Texto:string); // ESCRIBE UN TEXTO EN LA PAGINA
    procedure Escribir(X,Y : byte; Texto:string;Fnt : TFuente); // ESCRIBE UN TEXTO EN LA PAGINA
    procedure Cuadro(X1,Y1,X2,Y2 : byte; Tipo : TLinea);                // ESCRIBE UN RECTANGULO
    procedure LineaHorizontal(X1,X2,Y : byte; Tipo : TLinea);           // ESCRIBE UNA LINEA HORIZONTAL
    procedure LineaVertical(X,Y1,Y2 : byte; Tipo : TLinea);             // ESCRIBE UNA LINEA VERTICAL
    procedure Imprimir;                           // MANDA LA IMPRESION A LA IMPRESORA
    procedure NuevaPagina;                        // CREA UNA NUEVA PAGINA
    procedure SetModeloName(Nombre : String);
    procedure GetModelos(Modelos : TStrings);
    function GetModeloName : String;
    procedure HacerHoja(Numero : integer; Hoja : TMetaFile;ToPrint:boolean);
    function GetPrintingWidth : integer;
    function GetPrintingHeight : integer;
    property Lineas : byte read FLineas write FLineas default 66; // CANTIDAD DE LINEAS POR PAGINA
    function ImprimirPagina(Numero:integer) : boolean;// MANDA UNA PAGINA A LA IMPRESORA
    procedure ImprimirTodo;                           // MANDA LA IMPRESION A LA IMPRESORA
  published
    { Published declarations }
    property FastPrinter : TModelo read FModelo Write SetModelo; // MODELO DE LA IMPRESORA
    property FastPort : string read FFastPuerto Write SetFastPuerto; // PUERTO DE LA IMPRESORA
    property Mode : TPrinterMode read FModo write FModo default pmFast; // MODO DE IMPRESION
    property Columnas : byte read FColumnas default 80; // CANTIDAD DE COLUMNAS EN LA PAGINA
    property Paginas : byte read GetPaginas default 0;             // CANTIDAD DE PAGINAS
    property FastFont : TFuente read FFuente write FFuente;
    property CompanyData : string read FDatosEmpresa write FDatosEmpresa; // SE IMPRIME EN TODOS LOS REPORTES
    property Zoom : TInitialZoom read FZoom write FZoom default zWidth;
    property Preview : boolean read FPreview write FPreview;
    property Title : string read FTitulo write FTitulo;
    property WinPrinter : string read fWinPrinter write fWinPrinter;
    property WinPort : string read fWinPort write fWinPort;
    property Copies : integer read fCopias write fCopias default 1;
    property OnPrinterError : TNotifyEvent read fOnPrinterError write fOnPrinterError;
    property PrintingWidth : integer read GetPrintingWidth;
    property PrintingHeight : integer read GetPrintingHeight;
  end;

  TTbReportColumn = class;
  TTbReportGroup = class;

  TTbEndQueryEvent = procedure(var EndReport : boolean) of object;

  TTbPreviewType = (pYes,pNo,pDefault);
  TTbPrinterMode = (rmFast,rmWindows,rmDefault);

  TTbProcedure = procedure of object;

  TTbCustomReport = class(TComponent)
  private
    FPrinter : TTbPrinter;
    FModo : TTbPrinterMode;
    FPreview : TTbPreviewType;
    FOnGenerate : TTbProcedure;
    FOnSendToExcel : TTbProcedure;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Execute;
  published
    property Printer : TTbPrinter read FPrinter write FPrinter;
    property ModoImpresion : TTbPrinterMode read FModo write FModo default rmDefault;
    property Preview : TTbPreviewType read FPreview write FPreview default pDefault;
    property OnGenerate : TTbProcedure read FOnGenerate write FOnGenerate;
    property OnSendToExcel : TTbProcedure read FOnSendToExcel write FOnSendToExcel;
  end;

  TTbReport = class(TComponent)
  private
    { Private declarations }
    FPrinter : TTbPrinter;
    FTabla : ReportTableType;
    FLineas : byte;
    FModo : TTbPrinterMode;
    IMargen : byte;
    DMargen : byte;
    Columnas : TList;
    Grupos : TList;
    NumeraPaginas : Boolean;
    FechaYHora : boolean;
    SeparacionColumnas : byte;
    FFuente : TFuente;
    FTitulo : string;
    FSubTitulo : string;
    PiePagina : string;
    LineaTitulo : byte;
    LineaSubTitulo : byte;
    LineaPiePagina : byte;
    ColumnaTitulo : byte;
    ColumnaSubTitulo : byte;
    ColumnaPiePagina : byte;
    FFiltro : string;       // FILTRO DE LA TABLA PARA EL LISTADO
    FIndice : string;
    FPreview : TTbPreviewType;
    FAutoFirst : boolean;
    FOnEndQuery : TTbEndQueryEvent;
    function GetEndQueryEvent : TTbEndQueryEvent;
    procedure SetEndQueryEvent(AEndQueryEvent: TTbEndQueryEvent);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Clear;
    function ColumnAdd(Columna : TTbReportColumn) : integer;
    procedure ColumnChangeIndex(Ind1,Ind2 : integer);
    procedure ColumnDel(Columna : TTbReportColumn);
    function GroupAdd(Grupo : TTbReportGroup) : integer;
    procedure GroupChangeIndex(Ind1,Ind2 : integer);
    procedure GroupDel(Grupo : TTbReportGroup);
    procedure Execute;
    procedure ExportToExcel;
    procedure Generate;
  published
    { Published declarations }
    property Printer : TTbPrinter read FPrinter write FPrinter;
    property Tabla : ReportTableType read FTabla write FTabla;
    property TablaFiltro : string read FFiltro write FFiltro;
    property TablaIndice : string read FIndice write FIndice;
    property Lineas : byte read FLineas write FLineas Default 66;
    property MargenDerecho : byte read DMargen write DMargen default 80;
    property MargenIzquierdo : byte read IMargen write IMargen Default 1;
    property NumerarPaginas : boolean read NumeraPaginas write NumeraPaginas default True;
    property EscribirFechaHora : boolean read FechaYHora write FechaYHora default True;
    property SeparacionDeColumnas: byte read SeparacionColumnas write SeparacionColumnas default 1;
    property Titulo : string read FTitulo write FTitulo;
    property LineaDeTitulo : byte read LineaTitulo write LineaTitulo default 4;
    property SubTitulo : string read FSubTitulo write FSubTitulo;
    property LineaDeSubTitulo : byte read LineaSubTitulo write LineaSubTitulo default 6;
    property LineaDePieDePagina : byte read LineaPiePagina write LineaPiePagina default 66;
    property ColumnaDeTitulo : byte read ColumnaTitulo write ColumnaTitulo default 0;
    property ColumnaDeSubTitulo : byte read ColumnaSubTitulo write ColumnaSubTitulo default 0;
    property ColumnaDePieDePagina : byte read ColumnaPiePagina write ColumnaPiePagina default 0;
    property PieDePagina : string read PiePagina write PiePagina;
    property Fuente : TFuente read FFuente write FFuente;
    property Preview : TTbPreviewType read FPreview write FPreview default pDefault;
    property TablaAutoFirst : boolean read FAutoFirst write FAutoFirst default True;
    property ModoImpresion : TTbPrinterMode read FModo write FModo default rmDefault;
    property OnEndQuery : TTbEndQueryEvent read GetEndQueryEvent write SetEndQueryEvent;
//	if Assigned(FOnEndQuery) then
//		FOnEndQuery(FinReporte);
  end;

  TTbGetTextEvent = procedure(var Text : string) of object;

  TTbReportColumn = class(TComponent)
  private
    { Private declarations }
    FIndice : integer;
    FReporte : TTbReport;
    FTitulo : string;
    FAncho : byte;
    AcumuladorColumna : Double;
    FSumaColumna : boolean;
    FField : ReportFieldType;
    FOnGetText : TTbGetTextEvent;
    PosicionIzquierda : byte;
    FFormato : string;
    procedure SetReporte(Rep : TTbReport);
    procedure SetIndice(Ind : integer);
    procedure SetField(F : ReportFieldType);
    function GetTextEvent: TTbGetTextEvent;
    procedure SetTextEvent(AGetTextEvent: TTbGetTextEvent);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property Indice : integer read FIndice write SetIndice;
    property Reporte : TTbReport read FReporte write SetReporte;
    property Titulo : string read FTitulo write FTitulo;
    property Ancho : byte read FAncho write FAncho;
    property SumaColumna : boolean read FSumaColumna write FSumaColumna default False;
    property DataField : ReportFieldType read FField write SetField;
    property Formato : string read FFormato write FFormato;
    property OnGetText : TTbGetTextEvent read GetTextEvent write SetTextEvent;
//	if Assigned(FOnGetText) then
//		FOnGetText(TextoAImprimir);
  end;

  TTbEndGroupEvent = procedure(var EndGroup : boolean) of object;

  TTbReportGroup = class(TComponent)
  private
    { Private declarations }
    FIndice : integer;
    FReporte : TTbReport;
    AcumuladorGrupo : Double;
    ClaveAgrupacion : ReportFieldType;
    Encabezado : string;
    TotalGrupo : Double;
    FTotalizaGrupo : boolean;
    FTotalFormato : string;
    SaltaHoja : boolean;
    ClaveAnterior : Variant;
    ClaveActual : Variant;
    FOnEndGroup : TTbEndGroupEvent;
    FTitulo : string;
    procedure SetReporte(Rep : TTbReport);
    procedure SetIndice(Ind : integer);
    function GetEndGroupEvent : TTbEndGroupEvent;
    procedure SetEndGroupEvent(AEndGroupEvent: TTbEndGroupEvent);
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    { Published declarations }
    property Indice : integer read FIndice write SetIndice;
    property Reporte : TTbReport read FReporte write SetReporte;
    property SaltaDeHoja : boolean read SaltaHoja write SaltaHoja default False;
    property TextoEncabezado : string read Encabezado write Encabezado;
//    property TotalGrupo : Double read TotalGrupo write TotalGrupo;
    property CampoClaveDeAgrupacion : ReportFieldType read ClaveAgrupacion write ClaveAgrupacion;
    property Totaliza : boolean read FTotalizaGrupo write FTotalizaGrupo default False;
    property FormatoTotal : string read FTotalFormato write FTotalFormato;
    property Titulo : string read FTitulo write FTitulo;
    property OnEndGroupQuery : TTbEndGroupEvent read GetEndGroupEvent write SetEndGroupEvent;
//	if Assigned(FOnEndGroup) then
//		FOnEndGroup(FinGrupo);
  end;

  TTbExcel = class(TComponent)
    private
    { Private declarations }
      FDDEClientConv : TDdeClientConv;
      FDDEClientItem : TDDEClientItem;
      procedure LocateExcel;
      procedure Exec(const Cmd: string);
    protected
    { Protected declarations }
    public
    { Public declarations }
      Conectado : Boolean;
      constructor Create(AOwner: TComponent); override;
      destructor Destroy; override;
      function Connect : boolean;
      procedure Disconnect;
      procedure StartExport;
      procedure EndExport;
      procedure Seleccionar(Columna1, Fila1, Columna2, Fila2 : integer);
      procedure Alinear(Horizontal : byte);
      procedure SetStr(Columna, Fila : integer; Valor : string);
      procedure AnchoColumna(Ancho : integer);
    published
    { Published declarations }
  end;
{ No funciona - It doesn't work
  TTbReportComponentEditor = class(TComponentEditor)
  public
    procedure Edit; override;
  end;
}
procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Terabyte', [TTbPrinter]);
  RegisterComponents('Terabyte', [TTbReport]);
  RegisterComponents('Terabyte', [TTbReportColumn]);
  RegisterComponents('Terabyte', [TTbReportGroup]);
  RegisterComponents('Terabyte', [TTbExcel]);
  RegisterComponents('Terabyte', [TTbCustomReport]);
{  RegisterComponentEditor(TTbReport,TTbReportComponentEditor) };
end;
{
procedure TTbReportComponentEditor.Edit;
var
  source : TTbReport;
  OrigPreview : TTbPreviewType;
begin
  source:=component as TTbReport;
  OrigPreview := source.Preview;
  source.Preview := pYes;
  source.Execute;
  source.Preview := OrigPreview;
end;
}

constructor TTbCustomReport.Create(AOwner: TComponent); 
begin
  inherited Create(AOwner);
  FPreview := pDefault;
  FModo := rmDefault;
  FOnSendToExcel := nil;
  FOnGenerate := nil;
end;

procedure TTbCustomReport.Execute;
var
  OldGenerate : procedure of object;
  OldExportToExcel : procedure of object;
  OldModo : TPrinterMode;
  OldPreview : Boolean;
begin
  if FPrinter = nil then
    begin
      MessageDlg('Debe enlazar el reporte con una impresora TTbPrinter.',mtError,[mbOk],0);
      Exit;
    end
  else if not Assigned(FOnGenerate) then
    begin
      MessageDlg('Debe asignar un procedimiento de generacin del reporte.',mtError,[mbOk],0);
      Exit;
    end;
  OldGenerate := FPrinter.ReGenerate;
  OldExportToExcel := FPrinter.SendToExcel;
  OldModo := FPrinter.Mode;
  OldPreview := FPrinter.Preview;
  if FModo = rmFast then
    FPrinter.Mode := pmFast
  else if FModo = rmWindows then
    FPrinter.Mode := pmWindows;
  if FPreview = pYes then
    FPrinter.Preview := True
  else if FPreview = pNo then
    FPrinter.FPreview := False;
  if Assigned(FOnGenerate) then
    begin
      FPrinter.ReGenerate := FOnGenerate;
      FOnGenerate;
    end
  else
    FPrinter.ReGenerate := nil;
  if Assigned(FOnSendToExcel) then
    FPrinter.SendToExcel := FOnSendToExcel
  else
    FPrinter.SendToExcel := nil;
  FPrinter.Imprimir;
  FPrinter.ReGenerate := OldGenerate;
  FPrinter.SendToExcel := OldExportToExcel;
  FPrinter.Mode := OldModo;
  FPrinter.Preview := OldPreview;
end;

function Min(Val1,Val2 : integer):integer;
begin
  if Val1<Val2 then
    Min := Val1
  else
    Min := Val2;
end;

(* EXCEL *)

constructor TTbExcel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  if (csdesigning in componentstate) then
    exit;
  FDDEClientConv := TDdeClientConv.Create(nil);
  FDDEClientConv.ConnectMode := ddeManual;
  FDDEClientItem := TDDEClientItem.Create(nil);
  FDDEClientItem.DDEConv := FDDEClientConv;
  FDDEClientConv.ServiceApplication := 'Excel.EXE';
  FDDEClientConv.SetLink('Excel', 'System');
  Conectado := False;
end;

destructor TTbExcel.Destroy;
begin
  if csdesigning in componentstate then
    begin
      inherited Destroy;
      exit;
    end;
  if Conectado then
     FDDEClientConv.CloseLink;
  FDDEClientItem.Free;
  FDDEClientConv.Free;
  inherited Destroy;
end;

function TTbExcel.Connect : boolean;
begin
  if FDDEClientConv.OpenLink then
    Conectado := True
  else
    begin
      LocateExcel;
      if FDDEClientConv.OpenLink then
        Conectado := True
      else
        if FDDEClientConv.OpenLink then
          Conectado := True
        else
          Conectado := False;
    end;
  Connect := Conectado;
end;

procedure TTbExcel.Disconnect;
begin
  if Conectado then
    begin
      FDDEClientConv.CloseLink;
      FDDEClientItem.Free;
      FDDEClientConv.Free;
      FDDEClientConv := TDdeClientConv.Create(nil);
      FDDEClientConv.ConnectMode := ddeManual;
      FDDEClientItem := TDDEClientItem.Create(nil);
      FDDEClientItem.DDEConv := FDDEClientConv;
      FDDEClientConv.ServiceApplication := 'Excel.EXE';
      FDDEClientConv.SetLink('Excel', 'System');
      Conectado := False;
    end;
end;

procedure TTbExcel.LocateExcel;
const
  BuffSize = 255;
var
  Buff: array[0..BuffSize] of Char;
  Fn  : string;
  Len : Longint;
begin
  Len := BuffSize;
  StrPCopy(Buff, '.XLS');
  RegQueryValue(HKEY_CLASSES_ROOT, Buff, Buff, Len);
  if Len > 0 then
    begin
      StrCat(Buff, '\Shell\Open\Command');
      Len := BuffSize;
      RegQueryValue(HKEY_CLASSES_ROOT, Buff, Buff, Len);
      if Len > 0 then
        begin
          Fn := StrPas(StrUpper(Buff));
          Len := Pos('EXCEL.EXE', Fn);
          Delete(Fn, Len + Length('EXCEL.EXE'), 255);
          if Buff[0] = '"' then Delete(Fn, 1, 1);
          if FileExists(Fn) then
            FDDEClientConv.ServiceApplication := fn;
        end;
    end;
end;

procedure TTbExcel.Exec(const Cmd: string);
var
  Buffer : PChar;
begin
  with FDDEClientConv do
    begin
      if DDETopic <> 'System' then
        begin
          if Conectado then
            CloseLink;
          SetLink('Excel', 'System');
          if Conectado then
            OpenLink;
        end;
    end;
  while FDDEClientConv.WaitStat do
    Application.ProcessMessages;   { Waiting for Excel }
  Buffer := StrAlloc(Length(Cmd)+SizeOf(Char));
  if not FDDEClientConv.ExecuteMacro(StrPCopy(Buffer, Cmd), False) then
    FDDEClientConv.ExecuteMacro(Buffer, True);
  StrDispose(Buffer);
end;

procedure TTbExcel.SetStr(Columna, Fila : integer; Valor : string);
begin
  Application.ProcessMessages;
  Exec(Format('[FORMULA("%s","R%dC%d")]', [Trim(Valor), Fila, Columna]));
end;

procedure TTbExcel.Seleccionar(Columna1, Fila1, Columna2, Fila2 : integer);
begin
  Exec(Format('[SELECCIONAR("L%dC%d:L%dC%d")]',[Fila1,Columna1,Fila2,Columna2]));
end;

procedure TTbExcel.AnchoColumna(Ancho : integer);
begin
  if Ancho = 0 then
    Exec('[ANCHO.COLUMNA(;;;"3")]')
  else
    Exec(Format('[ANCHO.COLUMNA("%d";;;)]',[Ancho]));
end;

procedure TTbExcel.Alinear(Horizontal : byte);
begin
  Exec(Format('[ALINEACION("%d")]',[Horizontal]));
end;

procedure TTbExcel.StartExport;
begin
  Exec('[NEW(1)]');
  Exec('[ECHO(FALSE)]');         // No actualiza excel
  Exec('[DISABLE.INPUT(TRUE)]'); // Deshabilita excel
end;

procedure TTbExcel.EndExport;
begin
  Exec('[DISABLE.INPUT(FALSE)]'); // Habilita excel
  Exec('[ECHO(TRUE)]');           // Actualiza excel
end;

(* REPORTE *)

constructor TTbReport.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Columnas := TList.Create;
  Grupos := TList.Create;
  FLineas := 66;
  IMargen := 1;
  DMargen := 80;
  NumeraPaginas := True;
  FechaYHora := True;
  SeparacionColumnas := 1;
  FTitulo := Name;
  FSubTitulo := '';
  PiePagina := '';
  LineaTitulo := 3;
  LineaSubTitulo := 4;
  LineaPiePagina := 66;
  ColumnaTitulo := 0;
  ColumnaSubTitulo := 0;
  ColumnaPiePagina := 0;
  FFiltro := '';       // FILTRO DE LA TABLA PARA EL LISTADO
  FIndice := '';
  FPreview := pDefault;
  FModo := rmDefault;
  FAutoFirst := True;
end;

destructor TTbReport.Destroy;
begin
  Clear;
  inherited Destroy;
end;

procedure TTbReport.Clear;
begin
  While Columnas.Count > 0 do
    Columnas.Delete(0);
  Columnas.Free;
  While Grupos.Count > 0 do
    Grupos.Delete(0);
  Grupos.Free;
end;

procedure TTbReport.GroupDel(Grupo : TTbReportGroup);
var
  Gru : TTbReportGroup;
  i : integer;
begin
  Grupos.Delete(Grupos.IndexOf(Grupo));
  for i := 0 to Grupos.Count-1 do
    begin
      Gru := Grupos.Items[i];
      Gru.FIndice := i+1;
    end;
end;

function TTbReport.GroupAdd(Grupo : TTbReportGroup) : integer;
begin
  Grupos.Add(Grupo);
  GroupAdd := Grupos.IndexOf(Grupo)+1;
end;

procedure TTbReport.ExportToExcel;
var
  Excel : TTbExcel;
  Columna : TTbReportColumn;
  Grupo : TTbReportGroup;
  i : integer;
  SumaAlgunaColumna : boolean;
  LineaActual : integer;
  FinReporte : boolean;
  TablaPos : TBookMark;
  TablaAbierta : boolean; // SI LA TABLA ESTABA ABIERTA AL EMPEZAR
  FiltroDeTabla : string; // SI HABIA ESTABLECIDO UN FILTRO PARA LA TABLA
  Filtrada : boolean;     // SI LA TABLA ESTABA FILTRADA AL EMPEZAR
  IndiceDeTabla : string; // EL INDICE ACTIVO EN LA TABLA AL EMEPZAR
  Comienzo : boolean;
  GA : integer;           // GRUPO ACTUAL
  GR : integer;           // GRUPO QUE SE ANALIZA
  CA : integer;           // COLUMNA ACTUAL
  Texto : string;         // USO INTERNO
begin
  // PRIMERO ESTABLECE LAS POSICIONES DE LAS COLUMNAS
  if Columnas.Count > 0 then
    begin
      Excel := TTbExcel.Create(Self);
     try
      if Excel.Connect then
        begin
          // COMIENZO DEL REPORTE
          Excel.StartExport;
          // AHORA SE FIJA SI SE SUMA ALGUNA COLUMNA
          SumaAlgunaColumna := False;
          i := 0;
          While (i<Columnas.Count) and (not SumaAlgunaColumna) do
            begin
              Columna := Columnas.Items[i];
              if Columna.FSumaColumna then
                SumaAlgunaColumna := True;
              Inc(i);
            end; // YA SABEMOS SI SE SUMA ALGUNA COLUMNA
          TablaAbierta := FTabla.Active;
          if not TablaAbierta then
            FTabla.Open;
          TablaPos := FTabla.GetBookMark;
          if FIndice <> '' then
            begin // SE ASIGNO UN INDICE
              if FTabla.IndexFieldNames = '' then
                IndiceDeTabla := FTabla.IndexName
              else
                IndiceDeTabla := FTabla.IndexFieldNames;
              FTabla.IndexFieldNames := FIndice;
            end;
          FiltroDeTabla := FTabla.Filter;
          Filtrada := FTabla.Filtered;
          if FFiltro <> '' then
            begin // SE ASIGNO UN FILTRO
              FTabla.Filter := FFiltro;
              FTabla.Filtered := True;
            end;
          if FAutoFirst then
            FTabla.First;
          for i := 0 to Columnas.Count-1 do
            begin // ESCRIBO LOS TITULOS DE COLUMNAS
              Columna := Columnas.Items[i];
              Texto := Columna.FTitulo;
              if Length(Texto) > (Columna.FAncho+SeparacionColumnas-1) then
                SetLength(Texto,Columna.FAncho+SeparacionColumnas-1);
              Excel.SetStr(i+1,4,Texto);
            end;  // ESCRIBO LOS TITULOS DE COLUMNAS
          LineaActual := 5;
          if FTabla.EOF then
            FinReporte := True
          else if Assigned(FOnEndQuery) then
            FOnEndQuery(FinReporte)
          else
            FinReporte := False;
          Comienzo := True;
          While not FinReporte do
            begin // GENERA EL REPORTE
              if Grupos.Count > 0 then
                begin // HAY GRUPOS
                  if not Comienzo then
                    begin // NO ES EL COMIENZO
                      for GA := 0 to Grupos.Count-1 do
                        begin // RECORRIDO DE GRUPOS
                          Grupo := Grupos.Items[GA];
                          Grupo.ClaveActual := Grupo.ClaveAgrupacion.Value;
                          if Grupo.ClaveActual <> Grupo.ClaveAnterior then
                            begin // CAMBIO EL GRUPO
                              Inc(LineaActual);
                              for GR := Grupos.Count-1 downto GA do
                                begin // RECORRE GRUPOS RESTANTES
                                  Grupo := Grupos.Items[GR];
                                  if Grupo.FTotalizaGrupo then
                                    begin // SE TOTALIZA EL GRUPO
                                      Inc(LineaActual);
                                      Excel.SetStr(1,LineaActual,FormatFloat(Grupo.FTotalFormato,Grupo.TotalGrupo));
                                      for CA := 0 to Columnas.Count-1 do
                                        begin // RECORRO LAS COLUMNAS
                                          Columna := Columnas.Items[CA];
                                          if Columna.FSumaColumna then
                                            begin // SUMA LA COLUMNA
                                              Excel.SetStr(CA+1,LineaActual,FormatFloat(Columna.FFormato,Columna.AcumuladorColumna));
                                            end;  // SUMA LA COLUMNA
                                        end;  // RECORRO LAS COLUMNAS
                                      Inc(LineaActual);
                                    end;
                                end;  // RECORRE GRUPOS RESTANTES
                            end;  // CAMBIO EL GRUPO
                        end;  // RECORRIDO DE GRUPOS
                    end   // NO ES EL COMIENZO
                  else
                    Comienzo := False;
                  if not FinReporte then
                    begin
                      for GA := 0 to Grupos.Count-1 do
                        begin // RECORRIDO DE GRUPOS
                          Grupo := Grupos.Items[GA];
                          Grupo.ClaveActual := Grupo.ClaveAgrupacion.Value;
                          if Grupo.ClaveActual <> Grupo.ClaveAnterior then
                            begin // CAMBIO LA CLAVE DE AGRUPACION
                              for GR := GA to Grupos.Count-1 do
                                begin // RECORRO EL RESTO DE LOS GRUPOS
                                  Grupo := Grupos.Items[GR];
                                  Grupo.ClaveAnterior := Grupo.ClaveActual;
                                  Inc(LineaActual);
                                  Excel.SetStr(1,LineaActual,Grupo.FTitulo);
                                  Inc(LineaActual);
                                  Grupo.TotalGrupo := 0;
                                end;  // RECORRO EL RESTO DE LOS GRUPOS
                            end;  // CAMBIO LA CLAVE DE AGRUPACION
                        end;  // RECORRIDO DE GRUPOS
                    end;
                end;  // HAY GRUPOS
              if (not FinReporte) { and (Grupos.Count>0) } then
                begin // HAY GRUPOS
                  Inc(LineaActual);
                  for CA := 0 to Columnas.Count-1 do
                    begin // RECORRO LAS COLUMNAS
                      Columna := Columnas.Items[CA];
                      Texto := Columna.FField.DisplayText;
                      if Columna.FField.Alignment = taRightJustify then
                        begin
                          While Length(Texto) < Columna.FAncho do
                            Texto := ' '+Texto;
                        end;
                      if Assigned(Columna.FOnGetText) then
                        Columna.FOnGetText(Texto);
                      if Columna.FSumaColumna then
                        Columna.AcumuladorColumna := Columna.AcumuladorColumna+Columna.FField.Value;
                      for GA := 0 to Grupos.Count-1 do
                        begin // RECORRO LOS GRUPOS
                          Grupo := Grupos.Items[GA];
                          if Grupo.FTotalizaGrupo then
                            Grupo.TotalGrupo := Grupo.TotalGrupo+Columna.FField.Value;
                        end;  // RECORRO LOS GRUPOS
                      if Length(Texto) > Columna.FAncho then
                        SetLength(Texto,Columna.FAncho);
                      Excel.SetStr(CA+1,LineaActual,Texto);
                    end;
                end;  // HAY GRUPOS
              FTabla.Next;
              if FTabla.EOF then
                FinReporte := True
              else if Assigned(FOnEndQuery) then
                FOnEndQuery(FinReporte)
              else
                FinReporte := False;
              if SumaAlgunaColumna then
                begin // SUMA ALGUNA COLUMNA
                  LineaActual := LineaActual + 3;
                  Excel.SetStr(1,LineaActual,'TOTAL GENERAL');
                  for CA := 0 to Columnas.Count-1 do
                    begin // RECORRO COLUMNAS
                      Columna := Columnas.Items[CA];
                      if Columna.FSumaColumna then
                        begin // SUMA LA COLUMNA
                          Excel.SetStr(CA+1,LineaActual,FormatFloat(Columna.FFormato,Columna.AcumuladorColumna));
                        end;  // SUMA LA COLUMNA
                    end;  // RECORRO COLUMNAS
                end;  // SUMA ALGUNA COLUMNA
            end;
//        FinalDePagina(False);
          Excel.Seleccionar(1,4,Columnas.Count,LineaActual);
          Excel.AnchoColumna(0); // 0 = AUTOMATICO
          // PONER EL TTULO DEL LISTADO EN LA FILA 1
          if FechaYHora then
            begin
              Excel.SetStr(1,1,FormatDateTime('dd/mm/yy hh:mm',Now));
              Excel.SetStr(3,1,FPrinter.CompanyData);
            end
          else
            Excel.SetStr(1,1,FPrinter.CompanyData);
          if FTitulo <> '' then
            Excel.SetStr(1,2,FTitulo);
          if FSubTitulo <> '' then
            Excel.SetStr(1,3,FSubTitulo);
          Excel.Seleccionar(1,2,Columnas.Count,2);
          Excel.Alinear(7); // 7 = EN SELECCION
          Excel.Seleccionar(1,4,Columnas.Count,4);
          Excel.Alinear(3); // 3 = CENTRADO - 4 = DERECHA
          Excel.Seleccionar(1,1,1,1);
          FTabla.GotoBookMark(TablaPos);
          FTabla.FreeBookMark(TablaPos);
          FTabla.IndexFieldNames := IndiceDeTabla;
          if not TablaAbierta then
            begin // ESTABA CERRADA
              FTabla.Close;
            end;
          FTabla.Filter := FiltroDeTabla;
          FTabla.Filtered := Filtrada;
              // FIN DEL REPORTE
        end;
     except
     end;
      Excel.EndExport;
      Excel.Free;
    end;
end;

procedure TTbReport.Execute;
var
  AnteriorFuente : TFuente;
  ModoPrn : TPrinterMode; // USO INTERNO
  TituloAnterior : string;
begin
  if FPrinter = nil then
    begin
      MessageDlg('El listado no est enlazado a una impresora.'+#13+'Consulte con el proveedor del sistema.',mtError,[mbOk],0);
      Exit;
    end;
  if Columnas.Count > 0 then
    begin
      FPrinter.ReGenerate := Generate;
      FPrinter.SendToExcel := ExportToExcel;
      Generate;
      AnteriorFuente := FPrinter.FastFont;
      FPrinter.FastFont := Fuente;
      ModoPrn := FPrinter.Mode;
      if FModo = rmFast then
        FPrinter.Mode := pmFast
      else if FModo = rmWindows then
        FPrinter.Mode := pmWindows;
      TituloAnterior := FPrinter.Title;
      FPrinter.Title := Titulo;
      if FPreview = pYes then
        FPrinter.PreviewReal
      else if FPreview=pDefault then
        begin
          if FPrinter.Preview then
            FPrinter.PreviewReal
          else
            FPrinter.Imprimir;
        end
      else
        FPrinter.Imprimir;
      FPrinter.Finalizar;
      FPrinter.Title := TituloAnterior;
      FPrinter.FastFont := AnteriorFuente;
      if FModo <> rmDefault then
        FPrinter.Mode := ModoPrn;
      FPrinter.ReGenerate := nil;
      FPrinter.SendToExcel := nil;
    end;
end;

procedure TTbReport.Generate;
var
  Columna : TTbReportColumn;
  Grupo : TTbReportGroup;
  i : integer;
  PosicionIzquierda : byte;
  SumaAlgunaColumna : boolean;
  LineaActual : byte;
  FinReporte : boolean;
  PaginaActual : integer;
  TablaPos : TBookMark;
  TablaAbierta : boolean; // SI LA TABLA ESTABA ABIERTA AL EMPEZAR
  FiltroDeTabla : string; // SI HABIA ESTABLECIDO UN FILTRO PARA LA TABLA
  Filtrada : boolean;     // SI LA TABLA ESTABA FILTRADA AL EMPEZAR
  IndiceDeTabla : string; // EL INDICE ACTIVO EN LA TABLA AL EMEPZAR
  Comienzo : boolean;
  GA : integer;           // GRUPO ACTUAL
  GR : integer;           // GRUPO QUE SE ANALIZA
  CA : integer;           // COLUMNA ACTUAL
  Texto : string;         // USO INTERNO

  procedure ComienzoDePagina;
  var
    i : integer;
  begin
    if PaginaActual > 1 then
      FPrinter.NuevaPagina;
    FPrinter.Escribir(IMargen,1,FPrinter.CompanyData,FFuente);
    if NumeraPaginas then
      FPrinter.Escribir(IMargen,2,'Pag. '+FormatFloat('000',PaginaActual),FFuente);
    if FechaYHora then
      FPrinter.Escribir(DMargen-16,2,FormatDateTime('dd/mm/yy - hh:nn',Now),FFuente);
    LineaActual := 2;
    if FTitulo <> '' then
      begin // HAY TITULO
        if ColumnaTitulo > 0 then
         // EL TITULO VA EN LA COLUMNA
          FPrinter.Escribir(ColumnaTitulo,LineaTitulo,FTitulo,FFuente)
        else
         // EL TITULO VA CENTRADO
          FPrinter.Escribir((DMargen-IMargen-Length(FTitulo))div 2,LineaTitulo,FTitulo,FFuente);
        LineaActual := LineaTitulo;
      end;  // HAY TITULO
    if FSubTitulo <> '' then
      begin // HAY SUBTITULO
        if ColumnaSubTitulo > 0 then
          // EL SUBTITULO VA EN LA COLUMNA
          FPrinter.Escribir(ColumnaSubTitulo,LineaSubtitulo,FSubTitulo,FFuente)
        else
          // EL SUBTITULO VA CENTRADO
          FPrinter.Escribir((DMargen-IMargen-Length(FSubTitulo))div 2,LineaSubtitulo,FSubTitulo,FFuente);
        LineaActual := LineaSubTitulo;
      end;  // HAY SUBTITULO
    LineaActual := LineaActual+2;
    for i := 0 to Columnas.Count-1 do
      begin // ESCRIBO LOS TITULOS DE COLUMNAS
        Columna := Columnas.Items[i];
        Texto := Columna.FTitulo;
        if Length(Texto) > (Columna.FAncho+SeparacionColumnas-1) then
          SetLength(Texto,Columna.FAncho+SeparacionColumnas-1);
        FPrinter.Escribir(Columna.PosicionIzquierda,LineaActual,Texto,FFuente);
      end;  // ESCRIBO LOS TITULOS DE COLUMNAS
    LineaActual := LineaActual+1;
  end;

  procedure FinalDePagina(CrearOtraPagina:boolean);
  begin
    if PiePagina <> '' then
      begin // HAY PIE DE PAGINA
        if ColumnaPiePagina > 0 then
          // EL PIE DE PAGINA NO VA CENTRADO
          FPrinter.Escribir(ColumnaPiePagina,LineaPiePagina,PiePagina,FFuente)
        else
          // EL PIE DE PAGINA VA CENTRADO
          FPrinter.Escribir((DMargen-IMargen-Length(PiePagina))div 2,LineaPiePagina,PiePagina,FFuente);
      end;  // HAY PIE DE PAGINA
    if CrearOtraPagina then
      begin
        Inc(PaginaActual);
        ComienzoDePagina;
      end;
  end;

  procedure AvanzarLineas(Cantidad : byte);
  begin
    LineaActual := LineaActual+Cantidad;
    if LineaActual > FLineas then
      begin
        FinalDePagina(True);
      end;
  end;

begin // GENERA EL REPORTE EN LA IMPRESORA CORRESPONDIENTE
  // PRIMERO ESTABLECE LAS POSICIONES DE LAS COLUMNAS
  if Columnas.Count > 0 then
    begin
     try
      Columna := Columnas.Items[0];
      Columna.PosicionIzquierda := IMargen;
      PosicionIzquierda := IMargen + Columna.FAncho + SeparacionColumnas;
      if Columnas.Count > 1 then
        begin
          for i := 1 to Columnas.Count-1 do
            begin
              Columna := Columnas.Items[i];
              Columna.PosicionIzquierda := PosicionIzquierda;
              PosicionIzquierda := PosicionIzquierda + Columna.FAncho + SeparacionColumnas;
            end;
        end; // YA ESTAN LAS POSICIONES DE LAS COLUMNAS
      // AHORA SE FIJA SI SE SUMA ALGUNA COLUMNA
      SumaAlgunaColumna := False;
      i := 0;
      While (i<Columnas.Count) and (not SumaAlgunaColumna) do
        begin
          Columna := Columnas.Items[i];
          if Columna.FSumaColumna then
            SumaAlgunaColumna := True;
          Inc(i);
        end; // YA SABEMOS SI SE SUMA ALGUNA COLUMNA
      TablaAbierta := FTabla.Active;
      if not TablaAbierta then
        FTabla.Open;
      TablaPos := FTabla.GetBookMark;
      if FIndice <> '' then
        begin // SE ASIGNO UN INDICE
          if FTabla.IndexFieldNames = '' then
            IndiceDeTabla := FTabla.IndexName
          else
            IndiceDeTabla := FTabla.IndexFieldNames;
          FTabla.IndexFieldNames := FIndice;
        end;
      FiltroDeTabla := FTabla.Filter;
      Filtrada := FTabla.Filtered;
      if FFiltro <> '' then
        begin // SE ASIGNO UN FILTRO
          FTabla.Filter := FFiltro;
          FTabla.Filtered := True;
        end;
      if FAutoFirst then
        FTabla.First;
      FPrinter.Comenzar;
      LineaActual := 1;
      PaginaActual := 1;
      ComienzoDePagina;
      if FTabla.EOF then
        FinReporte := True
      else if Assigned(FOnEndQuery) then
        FOnEndQuery(FinReporte)
      else
        FinReporte := False;
      Comienzo := True;
      While not FinReporte do
        begin // GENERA EL REPORTE
          if Grupos.Count > 0 then
            begin // HAY GRUPOS
              if not Comienzo then
                begin // NO ES EL COMIENZO
                  for GA := 0 to Grupos.Count-1 do
                    begin // RECORRIDO DE GRUPOS
                      Grupo := Grupos.Items[GA];
                      Grupo.ClaveActual := Grupo.ClaveAgrupacion.Value;
                      if Grupo.ClaveActual <> Grupo.ClaveAnterior then
                        begin // CAMBIO EL GRUPO
                          AvanzarLineas(1);
                          for GR := Grupos.Count-1 downto GA do
                            begin // RECORRE GRUPOS RESTANTES
                              Grupo := Grupos.Items[GR];
                              if Grupo.FTotalizaGrupo then
                                begin // SE TOTALIZA EL GRUPO
                                  AvanzarLineas(1);
                                  FPrinter.Escribir(IMargen,LineaActual,FormatFloat(Grupo.FTotalFormato,Grupo.TotalGrupo),FFuente);
                                  for CA := 0 to Columnas.Count-1 do
                                    begin // RECORRO LAS COLUMNAS
                                      Columna := Columnas.Items[CA];
                                      if Columna.FSumaColumna then
                                        begin // SUMA LA COLUMNA
                                          FPrinter.Escribir(Columna.PosicionIzquierda,LineaActual,FormatFloat(Columna.FFormato,Columna.AcumuladorColumna),FFuente);
                                        end;  // SUMA LA COLUMNA
                                    end;  // RECORRO LAS COLUMNAS
                                  AvanzarLineas(1);
                                end;
                              if Grupo.SaltaHoja then
                                begin // SALTA LA HOJA
                                  FinalDePagina(True);
                                end;  // SALTA LA HOJA
                            end;  // RECORRE GRUPOS RESTANTES
                        end;  // CAMBIO EL GRUPO
                    end;  // RECORRIDO DE GRUPOS
                end   // NO ES EL COMIENZO
              else
                Comienzo := False;
              if not FinReporte then
                begin
                  for GA := 0 to Grupos.Count-1 do
                    begin // RECORRIDO DE GRUPOS
                      Grupo := Grupos.Items[GA];
                      Grupo.ClaveActual := Grupo.ClaveAgrupacion.Value;
                      if Grupo.ClaveActual <> Grupo.ClaveAnterior then
                        begin // CAMBIO LA CLAVE DE AGRUPACION
                          for GR := GA to Grupos.Count-1 do
                            begin // RECORRO EL RESTO DE LOS GRUPOS
                              Grupo := Grupos.Items[GR];
                              Grupo.ClaveAnterior := Grupo.ClaveActual;
                              AvanzarLineas(1);
                              FPrinter.Escribir(IMargen,LineaActual,Grupo.FTitulo,FFuente);
                              AvanzarLineas(1);
                              Grupo.TotalGrupo := 0;
                            end;  // RECORRO EL RESTO DE LOS GRUPOS
                        end;  // CAMBIO LA CLAVE DE AGRUPACION
                    end;  // RECORRIDO DE GRUPOS
                end;
            end;  // HAY GRUPOS
          if (not FinReporte) { and (Grupos.Count>0) } then
            begin // HAY GRUPOS
              AvanzarLineas(1);
              for CA := 0 to Columnas.Count-1 do
                begin // RECORRO LAS COLUMNAS
                  Columna := Columnas.Items[CA];
                  if Columna.FField = nil then
                    Texto := ''
                  else
                    begin
                      Texto := Columna.FField.DisplayText;
                      if Columna.FField.Alignment = taRightJustify then
                        begin
                          While Length(Texto) < Columna.FAncho do
                            Texto := ' '+Texto;
                        end;
                    end;
                  if Assigned(Columna.FOnGetText) then
                    Columna.FOnGetText(Texto);
                  if Columna.FSumaColumna then
                    Columna.AcumuladorColumna := Columna.AcumuladorColumna+Columna.FField.Value;
                  for GA := 0 to Grupos.Count-1 do
                    begin // RECORRO LOS GRUPOS
                      Grupo := Grupos.Items[GA];
                      if Grupo.FTotalizaGrupo then
                        Grupo.TotalGrupo := Grupo.TotalGrupo+Columna.FField.Value;
                    end;  // RECORRO LOS GRUPOS
                  if Length(Texto) > Columna.FAncho then
                    SetLength(Texto,Columna.FAncho);
                  FPrinter.Escribir(Columna.PosicionIzquierda,LineaActual,Texto,FFuente);
                end;
            end;  // HAY GRUPOS
          FTabla.Next;
          if FTabla.EOF then
            FinReporte := True
          else if Assigned(FOnEndQuery) then
            FOnEndQuery(FinReporte)
          else
            FinReporte := False;
          if SumaAlgunaColumna then
            begin // SUMA ALGUNA COLUMNA
              AvanzarLineas(2);
              if LineaActual > FLineas then
                begin
                  FinalDePagina(True);
                end;
              AvanzarLineas(1);
              FPrinter.Escribir(IMargen,LineaActual,'TOTAL GENERAL',FFuente);
              for CA := 0 to Columnas.Count-1 do
                begin // RECORRO COLUMNAS
                  Columna := Columnas.Items[CA];
                  if Columna.FSumaColumna then
                    begin // SUMA LA COLUMNA
                      FPrinter.Escribir(Columna.PosicionIzquierda,LineaActual,FormatFloat(Columna.FFormato,Columna.AcumuladorColumna),FFuente);
                    end;  // SUMA LA COLUMNA
                end;  // RECORRO COLUMNAS
            end;  // SUMA ALGUNA COLUMNA
        end;
      FinalDePagina(False);
      FTabla.GotoBookMark(TablaPos);
      FTabla.FreeBookMark(TablaPos);
      FTabla.IndexFieldNames := IndiceDeTabla;
      if not TablaAbierta then
        begin // ESTABA CERRADA
          FTabla.Close;
        end;
      FTabla.Filter := FiltroDeTabla;
      FTabla.Filtered := Filtrada;
     except
       if FPrinter.LasPaginas.Count > 0 then
         FPrinter.Finalizar;
       raise EPrinterError.Create( 'No se ha podido generar la impresin.' )
     end;
    end;
end;

function TTbReport.GetEndQueryEvent : TTbEndQueryEvent;
begin
  Result := FOnEndQuery;
end;

procedure TTbReport.SetEndQueryEvent(AEndQueryEvent: TTbEndQueryEvent);
begin
  FOnEndQuery := AEndQueryEvent;
end;

function TTbReportGroup.GetEndGroupEvent : TTbEndGroupEvent;
begin
  Result := FOnEndGroup;
end;

procedure TTbReportGroup.SetEndGroupEvent(AEndGroupEvent: TTbEndGroupEvent);
begin
  FOnEndGroup := AEndGroupEvent;
end;

function TTbReportColumn.GetTextEvent: TTbGetTextEvent;
begin
  Result := FOnGetText;
end;

procedure TTbReportColumn.SetTextEvent(AGetTextEvent: TTbGetTextEvent);
begin
  FOnGetText := AGetTextEvent;
end;

procedure TTbReport.ColumnChangeIndex(Ind1,Ind2 : integer);
var
  Col : TTbReportColumn;
  i : integer;
begin
  if (Ind2>0) and (Ind2<=Columnas.Count) and (Ind1<>Ind2) then
    begin // CAMBIA EL INDICE POR OTRO VALIDO
      Col := Columnas.Items[Ind1-1];
      Columnas.Delete(Ind1-1);
      Columnas.Insert(Ind2-1,Col);
      for i := 0 to Columnas.Count-1 do
        begin
          Col := Columnas.Items[i];
          Col.FIndice := i+1;
        end;
    end;
end;

procedure TTbReport.GroupChangeIndex(Ind1,Ind2 : integer);
var
  Gru : TTbReportGroup;
  i : integer;
begin
  if (Ind2>0) and (Ind2<=Grupos.Count) and (Ind1<>Ind2) then
    begin // CAMBIA EL INDICE POR OTRO VALIDO
      Gru := Grupos.Items[Ind1-1];
      Grupos.Delete(Ind1-1);
      Grupos.Insert(Ind2-1,Gru);
      for i := 0 to Grupos.Count-1 do
        begin
          Gru := Grupos.Items[i];
          Gru.FIndice := i+1;
        end;
    end;
end;

procedure TTbReportColumn.SetField(F : TField);
begin
  FField := F;
  if FTitulo = '' then
    begin
      if F.DisplayLabel = null then
        FTitulo := F.FieldName
      else
        FTitulo := F.DisplayLabel;
      if F is TStringField then
        FAncho := F.DisplayWidth
      else if F is TIntegerField then
        FAncho := 14
      else if F is TSmallIntField then
        FAncho := 7
      else if F is TWordField then
        FAncho := 6
      else if F is TFloatField then
        FAncho := 14
      else if F is TCurrencyField then
        FAncho := 16
      else if F is TBooleanField then
        FAncho := 2
      else
        FAncho := 10;
    end;
end;

(* COLUMNA DE REPORTE*)

procedure TTbReportColumn.SetIndice(Ind : integer);
begin
  if FReporte <> nil then
    FReporte.ColumnChangeIndex(FIndice,Ind);
end;

procedure TTbReportColumn.SetReporte(Rep : TTbReport);
begin
  if FReporte <> nil then
    begin
      FReporte.ColumnDel(Self);
      FIndice := 0;
    end;
  if Rep <> nil then
    FIndice := Rep.ColumnAdd(Self);
  FReporte := Rep;
end;

procedure TTbReport.ColumnDel(Columna : TTbReportColumn);
var
  Col : TTbReportColumn;
  i : integer;
begin
  Columnas.Delete(Columnas.IndexOf(Columna));
  for i := 0 to Columnas.Count-1 do
    begin
      Col := Columnas.Items[i];
      Col.FIndice := i+1;
    end;
end;

function TTbReport.ColumnAdd(Columna : TTbReportColumn) : integer;
begin
  Columnas.Add(Columna);
  ColumnAdd := Columnas.IndexOf(Columna)+1;
end;

constructor TTbReportColumn.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FIndice := 0;
  FTitulo := '';
  FAncho := 10;
  AcumuladorColumna := 0;
  FSumaColumna := False;
  PosicionIzquierda := 0;
  FFormato := '';
end;

destructor TTbReportColumn.Destroy;
begin
  FReporte.ColumnDel(Self);
  inherited Destroy;
end;

(* GRUPO DE REPORTE *)

procedure TTbReportGroup.SetIndice(Ind : integer);
begin
  if FReporte <> nil then
    FReporte.GroupChangeIndex(FIndice,Ind);
end;

procedure TTbReportGroup.SetReporte(Rep : TTbReport);
begin
  if FReporte <> nil then
    begin
      FReporte.GroupDel(Self);
      FIndice := 0;
    end;
  if Rep <> nil then
    FIndice := Rep.GroupAdd(Self);
  FReporte := Rep;
end;

destructor TTbReportGroup.Destroy;
begin
  inherited Destroy;
end;

constructor TTbReportGroup.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FIndice := 0;
  AcumuladorGrupo := 0;
  Encabezado := '';
  TotalGrupo := 0;
  FTotalizaGrupo := False;
  FTotalFormato := ',0.00';
  SaltaHoja := True;
  FTitulo := '';
end;

(* IMPRESORA *)

constructor TTbPrinter.Create(AOwner: TComponent);
var
  ADevice, ADriver, APort : array [0..255] of char;
  DeviceMode : THandle;
begin
  inherited Create(AOwner);
  SetModelo(EPSON_FX);
  SetFastPuerto('LPT1');
  FColumnas := 80;
  PaginaActual := 0;
  fCopias := 1;
  FZoom := zWidth;
  FFuente := [];
  LasPaginas := TList.Create;
//  WinPrinter := Printer.Printers[Printer.PrinterIndex];
  PageOrientation := Printer.Orientation;
  PageWidth := GetDeviceCaps(Printer.Handle, PHYSICALWIDTH);
  PageHeight := GetDeviceCaps(Printer.Handle, PHYSICALHEIGHT);
  PageWidthP := PageWidth/GetDeviceCaps(Printer.Handle, LOGPIXELSX);
  PageHeightP := PageHeight/GetDeviceCaps(Printer.Handle, LOGPIXELSY);
  Lineas := Trunc(PageHeightP*6)-2;
  Printer.GetPrinter(ADevice, ADriver, APort, DeviceMode);
  WinPort := APort;
  WinPrinter := ADevice;
  ReGenerate := nil;
  SendToExcel := nil;
end;

destructor TTbPrinter.Destroy;
begin
  Clear;
  inherited Destroy;
end;

procedure TTbPrinter.Clear;
var
  Pag : PPagina;
  HLin : PHorizLine;
  VLin : PVertLine;
  Esc : PEscritura;
begin
  While LasPaginas.Count > 0 do
    begin
      Pag := LasPaginas.Items[0];
      While Pag.Escritura.Count > 0 do
        begin
          Esc := Pag.Escritura.Items[0];
          Dispose(Esc);
          Pag.Escritura.Delete(0);
          Pag.Escritura.Pack;
        end;
      Pag.Escritura.Free;
      While Pag.LineasHorizontales.Count > 0 do
        begin
          HLin := Pag.LineasHorizontales.Items[0];
          Dispose(HLin);
          Pag.LineasHorizontales.Delete(0);
          Pag.LineasHorizontales.Pack;
        end;
      While Pag.LineasVerticales.Count > 0 do
        begin
          VLin := Pag.LineasVerticales.Items[0];
          Dispose(VLin);
          Pag.LineasVerticales.Delete(0);
          Pag.LineasVerticales.Pack;
        end;
      Pag.LineasVerticales.Free;
      Dispose(Pag);
      LasPaginas.Delete(0);
      LasPaginas.Pack;
    end;
end;

procedure TTbPrinter.SetModelo(Nombre : TModelo);
begin
  FModelo := Nombre;
  Case Nombre of
    Cannon_F60 :
      begin
        PRNNormal := '27 70 27 54 00';
        PRNBold := '27 69';
        PRNItalics := '27 54 01';
        PRNULineON := '27 45 01';
        PRNULineOFF := '27 45 00';
        PRNCompON := '15';
        PRNCompOFF := '18';
        PRNSetup := '';
        PRNReset := '';
      end;
    Cannon_Laser :
      begin
        PRNNormal := '27 38';
        PRNBold := '27 79';
        PRNItalics := '';
        PRNULineON := '27 69';
        PRNULineOFF := '27 82';
        PRNCompON := '27 31 09';
        PRNCompOFF := '27 31 13';
        PRNSetup := '';
        PRNReset := '';
      end;
    HP_Deskjet :
      begin
        PRNNormal := '27 40 115 48 66 27 40 115 48 83';
        PRNBold := '27 40 115 51 66';
        PRNItalics := '27 40 115 49 83';
        PRNULineON := '27 38 100 48 68';
        PRNULineOFF := '27 38 100 64';
        PRNCompON := '27 40 115 49 54 46 54 72';
        PRNCompOFF := '27 40 115 49 48 72';
        PRNSetup := '';
        PRNReset := '';
      end;
    HP_Laserjet :
      begin
        PRNNormal := '27 40 115 48 66 27 40 115 48 83';
        PRNBold := '27 40 115 53 66';
        PRNItalics := '27 40 115 49 83';
        PRNULineON := '27 38 100 68';
        PRNULineOFF := '27 38 100 64';
        PRNCompON := '27 40 115 49 54 46 54 72';
        PRNCompOFF := '27 40 115 49 48 72';
        PRNSetup := '';
        PRNReset := '12';
      end;
    HP_Thinkjet :
      begin
        PRNNormal := '27 70';
        PRNBold := '27 69';
        PRNItalics := '';
        PRNULineON := '27 45 49';
        PRNULineOFF := '27 45 48';
        PRNCompON := '15';
        PRNCompOFF := '18';
        PRNSetup := '';
        PRNReset := '';
      end;
    IBM_Color_Jet :
      begin
        PRNNormal := '27 72';
        PRNBold := '27 71';
        PRNItalics := '';
        PRNULineON := '27 45 01';
        PRNULineOFF := '27 45 00';
        PRNCompON := '15';
        PRNCompOFF := '18';
        PRNSetup := '';
        PRNReset := '';
      end;
    IBM_PC_Graphics :
      begin
        PRNNormal := '27 70 27 55';
        PRNBold := '27 69';
        PRNItalics := '27 54';
        PRNULineON := '27 45 01';
        PRNULineOFF := '27 45 00';
        PRNCompON := '15';
        PRNCompOFF := '18';
        PRNSetup := '';
        PRNReset := '';
      end;
    IBM_Proprinter :
      begin
        PRNNormal := '27 70';
        PRNBold := '27 69';
        PRNItalics := '';
        PRNULineON := '27 45 01';
        PRNULineOFF := '27 45 00';
        PRNCompON := '15';
        PRNCompOFF := '18';
        PRNSetup := '';
        PRNReset := '';
      end;
    NEC_3500 :
      begin
        PRNNormal := '27 72';
        PRNBold := '27 71';
        PRNItalics := '';
        PRNULineON := '27 45';
        PRNULineOFF := '27 39';
        PRNCompON := '15';
        PRNCompOFF := '18';
        PRNSetup := '';
        PRNReset := '';
      end;
    NEC_Pinwriter:
      begin
        PRNNormal := '27 70 27 53';
        PRNBold := '27 69';
        PRNItalics := '27 52';
        PRNULineON := '27 45 01';
        PRNULineOFF := '27 45 00';
        PRNCompON := '15';
        PRNCompOFF := '18';
        PRNSetup := '';
        PRNReset := '';
      end;
    else
//  Epson_FX :
      begin
        PRNNormal := '27 70 27 53';
        PRNBold := '27 69';
        PRNItalics := '27 52';
        PRNULineON := '27 45 01';
        PRNULineOFF := '27 45 00';
        PRNCompON := '15';
        PRNCompOFF := '18';
        PRNSetup := '';
        PRNReset := '27 64';
      end;
  end;
end;

procedure TTbPrinter.SetFastPuerto(Puerto : string);
begin
  if (Puerto <> fFastPuerto) then
    FFastPuerto := Puerto;
end;

function TTbPrinter.GetPaginas : byte;
begin
  GetPaginas := LasPaginas.Count;
end;

procedure TTbPrinter.Comenzar;  // PARA COMENZAR UNA NUEVA IMPRESION
begin
  Clear;
  NuevaPagina;
end;

procedure TTbPrinter.Finalizar; // ELIMINA LA INFORMACION DE LAS PAGINAS AL FINALIZAR
begin
  Clear;
end;

procedure TTbPrinter.Escribir(X,Y : byte; Texto:string;Fnt : TFuente); // ESCRIBE UN TEXTO EN LA PAGINA
var
  Txt : PEscritura;
  Pag : PPagina;
  P : integer;
begin
  if LasPaginas.Count > 0 then
    begin
      Pag := LasPaginas.Items[PaginaActual];
      P := 0;
      if Pag.Escritura.Count>0 then
        begin
          Txt := Pag.Escritura.Items[0];
          While (P<Pag.Escritura.Count) and
                ((Txt^.Y < Y) or
                ((Txt^.Y = Y)and(Txt^.X<=X))) do
            begin
              Inc(P);
              if P<Pag.Escritura.Count then
                Txt := Pag.Escritura.Items[P];
            end;
        end;
      New(Txt);
      Pag.Escritura.Insert(P,Txt);
      Txt^.X := X;
      Txt^.Y := Y;
      Txt^.Texto := Texto;
      Txt^.Fuente := Fnt;
      if Y > Pag.LineasImpresas then
        Pag.LineasImpresas := Y;
    end;
end;

procedure TTbPrinter.EscribirStd(X,Y : byte; Texto:string); // ESCRIBE UN TEXTO EN LA PAGINA
var
  Txt : PEscritura;
  Pag : PPagina;
  P : integer;
begin
  if LasPaginas.Count > 0 then
    begin
      Pag := LasPaginas.Items[PaginaActual];
      P := 0;
      if Pag.Escritura.Count>0 then
        begin
          Txt := Pag.Escritura.Items[0];
          While (P<Pag.Escritura.Count) and
                ((Txt^.Y < Y) or
                ((Txt^.Y = Y)and(Txt^.X<=X))) do
            begin
              Inc(P);
              if P<Pag.Escritura.Count then
                Txt := Pag.Escritura.Items[P];
            end;
        end;
      New(Txt);
      Pag.Escritura.Insert(P,Txt);
      Txt^.X := X;
      Txt^.Y := Y;
      Txt^.Texto := Texto;
      Txt^.Fuente := FFuente;
      if Y > Pag.LineasImpresas then
        Pag.LineasImpresas := Y;
    end;
end;

procedure TTbPrinter.Cuadro(X1,Y1,X2,Y2 : byte; Tipo : TLinea);// ESCRIBE UN RECTANGULO
var
  Pag : PPagina;
  VLine : PVertLine;
  HLine : PHorizLine;
begin
  if LasPaginas.Count > 0 then
    begin
      Pag := LasPaginas.Items[PaginaActual];
      New(VLine);
      VLine^.X := X1;
      VLine^.Y1 := Y1;
      VLine^.Y2 := Y2;
      VLine^.Tipo := Tipo;
      Pag^.LineasVerticales.Add(VLine);
      New(VLine);
      VLine^.X := X2;
      VLine^.Y1 := Y1;
      VLine^.Y2 := Y2;
      VLine^.Tipo := Tipo;
      Pag^.LineasVerticales.Add(VLine);
      New(HLine);
      HLine^.X1 := X1;
      HLine^.X2 := X2;
      HLine^.Y := Y1;
      HLine^.Tipo := Tipo;
      Pag^.LineasHorizontales.Add(HLine);
      New(HLine);
      HLine^.X1 := X1;
      HLine^.X2 := X2;
      HLine^.Y := Y2;
      HLine^.Tipo := Tipo;
      Pag^.LineasHorizontales.Add(HLine);
      if Y2 > Pag^.LineasImpresas then
        Pag^.LineasImpresas := Y2;
    end;
end;

procedure TTbPrinter.LineaHorizontal(X1,X2,Y : byte; Tipo : TLinea); // ESCRIBE UNA LINEA HORIZONTAL
var
  HLine : PHorizLine;
  Pag : PPagina;
begin
  if LasPaginas.Count > 0 then
    begin
      Pag := LasPaginas.Items[PaginaActual];
      New(HLine);
      Pag.LineasHorizontales.Add(HLine);
      HLine^.X1 := X1;
      HLine^.X2 := X2;
      HLine^.Y := Y;
      HLine^.Tipo := Tipo;
      if Y > Pag^.LineasImpresas then
        Pag^.LineasImpresas := Y;
    end;
end;

procedure TTbPrinter.LineaVertical(X,Y1,Y2 : byte; Tipo : TLinea);             // ESCRIBE UNA LINEA VERTICAL
var
  VLine : PVertLine;
  Pag : PPagina;
begin
  if LasPaginas.Count > 0 then
    begin
      Pag := LasPaginas.Items[PaginaActual];
      New(VLine);
      Pag.LineasVerticales.Add(VLine);
      VLine^.X := X;
      VLine^.Y1 := Y1;
      VLine^.Y2 := Y2;
      VLine^.Tipo := Tipo;
      if Y2 > Pag^.LineasImpresas then
        Pag^.LineasImpresas := Y2;
    end;
end;

procedure TTbPrinter.PreviewReal;                            // MUESTRA LA IMPRESION EN PANTALLA
begin
  PreviewForm := TPrintPreview.Create(self);
  PreviewForm.ShowModal;
  PreviewForm.Free;
end;

procedure TTbPrinter.Imprimir;
begin
  if FPreview then
    PreviewReal
  else
    ImprimirTodo;
end;

procedure TTbPrinter.HacerHoja(Numero : integer; Hoja : TMetaFile;ToPrint:boolean);
var
  EA : integer; // LINEA ACTUAL
  Pagina : PPagina;
  Escritura : PEscritura;
  Texto : TMetafile;
  Ancho, Alto : Integer;
  MargenIzquierdo, MargenSuperior : integer;
  AltoDeLinea, AnchoDeColumna : double;
  CantColumnas : integer;
begin
  if Comprimido in FastFont then
    CantColumnas := 140
  else
    CantColumnas := 83;
  if ToPrint then
    begin
      With TMetaFileCanvas.Create(Hoja,0) do
        try
          Brush.Color := clWhite;
          Hoja.Width := PrintingWidth{PageWidth} div 4; // 640;
          Hoja.Height := PrintingHeight{PageHeight} div 4; // 1056;
          AnchoDeColumna := (Hoja.Width)/CantColumnas;
          AltoDeLinea := (Hoja.Height)/Lineas;
          Font.Name := 'Courrier';
          Font.Size := 10;
          Font.Pitch := fpFixed;
          Ancho := TextWidth('X');
          Alto := TextHeight('X');
          FillRect(Rect(0,0,(Hoja.Width)-1,(Hoja.Height-1))); //80*(Ancho),66*Alto));
          Pagina := LasPaginas.Items[Numero-1];
          For EA := 0 to Pagina.Escritura.Count-1 do
            begin
              Escritura := Pagina.Escritura.Items[EA];
              if Escritura^.Y <= Lineas then
                begin
                  Texto := TMetaFile.Create;
                  Texto.Width := Ancho*Length(Escritura^.Texto);
                  Texto.Height := Alto;
                  With TMetaFileCanvas.Create(Texto,0) do
                    try
                      Font.Name := 'Courrier';
                      Font.Size := 10;
                      Font.Pitch := fpFixed;
                      if Negrita in Escritura^.Fuente then
                        Font.Style := Font.Style + [fsBold]
                      else
                        Font.Style := Font.Style - [fsBold];
                      if Italica in Escritura^.Fuente then
                        Font.Style := Font.Style + [fsItalic]
                      else
                        Font.Style := Font.Style - [fsItalic];
                      if Subrayado in Escritura^.Fuente then
                        Font.Style := Font.Style + [fsUnderline]
                      else
                        Font.Style := Font.Style - [fsUnderline];
                        TextOut(0,0,Escritura^.Texto);
                    finally
                      Free
                    end;
                  if (Comprimido in Escritura^.Fuente) and not (Comprimido in FastFont) then
                    StretchDraw(rect(Round(AnchoDeColumna*(Escritura^.X-1)),Round(AltoDeLinea*(Escritura^.Y-1)),Round(AnchoDeColumna*(Escritura^.X-1)+Length(Escritura^.Texto)*Hoja.Width/140),Round(AltoDeLinea*(Escritura^.Y))),Texto)
                  else
                    StretchDraw(rect(Round(AnchoDeColumna*(Escritura^.X-1)),Round(AltoDeLinea*(Escritura^.Y-1)),Round(AnchoDeColumna*(Escritura^.X+Length(Escritura^.Texto)-1)),Round(AltoDeLinea*(Escritura^.Y))),Texto);
                  Texto.Free;
                end
            end;
         finally
          Free;
        end;
    end
  else
    begin
      With TMetaFileCanvas.Create(Hoja,0) do
        try
          Brush.Color := clWhite;
          MargenIzquierdo := Round(GetDeviceCaps(Printer.Handle,PHYSICALOFFSETX)/GetDeviceCaps(Printer.Handle,LOGPIXELSX)*80);
          MargenSuperior := Round(GetDeviceCaps(Printer.Handle,PHYSICALOFFSETY)/GetDeviceCaps(Printer.Handle,LOGPIXELSY)*80);
          Hoja.Width := Round(GetDeviceCaps(Printer.Handle,PHYSICALWIDTH)/GetDeviceCaps(Printer.Handle,LOGPIXELSX)*80);
          Hoja.Height := Round(GetDeviceCaps(Printer.Handle,PHYSICALHEIGHT)/GetDeviceCaps(Printer.Handle,LOGPIXELSY)*80);
          AnchoDeColumna := (Hoja.Width-(2*MargenIzquierdo))/CantColumnas;
          AltoDeLinea := (Hoja.Height-(2*MargenSuperior))/Lineas;
          Font.Name := 'Courrier';
          Font.Size := 10;
          Font.Pitch := fpFixed;
          Ancho := TextWidth('X');
          Alto := TextHeight('X');
          FillRect(Rect(0,0,(Hoja.Width)-1,(Hoja.Height)-1)); //80*(Ancho),66*Alto));
          Pen.Color := clSilver;
          Pen.Style := psDot;
          if (MargenIzquierdo > 2) and (MargenSuperior > 2) then
            Rectangle(MargenIzquierdo-2,MargenSuperior-2,Round(MargenIzquierdo+CantColumnas*AnchoDeColumna)+2,Round(MargenSuperior+Lineas*AltoDeLinea)+2)
          else
            Rectangle(MargenIzquierdo,MargenSuperior,Round(MargenIzquierdo+CantColumnas*AnchoDeColumna),Round(MargenSuperior+Lineas*AltoDeLinea));
          Pen.Style := psSolid;
          Pen.Color := clBlack;
          Pagina := LasPaginas.Items[Numero-1];
          For EA := 0 to Pagina.Escritura.Count-1 do
            begin
              Escritura := Pagina.Escritura.Items[EA];
              if Escritura^.Y <= Lineas then
                begin
                  Texto := TMetaFile.Create;
                  Texto.Width := Ancho*Length(Escritura^.Texto);
                  Texto.Height := Alto;
                  With TMetaFileCanvas.Create(Texto,0) do
                    try
                      Font.Name := 'Courrier';
                      Font.Size := 10;
                      Font.Pitch := fpFixed;
//                    Brush.Color := clWhite;
                      if Negrita in Escritura^.Fuente then
                        Font.Style := Font.Style + [fsBold]
                      else
                        Font.Style := Font.Style - [fsBold];
                      if Italica in Escritura^.Fuente then
                        Font.Style := Font.Style + [fsItalic]
                      else
                        Font.Style := Font.Style - [fsItalic];
                      if Subrayado in Escritura^.Fuente then
                        Font.Style := Font.Style + [fsUnderline]
                      else
                        Font.Style := Font.Style - [fsUnderline];
                        TextOut(0,0,Escritura^.Texto);
                    finally
                      Free
                    end;
                  if (Comprimido in Escritura^.Fuente) and not (Comprimido in FastFont) then
                    StretchDraw(rect(Round(MargenIzquierdo+AnchoDeColumna*(Escritura^.X)),Round(MargenSuperior+AltoDeLinea*(Escritura^.Y-1)),Round(MargenIzquierdo+AnchoDeColumna*(Escritura^.X)+Length(Escritura^.Texto)*Hoja.Width/140),Round(MargenSuperior+AltoDeLinea*(Escritura^.Y))),Texto)
                  else
                    StretchDraw(rect(Round(MargenIzquierdo+AnchoDeColumna*(Escritura^.X)),Round(MargenSuperior+AltoDeLinea*(Escritura^.Y-1)),Round(MargenIzquierdo+AnchoDeColumna*(Escritura^.X+Length(Escritura^.Texto))),Round(MargenSuperior+AltoDeLinea*(Escritura^.Y))),Texto);
                  Texto.Free;
                end
            end;
         finally
          Free;
        end;
    end;
end;

function TTbPrinter.GetPrintingWidth : integer;
begin
  result := Printer.PageWidth;
end;

function TTbPrinter.GetPrintingHeight : integer;
begin
  result := Printer.PageHeight;
end;

function TTbPrinter.ImprimirPagina(Numero:integer) : boolean; // MANDA UNA PAGINA A LA IMPRESORA
var
  Copias : integer;
  Imagen : TMetaFile;
  Resultado : Boolean;
begin
  if FModo = pmWindows then
    begin
     try
      Printer.Title := Title + ' (Pgina N '+IntToStr(Numero)+')';
      Printer.Copies := fCopias;
      Printer.BeginDoc;
      Imagen := TMetaFile.Create;
      Imagen.Width := PrintingWidth{PageWidth} div 4; // 640;
      Imagen.Height := PrintingHeight{PageHeight} div 4; // 1056;
      try
       HacerHoja(Numero,Imagen,True);
       Printer.Canvas.StretchDraw(Rect(0,0,Printer.PageWidth,Printer.PageHeight),Imagen);
       Printer.EndDoc;
      except
      end;
      Imagen.Free;
      Resultado := True;
     except
      Resultado := False;
     end;
    end
  else
    begin
      Resultado := True;
      For Copias := 1 to fCopias do
        if Resultado then
          Resultado := Resultado and ImprimirPaginaFast(Numero);
    end;
  ImprimirPagina := Resultado;
end;

function TTbPrinter.ImprimirPaginaFast(Numero:integer) : boolean; // MANDA UNA PAGINA A LA IMPRESORA
var
  Impresora : TextFile; // Impresora
  LA : integer; // LINEA ACTUAL
  i,Contador : integer;
  LineaAImprimir : string;
  Pagina : PPagina;
  HLinea : PHorizLine;
  VLinea : PVertLine;
  Fuente : TFuente;
  UltimaEscritura : integer;
  EstadoImpresora : TStatus;
  Resultado : boolean;

  function Status : TStatus;
  var
    Buff: array[0..255] of Char;
    Pto : Word;
    Rdo : byte;
    Confirmado : boolean;
    TextoError : string;
    Estado : TStatus;
    Len : longint;
  begin
   try
    StrPCopy(Buff, '\SOFTWARE\Microsoft\Windows NT');
    Len := 255;
    if (RegQueryValue(HKEY_LOCAL_MACHINE, Buff, Buff, Len) <> ERROR_SUCCESS) and
       (UpperCase(Copy(FFastPuerto,1,3))='LPT') then
      begin // ES WINDOWS 95
        Estado := Desconocido;
        Confirmado := False;
        While (Estado <> Lista) and (not Confirmado) do
          begin
            try
              Pto := StrToInt(FFastPuerto[Length(FFastPuerto)]) - 1;
            finally
            end;
              asm
                MOV  DX,Pto
                MOV  AX,$0200  {AH := $02 : Leer el estado de la impresora}
                INT  $17
                MOV  Rdo,AH     {Guarda el estado en AL}
              end;
            if Rdo = 144 then
              Estado := Lista
            else if Rdo = 24 then
              begin
                Estado := OffLine;
                TextoError := 'La impresora se encuentra fuera de linea. Solucione el problema y reintente.';
              end
            else if Rdo = 56 then
              begin
                Estado := SinPapel;
                TextoError := 'La impresora se encuentra sin papel. Solucione el problema y reintente.';
              end
            else if Rdo = 32 then
              begin
                Estado := Apagada;
                TextoError := 'La impresora se encuentra apagada. Solucione el problema y reintente.';
              end
            else
              begin
                Estado := Desconocido;
                TextoError := 'La impresora tiene un problema desconocido. Solucione el problema y reintente.';
              end;
            if Estado <> Lista then
              begin
                if MessageDlg(TextoError,mtError,[mbRetry,mbCancel],0) = mrCancel then
                  Confirmado := True;
              end;
          end;
        Status := Estado;
      end
    else
      begin // ESTAMOS EN WINDOWS NT
        Status := Lista; // aunque puede no estar lista :-(
      end;
   finally
   end;
  end;

  procedure ErrorDeImpresion;
  begin
    if Assigned(fOnPrinterError) then
      fOnPrinterError(Self) // EJECUTA OnPrinterError
    else
      begin
        if EstadoImpresora = OffLine then
          raise EPrinterError.Create( 'La impresora esta fuera de linea. Pongala en estado en linea antes de volver a intentar' )
        else if EstadoImpresora = SinPapel then
          raise EPrinterError.Create( 'La impresora se ha quedado sin papel. Agregue papel antes de volver a intentar' )
        else if EstadoImpresora = Apagada then
          raise EPrinterError.Create( 'La impresora est apagada o desenchufada. Enciendala antes de volver a intentar' )
        else
          raise EPrinterError.Create( 'Ha ocurrido un error desconocido en la impresora. Solucionelo antes de volver a intentar' );
     end;
  end;

  procedure ImprimirCodigo(Codigo:string);
  var
    Sub : string;
    Cod : byte;
    P : byte;
  begin
    Sub := Codigo;
    While Length(Sub) > 0 do
      begin
        P := Pos(#32,Sub);
        if P = 0 then // ES EL ULTIMO CODIGO
          begin
           try
            Cod := StrToInt(Sub);
            Write(Impresora,chr(Cod));
            Sub := '';
           except
           end;
          end
        else
          begin // HAY MAS CODIGOS
           try
            Cod := StrToInt(Copy(Sub,1,P-1));
            Write(Impresora,chr(Cod));
            Sub := Copy(Sub,P+1,Length(Sub)-3);
           except
           end;
          end;
      end;
  end;

  procedure MaxX(var Linea:string; X : byte);
  begin
    While Length(Linea)<X do
      Linea := Linea + ' ';
  end;

  procedure ImprimirLinea;
  var
    Escritura : PEscritura;
    i,Contador : integer;
    Columna : byte;
    ImprimioLinea : boolean;
  begin
    if Pagina.Escritura.Count = UltimaEscritura then
      begin
        if Fuente <> FFuente then
          begin // PONEMOS LA FUENTE POR DEFAULT
            Fuente := FFuente;
            ImprimirCodigo(PRNNormal);
            if Negrita in Fuente then
              ImprimirCodigo(PRNBold);
            if Italica in Fuente then
              ImprimirCodigo(PRNItalics);
            if Comprimido in Fuente then
              ImprimirCodigo(PRNCompON)
            else
              ImprimirCodigo(PRNCompOFF);
            if Subrayado in Fuente then
              ImprimirCodigo(PRNULineON)
            else
              ImprimirCodigo(PRNULineOFF);
          end;
        Writeln(Impresora,LineaAImprimir);
      end
    else
      begin
        ImprimioLinea := False;
        Contador := UltimaEscritura;
        Columna := 1;
        Escritura := Pagina.Escritura.Items[Contador];
        While (Contador < Pagina.Escritura.Count) and (Escritura^.Y <= LA) do
          begin
            if Escritura^.Y = LA then
              begin
                ImprimioLinea := True;
                UltimaEscritura := Contador;
                MaxX(LineaAImprimir,Escritura^.X+Length(Escritura^.Texto));
                While Columna < Escritura^.X do
                  begin
                    if (LineaAImprimir[Columna] <> #32) and
                       (Fuente <> FFuente) then
                      begin // PONEMOS LA FUENTE POR DEFAULT
                        Fuente := FFuente;
                        ImprimirCodigo(PRNNormal);
                        if Negrita in Fuente then
                          ImprimirCodigo(PRNBold);
                        if Italica in Fuente then
                          ImprimirCodigo(PRNItalics);
                        if Comprimido in Fuente then
                          ImprimirCodigo(PRNCompON)
                        else
                          ImprimirCodigo(PRNCompOFF);
                        if Subrayado in Fuente then
                          ImprimirCodigo(PRNULineON)
                        else
                          ImprimirCodigo(PRNULineOFF);
                      end;
                    Write(Impresora,LineaAImprimir[Columna]);
                    Inc(Columna);
                  end;
                 if Escritura^.Fuente <> Fuente then
                  begin // PONEMOS LA FUENTE DEL TEXTO
                    Fuente := Escritura^.Fuente;
                    ImprimirCodigo(PRNNormal);
                    if Negrita in Fuente then
                      ImprimirCodigo(PRNBold);
                    if Italica in Fuente then
                      ImprimirCodigo(PRNItalics);
                    if Comprimido in Fuente then
                      ImprimirCodigo(PRNCompON)
                    else
                      ImprimirCodigo(PRNCompOFF);
                    if Subrayado in Fuente then
                      ImprimirCodigo(PRNULineON)
                    else
                      ImprimirCodigo(PRNULineOFF);
                  end;
                Write(Impresora,Escritura^.Texto);
                if {(FModo = Mejorado) and} (Comprimido in Fuente) and not(Comprimido in FastFont) then
                  begin
                    for i := 1 to Length(Escritura^.Texto) do
                      Write(Impresora,#8);
                    if (Length(Escritura^.Texto)*6) mod 10 = 0 then
                      i := Columna + (Length(Escritura^.Texto) *6) div 10
                    else
                      i := Columna + (Length(Escritura^.Texto) *6) div 10;
                    Fuente := Fuente - [Comprimido];
                    ImprimirCodigo(PRNNormal);
                    if Negrita in Fuente then
                      ImprimirCodigo(PRNBold);
                    if Italica in Fuente then
                      ImprimirCodigo(PRNItalics);
                    if Comprimido in Fuente then
                      ImprimirCodigo(PRNCompON)
                    else
                      ImprimirCodigo(PRNCompOFF);
                    if Subrayado in Fuente then
                      ImprimirCodigo(PRNULineON)
                    else
                      ImprimirCodigo(PRNULineOFF);
                    While Columna <= i do
                      begin
                        Write(Impresora,#32);
                        Inc(Columna);
                      end;
                  end
                else
                  Columna := Columna + Length(Escritura^.Texto);
              end;
            Inc(Contador);
            if Contador < Pagina.Escritura.Count then
              Escritura := Pagina.Escritura.Items[Contador];
          end;
        if ImprimioLinea then
          begin
            if Fuente <> FFuente then
              begin // PONEMOS LA FUENTE POR DEFAULT
                Fuente := FFuente;
                ImprimirCodigo(PRNNormal);
                if Negrita in Fuente then
                  ImprimirCodigo(PRNBold);
                if Italica in Fuente then
                  ImprimirCodigo(PRNItalics);
                if Comprimido in Fuente then
                  ImprimirCodigo(PRNCompON)
                else
                  ImprimirCodigo(PRNCompOFF);
                if Subrayado in Fuente then
                  ImprimirCodigo(PRNULineON)
                else
                  ImprimirCodigo(PRNULineOFF);
              end;
            While Columna <= Length(LineaAImprimir) do
              begin
                Write(Impresora,LineaAImprimir[Columna]);
                Inc(Columna);
              end;
            WriteLn(Impresora);
          end
        else
          begin
            if Fuente <> FFuente then
              begin // PONEMOS LA FUENTE POR DEFAULT
                Fuente := FFuente;
                ImprimirCodigo(PRNNormal);
                if Negrita in Fuente then
                  ImprimirCodigo(PRNBold);
                if Italica in Fuente then
                  ImprimirCodigo(PRNItalics);
                if Comprimido in Fuente then
                  ImprimirCodigo(PRNCompON)
                else
                  ImprimirCodigo(PRNCompOFF);
                if Subrayado in Fuente then
                  ImprimirCodigo(PRNULineON)
                else
                  ImprimirCodigo(PRNULineOFF);
              end;
            Writeln(Impresora,LineaAImprimir);
          end;
      end;
  end;

begin
     try
       Resultado := True;
       EstadoImpresora := Status;
       if EstadoImpresora <> Lista then
         begin
           Result := False;
           Exit;
         end;
//         raise EPrinterError.Create( 'La impresora no esta lista o no se ha detectado impresora.' );
       AssignFile(Impresora,FFastPuerto);
       ReWrite(Impresora);
       ImprimirCodigo(PRNReset);
       ImprimirCodigo(PRNSetup);
       Fuente := FFuente;
       ImprimirCodigo(PRNNormal);
       if Negrita in Fuente then
         ImprimirCodigo(PRNBold);
       if Italica in Fuente then
         ImprimirCodigo(PRNItalics);
       if Comprimido in Fuente then
         ImprimirCodigo(PRNCompON)
       else
         ImprimirCodigo(PRNCompOFF);
       if Subrayado in Fuente then
         ImprimirCodigo(PRNULineON)
       else
         ImprimirCodigo(PRNULineOFF);
       EstadoImpresora := Status;
       if EstadoImpresora <> Lista then
         raise EPrinterError.Create( 'Se ha cancelado la impresin' );
       UltimaEscritura := 0;
       Pagina := LasPaginas.Items[Numero-1];
       for LA := 1 to Min(Pagina.LineasImpresas,Lineas) do
         begin // SE IMPRIMEN TODAS LAS LINEAS
           LineaAImprimir := '';
           // ANALIZO PRIMERO LAS LINEAS HORIZONTALES
           For Contador := 0 to Pagina.LineasHorizontales.Count-1 do
             begin
               HLinea := Pagina.LineasHorizontales.Items[Contador];
               if HLinea^.Y = LA then // ES EN ESTA LINEA
                 begin
                   MaxX(LineaAImprimir,HLinea^.X2);
                   if HLinea^.Tipo = Simple then
                     begin
                       for i := HLinea^.X1 to HLinea^.X2 do
                         LineaAImprimir[i] := #196;
                     end
                   else // LINEA DOBLE
                     begin
                       for i := HLinea^.X1 to HLinea^.X2 do
                         LineaAImprimir[i] := #205;
                     end;
                 end;
             end;
           // AHORA SE ANALIZAN LAS LINEAS VERTICALES
           For Contador := 0 to Pagina.LineasVerticales.Count-1 do
             begin
               VLinea := Pagina.LineasVerticales.Items[Contador];
                 if (VLinea^.Y1<=LA) and (VLinea^.Y2>=LA) then
                   begin // LA LINEA PASA POR ESTA LINEA
                     MaxX(LineaAImprimir,VLinea^.X);
                     if VLinea^.Y1=LA then
                       begin // ES LA PRIMER LINEA
                         if LineaAImprimir[VLinea^.X] = #196 then // LINEA HORIZONTAL SIMPLE
                           begin
                             if (VLinea^.X > 0) and (ord(LineaAImprimir[VLinea^.X-1])in[192,193,194,195,196,197,199,208,210,211,214,215,218]) then
                               begin // VIENE DE LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[180,182,183,189,191,193,194,196,197,208,210,215,217]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #194
                                     else
                                       LineaAImprimir[VLinea^.X] := #210;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #191
                                     else
                                       LineaAImprimir[VLinea^.X] := #183;
                                   end;
                               end
                             else
                               begin // NO VA PARA LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[180,182,183,189,191,193,194,196,197,208,210,215,217]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #218
                                     else
                                       LineaAImprimir[VLinea^.X] := #214;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #194
                                     else
                                       LineaAImprimir[VLinea^.X] := #210;
                                   end;
                               end;
                           end
                         else if LineaAImprimir[VLinea^.X] = #205 then // LINEA HORIZONTAL DOBLE
                           begin
                             if (VLinea^.X > 0) and (ord(LineaAImprimir[VLinea^.X-1])in[198,200,201,202,203,204,205,206,207,209,212,213]) then
                               begin // VIENE DE LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[181,184,185,187,188,190,202,203,205,206,207,209,216]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #209
                                     else
                                       LineaAImprimir[VLinea^.X] := #203;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #184
                                     else
                                       LineaAImprimir[VLinea^.X] := #187;
                                   end;
                               end
                             else
                               begin // NO VA PARA LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[181,184,185,187,188,190,202,203,205,206,207,209,216]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #213
                                      else
                                       LineaAImprimir[VLinea^.X] := #201;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #209
                                     else
                                       LineaAImprimir[VLinea^.X] := #203;
                                   end;
                               end;
                           end
                         else // HAY OTRO CODIGO
                           begin
                             if VLinea^.Tipo = Simple then
                               LineaAImprimir[VLinea^.X] := #179
                             else // Doble
                               LineaAImprimir[VLinea^.X] := #186;
                           end;
                       end
                     else if VLinea^.Y2=LA then
                       begin // ES LA ULTIMA LINEA
                         if LineaAImprimir[VLinea^.X] = #196 then // LINEA HORIZONTAL SIMPLE
                           begin
                             if (VLinea^.X > 0) and (ord(LineaAImprimir[VLinea^.X-1])in[192,193,194,195,196,197,199,208,210,211,214,215,218]) then
                               begin // VIENE DE LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[180,182,183,189,191,193,194,196,197,208,210,215,217]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #193
                                     else
                                       LineaAImprimir[VLinea^.X] := #207;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #217
                                     else
                                       LineaAImprimir[VLinea^.X] := #189;
                                   end;
                               end
                             else
                               begin // NO VA PARA LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[180,182,183,189,191,193,194,196,197,208,210,215,217]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #192
                                     else
                                       LineaAImprimir[VLinea^.X] := #211;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #193
                                     else
                                       LineaAImprimir[VLinea^.X] := #207;
                                   end;
                               end;
                           end
                         else if LineaAImprimir[VLinea^.X] = #205 then // LINEA HORIZONTAL DOBLE
                           begin
                             if (VLinea^.X > 0) and (ord(LineaAImprimir[VLinea^.X-1])in[181,184,185,187,188,190,202,203,205,206,207,209,216]) then
                               begin // VIENE DE LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[198,200,201,202,203,204,205,206,207,209,212,213]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #207
                                     else
                                       LineaAImprimir[VLinea^.X] := #202;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #190
                                     else
                                       LineaAImprimir[VLinea^.X] := #188;
                                   end;
                               end
                             else
                               begin // NO VA PARA LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[198,200,201,202,203,204,205,206,207,209,212,213]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #212
                                     else
                                       LineaAImprimir[VLinea^.X] := #200;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #208
                                     else
                                       LineaAImprimir[VLinea^.X] := #202;
                                   end;
                               end;
                           end
                         else // HAY OTRO CODIGO
                           begin
                             if VLinea^.Tipo = Simple then
                               LineaAImprimir[VLinea^.X] := #179
                             else // Doble
                               LineaAImprimir[VLinea^.X] := #186;
                           end;
                       end
                     else
                       begin // ES UNA LINEA DEL MEDIO
                         if LineaAImprimir[VLinea^.X] = #196 then // LINEA HORIZONTAL SIMPLE
                           begin
                             if (VLinea^.X > 0) and (ord(LineaAImprimir[VLinea^.X-1])in[192,193,194,195,196,197,199,208,210,211,214,215,218]) then
                               begin // VIENE DE LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[180,182,183,189,191,193,194,196,197,208,210,215,217]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #197
                                     else
                                       LineaAImprimir[VLinea^.X] := #215;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #180
                                     else
                                       LineaAImprimir[VLinea^.X] := #182;
                                   end;
                               end
                             else
                               begin // NO VA PARA LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[180,182,183,189,191,193,194,196,197,208,210,215,217]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #195
                                     else
                                       LineaAImprimir[VLinea^.X] := #199;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #197
                                     else
                                       LineaAImprimir[VLinea^.X] := #215;
                                   end;
                               end;
                           end
                         else if LineaAImprimir[VLinea^.X] = #205 then // LINEA HORIZONTAL DOBLE
                           begin
                             if (VLinea^.X > 0) and (ord(LineaAImprimir[VLinea^.X-1])in[198,200,201,202,203,204,205,206,207,209,212,213]) then
                               begin // VIENE DE LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[181,184,185,187,188,190,202,203,205,206,207,209,216]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #216
                                     else
                                       LineaAImprimir[VLinea^.X] := #206;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #181
                                     else
                                       LineaAImprimir[VLinea^.X] := #185;
                                   end;
                               end
                             else
                               begin // NO VA PARA LA IZQUIERDA
                                 if (VLinea^.X < Length(LineaAImprimir)) and (ord(LineaAImprimir[VLinea^.X+1])in[181,184,185,187,188,190,202,203,205,206,207,209,216]) then
                                   begin // SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #198
                                     else
                                       LineaAImprimir[VLinea^.X] := #204;
                                   end
                                 else
                                   begin // NO SIGUE A LA DERECHA
                                     if VLinea^.Tipo = Simple then
                                       LineaAImprimir[VLinea^.X] := #216
                                     else
                                       LineaAImprimir[VLinea^.X] := #206;
                                   end;
                               end;
                           end
                         else
                           begin
                             if VLinea^.Tipo = Simple then
                               LineaAImprimir[VLinea^.X] := #179
                             else // Doble
                               LineaAImprimir[VLinea^.X] := #186;
                           end;
                       end;
                   end;
               end;
             ImprimirLinea;
           end;
         Write(Impresora,#12);
     except
      // si hay un error durante la impresion...
      ErrorDeImpresion;
      Resultado := False;
     end;
      {$I-}
      CloseFile(Impresora);
      {$I+}
  ImprimirPaginaFast := Resultado;
end;

procedure TTbPrinter.ImprimirTodo; // MANDA LA IMPRESION A LA IMPRESORA
var
  Imagen : TMetaFile;
  i : integer;
  Bien : boolean;
  Copias : integer;
begin // IMPRIMIR
  if FModo = pmWindows then
    begin
      Printer.Title := Title;
      Printer.Copies := FCopias;
      Printer.BeginDoc;
      Imagen := TMetaFile.Create;
      Imagen.Width := PrintingWidth{PageWidth} div 4; // 640;
      Imagen.Height := PrintingHeight{PageHeight} div 4; // 1056;
      HacerHoja(1,Imagen,True);
      Printer.Canvas.StretchDraw(Rect(0,0,Printer.PageWidth,Printer.PageHeight),Imagen);
      if LasPaginas.Count > 1 then
        for i := 2 to LasPaginas.Count do
          begin
            Printer.NewPage;
            HacerHoja(i,Imagen,True);
            Printer.Canvas.StretchDraw(Rect(0,0,Printer.PageWidth,Printer.PageHeight),Imagen);
          end;
      Printer.EndDoc;
      Imagen.Free;
    end
  else
    begin
      Bien := True;
      for Copias := 1 to FCopias do
        for i := 1 to LasPaginas.Count do
          if Bien then
            Bien := Bien and ImprimirPaginaFast(i);
    end;
end; // IMPRIMIR

procedure TTbPrinter.NuevaPagina;                        // CREA UNA NUEVA PAGINA
var
  Pag : PPagina;
begin
  New(Pag);
  LasPaginas.Add(Pag);
  Pag^.Escritura := TList.Create;
  Pag^.LineasVerticales := TList.Create;
  Pag^.LineasHorizontales := TList.Create;
  Pag^.LineasImpresas := 0;
  PaginaActual := LasPaginas.IndexOf(Pag);
end;

procedure TTbPrinter.SetModeloName(Nombre : String);
begin
  if Nombre = 'CANNON F-60' then
    SetModelo(Cannon_F60)
  else if Nombre = 'CANNON LASER' then
    SetModelo(Cannon_Laser)
  else if Nombre = 'EPSON FX/LX/LQ' then
    SetModelo(Epson_FX)
  else if Nombre = 'HP DESKJET' then
    SetModelo(HP_Deskjet)
  else if Nombre = 'HP LASERJET' then
    SetModelo(HP_Laserjet)
  else if Nombre = 'HP THINKJET' then
    SetModelo(HP_Thinkjet)
  else if Nombre = 'IBM COLOR JET' then
    SetModelo(IBM_Color_Jet)
  else if Nombre = 'IBM PC GRAPHICS' then
    SetModelo(IBM_PC_Graphics)
  else if Nombre = 'IBM PROPRINTER' then
    SetModelo(IBM_Proprinter)
  else if Nombre = 'NEC 3500' then
    SetModelo(NEC_3500)
  else if Nombre = 'NEC PINWRITER' then
    SetModelo(NEC_Pinwriter);
end;

function TTbPrinter.GetModeloRealName(Model : TModelo) : String;
begin
  Case Model of
    Cannon_F60 : GetModeloRealName := 'CANNON F-60';
    Cannon_Laser : GetModeloRealName := 'CANNON LASER';
    Epson_FX : GetModeloRealName := 'EPSON FX/LX/LQ';
    HP_Deskjet : GetModeloRealName := 'HP DESKJET';
    HP_Laserjet : GetModeloRealName := 'HP LASERJET';
    HP_Thinkjet : GetModeloRealName := 'HP THINKJET';
    IBM_Color_Jet : GetModeloRealName := 'IBM COLOR JET';
    IBM_PC_Graphics : GetModeloRealName := 'IBM PC GRAPHICS';
    IBM_Proprinter : GetModeloRealName := 'IBM PROPRINTER';
    NEC_3500 : GetModeloRealName := 'NEC 3500';
    NEC_Pinwriter : GetModeloRealName := 'NEC PINWRITER';
  end;
end;

function TTbPrinter.GetModeloName : String;
begin
  GetModeloName := GetModeloRealName(FModelo);
end;

procedure TTbPrinter.GetModelos(Modelos : TStrings);
var
  i : integer;
begin
  Modelos.Clear;
  for i := Ord(Low(TModelo)) to Ord(High(TModelo)) do
    Modelos.Add(GetModeloRealName(TModelo(i)));
end;

end.
