unit DemoMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TbPrint, ComCtrls, Tabnotbk, StdCtrls, Db, DBTables;

type
  TMain = class(TForm)
    TbPrinter1: TTbPrinter;
    TbReport1: TTbReport;
    Paginas: TTabbedNotebook;
    TbExcel1: TTbExcel;
    ExcelExample: TTabbedNotebook;
    ConnectToExcel: TButton;
    DisconnectFromExcel: TButton;
    LState: TLabel;
    State: TLabel;
    SendPanel: TGroupBox;
    LExcelY: TLabel;
    LExcelX: TLabel;
    LTextToSend: TLabel;
    ExcelX: TEdit;
    ExcelY: TEdit;
    TextToSend: TEdit;
    SendToExcel: TButton;
    StartAutoExcel: TButton;
    Friends: TTable;
    StartReport: TButton;
    FriendsNAME: TStringField;
    FriendsADDRESS: TStringField;
    FriendsZIP: TStringField;
    FriendsCITY: TStringField;
    FriendsAGE: TSmallintField;
    FriendsBORNDATE: TDateField;
    TbReportColumn1: TTbReportColumn;
    TbReportColumn2: TTbReportColumn;
    TbReportColumn3: TTbReportColumn;
    TbReportColumn4: TTbReportColumn;
    TbReportColumn5: TTbReportColumn;
    TbReportColumn6: TTbReportColumn;
    ReportPrintingMode: TComboBox;
    Label1: TLabel;
    Label2: TLabel;
    ReportShowPreview: TComboBox;
    Label3: TLabel;
    PrintingMode: TComboBox;
    Label4: TLabel;
    ShowPreview: TComboBox;
    FastMode: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    Model: TComboBox;
    Port: TEdit;
    TbCustomReport1: TTbCustomReport;
    Label7: TLabel;
    CustomPrintingMode: TComboBox;
    Label8: TLabel;
    CustomShowPreview: TComboBox;
    StartCustomReport: TButton;
    procedure ConnectToExcelClick(Sender: TObject);
    procedure ExcelXExit(Sender: TObject);
    procedure ExcelYExit(Sender: TObject);
    procedure SendToExcelClick(Sender: TObject);
    procedure DisconnectFromExcelClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure PaginasChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure ExcelExampleChange(Sender: TObject; NewTab: Integer;
      var AllowChange: Boolean);
    procedure StartAutoExcelClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure StartReportClick(Sender: TObject);
    procedure ReportPrintingModeChange(Sender: TObject);
    procedure ReportShowPreviewChange(Sender: TObject);
    procedure PrintingModeChange(Sender: TObject);
    procedure ShowPreviewChange(Sender: TObject);
    procedure PortChange(Sender: TObject);
    procedure ModelChange(Sender: TObject);
    procedure CustomPrintingModeChange(Sender: TObject);
    procedure CustomShowPreviewChange(Sender: TObject);
    procedure StartCustomReportClick(Sender: TObject);
    procedure TbCustomReport1Generate;
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

{$R *.DFM}

procedure TMain.ConnectToExcelClick(Sender: TObject);
begin
  With TbExcel1 do
    begin
      if Connect then
        begin
          ConnectToExcel.Enabled := False;
          DisconnectFromExcel.Enabled := True;
          State.Caption := 'Connected';
          SendPanel.Enabled := True;
          StartExport;
        end;
    end;
end;

procedure TMain.DisconnectFromExcelClick(Sender: TObject);
begin
  With TbExcel1 do
    begin
      EndExport;
      Disconnect;
      ConnectToExcel.Enabled := True;
      DisconnectFromExcel.Enabled := False;
      State.Caption := 'Disconnected';
      SendPanel.Enabled := False;
    end;
end;

procedure TMain.ExcelXExit(Sender: TObject);
begin
  try
    StrToInt(ExcelX.Text);
  except
    MessageDlg('You must put a number here.',mtError,[mbOk],0);
    ExcelX.SetFocus;
  end;
end;

procedure TMain.ExcelYExit(Sender: TObject);
begin
  try
    StrToInt(ExcelY.Text);
  except
    MessageDlg('You must put a number here.',mtError,[mbOk],0);
    ExcelY.SetFocus;
  end;
end;

procedure TMain.SendToExcelClick(Sender: TObject);
begin
  TbExcel1.SetStr(StrToInt(ExcelY.Text),StrToInt(ExcelX.Text),TextToSend.Text);
end;

procedure TMain.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if State.Caption = 'Connected' then
    begin
      TbExcel1.EndExport;
      TbExcel1.Disconnect;
    end;
end;

procedure TMain.PaginasChange(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  if Paginas.ActivePage = 'TbExcel' then
    begin
      if State.Caption = 'Connected' then
        DisconnectFromExcelClick(self);
    end;
end;


procedure TMain.ExcelExampleChange(Sender: TObject; NewTab: Integer;
  var AllowChange: Boolean);
begin
  if (ExcelExample.ActivePage = 'Manual') and
     (State.Caption = 'Connected') then
    DisconnectFromExcelClick(self);
end;

procedure TMain.StartAutoExcelClick(Sender: TObject);
begin
  with TbExcel1 do
    begin
      if Connect then
        begin
          StartExport;
          SetStr(1,1,'First name');
          SetStr(2,1,'Last name');
          SetStr(3,1,'Tel/Fax');
          SetStr(1,2,'Horacio');
          SetStr(2,2,'Jamilis');
          SetStr(3,2,'+54+1+482-xxxx');
          EndExport;
          Disconnect;
        end;
    end;
end;

procedure TMain.FormCreate(Sender: TObject);
begin
  Friends.TableName := ExtractFilePath(ParamStr(0))+'FRIENDS.DBF';
  ReportPrintingMode.ItemIndex := 0;
  ReportShowPreview.ItemIndex := 0;
  PrintingMode.ItemIndex := 0;
  ShowPreview.ItemIndex := 0;
  CustomPrintingMode.ItemIndex := 0;
  CustomShowPreview.ItemIndex := 0;
  TbPrinter1.GetModelos(Model.Items);
  Model.ItemIndex := 2;
 try
  Friends.Open;
 except
  MessageDlg('You could not use the TbReport because the table file is missing.',mtError,[mbOk],0);
 end;
end;

procedure TMain.StartReportClick(Sender: TObject);
begin
  TbReport1.Execute;
end;

procedure TMain.ReportPrintingModeChange(Sender: TObject);
begin
  case ReportPrintingMode.ItemIndex of
    1 : TbReport1.ModoImpresion := rmFast;
    2 : TbReport1.ModoImpresion := rmWindows;
    else
        TbReport1.ModoImpresion := rmDefault;
  end;
end;

procedure TMain.ReportShowPreviewChange(Sender: TObject);
begin
  case ReportShowPreview.ItemIndex of
    1: TbReport1.Preview := pYes;
    2: TbReport1.Preview := pNo;
  end;
       TbReport1.Preview := pDefault;
end;


procedure TMain.PrintingModeChange(Sender: TObject);
begin
  case PrintingMode.ItemIndex of
    1 : TbPrinter1.Mode := pmWindows;
    else
        TbPrinter1.Mode := pmFast;
  end;
end;

procedure TMain.ShowPreviewChange(Sender: TObject);
begin
  case ShowPreview.ItemIndex of
    1 : TbPrinter1.Preview := False
    else
        TbPrinter1.Preview := True;
  end;
end;

procedure TMain.PortChange(Sender: TObject);
begin
  TbPrinter1.FastPort := Port.Text;
end;

procedure TMain.ModelChange(Sender: TObject);
begin
  TbPrinter1.SetModeloName(Model.Items[Model.ItemIndex]);
end;

procedure TMain.CustomPrintingModeChange(Sender: TObject);
begin
  case CustomPrintingMode.ItemIndex of
    1 : TbCustomReport1.ModoImpresion := rmFast;
    2 : TbCustomReport1.ModoImpresion := rmWindows;
    else
        TbCustomReport1.ModoImpresion := rmDefault;
  end;
end;

procedure TMain.CustomShowPreviewChange(Sender: TObject);
begin
  case CustomShowPreview.ItemIndex of
    1: TbCustomReport1.Preview := pYes;
    2: TbCustomReport1.Preview := pNo;
  end;
       TbCustomReport1.Preview := pDefault;
end;

procedure TMain.StartCustomReportClick(Sender: TObject);
begin
  TbCustomReport1.Execute;
end;

procedure TMain.TbCustomReport1Generate;
begin
  with TbCustomReport1.Printer do
    begin
      Comenzar;
      EscribirStd(1,1,'Custom Printing Demostration.');
      EscribirStd(1,2,'In this example I don''t assign a procedure to export to Excel');
      EscribirStd(1,3,'so in the print preview form does not appear the Export to excel button.');
      Escribir(5,5,'You could change the font in the report!',[negrita]);
      Escribir(5,6,'Or you could write subscript.',[subrayado]);
      Escribir(5,7,'Or may be italic???',[italica]);
      Escribir(5,8,'Or a combination of this...',[negrita,subrayado,italica]);
      Escribir(10,10,'ANYWHERE',[negrita]);
      Escribir(15,12,'COMPRESSED FONT TOO... AND THIS IS ALL!',[comprimido]);
    end;
end;

end.
