unit TableMirror;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Db, DBTables;

type
  TTableMirror = class(TTable)
  private
    { Private declarations }
  protected
    { Protected declarations }
    TableMirror : TTable;
    FDatabaseNameMirror : string;
    FDoMirror : boolean;
    CurRecord : Variant;
    CurFields : string;
    LastState : TDataSetState;
    LastLocate : boolean;
    procedure GetCurPosition;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure DoAfterOpen; override;
    procedure DoAfterClose; override;

    procedure DoBeforeDelete; override ;
    procedure DoAfterDelete; override ;

    procedure DoBeforeEdit; override;
    procedure DoBeforePost; override;
    procedure DoAfterPost; override;
  published
    { Published declarations }
    property DatabaseNameMirror : string read FDatabaseNameMirror write FDatabaseNameMirror ;
    property DoMirror : boolean read FDoMirror write FDoMirror;
  end;

procedure Register;

implementation

procedure Register;
begin
     RegisterComponents('Data Access', [TTableMirror]);
end;

constructor TTableMirror.Create(AOwner: TComponent);
begin
     inherited Create(AOwner);
     TableMirror := nil;
end;

destructor TTableMirror.Destroy;
begin
     inherited ;
end;

procedure TTableMirror.GetCurPosition;
var
   i : integer;
begin
     if TableMirror <> nil then
     begin
          for i := 0 to FieldCount-1 do
          begin
               CurRecord[i] := FieldValues[Fields[i].FieldName];
          end;
          LastLocate := TableMirror.locate(CurFields, CurRecord, []);
     end;
end;


procedure TTableMirror.DoAfterOpen;
var
   i : integer;
begin
     inherited;
     if DoMirror and (DatabaseNameMirror <> '') then
     begin
          TableMirror := TTable.Create(self);
          TableMirror.TableName := TableName;
          TableMirror.IndexFieldNames := IndexFieldNames;
          TableMirror.IndexFiles := IndexFiles;
          TableMirror.IndexName := IndexName;
          TableMirror.DataBaseName := DataBaseNameMirror;
          TableMirror.open;
          CurRecord := VarArrayCreate([0, FieldCount-1], varVariant);
          CurFields := '';
          LastLocate := false;
          for i := 0 to TableMirror.FieldCount-1 do
          begin
               if CurFields <> ''  then
                  CurFields := CurFields + ';' + Fields[i].FieldName
               else
                   CurFields := Fields[i].FieldName;
          end;
     end;
end;

procedure TTableMirror.DoBeforeDelete;
begin
     inherited ;
     GetCurPosition;
end;

procedure TTableMirror.DoAfterDelete;
begin
     inherited ;
     if TableMirror <> nil then
     begin
          if LastLocate then
             TableMirror.delete;
     end;
end;

procedure TTableMirror.DoAfterClose;
begin
     inherited;
     if TableMirror <> nil then
     begin
          TableMirror.close;
          TableMirror.free;
          TableMirror := nil;
          VarClear(CurRecord);
     end;
end;

procedure TTableMirror.DoBeforeEdit;
begin
     inherited ;
     GetCurPosition;
end;

procedure TTableMirror.DoBeforePost;
var
   i : integer;
begin
     inherited ;
     if TableMirror <> nil then
     begin
          for i := 0 to FieldCount-1 do
          begin
               CurRecord[i] := FieldValues[Fields[i].FieldName];
          end;
          LastState := state;
     end;
end;

procedure TTableMirror.DoAfterPost;
var
   i : integer;
begin
     inherited ;
     if TableMirror <> nil then
     begin
          if LastState = dsInsert then
             TableMirror.append
          else
          begin
               if not LastLocate then
                  exit;
               TableMirror.edit;
          end;
          for i := 0 to FieldCount-1 do
          begin
               TableMirror.FieldValues[Fields[i].FieldName] := CurRecord[i];
          end;
          TableMirror.post;
     end;
end;

end.
