unit TbMultiLanguage;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  TypInfo, Db, DbTables, DbCtrls, Outline, StdCtrls, ExtCtrls, TabNotBk, Tabs,
  dsgnintf;

type
  TLanguage = String[2];

  TFilenameProperty = class(TStringProperty)
  public
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
  end;

  TTbMultiLanguage = class(TComponent)
  private
    { Private declarations }
    FLanguage : TLanguage;  // Lenguaje activo
    FFileName : string;     // Nombre del archivo de lenguajes
    FTable : TTable;        // Puntero a la tabla
    FForm : TForm;          // Forma en que esta el componente
    SAll  : string;
    SObj  : string;
    s     : string;
    sForm : string;
    procedure SetLanguage(Lang : TLanguage);
    procedure SetLocalLanguage(Lang : TLanguage);
    procedure SetFileName(Name : string);
    procedure SetReadNow(Now : Boolean);
    function GetReadNow : boolean;
      {Returns the value or content of a property if exists
       Devuelve el valor o contenido de una propiedad si esta existe}
    function  GetComponentProp(C: TComponent; Name: String): String;
      {Change the content of the property of the component
       Cambia el contenido de la propiedad del componente}
    procedure SetComponentProp(C: TComponent; const Name, Valor: String);
      {Says us if a component has the indicated property
       Nos dice si un componente tiene la propiedad indicada}
    function IfProperty(C: TComponent; Propiedad : String) : Boolean;
      {Watch exist table GLang, and if it does not create it
       Mira si existe la tabla Lang, y si no la crea}
    procedure IfExistsTable;
      {Saves a record with the data of a property
       Graba un registro con los datos de una propiedad}
    procedure GrabaReg(Lang : String; ReWrite : Boolean);
      {Read a record with the data of a property
       Lee un registro con los datos de una propiedad}
    procedure LeeReg(Lang : String);
      {Add the data in GLang.dbf with the String of the components of a Form
       Aade los datos en Lang.dbf con las String de los componentes de un Form}
    procedure DbfStringComponent(Form : TForm;
                                 Blancos,
                                 ReWrite : Boolean);
      {Returns the String of the language selected for the form past
       Devuelve los String del idioma seleccionado para el form pasado}
    procedure LangDbfComponent(Form : TForm; Lang : String);
  protected
    { Protected declarations }
  public
    { Public declarations }
    Constructor Create(AOwner:TComponent); override;
    Destructor Destroy; override;
  published
    { Published declarations }
    property TableName : string read FFileName write SetFileName;
    property ReadNow : Boolean read GetReadNow write SetReadNow;
    property Language : TLanguage read FLanguage write SetLanguage;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Terabyte', [TTbMultiLanguage]);
  RegisterPropertyEditor(TypeInfo(String), TTbMultiLanguage, 'TableName', TFileNameProperty);
end;

Constructor TTbMultiLanguage.Create(AOwner:TComponent);
var
  C : TComponent;
  i : integer;
begin
  inherited Create(AOwner);
  i := 0;
  FFileName := ExtractFilePath(ParamStr(0))+'Language.dbf';
  While (i < Owner.ComponentCount-1) and (Owner.Components[i]<>self) and not (Owner.Components[i] is TTbMultiLanguage) do
    inc(i);
  if (Owner.Components[i] is TTbMultiLanguage) and (Owner.Components[i]<>Self) then
    MessageDlg('There are already a TTbMultiLanguage component here!'+#13+'Please, delete this one.',mtError,[mbOk],0);
  C := AOwner;
  While not (C is TForm) do
    C := C.Owner;
  FForm := TForm(C);
  FTable := TTable.Create(self);
  FTable.TableName := FFileName;
  FLanguage := 'SP';
end;

Destructor TTbMultiLanguage.Destroy;
begin
  FTable.Free;
  inherited Destroy;
end;

procedure TTbMultiLanguage.SetLocalLanguage(Lang : TLanguage);
begin
  FLanguage := Lang;
  if Lang <> 'SP' then
    Lang := 'EN';
  LangDbfComponent(FForm,Lang);
end;

procedure TTbMultiLanguage.SetLanguage(Lang : TLanguage);
var
  i,j : integer;
begin
  if (CSDesigning in ComponentState) then
    begin
      FLanguage := Lang;
      if Lang <> 'SP' then
        Lang := 'EN';
      LangDbfComponent(FForm,Lang);
    end
  else if (Application.MainForm=nil) or (Application.MainForm=FForm) then
    begin
      i := 0;
      while (i < Application.ComponentCount) do
        begin
          if (Application.Components[i] is TForm) then
            begin
              j := 0;
              While (j < Application.Components[i].ComponentCount) and not (Application.Components[i].Components[j] is TTbMultiLanguage) do
                inc(j);
              if (Application.Components[i].Components[j] is TTbMultiLanguage) and (TTbMultiLanguage(Application.Components[i].Components[j]).Language <> Lang) then
                TTbMultiLanguage(Application.Components[i].Components[j]).SetLocalLanguage(Lang);
            end;
          inc(i);
        end;
    end
  else // establezco el lenguaje del mainform!
    begin
      i := 0;
      While (i<Application.MainForm.ComponentCount) and not(Application.MainForm.Components[i] is TTbMultiLanguage) do
        inc(i);
      if (Application.MainForm.Components[i] is TTbMultiLanguage){ and (TTbMultiLanguage(Application.MainForm.Components[i]).Language<>FLanguage)} then
        SetLocalLanguage(TTbMultiLanguage(Application.MainForm.Components[i]).Language);
    end;
end;

procedure TTbMultiLanguage.SetFileName(Name : string);
begin
  if (CSDesigning in ComponentState) then
    FFileName := Name
  else
    FFileName := ExtractFilePath(ParamStr(0))+'Language.dbf';
  FTable.TableName := FFileName;
end;

  {Get property component if exists
   Devuelve el valor o contenido de una propiedad si esta existe}
function TTbMultiLanguage.GetComponentProp(C: TComponent; Name: String): String;
var
  p:PPropInfo;
begin
  p := GetPropInfo(C.ClassInfo, Name);
  if Assigned(p) then
    Result := GetStrProp(C, p)
  else
    Result := '';
end;

  {Set property component
   Cambia el contenido de la propiedad del componente}
procedure TTbMultiLanguage.SetComponentProp(C: TComponent; const Name, Valor: String);
var
  p: PPropInfo;
begin
  if Valor = '' then
    Exit;
  p := GetPropInfo(C.ClassInfo, Name);
  if Assigned(p) then
    SetStrProp(C, p, Valor);
end;

  {True if Exist property of component
   Devuelve True si esxiste la propiedad en el componente}
function TTbMultiLanguage.IfProperty(C: TComponent; Propiedad : String) : Boolean;
begin
  Result := (C.Name <> '') and (GetPropInfo(C.ClassInfo, Propiedad) <> nil );
end;

  {Watch exist table GLang, and if it does not create it
   Mira si existe la tabla de Idioma, y si no la crea}
procedure TTbMultiLanguage.IfExistsTable;
begin
  if FileExists(FFileName) then
    Exit;
  with FTable do
    begin
      Close;
       {The names of the fields and your length, they can be varied to will, always
        that in the calls to the procedures are observed the same names
        Los nombres de los campos y su longitud, pueden variarse a voluntad, siempre
        que en las llamadas a los procedimientos se respeten los mismos nombres}
      with FieldDefs do
        begin
          Clear;
          Add('Form', ftString, 30, False);
          Add('Objeto', ftString, 70, False);
          Add('SP', ftString, 125, False);
          Add('EN', ftString, 125, False);
        end;
      with IndexDefs do
        begin
          Clear;
          Add('Objeto', 'Objeto', []);
        end;
      CreateTable;
    end;
end;

  {Saves a record with the data of a property
   Graba un registro con los datos de una propiedad}
procedure TTbMultiLanguage.GrabaReg(Lang : String; ReWrite : Boolean);
begin
  sAll := sForm + '.' + sObj;
  with FTable do
    begin
      if not Active then
        Open;
        First;
      if not Locate('Objeto', sAll, [loPartialKey]) then
        Append;
      Edit;
      FieldByName('Form').AsString   := sForm;
      FieldByName('Objeto').AsString := sAll;
      if Rewrite then
        begin {ReWrite all string
               Sobreescribir todas las String}
          if (Lang = 'SP') or (Lang = 'ALL')  then
            FieldByName('SP').AsString := s;
          if (Lang = 'EN') or (Lang = 'ALL')  then
            FieldByName('EN').AsString := s;
        end
      else
        begin {Only writes when this in white
               Solo escribe cuando esta en blanco}
          if ((Lang = 'SP') or (Lang = 'ALL')) and
             (Length(FieldByName('SP').AsString) = 0) then
            FieldByName('SP').AsString := s;
          if ((Lang = 'EN') or (Lang = 'ALL')) and
             (Length(FieldByName('EN').AsString) = 0) then
            FieldByName('EN').AsString := s;
        end;
      Post;
      Close;
    end;
end;

  {Read a record with the data of a property
   Lee un registro con los datos de una propiedad}
procedure TTbMultiLanguage.LeeReg(Lang : String);
begin
  sAll := sForm + '.' + sObj;
  with FTable do
    begin
      if not Active then
        Open;
      First;
      if Locate('Objeto', sAll, [loPartialKey]) then
        begin
          if Lang = 'SP' then s := FieldByName('SP').AsString
          else if Lang = 'EN' then s := FieldByName('EN').AsString
          else s := ''
        end
      else
        s := '';
    end;
end;

  {Returns the String of the language selected for the form pased
   Devuelve los String del idioma seleccionado para el form pasado}
procedure TTbMultiLanguage.LangDbfComponent(Form : TForm; Lang : String);
var
  j,i  : Integer;
begin
  if not FileExists(FFileName) then
    Exit;
   {We assure ourselves of the fact that the index is the waited
    Nos aseguramos de que el indice es el esperado}
  try
    FTable.Close;
    FTable.IndexName := 'Objeto';
    FTable.Open;
  except
  end;
   {Properties obtainment and its String
    Obtencin de propiedades y sus String}
  try
    with Form do
      begin
        {Propertys of the Form}
        sForm := Name;
        {Caption of the Form}
        sObj  := Name + '.Caption'; {Objet and property}
        LeeReg(Lang); {Read property string}
        if (Length(s) > 0) then
          for j :=1 to Length(s) do
            if s[j] = #21 then
              s[j] := #10
            else if s[j] = #22 then
              s[j] := #13;
        Form.Caption := s;
        {Hint of the Form}
        sObj  := Name + '.Hint';
        LeeReg(Lang);
        if (Length(s) > 0) then
          for j:=1 to Length(s) do
            if s[j] = #21 then
              s[j] := #10
            else if s[j] = #22 then
              s[j] := #13;
        Form.Hint := s;
        {Propertys of the All component}
        for i := 0 to ComponentCount - 1 do
          begin
           {TeeChart make pointer exception
            TeeChart hace una excepcin de tipo puntero}
            if Pos('CHART',UpperCase(Components[i].Name)) = 0  then
              begin
                {Property Caption}
                if IfProperty(Components[i], 'Caption') then
                  begin
                    sObj := Components[i].Name + '.Caption';
                    LeeReg(Lang);
                    SetComponentProp(Components[i], 'Caption' , s);
                  end;
                {Property Hint}
                if IfProperty(Components[i], 'Hint') then
                  begin
                    sObj := Components[i].Name + '.Hint';
                    LeeReg(Lang);
                    for j := 1 to Length(s) do
                      if s[j] = #21 then
                        s[j] := #10
                      else if s[j] = #22 then
                        s[j] := #13;
                    SetComponentProp(Components[i], 'Hint' , s);
                  end;
                {Property Title}
                if IfProperty(Components[i], 'Title') then
                  begin
                    sObj := Components[i].Name + '.Title';
                    LeeReg(Lang);
                    SetComponentProp(Components[i], 'Title' , s);
                  end;
                {Property DisplayLabel}
                if IfProperty(Components[i], 'DisplayLabel') then
                  begin
                    sObj := Components[i].Name + '.DisplayLabel';
                    LeeReg(Lang);
                    SetComponentProp(Components[i], 'DisplayLabel' , s);
                  end;
                {Property Lines}
                if IfProperty(Components[i], 'Lines') then
                  begin
                    if Components[i] is TOutLine then
                      for j := 0 to TOutLine(Components[i]).Lines.Count - 1 do
                        begin
                          sObj := Components[i].Name + '.' + IntToStr(j);
                          LeeReg(Lang);
                          TOutLine(Components[i]).Lines[j] := s;
                        end
                    else if Components[i] is TMemo then
                      for j := 0 to TMemo(Components[i]).Lines.Count - 1 do
                        begin
                          sObj := Components[i].Name + '.' + IntToStr(j);
                          LeeReg(Lang);
                          TMemo(Components[i]).Lines[j] := s;
                        end;
                  end;
                {Property Items}
                if IfProperty(Components[i], 'Items') then
                  begin
                    if (Components[i] is TListBox) or
                       (Components[i] is TComboBox) or
                       (Components[i] is TDBListBox) or
                       (Components[i] is TDBComboBox) then
                      for j := 0 to TListBox(Components[i]).Items.Count-1 do
                        begin
                          sObj := Components[i].Name + '.' + IntToStr(j);
                          LeeReg(Lang);
                          TListBox(Components[i]).Items[j] := s;
                        end
                    else if (Components[i] is TRadioGroup) then
                      for j := 0 to TRadioGroup(Components[i]).Items.Count-1 do
                        begin
                          sObj := Components[i].Name + '.' + IntToStr(j);
                          LeeReg(Lang);
                          TRadioGroup(Components[i]).Items[j] := s;
                        end;
                  end;
                {Property Pages}
                if IfProperty(Components[i], 'Pages') then
                  begin
                    if (Components[i] is TNotebook) then
                      for j := 0 to TNotebook(Components[i]).Pages.Count-1 do
                        begin
                          sObj := Components[i].Name + '.' + IntToStr(j);
                          LeeReg(Lang);
                          TNotebook(Components[i]).Pages[j] := s;
                        end
                    else if (Components[i] is TTabbedNotebook) then
                      for j := 0 to TTabbedNotebook(Components[i]).Pages.Count-1 do
                        begin
                          sObj := Components[i].Name + '.' + IntToStr(j);
                          LeeReg(Lang);
                          TTabbedNotebook(Components[i]).Pages[j] := s;
                        end;
                  end;
                {Property Tabs}
                if IfProperty(Components[i], 'Tabs') then
                  begin
                    if (Components[i] is TTabset) then
                      for j := 0 to TTabset(Components[i]).Tabs.Count-1 do
                        begin
                          sObj := Components[i].Name + '.' + IntToStr(j);
                          LeeReg(Lang);
                          TTabset(Components[i]).Tabs[j] := s;
                        end;
                  end;
              end; {If is not teeChart Component
                    Si no es TeeChart Component}
          end;  {for i := 0 to Form.ComponentCount - 1}
      end;   {with Form}
    finally
      FTable.Close;
    end; {try}
end;

procedure TTbMultiLanguage.DbfStringComponent(Form : TForm;
                             Blancos, ReWrite : Boolean);
var
  C    : TComponent;
  j,i  : Integer;
  Lang : string;
begin
 {This procedure adds to table Lang.dbf all the components that have String and
  your value. It is tables generator for power to accomplish applications in
  various languages.
  Table has several languages:
    EN: English; SP: Spanish; IT: Italian; ALL: Write what is same in all
  It will have to of be called alone in design time to create the languages table
  ------------------------------------------------------------------------------
  Este procedimiento aade a la tabla Lang.dbf todos los componentes que tienen
  String y su valor. Es el generador de recursos para intercionalizar las
  aplicaciones.
  La tabla tiene varios idiomas:
    SP: Espaol; EN: Ingles; IT: Italiano; DE: Aleman; FR: Frances;
    PO: Portugues; ALL: Escribe lo mismo en todos
   Ejemplo de llamada:
   DbfStringComponent(Copia_Dbf, 'Espaol');
   DbfStringComponent(Copia_Dbf, 'Ingles');
  Con esto nos aadira los textos en el idioma correspondiente con todos los
  String de los componentes, repetidos para cada objeto e idioma definido.
 }
  if not FileExists(FFileName) then
    Exit;
  Lang := FLanguage;
  if Lang <> 'SP' then
    Lang := 'EN';
  try
    FTable.Close;
    FTable.IndexName := 'Objeto';
    FTable.Open;
  except
  end;
  blancos := true;
  try
    with Form do
      begin
        {Propertys of the Form}
        sForm := Name;
        sAll  := Name + '.' + Name;
        // Caption of the Form
        sObj  := Name + '.Caption';
        S := Caption;
        if Blancos or (Length(S) > 0) then
          for j:=1 to Length(S) do
            if S[j] = #10
              then S[j] := #21
            else if S[j] = #13
              then S[j] := #22;
        GrabaReg(Lang,Rewrite);
        // Hint of the Form
        sObj  := Name + '.Hint';
        S := Hint;
        if Blancos or (Length(S) > 0) then
          for j:=1 to Length(S) do
            if S[j] = #10
              then S[j] := #21
            else if S[j] = #13
              then S[j] := #22;
        GrabaReg(Lang,Rewrite);
        {Propertys of the All component}
        for i := 0 to ComponentCount - 1 do
          begin
            C := Components[i];
            if (UpperCase(C.Name) = 'CHART1') or (UpperCase(C.Name) = 'CHART2') then
              C := Components[i + 1];
            {Property Caption}
            if IfProperty(C, 'Caption') then
              begin
                S := GetComponentProp(C,'Caption');
                if Blancos or (Length(s) > 0) then
                  begin
                    sObj := C.Name + '.Caption';
                    GrabaReg(Lang,Rewrite);
                  end;
              end;
            {Property Hint}
            if IfProperty(C, 'Hint') then
              begin
                S := GetComponentProp(C,'Hint');
                for j := 1 to Length(S) do
                  if S[j] = #10 then
                    S[j] := #21
                  else if S[j] = #13 then
                    S[j] := #22;
                  if Blancos or (Length(s) > 0) then
                    sObj := C.Name + '.Hint';
                  GrabaReg(Lang,Rewrite);
              end;
            {Property Title}
            if IfProperty(C, 'Title') then
              begin
                s := GetComponentProp(C,'Title');
                if Blancos or (Length(s) > 0) then
                  begin
                    sObj := C.Name + '.Title';
                    GrabaReg(Lang,Rewrite);
                  end;
              end;
            {Property DisplayLabel}
            if IfProperty(C, 'DisplayLabel') then
              begin
                s := GetComponentProp(C,'DisplayLabel');
                if Blancos or (Length(s) > 0) then
                  begin
                    sObj := C.Name + '.DisplayLabel';
                    GrabaReg(Lang,Rewrite);
                  end;
              end;
            {Property Lines}
            if IfProperty(C, 'Lines') then
              begin
                if C is TOutLine then
                  for j := 0 to TOutLine(C).Lines.Count - 1 do
                    begin
                      s := TOutLine(C).Lines[j];
                      sObj := C.Name + '.' + IntToStr(j);
                      GrabaReg(Lang,Rewrite);
                    end
                else if C is TMemo then
                  for j := 0 to TMemo(C).Lines.Count - 1 do
                    begin
                      s := TMemo(C).Lines[j];
                      sObj := C.Name + '.' + IntToStr(j);
                      GrabaReg(Lang,Rewrite);
                    end;
              end;
            {Property Items}
            if IfProperty(C, 'Items') then
              begin
                if (C is TListBox) or (C is TComboBox) or (C is TDBListBox) or (C is TDBComboBox) then
                 {for j := 0 to TListBox(C).Items.Count-1 do
                    begin
                      s := TListBox(C).Items[j];
                      sObj := C.Name + '.' + IntToStr(j);
                      GrabaReg(Lang,Rewrite);
                    end}
                else if (C is TRadioGroup) then
                  for j := 0 to TRadioGroup(C).Items.Count-1 do
                    begin
                      s := TRadioGroup(C).Items[j];
                      sObj := C.Name + '.' + IntToStr(j);
                      GrabaReg(Lang,Rewrite);
                    end;
              end;
            {Property Pages}
            if IfProperty(C, 'Pages') then
              begin
                if (C is TNotebook) then
                  for j := 0 to TNotebook(C).Pages.Count-1 do
                    begin
                      s := TNotebook(C).Pages[j];
                      sObj := C.Name + '.' + IntToStr(j);
                      GrabaReg(Lang,Rewrite);
                    end
                else if (C is TTabbedNotebook)then
                  for j := 0 to TTabbedNotebook(C).Pages.Count-1 do
                    begin
                      s := TTabbedNotebook(C).Pages[j];
                      sObj := C.Name + '.' + IntToStr(j);
                      GrabaReg(Lang,Rewrite);
                    end;
              end;
            {Property Tabs}
            if IfProperty(C, 'Tabs') then
              begin
                if C is TTabset then
                  for j := 0 to TTabset(C).Tabs.Count-1 do
                    begin
                      s := TTabset(C).Tabs[j];
                      sObj := C.Name + '.' + IntToStr(j);
                      GrabaReg(Lang,Rewrite);
                    end;
              end;
            {Property Filter}
           {if IfProperty(C, 'Filter') then
             begin
               s := GetComponentProp(C,'Filter');
               if (Blancos) or (Length(s) > 0) then
                 begin
                   sObj := C.Name + '.Filter';
                   GrabaReg(Lang,ReWrite);
                 end;
             end;}
            {Property CustomColors of TColorDialog}
           {if IfProperty(C, 'CustomColors') then
             begin
               for j := 0 to TColorDialog(C).CustomColors.Count-1 do
                 s := TColorDialog(C).CustomColors[j];
               sObj := C.Name + '.' + IntToStr(j);
               GrabaReg(Lang,ReWrite);
             end;}
          end; {for i := 0 to Form.ComponentCount - 1}
      end; { with Form }
    finally
      FTable.Close;
    end; {try}
end;

function TTbMultiLanguage.GetReadNow : boolean;
begin
  GetReadNow := False;
end;

procedure TTbMultiLanguage.SetReadNow(Now : Boolean);
var
  Lang : string;
begin
  if not Now then
    Exit;
  IfExistsTable;
  if FLanguage = 'SP' then
    Lang := 'Spanish'
  else
    Lang := 'English';
  if MessageDlg('Do you want to read now? ('+Lang+')',mtConfirmation,[mbOk,mbCancel],0)=mrOk then
    begin
      DbfStringComponent(FForm,True,True);
    end;
end;

{******************************************************************************}
{* Property Editors Code                                                       *}
{******************************************************************************}

procedure TFilenameProperty.Edit;
var
  FileOpen: TOpenDialog;
begin
  FileOpen := TOpenDialog.Create(Nil);
  FileOpen.Filename := GetValue;
  FileOpen.Filter := 'dBase Files (*.DBF)|*.DBF|All Files (*.*)|*.*';
  FileOpen.Options := FileOpen.Options + [ofPathMustExist];
  try
    if FileOpen.Execute then SetValue(FileOpen.Filename);
  finally
    FileOpen.Free;
  end;
end;

function TFilenameProperty.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

end.
