unit TaskIcon;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls, Forms, Dialogs,ShellAPI;

const
  WM_TASKICON = WM_USER+10; {Change this if used by something else!}

type
  String64 = String[64];
  TStateTaskIcon = (tiEnabled, tiDisabled, tiAnimated);
  TWhereTaskIcon = (tiInFiles, tiInExe);
  TTaskIcon = class(TWinControl)
  private
    {Field variables}
    tnid: TNOTIFYICONDATA;
    fActive: boolean;
    fIcon: TIcon;
    fDisabledIcon: TIcon;
    fAniIcon: TIcon;
    fVisible: boolean;
    fHint: string64;
    fShowHint: boolean;
    fTaskIconID: UINT;
    fState: TStateTaskIcon;
    fIconList: TStrings;
    fInterval: UINT;
    fWhereIcons: TWhereTaskIcon;
    fOnClick: TNotifyEvent;
    fOnDblClick: TNotifyEvent;
    fOnRightClick: TMouseEvent;
    fOnAnimate: TNotifyEvent;
    fIconNum: integer;
    fTimerID: UINT;
    p: PChar;
    function MakeIcon(Sender: TObject) : boolean;
    function KillIcon(Sender: TObject) : boolean;
    function ChangeIcon(Sender: TObject) : boolean;
    procedure SetActive(Value: boolean);
    procedure SetIcon(Value: TIcon);
    procedure SetDisabledIcon(Value: TIcon);
    procedure SetHint(Value: String64);
    procedure SetShowHint(Value: boolean);
    procedure SetTaskIconID(Value: UINT);
    procedure SetState(Value: TStateTaskIcon);
    procedure SetIconList(Value: TStrings);
    procedure SetInterval(Value: UINT);
    procedure WMTASKICON(var msg: TMessage); message WM_TASKICON;
    procedure WMTIMER(var msg: TMessage); message WM_TIMER;
    procedure LoadTaskIcon;
  protected
  public
    constructor Create(aOwner: TComponent); override;
    destructor Destroy; override;
  published
    property Active: boolean read fActive write SetActive;
    property Icon: TIcon read fIcon write SetIcon;
    property DisabledIcon: TIcon read fDisabledIcon write SetDisabledIcon;
    property Hint: string64 read fHint write SetHint;
    property ShowHint: boolean read fShowHint write SetShowHint;
    property TaskIconID: UINT read fTaskIconID write SetTaskIconID;
    property State: TStateTaskIcon read fState write SetState;
    property IconList: TStrings read fIconList write SetIconList;
    property Interval: UINT read fInterval write SetInterval;
    property WhereIcons: TWhereTaskIcon read fWhereIcons write fWhereIcons;
    property OnClick: TNotifyEvent read fOnClick write fOnClick;
    property OnDblClick: TNotifyEvent read fOnDblClick write fOnDblClick;
    property OnRightClick: TMouseEvent  read fOnRightClick write fOnRightClick;
    property OnAnimate: TNotifyEvent  read fOnAnimate write fOnAnimate;
  end;

procedure Register;

implementation

procedure TTaskIcon.SetActive(Value: boolean);
begin
  if value<>fActive then
    begin
      if Value then
        begin
          if MakeIcon(self) then fActive:=true
        end
      else
        begin
          if KillIcon(self) then fActive:=false;
        end;
    end;
end;

procedure TTaskIcon.SetIcon(Value: TIcon);
begin
  if Value<>fIcon then
    begin
      fIcon.Assign(value);
      if fActive then ChangeIcon(Self);
    end;
end;

procedure TTaskIcon.SetDisabledIcon(Value: TIcon);
begin
  if Value<>fDisabledIcon then
    begin
      fDisabledIcon.Assign(value);
      if fActive then ChangeIcon(Self);
    end;
end;

procedure TTaskIcon.SetTaskIconID(Value: UINT);
begin
  if Value<>fTaskIconID then
    begin
      fTaskIconID:=value;
      if fActive then ChangeIcon(Self);
    end;
end;

procedure TTaskIcon.SetHint(Value: string64);
begin
  if Value<>fHint then
    begin
      fHint:=value;
      if fActive then ChangeIcon(Self);
    end;
end;

procedure TTaskIcon.SetShowHint(Value: boolean);
begin
  if Value<>fShowHint then
    begin
      fShowHint:=value;
      if fActive then ChangeIcon(Self);
    end;
end;

constructor TTaskIcon.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  FIcon:=TIcon.Create;
  FDisabledIcon:=TIcon.Create;
  FAniIcon:=TIcon.Create;
  fIconList:=TStringList.Create;
  fInterval:=1000;
  fTimerID:=147;
  GetMem(p,50);
end;

destructor TTaskIcon.Destroy;
begin
  if fActive then SetActive(False);
  FreeMem(p,50);
  fIcon.Free;
  fDisabledIcon.Free;
  fAniIcon.Free;
  fIconList.Destroy;
  inherited Destroy;
end;

function TTaskIcon.MakeIcon(Sender: TObject): boolean;
begin
  fIconNum:=0;
  LoadTaskIcon;
  if fState=tiAnimated then SetTimer(Handle,fTimerID,fInterval,nil);
  with tnid do
    begin
      cbSize:=sizeof(TNOTIFYICONDATA);
      wnd:=Handle;
      uID:=fTaskIconID;
      uFlags:=NIF_MESSAGE+NIF_ICON+NIF_TIP;
      case fState of
        tiEnabled : hIcon:=fIcon.Handle;
        tiDisabled: hIcon:=fDisabledIcon.Handle;
        tiAnimated: hIcon:=fAniIcon.Handle;
      end;
      if fShowHint then StrPCopy(szTip,fHint) else StrPCopy(szTip,'');
      uCallbackMessage:=WM_TASKICON;
      result:=Shell_NotifyIcon(NIM_ADD,@tnid);
    end;
end;

function TTaskIcon.KillIcon(Sender: Tobject): boolean;
begin
{  try
    if fState=tiAnimated then KillTimer(Handle,fTimerID);
  except on EInvalidOperation do ;
  end; }
  result:=Shell_NotifyIcon(NIM_DELETE,@tnid);
end;

function TTaskIcon.ChangeIcon(Sender: TObject): boolean;
var tnid: TNOTIFYICONDATA;
begin
  with tnid do
    begin
      cbSize:=sizeof(TNOTIFYICONDATA);
      wnd:=Handle;
      uID:=fTaskIconID;
      uFlags:=NIF_MESSAGE+NIF_ICON+NIF_TIP;
      case fState of
        tiEnabled : hIcon:=fIcon.Handle;
        tiDisabled: hIcon:=fDisabledIcon.Handle;
        tiAnimated: hIcon:=fAniIcon.Handle;
      end;
      if fShowHint then StrPCopy(szTip,fHint) else StrPCopy(szTip,'');
      uCallbackMessage:=WM_TASKICON;
      result:=Shell_NotifyIcon(NIM_MODIFY,@tnid);
    end;
end;

procedure TTaskIcon.SetState(Value: TStateTaskIcon);
begin
  if Value<>fState then
    begin
      fState:=Value;
      if fState=tiAnimated then
        begin
          fIconNum:=0;
          LoadTaskIcon;
          if fActive then SetTimer(Handle,fTimerID,fInterval,nil);
        end
      else if fActive then KillTimer(Handle,fTimerID);
      if fActive then ChangeIcon(Self);
    end;
end;

procedure TTaskIcon.SetIconList(Value: TStrings);
begin
  fIconList.Assign(Value);
end;

procedure TTaskIcon.SetInterval(Value: UINT);
begin
  if Value<>fInterval then
    begin
      fInterval:=value;
      if fActive then
        begin
          KillTimer(Handle,fTimerID);
          SetTimer(Handle,fTimerID,fInterval,nil);
          fIconNum:=0;
          LoadTaskIcon;
        end;
    end;
end;

procedure TTaskIcon.WMTASKICON(var msg: TMessage);
var MouseCo: Tpoint;
begin
  if msg.wParam=fTaskIconID then
    case msg.lParam of
      WM_LBUTTONDBLCLK : if assigned(fOnDblClick) then fOnDblClick(self);
      WM_LBUTTONUP     : if assigned(fOnClick)then fOnClick(self);
      WM_RBUTTONUP     : if assigned(fOnRightClick)then
                           begin
                             GetCursorPos(MouseCo);
                             fOnRightClick(self,mbRight,[],MouseCo.x,MouseCo.y);
                           end;
    end;
end;

procedure TTaskIcon.WMTIMER(var msg: TMessage);
begin
  if (msg.wParam=fTimerID) and (fIconList.Count>0) then
    begin
      inc(fIconNum);
      if fIconNum>=fIconList.Count then fIconNum:=0;
      LoadTaskIcon;
      if fActive=true then ChangeIcon(Self);
      if (State=tiAnimated) and assigned(fOnAnimate) and fActive then fOnAnimate(self);
    end;
end;

procedure TTaskIcon.LoadTaskIcon;
begin
  if fIconList.Count>0 then
    begin
      StrPCopy(p,UpperCase(fIconList.Strings[fIconNum]));
      if WhereIcons=tiInFiles then
        fAniIcon.LoadFromFile(UpperCase(fIconList.Strings[fIconNum]))
      else fAniIcon.Handle:=LoadIcon(hInstance,p);
    end;
end;

procedure Register;
begin
  RegisterComponents('Samples',[TTaskIcon]);
end;

end.
