////////////////////////////////////////////////////////////////////////////////
// TABCONTROL98                                                               //
////////////////////////////////////////////////////////////////////////////////
// Enhanced TabControl for D2 & D3                                            //
// * Image List, Right & Left Tabs, ...                                       //
////////////////////////////////////////////////////////////////////////////////
// Version 1.80 Beta                                                          //
// Date de cration           : 08/07/1997                                    //
// Date dernire modification : 22/09/1997                                    //
////////////////////////////////////////////////////////////////////////////////
// Jean-Luc Mattei                                                            //
// jlucm@club-internet.fr  / jlucm@mygale.org                                 //
////////////////////////////////////////////////////////////////////////////////
//  REVISIONS :                                                               //
//                                                                            //
//  1.10 : * Added CNMeasureItem                                              //
//         * Added image drawing in default drawing                           //
//  1.11 : * CommCtrlEx Modified for D2 (thanks to Gerhard Volk)              //
//         * TDrawTabCtrlEvent, TMeasureTabCtrlEvent Page parameter changed   //
//           from TTabControl to TTabControl98 (thanks to Marcus Monnig)      //
//  1.20 : * CustomTabControl98 allows hiddenproperties                       //
//         * Some properties modified                                         //
//         * Justification only works with fixed width                        //
//         * Multiline and Buttons looks bad when set (but ok after)          //
//         * DrawTab Procedure modified                                       //
//  1.60 : * Removed unused properties                                        //
//         * Some declaration modified for D2 compatibility                   //
//           (thanks to Gerhard Volk - again - for all the tests :-))         //
//         * Unified version number                                           //
//  1.70 : * Color Property added and OnGetColor Event added                  //
//           (Changes made by Tomas Tejon)                                    //
//         * Added Multiple Default Drawing                                   //
//           ddMode1 : Default                                                //
//           ddMode2 : Written by Tomas Tejon                                 //
//           ddMode3 : Written by Roger Misteli                               //
//  1.80 : * Tab Hint                                                         //
//         * Font can be choosen for each tab                                 //
////////////////////////////////////////////////////////////////////////////////

unit TabControl98;

// Remove this line if you got a Duplicate ressource error

interface

{$R *.DCR}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Forms, Controls, Dialogs,
  CommCtrl, ComCtrls {$ifdef VER100}, ComCtl98 {$else}, CommCtrlEx {$endif};

type
  TTabPosition = (tpTop, tpBottom, tpLeft, tpRight);
  TTabType = (ttDefault, ttOpposite);
  TTabStyle = (tsDefault, tsButtons, tsIE4FlatButtons);
  TTabJustification = (tjLeftText, tjCenterText, tjRightText);
  TTabDrawStyle = (tdDefault, tdOwnerDrawFixed);
  TDefaultDrawingType = (ddNone, ddMode1, ddMode2, ddMode3);

  TCustomTabControl98 = class;

  TDrawTabEvent = procedure(Page: TCustomTabControl98; Tab: Integer;
                            const Rect: TRect) of object;
  TMeasureTabEvent = procedure(Page: TCustomTabControl98; Tab: Integer;
                            Var Height, Width: Integer) of object;
  TGetTabColorEvent= procedure(Page:TCustomTabControl98; Tab:Integer;
                            Var TabColor, FontColor: TColor) of object;

  TCustomTabControl98 = class(TCustomTabControl)
  private
    FImages: TImageList;
    FImageChangeLink: TChangeLink;
    FTabPosition: TTabPosition;
    FTabStyle: TTabStyle;
    FTabJustification: TTabJustification;
    {$ifndef VER100}
    FHotTrack: Boolean;
    FTabType: TTabType;
    {$endif}
    FMultiSelect: Boolean;
    FDrawStyle: TTabDrawStyle;
    FCanvas: TCanvas;
    FOnDrawTab: TDrawTabEvent;
    FOnMeasureTab: TMeasureTabEvent;
    FOnGetTabColor: TGetTabColorEvent;
    FDefaultDrawing: TDefaultDrawingType;
    FColor: TColor;
    procedure ImageListChange (Sender: TObject);
    procedure SetImages (Value: TImageList);
    procedure SetImage (Index: Integer; imIndex: Integer);
    function GetImage (Index: Integer): Integer;
    {$ifndef VER100}
    procedure SetTabType (Value: TTabType);
    procedure SetHotTrack (Value: Boolean);
    {$endif}
    procedure SetTabStyle (Value: TTabStyle);
    procedure SetTabJustification (Value: TTabJustification);
    procedure SetDrawStyle (Value: TTabDrawStyle);
    procedure SetMultiSelect (Value: Boolean);
    procedure SetColor(Value: TColor);
    procedure SetDefaultDrawing(Value: TDefaultDrawingType);
    procedure CNDrawItem(var Message: TWMDrawItem); message CN_DRAWITEM;
    procedure CNMeasureItem(var Message: TWMMeasureItem); message CN_MEASUREITEM;
    procedure CNNotify(var Message: TWMNotify); message CN_NOTIFY;
    procedure WMNotify(var Message: TWMNotify); message WM_NOTIFY;
  protected
    procedure SetTabPosition (Value: TTabPosition); virtual;
    procedure CreateParams(var Params: TCreateParams); override;
    procedure DrawTab(TabNdx: Integer; const Rect: TRect); dynamic;
    procedure AssociateImages; dynamic;
  public
    constructor Create (AOwner: TComponent); override;
    destructor Destroy; override;

    property Image[Index: Integer]: Integer read GetImage write SetImage; default;
    property Canvas: TCanvas read FCanvas;
    property Color: TColor read FColor write SetColor default clBtnFace;

    property DefaultDrawing: TDefaultDrawingType read FDefaultDrawing write SetDefaultDrawing default ddMode1;
    property DrawStyle: TTabDrawStyle read FDrawStyle write SetDrawStyle;
    property Images: TImageList read FImages write SetImages;
    property MultiSelect: Boolean read FMultiSelect write SetMultiSelect;
    property TabPosition: TTabPosition read FTabPosition write SetTabPosition;
    {$ifndef VER100}
    property TabType: TTabType read FTabType write SetTabType;
    property HotTrack: Boolean read FHotTrack write SetHotTrack;
    {$endif}
    property TabStyle: TTabStyle read FTabStyle write SetTabStyle;
    property TabJustification: TTabJustification read FTabJustification write SetTabJustification;
    property OnDrawTab: TDrawTabEvent read FOnDrawTab write FOnDrawTab;
    property OnMeasureTab: TMeasureTabEvent read FOnMeasureTab write FOnMeasureTab;
    property OnGetTabColor: TGetTabColorEvent read FOnGetTabColor write FOnGetTabColor;
  end;

  TTabControl98 = class(TCustomTabControl98)
  public
    property DisplayRect;
  published
    property Color;
    property DefaultDrawing;
    property DrawStyle;
    property Images;
    property MultiSelect;
    property TabPosition;
    {$ifndef VER100}
    property TabType;
    {$endif}
    property HotTrack;
    property TabStyle;
    property TabJustification;
    property OnDrawTab;
    property OnMeasureTab;
    property OnGetTabColor;

    property Align;
    property DragCursor;
    property DragMode;
    property Enabled;
    property Font;
    property MultiLine;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    {$ifdef VER100}
    property ScrollOpposite;
    {$endif}
    property ShowHint;
    property TabHeight;
    property TabIndex;
    property TabOrder;
    //property TabPosition;
    property Tabs;
    property TabStop;
    property TabWidth;
    property Visible;
    property OnChange;
    property OnChanging;
    property OnDragDrop;
    property OnDragOver;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDrag;
  end;

procedure Register;

implementation

Uses PageControl98;

procedure Register;
begin
  RegisterComponents('Exemples', [TTabControl98]);
end;


procedure TCustomTabControl98.DrawTab(TabNdx: Integer; const Rect: TRect);
Var LogRec: TLOGFONT;
    OldFont,
    NewFont: HFONT;
    R : TRect;

  procedure DrawingMode1;
  begin
    //FCanvas.FillRect(Rect);
    if ( TabPosition in [tpLeft, tpRight] ) then begin
      GetObject(Canvas.Font.Handle, SizeOf(LogRec), @LogRec);
      if ( TabPosition = tpLeft ) then
        LogRec.lfEscapement := 900
      else
        LogRec.lfEscapement := -900;
      LogRec.lfOutPrecision := OUT_TT_ONLY_PRECIS;
      NewFont:= CreateFontIndirect(LogRec);
      OldFont:= SelectObject(FCanvas.Handle,NewFont);
      if ( TabIndex = TabNdx ) then
        InflateRect(R, 0, -4);
      if ( TabPosition = tpLeft ) then begin
        if ( Images <> nil ) and ( Image[TabNdx] >= 0 ) then begin
          Images.Draw(FCanvas, R.Left+2, R.Bottom - Images.Height - 2, Image[TabNdx]);
          R.Bottom:= R.Bottom - 4 - Images.Width;
        end;
        FCanvas.TextOut(Rect.Left + 1 + (Rect.Right - Rect.Left - FCanvas.TextHeight(Tabs[TabNdx])) Div 2,
                        Rect.Bottom - 1 - (Rect.Bottom - Rect.Top - FCanvas.TextWidth(Tabs[TabNdx])) Div 2, Tabs[TabNdx]);
      end;
      if ( TabPosition = tpRight ) then begin
        if ( Images <> nil ) and ( Image[TabNdx] >= 0 ) then begin
          Images.Draw(FCanvas, R.Right - 2 - Images.Width, R.Top + 2, Image[TabNdx]);
          R.Top:= R.Top + 4 + Images.Width;
        end;
        FCanvas.TextOut(Rect.Right - (Rect.Right - 1 - Rect.Left - FCanvas.TextHeight(Tabs[TabNdx])) Div 2,
                        Rect.Top + 1 + (Rect.Bottom - Rect.Top - FCanvas.TextWidth(Tabs[TabNdx])) Div 2, Tabs[TabNdx]);
      end;
      NewFont:= SelectObject(FCanvas.Handle,OldFont);
      DeleteObject(NewFont);
    end
    else begin
      if ( TabIndex = TabNdx ) then
        InflateRect(R, -4, 0);
      if ( TabPosition in [tpBottom] ) then begin
        if ( Images <> nil ) and ( Image[TabNdx] >= 0 ) then begin
          Images.Draw(FCanvas, R.Left + 4, R.Bottom - Images.Height - 2, Image[TabNdx]);
          R.Left:= R.Left + 4 + Images.Width;
        end;
        FCanvas.TextOut(R.Left + (R.Right - R.Left - FCanvas.TextWidth(Tabs[TabNdx])) Div 2,
                      R.Bottom - 3 - FCanvas.TextHeight(Tabs[TabNdx]), Tabs[TabNdx]);
      end
      else begin
        if ( Images <> nil ) and ( Image[TabNdx] >= 0 ) then begin
          Images.Draw(FCanvas, R.Left + 2, R.Top + 2, Image[TabNdx]);
          R.Left:= R.Left + 4 + Images.Width;
          R.Bottom:= R.Top + Images.Height;
        end;
        FCanvas.TextOut(R.Left + (R.Right - R.Left - FCanvas.TextWidth(Tabs[TabNdx])) Div 2,
                      R.Top + 2 + (R.Bottom - R.Top - FCanvas.TextHeight(Tabs[TabNdx])) Div 2, Tabs[TabNdx]);
      end;
    end;
  end;

  // Written by Tomas Tejon
  procedure DrawingMode2;
  begin
    //FCanvas.FillRect(Rect);
    if Assigned(Images) and (Image[TabNdx]>=0)
       THEN Case TabPosition OF
                 tpLeft:BEGIN
                             Images.Draw(FCanvas,(R.Right+R.Left-Images.Width) DIV 2,R.Bottom-Images.Height-2,Image[TabNdx]);
                             R.Bottom:=R.Bottom-4-Images.Height
                        END;
                 tpRight:BEGIN
                              Images.Draw(FCanvas,(R.Right+R.Left-Images.Width) DIV 2,R.Top+2,Image[TabNdx]);
                              R.Top:=R.Top+4+Images.Height
                         END;
                 tpTop,
                 tpBottom:BEGIN
                               Images.Draw(FCanvas,R.Left+2,(R.Bottom+R.Top-Images.Height) DIV 2,Image[TabNdx]);
                               R.Left:=R.Left+4+Images.Width
                          END;
            end;
    Case TabPosition OF
         tpLeft,
         tpRight:BEGIN
                      GetObject(Canvas.Font.Handle, SizeOf(LogRec), @LogRec);
                      if (TabPosition=tpLeft)
                         then LogRec.lfEscapement := 900
                         else LogRec.lfEscapement := -900;
                      LogRec.lfOutPrecision := OUT_TT_ONLY_PRECIS;
                      NewFont:= CreateFontIndirect(LogRec);
                      OldFont:= SelectObject(FCanvas.Handle,NewFont);
                      IF TabPosition=tpLeft
                         THEN FCanvas.TextOut((R.Right+R.Left-FCanvas.TextHeight(Tabs[TabNdx])) Div 2,
                                              (R.Bottom+R.Top+FCanvas.TextWidth(Tabs[TabNdx])) Div 2,Tabs[TabNdx])
                         ELSE FCanvas.TextOut((R.Right+R.Left+FCanvas.TextHeight(Tabs[TabNdx])) Div 2,
                                              (R.Bottom+R.Top-FCanvas.TextWidth(Tabs[TabNdx])) Div 2,Tabs[TabNdx]);
                      NewFont:= SelectObject(FCanvas.Handle,OldFont);
                      DeleteObject(NewFont);
                 END;
         tpBottom:FCanvas.TextOut((R.Right+R.Left-FCanvas.TextWidth(Tabs[TabNdx])) Div 2,
                                  (R.Bottom+R.Top-FCanvas.TextHeight(Tabs[TabNdx])) Div 2,Tabs[TabNdx]);
         tpTop:FCanvas.TextOut((R.Right+R.Left-FCanvas.TextWidth(Tabs[TabNdx])) Div 2,
                               (R.Bottom+R.Top-FCanvas.TextHeight(Tabs[TabNdx])) Div 2, Tabs[TabNdx])
    END
  end;

  // Written by Roger Misteli
  procedure DrawTextEx(TabNdx: Integer; Canvas: TCanvas; X, Y: Integer; sCaption: String);
  var       i: Integer;
  begin
    i:=GetBkMode(Canvas.Handle);
    SetBkMode(Canvas.Handle, TRANSPARENT);
    if ( Self is TCustomPageControl98 ) then begin
      with Self As TCustomPageControl98 do begin
        if Pages[TabNdx].Enabled then
          Canvas.TextOut(X, Y, sCaption)
        else begin
          Canvas.Font.Color:=clBtnHighlight;
          Windows.TextOut(Canvas.Handle, Succ(X), Succ(Y), PChar(sCaption), Length(sCaption));
          Canvas.Font.Color:=clBtnShadow;
          Windows.TextOut(Canvas.Handle, X, Y, PChar(sCaption), Length(sCaption));
        end;
      end;
    end
    else
      Canvas.TextOut(X, Y, sCaption);
    SetBkMode(Canvas.Handle, i);
  end;

  // Written by Roger Misteli
  procedure DrawingMode3;
  begin
    //FCanvas.FillRect(Rect);
    if ( TabPosition in [tpLeft, tpRight] ) then begin
      GetObject(Canvas.Font.Handle, SizeOf(LogRec), @LogRec);
      if ( TabPosition = tpLeft ) then
        LogRec.lfEscapement := 900
      else
        LogRec.lfEscapement := -900;
      LogRec.lfOutPrecision := OUT_TT_ONLY_PRECIS;
      NewFont:= CreateFontIndirect(LogRec);
      OldFont:= SelectObject(FCanvas.Handle,NewFont);
    end;
    if ( TabPosition in [tpLeft, tpRight] ) then begin
      DrawTextEx(TabNdx, FCanvas, Rect.Left + (Rect.Right - Rect.Left - FCanvas.TextHeight(Tabs[TabNdx])) Div 2,
                      Rect.Top + 1 + (Rect.Bottom - Rect.Top - FCanvas.TextWidth(Tabs[TabNdx])) Div 2, Tabs[TabNdx]);
      NewFont:= SelectObject(FCanvas.Handle,OldFont);
      DeleteObject(NewFont);
    end
    else
      DrawTextEx(TabNdx, FCanvas, Rect.Left + (Rect.Right - Rect.Left - FCanvas.TextWidth(Tabs[TabNdx])) Div 2,
                      Rect.Top + 1 + (Rect.Bottom - Rect.Top - FCanvas.TextHeight(Tabs[TabNdx])) Div 2, Tabs[TabNdx]);
  end;

begin
  R:= Rect;
  if ( TabNdx <> TabIndex ) then begin
    case TabPosition of
      tpLeft   : R.Right:= R.Right + 2;
      tpTop    : R.Bottom:= R.Bottom + 2;
      tpRight  : R.Left:= R.Left - 2;
      tpBottom : R.Top:= R.Top - 2;
    end;
    FCanvas.FillRect(R);
    R:= Rect;
  end
  else
    FCanvas.FillRect(Rect);
  with FCanvas do begin
    //FCanvas.FillRect(Rect);
    case DefaultDrawing of
      ddMode1 : DrawingMode1;
      ddMode2 : DrawingMode2;
      ddMode3 : DrawingMode3;
      ddNone  : ;
    end;
  end;
  if Assigned(FOnDrawTab) then
    FOnDrawTab(Self, TabNdx, Rect);
end;

procedure TCustomTabControl98.CNDrawItem(var Message: TWMDrawItem);
var
  SaveIndex: Integer;
  TabColor, FontColor: TColor;
begin
  with Message.DrawItemStruct^ do
  begin
    TabColor:=Color;
    FontColor:=Font.Color;
    if Assigned(fOnGetTabColor) then
      fOnGetTabColor(Self, itemID, TabColor, FontColor);
    SaveIndex := SaveDC(hDC);
    FCanvas.Handle := hDC;
    //FCanvas.Font := Font;
    //FCanvas.Brush.Color:= clBtnFace;
    FCanvas.Font.Color:=FontColor;
    if ( Self is TCustomPageControl98 ) then begin
      with ( Self as TCustomPageControl98 ) do begin
        FCanvas.Brush:= Pages[itemID].Brush;
        FCanvas.Font:= Pages[itemID].TabFont;
      end;
    end
    else
      FCanvas.Brush.Color:= TabColor;
    FCanvas.Brush.Style := bsSolid;
    DrawTab(itemID, rcItem);
    FCanvas.Handle := 0;
    RestoreDC(hDC, SaveIndex);
  end;
  Message.Result := 1;
end;

procedure TCustomTabControl98.CNMeasureItem(var Message: TWMMeasureItem);
var
  SaveIndex, Tmp: Integer;
begin
  with Message.MeasureItemStruct^ do
  begin
    FCanvas.Handle:= GetDC(Handle);
    //FCanvas.Handle := hDC;
    FCanvas.Font := Font;
    if Assigned ( FOnMeasureTab ) then begin
      FOnMeasureTab(Self, itemID, Integer(itemHeight), Integer(itemWidth));
    end
    else begin
      if ( TabPosition in [tpBottom] ) then
        itemWidth:= FCanvas.TextWidth(Tabs[itemId]) + 20
      else
        itemWidth:= FCanvas.TextWidth(Tabs[itemId]);
      itemHeight:= FCanvas.TextHeight(Tabs[itemId]);
      if ( FImages <> nil ) and ( Image[itemId] >= 0 ) then begin
        Tmp:= FImages.Height + 4;
        if Tmp > ItemHeight then
          itemHeight:= Tmp;
        itemWidth:=ItemWidth+FImages.Height+4;
        //itemHeight:= FImages.Height + 4;
        //itemWidth:= itemWidth + FImages.Height + 4;
      end
    end;
    ReleaseDC(Handle, FCanvas.Handle);
    FCanvas.Handle:= 0;
  end;
  Message.Result := 1;
end;

procedure TCustomTabControl98.WMNotify(var Message: TWMNotify);
var
  HitIndex: Integer;
  HitTestInfo: TTCHitTestInfo;
begin
  with Message.NMHdr^ do
    case code of
      TTN_NEEDTEXT:
        with Message do begin
          if ( Self is TCustomPageControl98 ) then
            Exit;
          Windows.GetCursorPos(HitTestInfo.pt);
          HitTestInfo.pt:= ScreenToClient(HitTestInfo.pt);
          HitIndex:= SendMessage(Handle, TCM_HITTEST, 0, Longint(@HitTestInfo));
          if (HitIndex <> -1) then
            //strPCopy(PToolTipText(NMHdr)^.lpszText,Pages[HitIndex].Hint)
            strPCopy(PToolTipText(NMHdr)^.lpszText,Hint)
          else
            strPCopy(PToolTipText(NMHdr)^.lpszText,Hint);
          PToolTipText(NMHdr)^.hInst := 0;
          SetWindowPos(NMHdr^.hwndFrom, HWND_TOP, 0, 0, 0, 0, SWP_NOACTIVATE or
          SWP_NOSIZE or SWP_NOMOVE);
          Result := 1;
        end;
      NM_HOVER :
        begin
          MessageBeep(MB_Ok);
        end;
    end;
end;

procedure TCustomTabControl98.CNNotify(var Message: TWMNotify);
Var
  Pt: TPoint;
begin
  with Message.NMHdr^ do
    case code of
      TCN_SELCHANGE:
        Change;
      TCN_SELCHANGING:
        begin
          Message.Result := 1;
          if CanChange then Message.Result := 0;
        end;
      NM_HOVER :
        begin
          MessageBeep(MB_Ok);
        end;
    end;
end;

procedure TCustomTabControl98.SetMultiSelect (Value: Boolean);
begin
  if ( FMultiSelect <> Value ) then begin
    FMultiSelect:= Value;
    RecreateWnd;
    Images:= FImages;
    Invalidate;
  end;
end;

procedure TCustomTabControl98.SetColor(Value: TColor);
begin
  if FCOlor <> Value then begin
    FColor:= Value;
    RecreateWnd
  end;
end;

procedure TCustomTabControl98.SetTabPosition (Value: TTabPosition);
begin
  if ( FTabPosition <> Value ) then begin
    if ( FTabStyle = tsIE4FlatButtons ) and ( Value <> tpTop ) then Exit;
    if ( FTabStyle = tsButtons ) and ( Value = tpBottom ) then Exit;
    FTabPosition:= Value;
    RecreateWnd;
    Images:= FImages;
    Invalidate;
  end;
end;

{$ifndef VER100}
procedure TCustomTabControl98.SetTabType (Value: TTabType);
begin
  if ( FTabType <> Value ) then begin
    FTabType:= Value;
    RecreateWnd;
    Images:= FImages;
    Invalidate;
  end;
end;
{$endif}

procedure TCustomTabControl98.SetTabStyle (Value: TTabStyle);
begin
  if ( FTabStyle <> Value ) then begin
    if ( Value = tsIE4FlatButtons ) and ( TabPosition <> tpTop ) then Exit;
    if ( Value = tsButtons ) and ( TabPosition = tpBottom ) then Exit;
    FTabStyle:= Value;
    RecreateWnd;
    Images:= FImages;
    Invalidate;
  end;
end;

procedure TCustomTabControl98.SetTabJustification (Value: TTabJustification);
begin
  if ( FTabJustification <> Value ) then begin
    FTabJustification:= Value;
    RecreateWnd;
    Images:= FImages;
    Invalidate;
  end;
end;

{$ifndef VER100}
procedure TCustomTabControl98.SetHotTrack (Value: Boolean);
begin
  if ( FHotTrack <> Value ) then begin
    FHotTrack:= Value;
    RecreateWnd;
    Images:= FImages;
    Invalidate;
  end;
end;
{$endif}

procedure TCustomTabControl98.SetDrawStyle (Value: TTabDrawStyle);
begin
  if ( FDrawStyle <> Value ) then begin
    FDrawStyle:= Value;
    RecreateWnd;
    Images:= FImages;
    Invalidate;
  end;
end;

procedure TCustomTabControl98.CreateParams(var Params: TCreateParams);
begin
  {$ifdef VER100}
  InitCommonControl(ICC_TAB_CLASSES);
  {$else}
  InitTabCommonControlEx;
  {$endif}
  inherited CreateParams(Params);
  with Params do begin
    Style:= Style or TCS_TOOLTIPS;
    if ( FMultiSelect ) then
      Style:= Style or TCS_MULTISELECT
    else
      Style:= Style and Not( TCS_MULTISELECT );
    if ( FDrawStyle = tdOwnerDrawFixed ) then
      Style:= Style or TCS_OWNERDRAWFIXED
    else
      Style:= Style and Not( TCS_OWNERDRAWFIXED );
    {$ifndef VER100}
    if ( FHotTrack ) then
      Style:= Style or TCS_HOTTRACK
    else
      Style:= Style and Not( TCS_HOTTRACK );
    {$endif}
    case FTabStyle of
      tsDefault: Style:= Style and ( Not(TCS_BUTTONS) or Not(TCS_FLATBUTTONS) );
      tsButtons: Style:= Style or TCS_BUTTONS and Not TCS_FLATBUTTONS;
      tsIE4FlatButtons: Style:= Style or TCS_BUTTONS or TCS_FLATBUTTONS;
    end;
    {$ifndef VER100}
    if ( FTabType = ttOpposite ) then
      Style:= Style or TCS_SCROLLOPPOSITE
    else
      Style:= Style and Not TCS_SCROLLOPPOSITE;
    {$endif}
    case FTabJustification of
      tjRightText   : Style:= Style and Not ( TCS_FORCELABELLEFT ) or TCS_RIGHTJUSTIFY or TCS_FORCEICONLEFT;
      tjLeftText    : Style:= Style or TCS_FORCELABELLEFT and Not ( TCS_RIGHTJUSTIFY );
      tjCenterText  : Style:= Style and Not ( TCS_FORCELABELLEFT or TCS_RIGHTJUSTIFY );
    end;
    //Style:= Style and Not( TCS_FORCEICONLEFT );
    case FTabPosition of
      tpTop    : Style:= Style and Not ( TCS_VERTICAL or TCS_RIGHT or TCS_BOTTOM );
      tpBottom : Style:= Style and Not ( TCS_VERTICAL or TCS_RIGHT) or TCS_BOTTOM;
      tpLeft   : Style:= Style and Not ( TCS_RIGHT or TCS_BOTTOM ) or TCS_VERTICAL or TCS_MULTILINE;
      tpRight  : Style:= Style and Not ( TCS_BOTTOM ) or TCS_RIGHT or TCS_VERTICAL or TCS_MULTILINE;
    end;
  end;
end;

constructor TCustomTabControl98.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  FDefaultDrawing:= ddMode1;
  FCanvas := TControlCanvas.Create;
  FColor:= clBtnFace;
  TControlCanvas(FCanvas).Control := Self;
  FImageChangeLink := TChangeLink.Create;
  FImageChangeLink.OnChange := ImageListChange;
end;

destructor TCustomTabControl98.Destroy;
begin
  FImageChangeLink.Free;
  FCanvas.Free;
  inherited Destroy;
end;

procedure TCustomTabControl98.ImageListChange(Sender: TObject);
begin
  if HandleAllocated then
    SendMessage(Handle, TCM_SETIMAGELIST, 0, Longint(TImageList(Sender).Handle));
end;

procedure TCustomTabControl98.SetImages (Value: TImageList);
begin
  if Assigned (FImages) then
    Images.UnRegisterChanges(FImageChangeLink);

  FImages := Value;

  if Assigned (FImages) then
    begin
      Images.RegisterChanges (FImageChangeLink);
      SendMessage(Handle, TCM_SETIMAGELIST, 0, Longint(Images.Handle));
    end
  else
    SendMessage(Handle, TCM_SETIMAGELIST, 0, Longint(0));
  if ( FImages <> nil ) then AssociateImages;
end;

procedure TCustomTabControl98.AssociateImages;
Var
  i: Integer;
begin
  for i:= 0 to Tabs.Count - 1 do begin
    if ( FImages.Count > i ) then
      SetImage( i, i );
  end;
end;

procedure TCustomTabControl98.SetImage (Index: Integer; imIndex: Integer);
var
  imItem: TTCItem;
begin
  imItem.iImage := imIndex;
  imItem.mask := TCIF_IMAGE;
  SendMessage (Handle, TCM_SETITEM, Index, Longint(@imItem));
  Invalidate;
end;

function TCustomTabControl98.GetImage (Index: Integer): Integer;
var
  imItem: TTCItem;
begin
  if Assigned (FImages) then
    begin
      imItem.mask := TCIF_IMAGE;
      SendMessage (Handle, TCM_GETITEM, Index, Longint(@imItem));
      Result := imItem.iImage;
    end
  else
    Result := -1
end;

procedure TCustomTabControl98.SetDefaultDrawing(Value: TDefaultDrawingType);
begin
  FDefaultDrawing:= Value;
  Invalidate;
end;

end.