unit Testing;

interface

{$DEFINE RUNTIME}
{$DEFINE NOLISTVIEW}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, SystemTreeView, ExtCtrls, FileChange, ComCtrls;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    tvRoot: TComboBox;
    Bevel1: TBevel;
    Label2: TLabel;
    Label3: TLabel;
    lvStyle: TComboBox;
    Label4: TLabel;
    edCustomRootDir: TEdit;
    Label5: TLabel;
    lbFilePath: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure tvRootChange(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormResize(Sender: TObject);
    procedure lvStyleChange(Sender: TObject);
    procedure MyTreeChange(Sender: TObject; Node: TTreeNode);
  private
    { Private declarations }
  public
{$IFDEF RUNTIME}
    MyTree: TSystemTreeView;
{$IFNDEF NOLISTVIEW}
    MyList: TSystemListView;
{$ENDIF}
{$ENDIF}
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses TypInfo;

procedure TForm1.FormCreate(Sender: TObject);
var
{$IFDEF RUNTIME}
  BevelBottom: integer;
{$ENDIF}
  x: TRootFolder;
  y: TViewStyle;
begin
{$IFDEF RUNTIME}
  BevelBottom := Panel1.Top + Panel1.Height;
  MyTree := TSystemTreeView.Create(Self);
  MyTree.ShowRoot := TRUE;
  MyTree.ShowFiles := TRUE;
  MyTree.Parent := Self;

  MyTree.Left := 20;
  MyTree.Top := BevelBottom + 20;
  MyTree.Width := (Width div 2) - 25;

{$IFNDEF NOLISTVIEW}
  MyList := TSystemListView.Create(Self);
  MyList.Parent := Self;
  MyList.Left := MyTree.Width + 30;
  MyList.Top := MyTree.Top;
{$ENDIF}  
  MyTree.CustomDir := 'c:\';
{$ENDIF}

  MyTree.HideSelection := FALSE;
{$IFNDEF NOLISTVIEW}
  MyTree.ListView := MyList;
  MyList.ViewStyle := vsSmallIcon;
{$ENDIF}  

  // Fill combo boxes
  for x := Low(TRootFolder) to High(TRootFolder) do
    tvRoot.Items.Add(GetEnumName(TypeInfo(TRootFolder), ord(x)));
  tvRoot.ItemIndex := 0;
  for y := Low(TViewStyle) to High(TViewStyle) do
    lvStyle.Items.Add(GetEnumName(TypeInfo(TViewStyle), ord(y)));
  lvStyle.ItemIndex := 1;

  edCustomRootDir.Text := MyTree.CustomDir;
  MyTree.OnChange := MyTreeChange;
end;


procedure TForm1.FormResize(Sender: TObject);
begin
  // This is full of "magic numbers" and is just a quick hack.  Please don't copy it.  It
  // is very bad form.  I just hacked it up because this is only a demo of the components.
{$IFNDEF NOLISTVIEW}
  with MyTree do
    SetBounds(Left, Top,
              (Self.ClientWidth - 50) div 2, Self.ClientHeight - 40 - Panel1.Height);

  with MyList do
    SetBounds((Self.ClientWidth div 2) + 5, Top,
              (Self.ClientWidth - 50) div 2, Self.ClientHeight - 40 - Panel1.Height);
{$ELSE}
  with MyTree do
    SetBounds(Left, Top, Self.ClientWidth - 40, Self.ClientHeight - Panel1.Height - 40);
{$ENDIF}
end;

procedure TForm1.FormShow(Sender: TObject);
begin
{$IFDEF RUNTIME}
  MyTree.SetFocus;
{$ENDIF}
end;

procedure TForm1.tvRootChange(Sender: TObject);
var
  NewRoot: TRootFolder;
begin
  with tvRoot do
    NewRoot := TRootFolder(GetEnumValue(TypeInfo(TRootFolder), Items[ItemIndex]));

  if NewRoot = rfCustom then
    MyTree.CustomDir := edCustomRootDir.Text;

  MyTree.RootFolder := NewRoot;
  if MyTree.Items.Count > 0 then
    MyTree.Selected := MyTree.Items[0];
end;

procedure TForm1.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if Shift = [] then
    case Key of
      VK_F2:
        if MyTree.Selected <> NIL then
          MyTree.Selected.EditText;
      VK_F5:
        MyTree.ResetNode(MyTree.Selected);
      VK_DELETE:
          if MessageDlg('Are you sure you want to delete this?'#13 +
                        'It will be permanently removed from your system.',
                        mtConfirmation, [mbYes, mbNo], 0) = mrYes then
            MyTree.DeleteNode(MyTree.Selected);
      VK_INSERT:
        if MyTree.AddNewNode(MyTree.Selected, 'New Folder', TRUE) then
          MyTree.Selected.EditText
        else
          MessageDlg('Could not add folder.', mtError, [mbOk], 0);
    end;
end;

procedure TForm1.lvStyleChange(Sender: TObject);
var
  NewStyle: TViewStyle;
begin
{$IFNDEF NOLISTVIEW}
  with lvStyle do
    NewStyle := TViewStyle(GetEnumValue(TypeInfo(TViewStyle), Items[ItemIndex]));

  MyList.ViewStyle := NewStyle;
  if MyList.Items.Count > 0 then
    MyList.Selected := MyList.Items[0];
{$ENDIF}
end;

procedure TForm1.MyTreeChange(Sender: TObject; Node: TTreeNode);
var
  Path: string;
begin
(*
  Path := LowerCase(MyTree.GetNodePath(Node));
  if Path = '' then // node is a virtual path.  No corresponding directory for it.
    lbFilePath.Caption := Format('[%s]', [Node.Text])
  else
    lbFilePath.Caption := Path;
*)    
end;

end.

