{ -------------------------------------------------------------------------------------}
{                          R E A D   T H I S   N O W ! ! !                             }
{ -------------------------------------------------------------------------------------}
{ I hope that got your attention.  This component requires a unit that provides access }
{ to the Win95/NT 4.0 Shell Namespace API.  Delphi 2.0 did not include this import,    }
{ but the v2.01 update does.  Also, Mr. Pat Ritchey was kind enough to write one,      }
{ which I think was the basis for Borland's (same bugs in both units, must be the      }
{ same).  Regardless of which you use, you will have to do some extra work because     }
{ both contain errors that will prevent this component from working properly.  To      }
{ implement these changes, read the FIXSHELL.TXT file that should have been included   }
{ with this file.                                                                      }
{ -------------------------------------------------------------------------------------}


{ -------------------------------------------------------------------------------------}
{ A tree view control that acts as the tree in the Windows 95 Explorer.                }
{ Copyright 1996, Brad Stowers & Thomas AW Brown.  All Rights Reserved.                }
{ This component can be freely used and distributed in commercial and private          }
{ environments, provied this notice is not modified in any way.                        }
{ -------------------------------------------------------------------------------------}
{ Feel free to contact me if you have any questions, comments or suggestions at        }
{ bstowers@pobox.com or 72733,3374 on CompuServe.                                      }
{ You can contact Thomas at calsoft@dircon.co.uk.                                      }
{ -------------------------------------------------------------------------------------}
{ Date last modified:  10/17/96                                                        }
{ -------------------------------------------------------------------------------------}

{ -------------------------------------------------------------------------------------}
{ TSystemTreeView v0.30                                                                }
{ -------------------------------------------------------------------------------------}
{                                                                                      }
{ Description:                                                                         }
{   A tree view control that acts as the tree in the Windows 95 Explorer.              }
{                                                                                      }
{ -------------------------------------------------------------------------------------}
{                                                                                      }
{ WORKING NOTES:                                                                       }
{   * I really need to rip all the namespace stuff out and put it in it's own class    }
{     so that you could use it however you wanted, i.e. menu, tree view, whatever.     }
{   * The included test project creates a TSystemTreeView object on the fly so that    }
{     you don't have to install the component in your library.  I'm fairly confident   }
{     that the component is stable, but if you don't want to install, you don't have   }
{     to just to see the demo.                                                         }
{   * Shared folders' icons aren't right.  Don't know what the problem there is.       }
{     Same thing for links.  For links, I need to do something like:                   }
{       SHGetFileInfo(PChar(PFolderItemData(SelItem.Data).IDList), 0, SFI,             }
{                 SizeOf(TSHFileInfo), SHGFI_PIDL or SHGFI_ICON or SHGFI_LINKOVERLAY); }
{       DrawIcon(Canvas.Handle, 0, 150, SFI.hIcon);                                    }
{     Can't find anything like SHGFI_SHAREOVERLAY, though, for shared folders.  Also,  }
{     Tree and List views don't have Canvas properties, and even if they did, where    }
{     am I going to do the drawing?  There doesn't seem to be any way of doing owner   }
{     drawing...  We are using the systems image list, so we can't add new stuff to    }
{     that without a lot of trouble.                                                   }
{   * Sorting is horribly slow.  I've been seeing a lot of people complaining about    }
{     the speed of the TTreeView/TListVew component, so I think that it's not me.      }
{   * Drag/Drop is begin worked on.                                                    }
{   * DisplayContextMenu doesn't work for root tree objects.  Desktop doesn't have     }
{     one, and I fixed that, but don't know what's wrong with the others.              }
{   * If anyone knows how to determine the type of object you have given it's PIDL,    }
{     I'd love to know it.  Right now, if it's not a file system object, you just get  }
{     it's name.  I need to determine other types like the printer folder, control     }
{     panel folder, network servers, network workgroups, etc.                          }
{   * I really need to rip all the namespace stuff out and put it in it's own class    }
{     so that you could use it however you wanted, i.e. menu, tree view, whatever.     }
{                                                                                      }
{ -------------------------------------------------------------------------------------}
{                                                                                      }
{ Beta Revision History:                                                               }
{ 0.00:  + Initial alpha release to limited audience.                                  }
{ 0.01:  + Cleaned up the mess in the USES clauses and the test project.               }
{ 0.02:  + Updated to use ShlObj, available inthe Delphi 2.01 update.  See NOTE above. }
{          Edit the DEFINES.INC file to control which namespace import unit you want   }
{          to use.  If $D201 is defined, you use Borland's, otherwise Pat Ritchey's.   }
{          Also made some more changes to ShellObj to make it more compatible with     }
{          Borland's ShlObj version.  If you use Borland's, context menus won't work.  }
{          See the comments in the DisplayContextMenu method for an explanation.       }
{        + Context menus (right click) are working, but need a good round of testing.  }
{        + Added some stuff to the demo project to help with testing.                  }
{        + Can now change RootFolder property during execution.  Would blow up before  }
{          if changed after initial assignment.                                        }
{          rfRecycleBin still blows up...  don't know why.  It doesn't like the        }
{          EnumObjects call in EnumerateFolders.                                       }
{        + A lot of the code got rewritten to make context menus, icons, etc. work.    }
{          A the Golden Rule of PIDLs is that the SH* functions take a fully qualified }
{          path PIDL, and the IShellFolder interface methods take a relative PIDL.     }
{          I was using relative PIDLs everywhere.  The result is that more things work }
{          now, but the code is probably even less stable than before.  Bang on it.    }
{ 0.03:  + Finally got the damn icon problem fixed.  The PIDL wrapper class was hosing }
{          me up somehow.  Don't know what was wrong with it, but it pointer would     }
{          disappear for some reason.  Getting rid of it cleared up the problem.  So   }
{          much for OOP making my life easier.  :)                                     }
{        + Got ShowRoot working.  Thanks to John Cardinal for that.                    }
{        + General code clean up.                                                      }
{        + While Mr. Ritchey acknowledged the declaration errors in his ShellObj unit, }
{          he has never answered my request to included a fixed version of it with     }
{          this control.  So, for now, I'm just going to include directions on how to  }
{          fix everything and not worry about.  See the FIXSEHLL.TXT file.             }
{ 0.10:  + I Feel reasonably confident in the component now.  All core functionality   }
{          seems to be in place and working.                                           }
{        + Thomas Brown has volunteered to colaborate on this with me, so things will  }
{          probably start moving faster.  All items prefaced with (TB) are by him,     }
{          otherwise, blame me.                                                        }
{        + (TB) Added ability to rename folders.                                       }
{        + Fixed problem that would occur if you installed the component in Delphi     }
{          (i.e. Component | Install).  By default, the Items property is "stored",    }
{          so all everything in it is written to the DFM file that the component is on }
{          and that includes the Data property of each of the tree nodes.  This a      }
{          pointer to memory we allocate, so having the pointer value stored wouldn't  }
{          do a whole lot of good, would it?  See the redeclaration of Items below.    }
{        + Added a new unit, FileChange, which provides a TThread descendant that      }
{          knows how to watch directories for changes in structure.  It hasn't been    }
{          well tested, so I have included it only inside $IFDEFs.  It should          }
{          automatically cause the selected node to be updated if another app makes    }
{          changes to that directory's subdir structure.  For example, compile and run }
{          the demo.  Select a node that is a directory somewhere on your hard drive.  }
{          Start explorer and select that same node in it.  Add a new folder to the    }
{          selected directory in Explorer.  The demo app should automatically update   }
{          the node to reflect the change.  If you have problems with it, comment out  }
{          the $DEFINE FILECHANGES line below.                                         }
{ 0.11   + Deleted the $I DEFINES.INC file in demo app.  Not needed any more.          }
{        + Added GetNodePath.  Returns full path given a TTreeNode.  Returns '' if it  }
{          is not a file system type node (i.e. control panel).                        }
{        + If selected node were deleted from another app, it could get pretty ugly.   }
{          Fixed.                                                                      }
{        + Added palette resource icon for component.  Thanks to Basri Kanca for it.   }
{        + Added three new functions, RenameNode, DeleteNode, AddNewNode.              }
{ 0.20   + This unit requires complete boolean eval to be turned off.  I've added the  }
{          appropriate compiler switches to do this in case it is turned on in your    }
{          project.                                                                    }
{        + First crack at a TSystemListView component to compliment the tree view.     }
{          It is way far from being as functionally complete as the tree view.  Mostly }
{          it's to see if it works for everyone at it's simplest form.                 }
{ 0.21   + DisplayContextMenu doesn't work for root tree objects.  Desktop doesn't     }
{          have one, and I fixed that, but don't know what's wrong with the others.    }
{        + Moved all strings into resource file (ErrorMsgs.r32) except for the         }
{          debugging "mem leak" string.  Doesn't seem to like loading strings in an    }
{          exitproc (finalization section).                                            }
{        + Could never make up my mind about whether to go with message boxes or       }
{          exceptions, so I just added a public property that can be used to set your  }
{          preference.  I prefer message boxes since there is no good way to catch the }
{          exceptions in an app, so that is the default.                               }
{        + Added all the file system report info stuff for list view items (size,      }
{          type, date).  If anyone knows how to determine the type of object you have  }
{          given it's PIDL, I'd love to know it.  Right now, if it's not a file system }
{          object, you just get it's name.                                             }
{ 0.30   + New feature:  Set the value of CustomDir to a valid directory, and then set }
{          RootFolder to rfCustom, and the tree will allow you to browse from that     }
{          directory as the root.  Also, if you don't want the root to read something  }
{          like 'c:\win\system', then use CustomDirCaption to override it.             }
{        + Now using SHGetDataFromIDList, which is missing from SHLOBJ.PAS.  See step  }
{          five in ShellFix.txt.                                                       }
{        + If PopupMenu property is has a menu, it is displayed instead of the context }
{          menu.                                                                       }
{        + TSystemListView now descends form TCustomListView as it should.             }
{        + Fixed bug.  I overrode the Change method of the tree, but forgot to call    }
{          inherited method.  This broke the OnChangeEvent -- never called.            }
{        + Fixed bug that caused serious problems for projects with one of these saved }
{          on a form.  When you tried to reopen the form after it was closed, it would }
{          cause many strange things to happen, usually just a lockup.  See the Loaded }
{          and CreateWnd methods for the fix.  If you want detailed description, email }
{          me and I will explain it.                                                   }
{        + New feature: ShowFiles property.  Allows the tree to display items other    }
{          than folders in it.  I guess ShowFiles isn't the best descriptiong, since   }
{          also includes things like printers in the printers folder.  Anyone got a    }
{          better name for it?                                                         }
{        + TSystemListView object has some serious problems, so I've disabled it in    }
{          test app until I get time to work on it.  I strongly suggest you stay away  }
{          from it in this version, unless you want to help me fix it.  To reenable it }
{          in the test app, take out the NOLISTVIEW define at the top of TESTING.PAS.  }
{--------------------------------------------------------------------------------------}


unit SystemTreeView;

interface

{$R SystemTreeView.res}
{$R ErrorMsgs.r32}

{.$DEFINE STV_DOSORTING}
{$DEFINE STV_SYSCOMBOBOX}
{$DEFINE STV_FILECHANGES}
{$BOOLEVAL OFF}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, ComCtrls,
  StdCtrls, MyShlObj, CommCtrl, _Res__IDs,
{$IFDEF STV_FILECHANGES}
  FileChange,
{$ENDIF}
  OLE2;

const
  MEMLEAK_STR = 'Memory Leak Detected.  Not all folder data was freed.';


type
  ENoRootFolder    = class(Exception);
  ENoEnumObjects   = class(Exception);
  ENoFolderData    = class(Exception);
  ENoBindFolder    = class(Exception);
  ENoDesktopFolder = class(Exception);
  EInvokeFailed    = class(Exception);
  ENoUIObject      = class(Exception);
  ELeaking         = class(Exception);

  // If you change the order of these, you have to change the order of the FOLDERID
  // constants below in GetFolderID function.
  TRootFolder = (rfDesktop, rfRecycleBin, rfControlPanel, rfDesktopDir, rfDrives,
                 rfFavoriteURLs, rfFonts, rfNetHood, rfNetHoodDir, rfDocumentDir,
                 rfPrinters, rfPrograms, rfRecentDir, rfSendTo, rfStartMenu, rfStartup,
                 rfTemplates, rfCustom);

  // A PFolderItemData pointer is stored in each node's Data property.  This is
  // used to populate the children of that node, show context menus, etc.
  PFolderItemData = ^TFolderItemData;
  TFolderItemData = record
    Initialized: boolean;             // Has it been populated yet?
    SFParent: IShellFolder;           // Parent IShellFolder object
    IDList,                           // Relative (to SFParent) ID List
    FQ_IDList:  PItemIDList;  // Fully Qualified ID List
    Attributes: UINT;
    Indent: UINT;
    Selected,
    Normal: integer;
  end;

{$IFDEF STV_SYSCOMBOBOX}
  TSystemComboBox = class;
{$ENDIF}

  TSystemListView = class;

  TSystemTreeView = class(TCustomTreeView)
  private
    FShowErrorsInMsgBox: boolean;
    FRootFolder: TRootFolder;
    FShowHiddenDirs: boolean;
    FExpandRoot: boolean;
    FListView: TSystemListView;
    FCustomDir: string;
    FCustomDirCaption: string;
    FShowFiles: boolean;
{$IFDEF STV_FILECHANGES}
    FCThread: TFileChangeThread;
    WatchedNode: TTreeNode;
{$ENDIF}

    function GetCustomID(const ShellFolder: IShellFolder; var ID: PItemIDList): boolean;
    function GetFolderID: integer;
    function EnumerateFolders(const ShellFolder: IShellFolder;
                              const ParentNode: TTreeNode): boolean;
    function EnumerateFiles(const Folder: IShellFolder;
                            const ParentNode: TTreeNode): boolean;
    // event for this?
    function AddNode(const ShellFolder: IShellFolder;
                     FQ_IDList, IDList: PItemIDList;
                     const ParentNode: TTreeNode): TTreeNode;
    function AddItemData(ItemFolder: IShellFolder; aIDList,
                         aFQ_IDList: PItemIDList; Attrs: UINT): PFolderItemData;
    procedure FreeItemData(Item: TTreeNode);
    procedure FreeAllItemData;
    function GetValidHandle: HWND;
  protected
    procedure CreateWnd; override;
    procedure Loaded; override;
    procedure CNNotify(var Message: TWMNotify); message CN_NOTIFY;
    function CanExpand(Node: TTreeNode): boolean; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    function CanEdit(Node: TTreeNode): boolean; override;
    procedure Edit(const Item: TTVItem); override;
    procedure Change(Node: TTreeNode); override;

    // Helpers
      // Why isn't there one of these in TTreeView????
    procedure DeleteItem(Node: TTreeNode); virtual;
    function GetNodeFromItem(const Item: TTVItem): TTreeNode;

    // Property methods.
    procedure SetRootFolder(Val: TRootFolder);
    procedure SetListView(Val: TSystemListView);
    procedure SetCustomDir(const Val: string);
    procedure SetCustomDirCaption(const Val: string);
    procedure SetShowFiles(Val: boolean);

    // These two do the same thing, just take different parameters.
    function GetItemData(Index: integer): PFolderItemData;
    function GetNodeData(Node: TTreeNode): PFolderItemData;

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure ResetTreeView;
    function DisplayContextMenu(Node: TTreeNode; Where: TPoint): boolean; virtual;
    procedure ResetNode(const Node: TTreeNode);
    function GetNodePath(const Node: TTreeNode): string;

    // Useful functions for applications.  These modify permanently, not just the node.
    // i.e. if you rename 'My Computer' to 'Crasher', it is renamed system wide, not
    // just in your app.  If you delete the 'C:\WINDOWS' folder, you are in deep trouble.
    function RenameNode(const Node: TTreeNode; const NewName: string): boolean;
    function DeleteNode(const Node: TTreeNode): boolean;
    function AddNewNode(const ParentNode: TTreeNode; const NodeName: string;
                        SelectNewNode: boolean): boolean;

{$IFDEF STV_FILECHANGES}
    procedure WatchDirectoryForChanges(const ANode: TTreeNode);
    procedure ThreadDone(Sender: TObject);
{$ENDIF}
    property ShowErrorsInMsgBox: boolean
             read FShowErrorsInMsgBox write FShowErrorsInMsgBox default TRUE;
  published
    property RootFolder: TRootFolder
             read FRootFolder write SetRootFolder default rfDesktop;
    property CustomDir: string
             read FCustomDir write SetCustomDir;
    property CustomDirCaption: string
             read FCustomDirCaption write SetCustomDirCaption;
    property ShowFiles: boolean
             read FShowFiles write SetShowFiles default FALSE;
    property ShowHiddenDirs: boolean
             read FShowHiddenDirs write FShowHiddenDirs default TRUE;
    property ExpandRoot: boolean
             read FExpandRoot write FExpandRoot default TRUE;
    property ListView: TSystemListView
             read FListView write SetListView;

    { Publish protected properties. }
    property ShowButtons;
    property BorderStyle;
    property DragCursor;
    property ShowLines;
    property ReadOnly;
    property DragMode;
    property HideSelection;
    property Indent;
    property OnEditing;
    property OnEdited;
    property OnExpanding;
    property OnExpanded;
    property OnCollapsing;
    property OnCompare;
    property OnCollapsed;
    property OnChanging;
    property OnChange;
    property OnDeletion;
    property OnGetImageIndex;
    property OnGetSelectedIndex;
    property Align;
    property Enabled;
    property Font;
    property Color;
    property ParentColor;
    property ParentCtl3D;
    property Ctl3D;
    property TabOrder;
    property TabStop default True;
    property Visible;
    property OnClick;
    property OnEnter;
    property OnExit;
    property OnDragDrop;
    property OnDragOver;
    property OnStartDrag;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnDblClick;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property ParentFont;
    property ParentShowHint;
    property ShowHint;

    property ShowRoot
             default TRUE;
    property Items
             stored FALSE; // this stuff can't be saved with the form.  It has to be
                           // read every time for obvious reasons.
  end;


  TColumnType = (ctFileSystem, ctMachine, ctControlPanel, ctPrinters, ctDUNet, ctNetwork,
                 ctUnknown);
  TSystemListView = class(TCustomListView)
  private
    // This will eventually be a set of attributes (system, read-only, etc.)
    FShowErrorsInMsgBox: boolean;
    FShowHiddenFiles: boolean;
    FColumnType: TColumnType;
    FColumnWidths: record
      cwName, cwSize, cwType, cwModified: integer;
    end;

    function GetValidHandle: HWND;
    function AddNode(const ShellFolder: IShellFolder;
                     FQ_IDList, IDList: PItemIDList;
                     const ParentNode: TTreeNode): TListItem;
    function AddItemData(ItemFolder: IShellFolder; aIDList,
                         aFQ_IDList: PItemIDList; Attrs: UINT): PFolderItemData;
    procedure FreeItemData(Item: TListItem);
    procedure FreeAllItemData;
  protected
    procedure CreateColumns(ColType: TColumnType); virtual;
    procedure SetColumnType(ColType: TColumnType);

    procedure CreateWnd; override;
    function EnumerateFiles(const Folder: IShellFolder;
                            const ParentNode: TTreeNode): boolean;
    function GetItemData(Item: TListItem): PFolderItemData;

    procedure CNNotify(var Message: TWMNotify); message CN_NOTIFY;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure Reset(const ParentNode: TTreeNode);
    function DisplayContextMenu(Item: TListItem; Where: TPoint): boolean; virtual;

    procedure SetColumnWidths(NameWidth, SizeWidth, TypeWidth, ModifiedWidth: integer);

    property ShowErrorsInMsgBox: boolean
             read FShowErrorsInMsgBox write FShowErrorsInMsgBox default TRUE;
    property ColumnType: TColumnType read FColumnType write SetColumnType;
  published
    property ShowHiddenFiles: boolean
             read FShowHiddenFiles write FShowHiddenFiles default TRUE;
    property Items
             stored FALSE; // this stuff can't be saved with the form.  It has to be
                           // read every time for obvious reasons.

    { Published protected properties }
    property Align;
    property BorderStyle;
    property Color;
    property ColumnClick;
    property OnClick;
    property OnDblClick;
    property Columns;
    property Ctl3D;
    property DragMode;
    property ReadOnly;
    property Font;
    property HideSelection;
    property IconOptions;
    property AllocBy;
    property MultiSelect;
    property OnChange;
    property OnChanging;
    property OnColumnClick;
    property OnCompare;
    property OnDeletion;
    property OnEdited;
    property OnEditing;
    property OnEnter;
    property OnExit;
    property OnInsert;
    property OnDragDrop;
    property OnDragOver;
    property DragCursor;
    property OnStartDrag;
    property OnEndDrag;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property ParentShowHint;
    property ShowHint;
    property PopupMenu;
    property ShowColumnHeaders;
    property SortType;
    property TabOrder;
    property TabStop default True;
    property ViewStyle;
    property Visible;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
  end;

{$IFDEF STV_SYSCOMBOBOX}
  TSCBType = (scbSystem, scbDrives);

  TSystemComboBox = class(TComboBox)
  private
    FItemType: TSCBType;
    FImages: TImageList;

    procedure AddItem(const ShellFolder: IShellFolder; FQ_IDList, IDList: PItemIDList;
                      Indent: UINT);
    function AddItemData(ItemFolder: IShellFolder; aIDList, aFQ_IDList: PItemIDList;
                         Attrs: UINT; aIndent: UINT): PFolderItemData;
    procedure FreeItemData(Item: integer);
    procedure FreeAllItemData;
    function GetItemData(Item: integer): PFolderItemData;
  protected
    function EnumerateFolders(const ShellFolder: IShellFolder;
                              ParentItem: PFolderItemData): boolean;
    procedure SetItemType(Val: TSCBType);
    procedure CreateWnd; override;
    // This is really stupid, but DestroyWnd isn't getting called...
//    procedure DestroyWnd; override;
    procedure WMDestroy(var Message: TWMDestroy); message WM_DESTROY;
    procedure DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState); override;
    procedure MeasureItem(Index: Integer; var Height: Integer); override;
   public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Reset;
  published
    property ItemType: TSCBType
             read FItemType write SetItemType default scbSystem;
  end;
{$ENDIF}


procedure Register;

implementation


uses ShellAPI, Menus;

var
  NewCount: Longint;
  FShellMalloc: IMalloc;
  // temp
  DESCR_FLAG: boolean;


procedure Register;
begin
  RegisterComponents('My Controls', [TSystemTreeView]);
  RegisterComponents('My Controls', [TSystemListView]);
end;


function ItemHasFlag(Data: PFolderItemData; Flag: UINT): boolean;
begin
  Result := FALSE;
  if Data = NIL then exit;
  Result := (Data.Attributes and Flag) <> 0;
end;

function GetPidlSize(pidl: PITEMIDLIST): integer;
begin
  Result := 0;
  if pidl <> nil then begin
    Inc(Result, SizeOf(pidl^.mkid.cb));
    while pidl^.mkid.cb <> 0 do begin
      Inc(Result, pidl^.mkid.cb);
      Inc(longint(pidl), pidl^.mkid.cb);
    end;
  end;
end;

function ConcatPIDLs(ID1, ID2: PItemIDList): PItemIDList;
  function CreatePIDL(Size: UINT): PItemIDList;
  begin
    Result := FShellMalloc.Alloc(Size);
    if Result <> NIL then
      FillChar(Result^, Size, #0);
  end;
var
  S1, S2: UINT;
begin
  if (ID1 <> NIL) then
    S1 := GetPIDLSize(ID1) - SizeOf(ID1.mkid.cb)
  else
    S1 := 0;
  S2 := GetPIDLSize(ID2);

  Result := CreatePIDL(S1 + S2);
  if Result <> NIL then begin
    if (ID1 <> NIL) then
      Move(ID1^, Result^, S1);
    Move(ID2^, PChar(Result)[S1], S2);
  end;
end;

function GetNiceName(const ShellFolder: IShellFolder; IDList: PItemIDList;
                                         Flags: DWORD; var Name: string): boolean;
var
  Str : TStrRet;
begin
  Result := TRUE;
  Name := '';
  if ShellFolder.GetDisplayNameOf(IDList, Flags, Str) = NOERROR then begin
    case Str.uType of
      STRRET_WSTR:
        begin
          // Make sure enough mem is available initially.
          SetLength(Name, MAX_PATH+1);
          // This resets the length and copies the string into Name
          SetLength(Name, WideCharToMultiByte(CP_ACP, 0, Str.pOleStr, -1,
                                              pChar(Name), MAX_PATH, NIL, NIL));
        end;
      STRRET_OFFSET: Name := PChar(Longint(IDList) + Str.uOffset);
      STRRET_CSTR:   Name := Str.cStr;
    else
      Result := FALSE;
    end;
  end else
    Result := FALSE;
end;

// Use this only for fully qualified PIDLs.  Relative won't work.
function GetIconIndex(IDList: PItemIDList; Flags: UINT): integer;
var
  SFI: TSHFileInfo;
begin
  SHGetFileInfo(PChar(IDList), 0, SFI, SizeOf(TSHFileInfo), Flags);
  Result := SFI.iIcon;
end;

// Use this only for fully qualified PIDLs.  Relative won't work.
procedure GetNormalAndSelectedIcons(IDList: PItemIDList; var Normal, Selected: integer);
begin
  Normal := GetIconIndex(IDList, SHGFI_PIDL or SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
  Selected := GetIconIndex(IDList, SHGFI_PIDL or SHGFI_SYSICONINDEX or
                                   SHGFI_SMALLICON or SHGFI_OPENICON);
end;


{$IFDEF STV_DOSORTING}

(*****************************************************************************************
  SortProc:
*****************************************************************************************)
function SysTV_SortProc(lParam1, lParam2, lParamSort: Longint): Integer stdcall;
begin
  // CompareIDs can probably handle NIL pointers.  need to try it.
  if Node1 = Node2 then
    Compare := 0
  else if Node1 = NIL then
    Compare := -1
  else if Node2 = NIL then
    Compare := 1
  else begin
    if Node1.Data <> NIL then with PFolderItemData(Node1.Data)^ do begin
      Compare := SFParent.CompareIDs(0, PFolderItemData(Node1.Data).IDList,
                                        PFolderItemData(Node2.Data).IDList);
    end else
      Compare := 0;
  end;
end; {SysTV_SortProc}
{$ENDIF}


(*****************************************************************************************
  Create:
*****************************************************************************************)
constructor TSystemTreeView.Create(AOwner: TComponent);
var
 SysIL: HImageList;
 SFI: TSHFileInfo;
begin
  inherited Create(AOwner);
  // Set the defaults.
  FCustomDir := '';
  FCustomDirCaption := '';
  FShowFiles := FALSE;
  FShowErrorsInMsgBox := TRUE;
  FRootFolder := rfDesktop;
  FShowHiddenDirs := TRUE;
  FExpandRoot := TRUE;
{$IFDEF STV_FILECHANGES}
  WatchedNode := NIL;
  FCThread := NIL;
{$ENDIF}
  ShowRoot := TRUE;
// This is horrendously slow!
{$IFDEF STV_DOSORTING}
  SortType := stBoth;
  OnCompare := SortProc;
{$ENDIF}

  { Create the image list.  We don't really "create" one.  We fool SHGetFileInfo into
    giving us the system's image list and use it's handle.  You'd think it would be
    easier to get the handle of the system image list....                              }
  Images := TImageList.Create(Self);
  SysIL := SHGetFileInfo('', 0, SFI, SizeOf(SFI), SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
  if SysIL <> 0 then begin
    Images.Handle := SysIL;
    Images.ShareImages := TRUE;  // DON'T FREE THE SYSTEM IMAGE LIST!!!!!  BAD IDEA (tm)!
  end;
end; {Create}


(*****************************************************************************************
  Destroy:
*****************************************************************************************)
destructor TSystemTreeView.Destroy;
begin
{$IFDEF STV_FILECHANGES}
  if FCThread <> NIL then
    FCThread.Terminate;
{$ENDIF}
  // Free the image list object.  Doesn't release the image list handle because it
  // doesn't belong to us, but the system.  Go ahead, delete the handle and see what
  // happens....  :)   It won't crash anything, but Explorer will look a bit strange.
  Images.Free;

  inherited Destroy;
end; {Destroy}


procedure TSystemTreeView.CreateWnd;
begin
  inherited CreateWnd;
  // If we are loading object from stream (form file), we have to wait until everything
  // is loaded before populating the list.  If we are not loading, i.e. the component was
  // created dynamically or was just dropped on a form, we need to populate it now since
  // the Loaded method will never get called.
  if not (csLoading in ComponentState) then
    ResetTreeView;
end;

procedure TSystemTreeView.Loaded;
begin
  inherited Loaded;
  ResetTreeView; // We've finished loading, we can populate the tree now.
end;


(*****************************************************************************************
  CNNotify:  Trap notification messages sent to the window.
    This is damn silly, but it's the only way we can know when a node is being deleted.
    I think it's an oversight in the VCL, so until Borland fixes it, just live with it.
*****************************************************************************************)
procedure TSystemTreeView.CNNotify(var Message: TWMNotify);
var
  Node: TTreeNode;
begin
  if Message.NMHdr.code = TVN_DELETEITEM then begin
    with PNMTreeView(Pointer(Message.NMHdr))^ do
      Node := GetNodeFromItem(itemOld);
    if Node <> NIL then
      FreeItemData(Node);
    // we can't do the actual delete processing here because we don't have access to
    // some of the stuff needed.  Let default handling do it below.
  end;

  inherited;
end; {CNNotify}


(*****************************************************************************************
  CanExpand:
*****************************************************************************************)
function TSystemTreeView.CanExpand(Node: TTreeNode): boolean;
var
  SubFolder: IShellFolder;
begin
  Result := inherited CanExpand(Node);
  if not Result then exit;

  // See if the node needs to be populated.
  if Node.Data <> NIL then begin
    with GetNodeData(Node)^ do begin
      if not Initialized then begin
        if (Node.Parent = NIL) and (FRootFolder = rfDesktop) then begin
          SHGetDesktopFolder(SubFolder);
          EnumerateFolders(SubFolder, Node);
          Initialized := TRUE;
        end else begin
          if SUCCEEDED(SFParent.BindToObject(IDList, NIL, IID_IShellFolder,
                                             pointer(SubFolder))) then begin
            Initialized := TRUE;
            Result := EnumerateFolders(SubFolder, Node);
            SubFolder.Release;
          end; //if
        end; //if
      end; //if
    end; //with
  end; //if
  // This usually happens on networked stuff.  It's not unusual there, and even
  // Explorer does it this way, so I'm guessing I'm doing it right.  :)
  if not Result then // something happened and we couldn't enum folders.
    Node.HasChildren := FALSE;
end; {CanExpand}


(*****************************************************************************************
  DeleteItem:
*****************************************************************************************)
procedure TSystemTreeView.DeleteItem(Node: TTreeNode);
begin
  if Node = NIL then exit;
  FreeItemData(Node);
  Node.Delete;
end; {DeleteItem}

function TSystemTreeView.GetNodeFromItem(const Item: TTVItem): TTreeNode;
begin
  with Item do
    if (state and TVIF_PARAM) <> 0 then
      Result := Pointer(lParam)
    else
      Result := Items.GetNode(hItem);
end;


function TSystemTreeView.GetFolderID: integer;
const
  CSIDL_CUSTOM = $EAFE;
  FOLDERID : array[rfDesktop..rfCustom] of integer =
    (
      CSIDL_DESKTOP, CSIDL_BITBUCKET, CSIDL_CONTROLS, CSIDL_DESKTOPDIRECTORY,
      CSIDL_DRIVES, CSIDL_FAVORITES, CSIDL_FONTS, CSIDL_NETWORK, CSIDL_NETHOOD,
      CSIDL_PERSONAL, CSIDL_PRINTERS, CSIDL_PROGRAMS, CSIDL_RECENT, CSIDL_SENDTO,
      CSIDL_STARTMENU, CSIDL_STARTUP, CSIDL_TEMPLATES, CSIDL_CUSTOM
    );
begin
  Result := FOLDERID[FRootFolder];
end;


procedure TSystemTreeView.SetShowFiles(Val: boolean);
begin
  if Val = FShowFiles then exit;
  FShowFiles := Val;
  ResetTreeView;
end;


procedure TSystemTreeView.SetCustomDir(const Val: string);
begin
  if Val = FCustomDir then exit;
  FCustomDir := Val;
  ResetTreeView;
end;


procedure TSystemTreeView.SetCustomDirCaption(const Val: string);
begin
  if FCustomDirCaption = Val then exit;
  FCustomDirCaption := Val;
  if Items.Count > 0 then
    Items[0].Text := FCustomDirCaption;
end;


function TSystemTreeView.GetCustomID(const ShellFolder: IShellFolder;
                                     var ID: PItemIDList): boolean;
var
  OLEStr: array[0..MAX_PATH] of TOLEChar;
  Eaten: ULONG;
  Attr: ULONG;
begin
  MultiByteToWideChar(CP_ACP, MB_PRECOMPOSED, PChar(FCustomDir), -1, OLEStr, MAX_PATH);
  Result := SUCCEEDED(ShellFolder.ParseDisplayName(GetValidHandle, NIL, OLEStr,
                                                   Eaten, ID, Attr));
end;


(*****************************************************************************************
  ResetTreeView:
*****************************************************************************************)
procedure TSystemTreeView.ResetTreeView;
var
  RootNode: TTreeNode;
  RootFolder: IShellFolder;
  RootID: PItemIDList;
  Success: boolean;
begin
  // Clear old stuff
  if not HandleAllocated then
    exit;
  Selected := NIL;
  FreeAllItemData;
  Items.Clear;

  if SUCCEEDED(SHGetDesktopFolder(RootFolder)) then begin
    try
      if (FRootFolder = rfCustom) then
        Success := GetCustomID(RootFolder, RootID)
      else
        Success := SUCCEEDED(SHGetSpecialFolderLocation(GetValidHandle, GetFolderID,
                                                        RootID));
      if Success then begin
        RootNode := AddNode(RootFolder, ConcatPIDLs(NIL, RootID), RootID, NIL);
        if ShowRoot and FExpandRoot and assigned(RootNode) and (Items.Count > 0) then
          RootNode.Expand(FALSE);
      end; //if
    finally
      FShellMalloc.Free(RootID);
    end; //try
    RootFolder.Release;
  end; //if
end; {ResetTreeView}


(*****************************************************************************************
  EnumerateFolders:
*****************************************************************************************)
function TSystemTreeView.EnumerateFolders(const ShellFolder: IShellFolder;
                                          const ParentNode: TTreeNode): boolean;
var
  Flags: DWORD;
  EnumList: IEnumIDList;
  FQ_List,
  List: PItemIDList;
  Fetched: Longint;
  OldCursor: TCursor;
begin
  Result := FALSE;
  // Inhibit screen painting for speed
  Items.BeginUpdate;
  // I wish there was some way to find out the number of items being enumerated, and
  // only set the hourglass cursor if there were many of them....
  OldCursor := Cursor;
  Cursor := crHourglass;

  try
    Flags := SHCONTF_FOLDERS;
    if FShowHiddenDirs then
      Flags := Flags or SHCONTF_INCLUDEHIDDEN;
    if FShowFiles then
      Flags := Flags or SHCONTF_NONFOLDERS;
    if SUCCEEDED(ShellFolder.EnumObjects(GetValidHandle, Flags, EnumList)) then begin
      // Walk the folders.
      try
        // The list will be saved so don't free it anywhere in here.
        while EnumList.Next(1, List, Fetched) = S_OK do begin
          Result := TRUE;  // only successful if we managed to enumerate at least once.
          if assigned(ParentNode) then
            with PFolderItemData(ParentNode.Data)^ do
              FQ_List := ConcatPIDLs(FQ_IDList, List)
          else
            FQ_List := ConcatPIDLs(NIL, List);

          AddNode(ShellFolder, FQ_List, List, ParentNode);
        end; {while}
      finally
        EnumList.Release;
      end;
{      if FShowFiles then
        EnumerateFiles(ShellFolder, ParentNode);}
    end else
      // Maybe an event for this???  No items to enum when there should be.
      ;
  finally
    // always protect this stuff to make sure it gets reset.
    Items.EndUpdate;
    Cursor := OldCursor;
  end;
end;


function TSystemTreeView.EnumerateFiles(const Folder: IShellFolder;
                                        const ParentNode: TTreeNode): boolean;
var
  Flags: DWORD;
  EnumList: IEnumIDList;
  FQ_List,
  List: PItemIDList;
  Fetched: Longint;
  OldCursor: TCursor;
begin
  Result := FALSE;

  if Folder = NIL then exit;

  // Inhibit screen painting for speed
  Items.BeginUpdate;
  // I wish there was some way to find out the number of items being enumerated, and
  // only set the hourglass cursor if there were many of them....
  OldCursor := Cursor;
  Cursor := crHourglass;

  try
    Flags := SHCONTF_NONFOLDERS;
    if SUCCEEDED(Folder.EnumObjects(GetValidHandle, Flags, EnumList)) then begin
      // Walk the folders.
      try
        // The list will be saved so don't free it anywhere in here.
        while EnumList.Next(1, List, Fetched) = S_OK do begin
          Result := TRUE;  // only successful if we managed to enumerate at least once.
          if assigned(ParentNode) then
            with PFolderItemData(ParentNode.Data)^ do
              FQ_List := ConcatPIDLs(FQ_IDList, List)
          else
            FQ_List := ConcatPIDLs(NIL, List);

          AddNode(Folder, FQ_List, List, ParentNode);
        end; {while}
      finally
        EnumList.Release;
      end;
    end else
      // Maybe an event for this???  No items to enum when there should be.
      ;
  finally
    // always protect this stuff to make sure it gets reset.
    Items.EndUpdate;
    Cursor := OldCursor;
  end;
end;


(*****************************************************************************************
  AddNode:
*****************************************************************************************)
function TSystemTreeView.AddNode(const ShellFolder: IShellFolder;
                                 FQ_IDList, IDList: PItemIDList;
                                 const ParentNode: TTreeNode): TTreeNode;
var
  NiceName: string;
  Attrs: UINT;
  Normal,
  Selected: integer;
begin
  Result := NIL;
  if GetNiceName(ShellFolder, IDList, SHGDN_NORMAL, NiceName) then begin
    if (ParentNode = NIL) and (FRootFolder = rfCustom) and (FCustomDirCaption <> '') then
      NiceName := FCustomDirCaption;
    Attrs := SFGAO_CAPABILITYMASK or SFGAO_DISPLAYATTRMASK or SFGAO_CONTENTSMASK;
    ShellFolder.GetAttributesOf(1, IDList, Attrs);
    Result := Items.AddChildObject(ParentNode, NiceName,
                                   AddItemData(ShellFolder, IDList, FQ_IDList, Attrs));
    GetNormalAndSelectedIcons(FQ_IDList, Normal, Selected);
    Result.ImageIndex := Normal;
    Result.SelectedIndex := Selected;
    Result.HasChildren := ItemHasFlag(PFolderItemData(Result.Data), SFGAO_HASSUBFOLDER);
  end; {if}
end; {AddEnumItem}


(*****************************************************************************************
  AddItemData:
*****************************************************************************************)
function TSystemTreeView.AddItemData(ItemFolder: IShellFolder;
                         aIDList, aFQ_IDList: PItemIDList; Attrs: UINT): PFolderItemData;
var
  FolderData: PFolderItemData;
begin
  GetMem(FolderData, SizeOf(TFolderItemData));
  with FolderData^ do begin
    Initialized := FALSE;
    SFParent := ItemFolder;
    SFParent.AddRef;
    IDList := aIDList;
    FQ_IDList := aFQ_IDList;
    Attributes := Attrs;
  end;
  Result := FolderData;
  inc(NewCount);
end; {AddItemDta}


(*****************************************************************************************
  FreeItemData:
*****************************************************************************************)
procedure TSystemTreeView.FreeItemData(Item: TTreeNode);
begin
  if Item.Data <> NIL then begin
    with GetNodeData(Item)^ do begin
      if SFParent <> NIL then
        SFParent.Release;
      if IDList <> NIL then
        FShellMalloc.Free(IDList);
      if FQ_IDList <> NIL then
        FShellMalloc.Free(FQ_IDList);
    end;
    FreeMem(Item.Data, SizeOf(TFolderItemData));
    Item.Data := NIL;
    dec(NewCount);
  end;
end; {FreeItemData}


(*****************************************************************************************
  FreeAllItemData:
*****************************************************************************************)
procedure TSystemTreeView.FreeAllItemData;
var
  x: integer;
begin
  for x := 0 to Items.Count-1 do
    FreeItemData(Items[x]);
end; {FreeAllItemData}


(*****************************************************************************************
  SetRootFolder:
*****************************************************************************************)
procedure TSystemTreeView.SetRootFolder(Val: TRootFolder);
begin
  if Val = FRootFolder then exit;
  FRootFolder := Val;
  ResetTreeView;
end; {SetRootFolder}


procedure TSystemTreeView.SetListView(Val: TSystemListView);
begin
  if FListView = Val then exit;
  FListView := Val;
  if (FListView <> NIL) and (Selected <> NIL) and (Selected.Data <> NIL) then
    FListView.Reset(Selected);
end;


(*****************************************************************************************
  DisplayContextMenu:
*****************************************************************************************)
function TSystemTreeView.DisplayContextMenu(Node: TTreeNode; Where: TPoint): boolean;
var
  ContextMenu: IContextMenu;
  Popup: HMenu;
  ICI: TCMInvokeCommandInfo;
  CmdID: integer;
  Res: HResult;
  ItemData: PFolderItemData;
  OldCursor: TCursor;
begin
  Result := FALSE;

  OldCursor := Cursor;
  Cursor := crHourglass;

  try
    ItemData := GetNodeData(Node);
    if (Node.Parent = NIL) and (FRootFolder = rfDesktop) then
      exit; // Desktop does not have a context menu!

    Res := ItemData.SFParent.GetUIObjectOf(GetValidHandle, 1, ItemData.IDList,
                                           IID_IContextMenu, NIL, pointer(ContextMenu));

    if SUCCEEDED(Res) then begin
      Popup := CreatePopupMenu;
      try
        // Get the context menu for the item.
        Res := ContextMenu.QueryContextMenu(Popup, 0, 1, $7FFF, CMF_EXPLORE);
        if SUCCEEDED(Res) then begin
          // As near as I can tell, typecasting this to an integer is undocumented, but
          // the two sources I have both do it, and it seems to work fine.
          CmdID := integer(TrackPopupMenu(Popup, TPM_LEFTALIGN or TPM_RETURNCMD or
                            TPM_RIGHTBUTTON, Where.X, Where.Y, 0, GetValidHandle, NIL));

          if CmdID <> 0 then begin
            // Execute command that was selected.
            with ICI do begin
              cbSize := SizeOf(TCMInvokeCommandInfo);
              fMask := 0;
              hwnd := GetValidHandle;
              lpVerb := MakeIntResource(CmdID-1);
              lpParameters := NIL;
              lpDirectory := NIL;
              nShow := SW_SHOWNORMAL;
              dwHotKey := 0;
              hIcon := 0;
            end; // with

            Res := ContextMenu.InvokeCommand(ICI);
            Result := SUCCEEDED(Res);
            // Sometimes this reports failure even though it succeeded...  Guess I should
            // get rid of the check here.  Damn...
            if not Result then begin
              if FShowErrorsInMsgBox then
                MessageDlg(FmtLoadStr(IDS_INVOKEFAILED, [Res]), mtError, [mbOK], 0)
              else
                raise EInvokeFailed.Create(FmtLoadStr(IDS_INVOKEFAILED, [Res]));
            end;
          end; // if
        end // if
      finally
        DestroyMenu(Popup);
        ContextMenu.Release;
      end; // try
    end // if
    else begin
      if FShowErrorsInMsgBox then
        MessageDlg(FmtLoadStr(IDS_NOUIOBJECT, [Res]), mtError, [mbOK], 0)
      else
        raise ENoUIObject.Create(FmtLoadStr(IDS_NOUIOBJECT, [Res]));
    end;
  finally
    Cursor := OldCursor;
  end;
end;

function TSystemTreeView.GetItemData(Index: integer): PFolderItemData;
begin
  Result := GetNodeData(Items[Index]);
end;

function TSystemTreeView.GetNodeData(Node: TTreeNode): PFolderItemData;
begin
  Result := Node.Data;
  if Result = NIL then begin
    if FShowErrorsInMsgBox then
      MessageDlg(LoadStr(IDS_NOFOLDERDATA), mtError, [mbOK], 0)
    else
      raise ENoFolderData.Create(LoadStr(IDS_NOFOLDERDATA));
  end
end;

procedure TSystemTreeView.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  SelNode: TTreeNode;
begin
  inherited MouseDown(Button, Shift, X, Y);
  if PopupMenu = NIL then begin
    if ssRight in Shift then begin
      SelNode := GetNodeAt(X, Y);
      if SelNode <> NIL then begin
        Selected := SelNode;
        DisplayContextMenu(SelNode, ClientToScreen(Point(X, Y)));
      end;
    end;
  end;
end;


procedure TSystemTreeView.ResetNode(const Node: TTreeNode);
var
  RedoExpand: boolean;
begin
  // This really isn't exactly like explorer.  Explorer remembers open children.
  if Node = NIL then exit;
  RedoExpand := Node.Expanded;
  Node.DeleteChildren;
  if Node.Data <> NIL then begin
    GetNodeData(Node).Initialized := FALSE;
    if CanExpand(Node) and RedoExpand then
      Node.Expand(FALSE);
    if (FListView <> NIL) then
      FListView.Reset(Node);
  end;
end;

(*****************************************************************************************
  CanEdit - 29/8/96 (tb)
*****************************************************************************************)
function TSystemTreeView.CanEdit(Node: TTreeNode): boolean;
begin
  if Node.Data = NIL then
    Result := False // Default to no editing allowed
  else
    Result := ItemHasFlag(GetNodeData(Node), SFGAO_CANRENAME)
end;

(*****************************************************************************************
  Edit - 29/8/96 (tb)
       - 11/9/96 Moved guts of it to RenameNode so it could be used programatically. (bds)
*****************************************************************************************)
procedure TSystemTreeView.Edit(const Item: TTVItem);
begin
  if RenameNode(GetNodeFromItem(Item), Item.pszText) then
    inherited Edit(Item);
end;

{$IFDEF STV_FILECHANGES}
procedure TSystemTreeView.WatchDirectoryForChanges(const ANode: TTreeNode);
var
  APath: string;
begin
  if FCThread <> NIL then begin
    FCThread.Terminate;  // it will destroy itself.
    FCThread := NIL;
    WatchedNode := NIL;
  end;
  APath := GetNodePath(ANode);
  if APath <> '' then begin
    WatchedNode := ANode;
    FCThread := TFileChangeThread.Create(APath, [fsfDirname], FALSE);
    FCThread.OnTerminate := ThreadDone;
  end;
end;

procedure TSystemTreeView.ThreadDone(Sender: TObject);
  function DirExists(ADir:string):boolean;
  var
    SR: TSearchRec;
  begin
    Result := FALSE;
    if ADir = '' then exit;
    if ADir[Length(ADir)] = '\' then begin
      SetLength(ADir, Length(ADir)-1);
      // can't strip from root...
      if (Length(ADir) = 2) and (ADir[2] = ':') then
        ADir := ADir + ';'; // put it back on.
    end;
    if FindFirst(ADir, faAnyFile, SR) = 0 then
      Result := (faDirectory and SR.Attr) <> 0;
    FindClose(SR);
  end;
var
  Temp: TTreeNode;
  dir: string;
begin
  // we need to make sure that the directory we are watching hasn't been deleted / moved
  dir := GetNodePath(WatchedNode);
  if dir = '' then exit;
  if not DirExists(dir) then begin
    if FileExists(dir) then begin // is it file that the user selected?
      WatchDirectoryForChanges(WatchedNode.Parent);
    end else begin
      Temp := WatchedNode.Parent;
      ResetNode(Temp);
      Selected := Temp;
    end;
  end else begin
    Temp := WatchedNode;
    FCThread := NIL;
    WatchedNode := NIL;
    ResetNode(Temp);
    WatchDirectoryForChanges(Temp);
  end;
end;
{$ENDIF}

function TSystemTreeView.GetNodePath(const Node: TTreeNode): string;
begin
  Result := '';
  if (Node <> NIL) and (Node.Data <> NIL) then begin
    SetLength(Result, MAX_PATH);
    if SHGetPathFromIDList(GetNodeData(Node)^.FQ_IDList, PChar(Result)) then
      SetLength(Result, StrLen(PChar(Result)))
    else
      Result := '';
  end;
end;

procedure TSystemTreeView.Change(Node: TTreeNode);
begin
  inherited Change(Node);
  if (FListView <> NIL) and (Selected <> NIL) and (Selected.Data <> NIL) then
    FListView.Reset(Node);
{$IFDEF STV_FILECHANGES}
  WatchDirectoryForChanges(Node);
{$ENDIF}
end;

function TSystemTreeView.GetValidHandle: HWND;
begin
  if HandleAllocated then
    Result := Handle
  else if assigned(Parent) and Parent.HandleAllocated then
    Result := Parent.Handle
  else if assigned(Application.MainForm) and Application.MainForm.HandleAllocated then
    Result := Application.MainForm.Handle
  else
    Result := 0;
end;

function TSystemTreeView.RenameNode(const Node: TTreeNode; const NewName: string): boolean;
var
  pstr: PWideChar;
begin
  Result := FALSE;
  if (Node = NIL) or (Node.Data = NIL) or (NewName = '') then exit;
  pstr := StringToOleStr(NewName); //make an OLE string for SetNameOf
  try
    with GetNodeData(Node)^ do begin
      // Passing the IDList again in the last param causes the Shell to free the old one,
      // and create the new one - easy!
      Result := SUCCEEDED(SFParent.SetNameOf(GetValidHandle, IDList, pstr,
                                             SHCONTF_FOLDERS, IDList));
      if Result then
        Node.Text := NewName;
    end;
  finally
    FShellMalloc.Free(pstr); // Don't forget to free the OLE string
  end;
end;

function TSystemTreeView.DeleteNode(const Node: TTreeNode): boolean;
var
  Dir: string;
begin
  Result := FALSE;
  if (Node = NIL) or (Node.Data = NIL) then exit;
  Dir := GetNodePath(Node);
  if Dir = '' then exit;
  Result := RemoveDirectory(PChar(Dir));
  if Result then
    DeleteItem(Node);
end;

function TSystemTreeView.AddNewNode(const ParentNode: TTreeNode; const NodeName: string;
                                    SelectNewNode: boolean): boolean;
var
  Dir: string;
  Temp: TTreeNode;
begin
  Result := FALSE;
  Dir := GetNodePath(ParentNode);
  if (Dir = '') or (NodeName = '') then exit; // can only add to file system nodes.
  Dir := Dir + '\' + NodeName;
  // Turn off the file change thread.
  Temp := NIL;
  if FCThread <> NIL then begin
    Temp := WatchedNode;
    WatchedNode:= NIL;
    FCThread.Terminate;
  end;
  Result := CreateDirectory(PChar(Dir), NIL);
  if Result then begin
    ResetNode(ParentNode);
    if SelectNewNode then begin
      Temp := ParentNode.GetFirstChild;
      while assigned(Temp) do begin
        if Temp.Text = NodeName then begin
          Selected := Temp;
          break; // We're done
        end;
        Temp := Temp.GetNextSibling;
      end;
      Temp := NIL; // Changing Selected will restart the watch.
    end;
  end;
  if Temp <> NIL then
    WatchDirectoryForChanges(Temp);
end;



{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}



constructor TSystemListView.Create(AOwner: TComponent);
var
 SysIL: HImageList;
 SFI: TSHFileInfo;
begin
  inherited Create(AOwner);
  // Set the defaults.
  FShowErrorsInMsgBox := TRUE;
  FShowHiddenFiles := TRUE;
  FColumnType := ctFileSystem;
  SetColumnWidths(120, 60, 120, 120);

  { Create the image list.  We don't really "create" one.  We fool SHGetFileInfo into
    giving us the system's image list and use it's handle.  You'd think it would be
    easier to get the handle of the system image list....                              }
  LargeImages := TImageList.Create(Self);
  SysIL := SHGetFileInfo('', 0, SFI, SizeOf(SFI), SHGFI_SYSICONINDEX or SHGFI_LARGEICON);
  if SysIL <> 0 then begin
    LargeImages.Handle := SysIL;
    LargeImages.ShareImages := TRUE;  // DON'T FREE THE SYSTEM IMAGE LIST!!!!!  BAD IDEA (tm)!
  end;
  SmallImages := TImageList.Create(Self);
  SysIL := SHGetFileInfo('', 0, SFI, SizeOf(SFI), SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
  if SysIL <> 0 then begin
    SmallImages.Handle := SysIL;
    SmallImages.ShareImages := TRUE;  // DON'T FREE THE SYSTEM IMAGE LIST!!!!!  BAD IDEA (tm)!
  end;
end; {Create}


destructor TSystemListView.Destroy;
begin
  LargeImages.Free;
  SmallImages.Free;

  inherited Destroy;
end;

procedure TSystemListView.CreateWnd;
begin
  inherited CreateWnd;
end;

procedure TSystemListView.SetColumnType(ColType: TColumnType);
begin
  if ColType = FColumnType then exit;
  FColumnType := ColType;
  CreateColumns(ColType);
end;

// This will be based on what type of stuff we are enumerating eventually
procedure TSystemListView.CreateColumns(ColType: TColumnType);
begin
  Columns.Clear;
  case ColType of
    ctMachine:
      begin
        with Columns.Add do begin
          Caption := 'Name';
          Width := FColumnWidths.cwName;
        end;
        with Columns.Add do begin
          Caption := 'Type';
          Width := FColumnWidths.cwSize;
        end;
        with Columns.Add do begin
          Caption := 'Total Size';
          Alignment := taRightJustify;
          Width := FColumnWidths.cwType;
        end;
        with Columns.Add do begin
          Caption := 'Free Space';
          Alignment := taRightJustify;
          Width := FColumnWidths.cwModified;
        end;
      end;
    ctControlPanel:
      begin
        with Columns.Add do begin
          Caption := 'Name';
          Width := FColumnWidths.cwName;
        end;
        with Columns.Add do begin
          Caption := 'Description';
          Width := FColumnWidths.cwSize;
        end;
      end;
    ctPrinters:
      begin
        with Columns.Add do begin
          Caption := 'Name';
          Width := FColumnWidths.cwName;
        end;
        with Columns.Add do begin
          Caption := 'Documents';
          Alignment := taCenter;
          Width := FColumnWidths.cwSize;
        end;
        with Columns.Add do begin
          Caption := 'Status';
          Width := FColumnWidths.cwType;
        end;
        with Columns.Add do begin
          Caption := 'Comment';
          Width := FColumnWidths.cwModified;
        end;
      end;
    ctDUNet:
      begin
        with Columns.Add do begin
          Caption := 'Entry name';
          Width := FColumnWidths.cwName;
        end;
        with Columns.Add do begin
          Caption := 'Phone #';
          Alignment := taRightJustify;
          Width := FColumnWidths.cwSize;
        end;
        with Columns.Add do begin
          Caption := 'Device name';
          Width := FColumnWidths.cwType;
        end;
      end;
    ctNetwork:
      begin
        with Columns.Add do begin
          Caption := 'Name';
          Width := FColumnWidths.cwName;
        end;
        with Columns.Add do begin
          Caption := 'Comment';
          Width := FColumnWidths.cwSize;
        end;
      end;
    ctFileSystem:
      begin
        with Columns.Add do begin
          Caption := 'Name';
          Width := FColumnWidths.cwName;
        end;
        with Columns.Add do begin
          Caption := 'Size';
          Alignment := taRightJustify;
          Width := FColumnWidths.cwSize;
        end;
        with Columns.Add do begin
          Caption := 'Type';
          Width := FColumnWidths.cwType;
        end;
        with Columns.Add do begin
          Caption := 'Modified';
          Width := FColumnWidths.cwModified;
        end;
      end;
  else // ctUnknown;
    with Columns.Add do begin
      Caption := 'Name';
      Width := FColumnWidths.cwName;
    end;
  end;
end;

procedure TSystemListView.Reset(const ParentNode: TTreeNode);
var
  SubFolder: IShellFolder;
  Attrs: UINT;
begin
  // Clear old stuff
  if not HandleAllocated then
    exit;
  Selected := NIL;
  FreeAllItemData;
  Items.Clear;

  if (ParentNode.Parent = NIL) then begin
    SHGetDesktopFolder(SubFolder);
    CreateColumns(ctFileSystem);

    EnumerateFiles(SubFolder, ParentNode);
    SubFolder.Release;
  end else begin
    with PFolderItemData(ParentNode.Data)^ do begin
      Attrs := SFGAO_FILESYSTEM;
      if SUCCEEDED(SFParent.GetAttributesOf(1, IDList, Attrs)) then begin
        if (Attrs and SFGAO_FILESYSTEM) <> 0 then
          CreateColumns(ctFileSystem)
        else
          // need to find out what kind of object we have.  No idea of how to do it.
          CreateColumns(ctUnknown);
      end else
        CreateColumns(ctUnknown);
      if SUCCEEDED(SFParent.BindToObject(IDList, NIL, IID_IShellFolder,
                                         pointer(SubFolder))) then begin
        EnumerateFiles(SubFolder, ParentNode);
        SubFolder.Release;
      end; // if
    end; // with
  end; //if
end; {ResetTreeView}


function TSystemListView.GetValidHandle: HWND;
begin
  if HandleAllocated then
    Result := Handle
  else if assigned(Parent) and Parent.HandleAllocated then
    Result := Parent.Handle
  else if assigned(Application.MainForm) and Application.MainForm.HandleAllocated then
    Result := Application.MainForm.Handle
  else
    Result := 0;
end;


function TSystemListView.EnumerateFiles(const Folder: IShellFolder;
                                        const ParentNode: TTreeNode): boolean;
var
  Flags: DWORD;
  EnumList: IEnumIDList;
  FQ_List,
  List: PItemIDList;
  Fetched: Longint;
  OldCursor: TCursor;
begin
  Result := FALSE;

  if Folder = NIL then exit;

  // Inhibit screen painting for speed
  Items.BeginUpdate;
  // I wish there was some way to find out the number of items being enumerated, and
  // only set the hourglass cursor if there were many of them....
  OldCursor := Cursor;
  Cursor := crHourglass;

  try
    Flags := SHCONTF_FOLDERS or SHCONTF_NONFOLDERS;
    if FShowHiddenFiles then
      Flags := Flags or SHCONTF_INCLUDEHIDDEN;
    if SUCCEEDED(Folder.EnumObjects(GetValidHandle, Flags, EnumList)) then begin
      // Walk the folders.
      try
        // The list will be saved so don't free it anywhere in here.
        while EnumList.Next(1, List, Fetched) = S_OK do begin
          Result := TRUE;  // only successful if we managed to enumerate at least once.
          if assigned(ParentNode) then
            with PFolderItemData(ParentNode.Data)^ do
              FQ_List := ConcatPIDLs(FQ_IDList, List)
          else
            FQ_List := ConcatPIDLs(NIL, List);

          AddNode(Folder, FQ_List, List, ParentNode);
        end; {while}
      finally
        EnumList.Release;
      end;
    end else
      // Maybe an event for this???  No items to enum when there should be.
      ;
  finally
    // always protect this stuff to make sure it gets reset.
    Items.EndUpdate;
    Cursor := OldCursor;
  end;
end;

function TSystemListView.AddNode(const ShellFolder: IShellFolder;
                                 FQ_IDList, IDList: PItemIDList;
                                 const ParentNode: TTreeNode): TListItem;
var
  NiceName: string;
  Normal,
  Selected: integer;
  FullPath: array[0..MAX_PATH] of char;
  FI: TSHFileInfo;
  SysTime: TSystemTime;
  DateStr,
  TimeStr: string;
  Attrs: UINT;
  FD: TWin32FindData;
  DI: TSHDescriptionID;
  Res: HResult;
begin
  Result := NIL;
  if GetNiceName(ShellFolder, IDList, SHGDN_NORMAL, NiceName) then begin
    Result := Items.Add;
    Attrs := SFGAO_CAPABILITYMASK or SFGAO_DISPLAYATTRMASK or SFGAO_CONTENTSMASK;
    ShellFolder.GetAttributesOf(1, IDList, Attrs);
    Result.Data := AddItemData(ShellFolder, IDList, FQ_IDList, Attrs);
    GetNormalAndSelectedIcons(FQ_IDList, Normal, Selected);
    Result.ImageIndex := Normal;
//    Result.SelectedIndex := Selected;
    Result.Caption := NiceName;
// This needs to be different for types other than files...

    // If you get a compiler error here, check step five in ShellFix.txt.  It is new.
    Res := SHGetDataFromIDList(ShellFolder, IDList, SHGDFIL_DESCRIPTIONID, DI, SizeOf(DI));

    if Res = E_INVALIDARG then
      DI.dwDescriptionID := SHDID_FS_FILE // I think this call is only working on NT 4.0.
    else
      if not DESCR_FLAG then
        ShowMessage('Something unexpected, but very interesting, has happened.'#13 +
                    'Please email me (bstowers@pobox.com) with information on what'#13 +
                    'operating system you are using, including service packs, etc.'#13 +
                    'Also, please send the file date and time of your Shell32.dll file.')
      else
        DESCR_FLAG := TRUE;

    case DI.dwDescriptionID of
      SHDID_FS_FILE,
      SHDID_FS_DIRECTORY,
      SHDID_FS_OTHER:
        begin
          if SHGetPathFromIDList(FQ_IDList, FullPath) then begin
            if SUCCEEDED(SHGetDataFromIDList(ShellFolder, IDList, SHGDFIL_FINDDATA, FD, SizeOf(FD))) then begin

              // size in KBs
              Result.SubItems.Add(IntTOStr((FD.nFileSizeLow+1023) div 1024) + 'KB');

              // type
              if SHGetFileInfo(FullPath, 0, FI, SizeOf(FI), SHGFI_TYPENAME) <> 0 then
                Result.SubItems.Add(FI.szTypeName)
              else
                Result.SubItems.Add(''); // couldn't get type.

              // date / time
              FileTimeToSystemTime(FD.ftLastWriteTime, SysTime);
              SetLength(DateStr, 256);
              SetLength(DateStr, GetDateFormat(LOCALE_USER_DEFAULT, 0, @SysTime, NIL,
                                               PChar(DateStr), 255) - 1);
              SetLength(TimeStr, 256);
              SetLength(TimeStr, GetTimeFormat(LOCALE_USER_DEFAULT, 0, @SysTime, NIL,
                                               PChar(TimeStr), 255)  - 1);
  (**)
              Result.SubItems.Add(DateStr + ' ' + TimeStr);
            end;  
          end;
        end;

      SHDID_COMPUTER_DRIVE35,
      SHDID_COMPUTER_DRIVE525,
      SHDID_COMPUTER_REMOVABLE,
      SHDID_COMPUTER_FIXED,
      SHDID_COMPUTER_NETDRIVE,
      SHDID_COMPUTER_CDROM,
      SHDID_COMPUTER_RAMDISK,
      SHDID_COMPUTER_OTHER:
        begin
          Result.SubItems.Add('Computer');
        end;

      SHDID_NET_DOMAIN,
      SHDID_NET_SERVER,
      SHDID_NET_SHARE,
      SHDID_NET_RESTOFNET,
      SHDID_NET_OTHER:
        begin
          Result.SubItems.Add('Net');
        end;

    else { don't know what to do with it... }
    end;
  end; {if}
end; {AddEnumItem}


function TSystemListView.AddItemData(ItemFolder: IShellFolder; aIDList,
                                 aFQ_IDList: PItemIDList; Attrs: UINT): PFolderItemData;
var
  FolderData: PFolderItemData;
begin
  GetMem(FolderData, SizeOf(TFolderItemData));
  with FolderData^ do begin
    Initialized := FALSE;
    SFParent := ItemFolder;
    SFParent.AddRef;
    IDList := aIDList;
    FQ_IDList := aFQ_IDList;
    Attributes := Attrs;
  end;
  Result := FolderData;
  inc(NewCount);
end; {AddItemDta}


procedure TSystemListView.FreeItemData(Item: TListItem);
begin
  if Item.Data <> NIL then begin
    with GetItemData(Item)^ do begin
      if SFParent <> NIL then
        SFParent.Release;
      if IDList <> NIL then
        FShellMalloc.Free(IDList);
      if FQ_IDList <> NIL then
        FShellMalloc.Free(FQ_IDList);
    end;
    FreeMem(Item.Data, SizeOf(TFolderItemData));
    Item.Data := NIL;
    dec(NewCount);
  end;
end; {FreeItemData}


procedure TSystemListView.FreeAllItemData;
var
  x: integer;
begin
  for x := 0 to Items.Count-1 do
    FreeItemData(Items[x]);
end; {FreeAllItemData}

(*****************************************************************************************
  CNNotify:  Trap notification messages sent to the window.
    This is damn silly, but it's the only way we can know when an itemis being deleted.
    I think it's an oversight in the VCL, so until Borland fixes it, just live with it.
*****************************************************************************************)
procedure TSystemListView.CNNotify(var Message: TWMNotify);
begin
  if Message.NMHdr.code = LVN_DELETEITEM then begin
     with PNMListView(Pointer(Message.NMHdr))^ do
       FreeItemData(TListItem(lParam));
    // we can't do the actual delete processing here because we don't have access to
    // some of the stuff needed.  Let default handling do it below.
  end;

  inherited;
end; {CNNotify}


function TSystemListView.GetItemData(Item: TListItem): PFolderItemData;
begin
  Result := Item.Data;
  if Result = NIL then begin
    if FShowErrorsInMsgBox then
      MessageDlg(LoadStr(IDS_NOFOLDERDATA), mtError, [mbOK], 0)
    else
      raise ENoFolderData.Create(LoadStr(IDS_NOFOLDERDATA));
  end
end;

procedure TSystemListView.SetColumnWidths(NameWidth, SizeWidth, TypeWidth,
                                          ModifiedWidth: integer);
begin
  with FColumnWidths do begin
    cwName := NameWidth;
    cwSize := SizeWidth;
    cwType := TypeWidth;
    cwModified := ModifiedWidth;
  end;
end;

(*****************************************************************************************
  DisplayContextMenu:
*****************************************************************************************)
function TSystemListView.DisplayContextMenu(Item: TListItem; Where: TPoint): boolean;
var
  ContextMenu: IContextMenu;
  Popup: HMenu;
  ICI: TCMInvokeCommandInfo;
  CmdID: integer;
  Res: HResult;
  ItemData: PFolderItemData;
  OldCursor: TCursor;
begin
  Result := FALSE;

  OldCursor := Cursor;
  Cursor := crHourglass;

  try
    ItemData := GetItemData(Item);
    Res := ItemData.SFParent.GetUIObjectOf(GetValidHandle, 1, ItemData.IDList, IID_IContextMenu,
                                           NIL, pointer(ContextMenu));

    if SUCCEEDED(Res) then begin
      Popup := CreatePopupMenu;
      try
        // Get the context menu for the item.
        Res := ContextMenu.QueryContextMenu(Popup, 0, 1, $7FFF, CMF_EXPLORE);
        if SUCCEEDED(Res) then begin
          // As near as I can tell, typecasting this to an integer is undocumented, but
          // the two sources I have both do it, and it seems to work fine.
          CmdID := integer(TrackPopupMenu(Popup, TPM_LEFTALIGN or TPM_RETURNCMD or
                            TPM_RIGHTBUTTON, Where.X, Where.Y, 0, GetValidHandle, NIL));

          if CmdID <> 0 then begin
            // Execute command that was selected.
            with ICI do begin
              cbSize := SizeOf(TCMInvokeCommandInfo);
              fMask := 0;
              hwnd := GetValidHandle;
              lpVerb := MakeIntResource(CmdID-1);
              lpParameters := NIL;
              lpDirectory := NIL;
              nShow := SW_SHOWNORMAL;
              dwHotKey := 0;
              hIcon := 0;
            end; // with

            Res := ContextMenu.InvokeCommand(ICI);
            Result := SUCCEEDED(Res);
            // Sometimes this reports failure even though it succeeded...  Guess I should
            // get rid of the check here.  Damn...
            if not Result then begin
              if FShowErrorsInMsgBox then
                MessageDlg(FmtLoadStr(IDS_INVOKEFAILED,[Res]), mtError, [mbOK], 0)
              else
                raise EInvokeFailed.Create(FmtLoadStr(IDS_INVOKEFAILED,[Res]));
            end;
          end; // if
        end // if
      finally
        DestroyMenu(Popup);
        ContextMenu.Release;
      end; // try
    end // if
    else begin
      if FShowErrorsInMsgBox then
        MessageDlg(FmtLoadStr(IDS_NOUIOBJECT,[Res]), mtError, [mbOK], 0)
      else
        raise ENoUIObject.Create(FmtLoadStr(IDS_NOUIOBJECT,[Res]));
    end;
//  end; // with
  finally
    Cursor := OldCursor;
  end;
end;


procedure TSystemListView.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  SelItem: TListItem;
begin
  inherited MouseDown(Button, Shift, X, Y);
  if PopupMenu = NIL then begin
    if ssRight in Shift then begin
      SelItem := GetItemAt(X, Y);
      if SelItem <> NIL then begin
        Selected := SelItem;
        DisplayContextMenu(SelItem, ClientToScreen(Point(X, Y)));
      end;
    end;
  end;
end;





{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}
{---------------------------------------------------------------------------------------}



{$IFDEF STV_SYSCOMBOBOX}
constructor TSystemComboBox.Create(AOwner: TComponent);
var
 SysIL: HImageList;
 SFI: TSHFileInfo;
begin
  inherited Create(AOwner);
  Style := csOwnerDrawFixed;
  FItemType := scbSystem;
  { Create the image list.  We don't really "create" one.  We fool SHGetFileInfo into
    giving us the system's image list and use it's handle.  You'd think it would be
    easier to get the handle of the system image list....                              }
  FImages := TImageList.Create(Self);
  SysIL := SHGetFileInfo('', 0, SFI, SizeOf(SFI), SHGFI_SYSICONINDEX or SHGFI_SMALLICON);
  if SysIL <> 0 then begin
    FImages.Handle := SysIL;
    FImages.ShareImages := TRUE;  // DON'T FREE THE SYSTEM IMAGE LIST!!!!!  BAD IDEA (tm)!
  end;
end;

destructor TSystemComboBox.Destroy;
begin
  // Free the image list object.  Doesn't release the image list handle because it
  // doesn't belong to us, but the system.  Go ahead, delete the handle and see what
  // happens....  :)   It won't crash anything, but Explorer will look a bit strange.
  FImages.Free;

  inherited Destroy;
end;

procedure TSystemComboBox.CreateWnd;
begin
  inherited CreateWnd;
  Reset;
end;

{procedure TSystemComboBox.DestroyWnd;
begin
  FreeAllItemData;
  inherited DestroyWnd;
end;}
procedure TSystemComboBox.WMDestroy(var Message: TWMDestroy);
begin
  FreeAllItemData;
  inherited;
end;


procedure TSystemComboBox.SetItemType(Val: TSCBType);
begin
  if Val = FItemType then exit;
  FItemType := Val;
  Reset;
end;

procedure TSystemComboBox.Reset;
var
  SubFolder: IShellFolder;
begin
  if not HandleAllocated then
    exit;
  ItemIndex := -1;
  FreeAllItemData;
  Items.Clear;
  // temp
  case FItemType of
    scbDrives:
  else //scbSystem
    SHGetDesktopFolder(SubFolder);
    EnumerateFolders(SubFolder, NIL);
    SubFolder.Release;
  end;
end;

function TSystemComboBox.EnumerateFolders(const ShellFolder: IShellFolder;
                                          ParentItem: PFolderItemData): boolean;
var
  Flags: DWORD;
  EnumList: IEnumIDList;
  FQ_List,
  List: PItemIDList;
  Fetched: Longint;
begin
  Result := FALSE;
  if not HandleAllocated then exit;
  Flags := SHCONTF_FOLDERS or SHCONTF_INCLUDEHIDDEN;
  if SUCCEEDED(ShellFolder.EnumObjects(Handle, Flags, EnumList)) then begin
    // Walk the folders.
    try
      // The list will be saved so don't free it anywhere in here.
      while EnumList.Next(1, List, Fetched) = S_OK do begin
        Result := TRUE;  // only successful if we managed to enumerate at least once.
        if assigned(ParentItem) then
          with ParentItem^ do
            FQ_List := ConcatPIDLs(FQ_IDList, List)
        else
          FQ_List := ConcatPIDLs(NIL, List);

        if assigned(ParentItem) then
          AddItem(ShellFolder, FQ_List, List, ParentItem^.Indent+1)
        else
          AddItem(ShellFolder, FQ_List, List, 0);
      end; {while}
    finally
      EnumList.Release;
    end;
  end else
    // Maybe an event for this???  No items to enum when there should be.
    ;
end;

procedure TSystemComboBox.MeasureItem(Index: Integer; var Height: Integer);
begin
  Height := Canvas.TextHeight(Items[Index]);
  if FImages.Height > Height then
    Height := FImages.Height;
end;

procedure TSystemComboBox.DrawItem(Index: Integer; Rect: TRect; State: TOwnerDrawState);
begin
  if odSelected in State then
    FImages.DrawingStyle := dsSelected
  else if odFocused in State then
    FImages.DrawingStyle := dsFocus
  else
    FImages.DrawingStyle := dsNormal; //dsTransparent
  with Canvas do begin
    FillRect(Rect);
    FImages.Draw(Canvas, Rect.Left + 2, Rect.Top,
                 PFolderItemData(Items.Objects[Index]).Normal);
{      BrushCopy(Bounds(Rect.Left + 2, Rect.Top, FImages.Width, FImages.Height, Bmp,
                       Bounds(0, 0, FImages.Width, FImages.Height), FImages.BkColor);}
    TextOut(Rect.Left + FImages.Width + 6, Rect.Top, Items[Index]);
  end;
end;


procedure TSystemComboBox.AddItem(const ShellFolder: IShellFolder;
                                  FQ_IDList, IDList: PItemIDList; Indent: UINT);
var
  NiceName: string;
  Attrs: UINT;
begin
  if GetNiceName(ShellFolder, IDList, SHGDN_NORMAL, NiceName) then begin
    Attrs := SFGAO_CAPABILITYMASK or SFGAO_DISPLAYATTRMASK or SFGAO_CONTENTSMASK;
    ShellFolder.GetAttributesOf(1, IDList, Attrs);
    Items.AddObject(NiceName,
                    Pointer(AddItemData(ShellFolder, IDList, FQ_IDList, Attrs, Indent)));
  end; {if}
end;

function TSystemComboBox.AddItemData(ItemFolder: IShellFolder; aIDList,
                    aFQ_IDList: PItemIDList; Attrs: UINT; aIndent: UINT): PFolderItemData;
begin
  GetMem(Result, SizeOf(TFolderItemData));
  with Result^ do begin
    Initialized := FALSE;
    SFParent := ItemFolder;
    SFParent.AddRef;
    IDList := aIDList;
    FQ_IDList := aFQ_IDList;
    Attributes := Attrs;
    GetNormalAndSelectedIcons(aFQ_IDList, Normal, Selected);
    Indent := Indent;
  end;
  inc(NewCount);
end; {AddItemDta}

procedure TSystemComboBox.FreeItemData(Item: integer);
begin
  if Items.Objects[Item] <> NIL then begin
    with GetItemData(Item)^ do begin
      if SFParent <> NIL then
        SFParent.Release;
      if IDList <> NIL then
        FShellMalloc.Free(IDList);
      if FQ_IDList <> NIL then
        FShellMalloc.Free(FQ_IDList);
    end;
    FreeMem(PFolderItemData(Items.Objects[Item]), SizeOf(TFolderItemData));
    Items.Objects[Item] := NIL;
    dec(NewCount);
  end;
end;

procedure TSystemComboBox.FreeAllItemData;
var
  x: integer;
begin
  for x := 0 to Items.Count-1 do
    FreeItemData(x);
end;

function TSystemComboBox.GetItemData(Item: integer): PFolderItemData;
begin
  Result := PFolderItemData(Items.Objects[Item])
{  if Result = NIL then begin
    if FShowErrorsInMsgBox then
      MessageDlg(LoadStr(IDS_NOFOLDERDATA), mtError, [mbOK], 0)
    else
      raise ENoFolderData.Create(LoadStr(IDS_NOFOLDERDATA));
  end}
end;

{$ENDIF}


(* Delphi and DCC32.EXE, probably the same anyway, will blow up if you do any {$IFDEF}s
   in the initialization or finalization sections.                                      *)
initialization
  DESCR_FLAG := FALSE;
  NewCount := 0;
  // Get the shell memory allocation interface that everyone uses.
  SHGetMalloc(FShellMalloc);

finalization
  // Release the shell memory allocation interface.
  FShellMalloc.Release;

  // You might want to take this out for production releases.  I wanted to do it with
  // an {$IFDEF}, but the compiler is nasty about it (see above comment).
  if NewCount > 0 then
    raise ELeaking.Create(MEMLEAK_STR);

end.

