unit f_SysInf;

(*******************************************************************************

 Name:     F_SysInf.Pas
 Project:  TSysInfo component stuff
 Version:  1.4
 Coder:    Christophe Porteneuve aka TDD
           URL: http://www.epita.fr/~porten_c - E-mail: porten_c@epita.fr

 Started:  12/16/97
 Effici.:  12/16/97
 Latest:   03/19/98

 ** SPANISH FORM **

 ******************************************************************************)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons;

type
  TfrmSysInfo = class(TForm)
    pnlMain: TPanel;
    // Version information
    gbxVersion: TGroupBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lblPlatform: TLabel;
    lblBuild: TLabel;
    lblVersion: TLabel;
    // General information
    gbxGeneral: TGroupBox;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    lblWinDir: TLabel;
    lblComputername: TLabel;
    lblUsername: TLabel;
    // Memory information
    gbxMemory: TGroupBox;
    gbxPhysical: TGroupBox;
    gbxPageFile: TGroupBox;
    gbxVirtual: TGroupBox;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    lblAvlPhys: TLabel;
    lblTotPhys: TLabel;
    lblMemLoad: TLabel;
    Label11: TLabel;
    lblTotPage: TLabel;
    Label13: TLabel;
    lblAvlPage: TLabel;
    lblPagRate: TLabel;
    Label24: TLabel;
    Label12: TLabel;
    lblTotVirt: TLabel;
    Label15: TLabel;
    lblAvlVirt: TLabel;
    // Processor(s) information
    gbxProcessors: TGroupBox;
    lblNbProcs: TLabel;
    Label14: TLabel;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    cbxActiveProcs: TComboBox;
    lblProcArchi: TLabel;
    lblProcType: TLabel;
    // Disks & Volumes information
    gbxDisksVols: TGroupBox;
    cbxDrives: TComboBox;
    Label19: TLabel;
    gbxVolInfo: TGroupBox;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    lblVolName: TLabel;
    lblVolSerial: TLabel;
    lblAcceptLN: TLabel;
    gbxFileSystem: TGroupBox;
    chkPreserve: TCheckBox;
    chkCase: TCheckBox;
    chkFileComp: TCheckBox;
    chkUnicode: TCheckBox;
    chkCompress: TCheckBox;
    gbxDiskInfo: TGroupBox;
    Label4: TLabel;
    Label23: TLabel;
    Label25: TLabel;
    Label26: TLabel;
    lblDiskFree: TLabel;
    lblDiskTotal: TLabel;
    lblSPC: TLabel;
    lblBPS: TLabel;
    procedure cbxDrivesChange(Sender: TObject);
  private
    OldDrive: Integer;
		procedure InitDiskVolInfo;
		procedure InitGeneralInfo;
		procedure InitMemoryInfo;
		procedure InitProcInfo;
		procedure InitVersionInfo;
		procedure UpdateDiskVolInfo;
	public
		procedure FillUp(AComponent: TComponent);
  end; // TfrmSysInfo

var
	frmSysInfo: TfrmSysInfo;

implementation

{$R *.DFM}

uses SysInfo;

const
	BOOL_STRS: array[boolean] of string = ('No','Si');

var
  ASysInfo: TSysInfo;

procedure TfrmSysInfo.InitDiskVolInfo;
var
	p,
	i: Integer;
	s: string;
	c: char;
begin
	p := 2;
	with ASysInfo do
	begin
		// Drives list combo box
		cbxDrives.Clear;
		for i := 0 to DriveTypes.Count-1 do
		begin
			s := DriveTypes[i];
			c := s[1];
			System.Delete(s,1,pos('=',s));
			cbxDrives.Items.Add(c+': ('+s+')');
			If c = 'C' Then P := i;
		end;
		cbxDrives.ItemIndex := p;
		OldDrive := 1;
		UpdateDiskVolInfo;
	end; // with ASysInfo
end; // InitDiskVolInfo

procedure TfrmSysInfo.InitGeneralInfo;
begin
	with ASysInfo do
	begin
		lblUsername.Caption := UserName;
		lblComputername.Caption := ComputerName;
		lblWinDir.Caption	:= WinDir;
	end;
end; // InitGeneralInfo

procedure TfrmSysInfo.InitMemoryInfo;
begin
	with ASysInfo.MemoryInfo do
	begin
		lblTotPhys.Caption := Format('%.2f',[TotalPhysical])+' Mb';
		lblAvlPhys.Caption := Format('%.2f',[AvailPhysical])+' Mb';
		lblMemLoad.Caption := IntToStr(MemoryLoad)+' %';
		lblTotPage.Caption := Format('%.2f',[TotalPageFile])+' Mb';
		lblAvlPage.Caption := Format('%.2f',[AvailPageFile])+' Mb';
		lblPagRate.Caption := IntToStr(PageFileRatio)+' %';
		lblTotVirt.Caption := Format('%.2f',[TotalVirtual])+' Mb';
		lblAvlVirt.Caption := Format('%.2f',[AvailVirtual])+' Mb';
	end;
end; // InitMemoryInfo

procedure TfrmSysInfo.InitProcInfo;
var
	i: Integer;
begin
	with ASysInfo.Processors do
	begin
		lblNbProcs.Caption 		:= IntToStr(Number);
		lblProcArchi.Caption	:= Architecture;
		lblProcType.Caption		:= Kind;
		with cbxActiveProcs do
		begin
			Clear;
			for i := 0 to 31 do
				if ActiveProcessors[i] then
					Items.Add('Procesador ' + IntToStr(i));
			if (Items.Count > 0) then
				ItemIndex := 0;
		end;
	end;
end; // InitProcInfo

procedure TfrmSysInfo.InitVersionInfo;
begin
	with ASysInfo.Version do
	begin
		lblVersion.Caption  := Full;
		lblBuild.Caption	  := IntToStr(Build);
		lblPlatform.Caption := Platform;
	end;
end; // InitVersionInfo

procedure TfrmSysInfo.UpdateDiskVolInfo;
begin
	try
		ChDir(Copy(cbxDrives.Text,1,2)+'\');
	except
		MessageDlg('La unidad ' + Copy(cbxDrives.Text,1,2) + ' no es accesible.', mtError, [mbOk], 0);
		cbxDrives.ItemIndex := OldDrive;
		Exit;
	end;
	OldDrive := cbxDrives.ItemIndex;
	with ASysInfo.VolumeInfo do
	begin
		Update;
		lblVolName.Caption  	:= VolumeName;
		lblVolSerial.Caption	:= Serial;
		lblAcceptLN.Caption 	:= BOOL_STRS[LongNames];
		gbxFileSystem.Caption := 'FileSystem: '+FileSystemName;
		chkPreserve.Checked 	:= (ffCasePreserved in FileSystemInfo);
		chkCase.Checked 			:= (ffCaseSensitive in FileSystemInfo);
		chkUnicode.Checked 		:= (ffUnicodeStored in FileSystemInfo);
		chkFileComp.Checked 	:= (ffFileCompression in FileSystemInfo);
		chkCompress.Checked 	:= (ffCompressedVolume in FileSystemInfo);
	end;
	with ASysInfo.DiskInfo do
	begin
		Update;
		lblBPS.Caption := IntToStr(BytesPerSector);
		lblSPC.Caption := IntToStr(SectorsPerCluster);
		lblDiskTotal.Caption := DiskTotalSpace;
		lblDiskFree.Caption	 := DiskFreeSpace;
	end;
end; // UpdateDiskVolInfo

procedure TfrmSysInfo.FillUp(AComponent: TComponent);
begin
	if AComponent is TSysInfo then
	begin
		ASysInfo := AComponent as TSysInfo;
		ASysInfo.Update;
		InitGeneralInfo;
		InitVersionInfo;
		InitDiskVolInfo;
		InitMemoryInfo;
		InitProcInfo;
	end;
end; // FillUp

//*************************** Evenemential code ********************************

procedure TfrmSysInfo.cbxDrivesChange(Sender: TObject);
begin
	UpdateDiskVolInfo;
end; // cbxDrivesChange

end.
