unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Grids, strgrdex;

type
  TfrmMain = class(TForm)
    cmdGetStatus: TButton;
    cmdSelect: TButton;
    cmdUnselect: TButton;
    cmdShowSelectCount: TButton;
    cmdRefresh: TButton;
    cmdExit: TButton;
    gridDemo: TStringGridEx;
    procedure cmdGetStatusClick(Sender: TObject);
    procedure cmdUnselectClick(Sender: TObject);
    procedure cmdSelectClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cmdShowSelectCountClick(Sender: TObject);
    procedure cmdRefreshClick(Sender: TObject);
    procedure cmdExitClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

procedure TfrmMain.cmdGetStatusClick(Sender: TObject);
begin
     if gridDemo.GetSelectRow(1)=true then
       ShowMessage('1st Row Is Selected')
     else
       ShowMessage('1st Row Is Not Selected');
end;

procedure TfrmMain.cmdUnselectClick(Sender: TObject);
begin
     gridDemo.SetSelectRow(1,False);
end;

procedure TfrmMain.cmdSelectClick(Sender: TObject);
begin
     gridDemo.SetSelectRow(1,true);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
   idx:integer;
begin
     gridDemo.Align:=alLeft;
     gridDemo.RowCount:=30;
     For idx:= 0 to 29 do
         gridDemo.Cells[0,idx]:=IntToStr(idx);
     gridDemo.MultiSelect:=True;
     gridDemo.Cells[3,3]:='Hello';
     gridDemo.Color:=clBtnFace;
     gridDemo.CTL3D:=True;
end;

procedure TfrmMain.cmdShowSelectCountClick(Sender: TObject);
begin
     ShowMessage(IntToStr(gridDemo.GetSelectRowCount));
end;

procedure TfrmMain.cmdRefreshClick(Sender: TObject);
begin
     gridDemo.Refresh;
end;

procedure TfrmMain.cmdExitClick(Sender: TObject);
begin
     Close;
end;

end.
