unit teststringdiff;

(* Test the string difference unit

   Barry Brannan, September 1997.
   barrylb@poboxes.com
   http://www.poboxes.com/barrylb

   To test...

   Type text into "Original" edit box.
   Type text into "Second" edit box.
   Press the "Compute Diff" button, and the "difference map" will be displayed.


   BINARY FILES:
         The diference routines work with Pascal long strings which means
         they can handle arbitrary binary files. However you must be careful
         when copying between Windows edit controls and similar data storage
         because the string is truncated at the first null.

         Use the LoadStringFromFile function below to load an arbitrary binary
         file into a string.

   BLOCK SIZE:
         Remember to adjust the block size depending on speed requirements and
         the size of the strings. There is a maximum of 65535 blocks in the
         original string. So
         * maximum string size for a block size of 1 is 65535
         * maximum string size for a block size of 2 is 65535*2
         * maximum string size for a block size of n is 65535*n

         Or, minimum block size for a string of length m is (1 + ((m-1) div 65535))

*)

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Label1: TLabel;
    Label2: TLabel;
    Memo2: TMemo;
    Memo3: TMemo;
    Label3: TLabel;
    Memo4: TMemo;
    Label4: TLabel;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

uses stringdiff;

function loadStringFromFile(filename: string): string;
var
   f: file of char;
   temp_filemode: byte;
begin
     temp_filemode := filemode;
     assignFile(f, filename);
     filemode := 0; (* read-only *)
     reset(f);
     setLength(result, fileSize(f));
     blockRead(f, pChar(result)^, fileSize(f));
     closeFile(f);
     filemode := temp_filemode;
end;

procedure TForm1.Button1Click(Sender: TObject);
const
     BlockSize = 2;
var
   s1,s2,diff: string;
begin
     diff := computeDifference(blockSize,memo1.text,memo2.text);

     memo3.clear;
     memo3.lines.add('Original length = ' + inttostr(length(memo1.text)));
     memo3.lines.add('Second length = ' + inttostr(length(memo2.text)));
     memo3.lines.add('Diffmap length = ' + inttostr(length(diff)));
     memo3.lines.add(dumpDifference(diff));

     memo4.Text := extractDifference(memo1.text, diff);

end;

end.
