unit CB_Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SRChkBox, StdCtrls, ExtCtrls, SRLabel, Spin;

type
  TMainForm = class(TForm)
    SRCheckBox: TSRCheckBox;
    Shape: TShape;
    CBAllowGrayed: TCheckBox;
    ComboStyle: TComboBox;
    Label1: TLabel;
    SpinCheckSize: TSpinEdit;
    Label2: TLabel;
    CBAutoSize: TCheckBox;
    CBTransparent: TCheckBox;
    SpinSpacing: TSpinEdit;
    Label3: TLabel;
    CBWordWrap: TCheckBox;
    procedure SRCheckBoxClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure CBAllowGrayedClick(Sender: TObject);
    procedure CBAutoSizeClick(Sender: TObject);
    procedure CBTransparentClick(Sender: TObject);
    procedure CBWordWrapClick(Sender: TObject);
    procedure ComboStyleChange(Sender: TObject);
    procedure SpinCheckSizeChange(Sender: TObject);
    procedure SpinSpacingChange(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure SetCheckBoxSize;
  public
    { Public-Deklarationen }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.SetCheckBoxSize;
begin
  if not CBAutoSize.Checked then begin
    if CBWordWrap.Checked then
      SRCheckBox.SetBounds(8, 4, 200, 70)
    else
      SRCheckBox.SetBounds(8, 4, 360, 70);
  end
  else begin
    SRCheckBox.AutoSize:=false;
    SRCheckBox.Width:=200;
    SRCheckBox.AutoSize:=true;
  end;
end;

procedure TMainForm.SRCheckBoxClick(Sender: TObject);
begin
  MessageBeep(0);
end;

procedure TMainForm.CBAllowGrayedClick(Sender: TObject);
begin
  SRCheckBox.AllowGrayed:=CBAllowGrayed.Checked;
end;

procedure TMainForm.CBAutoSizeClick(Sender: TObject);
begin
  SRCheckBox.AutoSize:=CBAutoSize.Checked;
  SetCheckBoxSize;
end;

procedure TMainForm.CBTransparentClick(Sender: TObject);
begin
  SRCheckBox.Transparent:=CBTransparent.Checked;
  Shape.Visible:=CBTransparent.Checked;
end;

procedure TMainForm.CBWordWrapClick(Sender: TObject);
begin
  SRCheckBox.WordWrap:=CBWordWrap.Checked;
  SetCheckBoxSize;
end;

procedure TMainForm.ComboStyleChange(Sender: TObject);
begin
  SRCheckBox.Style:=TCheckStyle(ComboStyle.ItemIndex);
end;

procedure TMainForm.SpinCheckSizeChange(Sender: TObject);
begin
  SRCheckBox.CheckSize:=SpinCheckSize.Value;
end;

procedure TMainForm.SpinSpacingChange(Sender: TObject);
begin
  SRCheckBox.Spacing:=SpinSpacing.Value;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  CBAllowGrayed.Checked:=SRCheckBox.AllowGrayed;
  CBAutoSize.Checked:=SRCheckBox.AutoSize;
  CBTransparent.Checked:=SRCheckBox.Transparent;
  CBWordWrap.Checked:=SRCheckBox.WordWrap;
  ComboStyle.ItemIndex:=ord(SRCheckBox.Style);
  SpinCheckSize.Value:=SRCheckBox.CheckSize;
  SpinSpacing.Value:=SRCheckBox.Spacing;
end;

end.
