{
  Source Expert 1.0
  Expert Form

  Roman M. Mochalov
  E-mail: roman@infra.sar.nnov.ru
}

unit SrcFrm;

interface

uses
  Windows, ShellAPI, ShlObj, Messages, SysUtils, Classes, Controls, Forms,
  ComCtrls, Registry, Menus;

type

{ TSourceForm }

  TSourceForm = class(TForm)
    StatusBar: TStatusBar;
    TreeView: TTreeView;
    ImageList: TImageList;
    SourceMenu: TPopupMenu;
    SourceOpenItem: TMenuItem;
    SourceN1Item: TMenuItem;
    SourceExploreItem: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure TreeViewDblClick(Sender: TObject);
    procedure TreeViewMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SourceMenuPopup(Sender: TObject);
    procedure SourceOpenItemClick(Sender: TObject);
    procedure SourceExploreItemClick(Sender: TObject);
  private
    FRootDir: string;
    function GetNodeFile(Node: TTreeNode): string;
    procedure OpenNodeFile(Node: TTreeNode);
  protected
    procedure RefreshMenu;
    procedure RefreshView;
  end;

function SourceForm: TSourceForm;

implementation

uses ExptIntf;

{$R *.DFM}

var
  FSourceForm: TSourceForm = nil;

function SourceForm: TSourceForm;
begin
  if FSourceForm = nil then FSourceForm := TSourceForm.Create(nil);
  Result := FSourceForm;
end;

{ TSourceForm }

function TSourceForm.GetNodeFile(Node: TTreeNode): string;
begin
  Result := Node.Text;
  while Node.Parent <> nil do
  begin
    Node := Node.Parent;
    Result := Node.Text + '\' + Result;
  end;
  Result := FRootDir + '\Source\' + Result;
end;

procedure TSourceForm.OpenNodeFile(Node: TTreeNode);
var
  FileName: string;
  Wnd: HWND;
begin
  if Node <> nil then
  begin
    FileName := GetNodeFile(Node);
    if FileExists(FileName) then
    begin
      ToolServices.OpenFile(FileName);
      SetForegroundWindow(FindWindow('TEditWindow', nil));
    end;
  end;
end;

procedure TSourceForm.RefreshMenu;
var
  SysMenu: HMENU;
begin
  SysMenu := GetSystemMenu(Handle, False);
  DeleteMenu(SysMenu, SC_RESTORE, MF_BYCOMMAND);
  DeleteMenu(SysMenu, SC_MINIMIZE, MF_BYCOMMAND);
  DeleteMenu(SysMenu, SC_MAXIMIZE, MF_BYCOMMAND);
end;

procedure TSourceForm.RefreshView;
var
  SCursor: TCursor;

  function AddNode(const Name: string; Node: TTreeNode): TTreeNode;
  const
    Flags = SHGFI_ATTRIBUTES or SHGFI_DISPLAYNAME or
      SHGFI_ICON or SHGFI_SMALLICON or SHGFI_SYSICONINDEX;
  var
    Info: TSHFileInfo;
    Handle: THandle;
  begin
    Result := TreeView.Items.AddChild(Node, ExtractFileName(Name));
    Handle := SHGetFileInfo(PChar(Name), 0, Info, SizeOf(Info), Flags);
    if Handle <> 0 then
    begin
      if ImageList.Handle <> Handle then
      begin
        ImageList.Handle := Handle;
        ImageList.ShareImages := True;
      end;
      Result.Text := Info.szDisplayName;
      Result.Data := Pointer(Info.dwAttributes);
      Result.ImageIndex := Info.iIcon;
      Result.SelectedIndex := Info.iIcon;
    end;
  end;

  procedure SearchDir(const Dir: string; Node: TTreeNode);
  var
    SR: TSearchRec;
    FR: Integer;

    function IsFolder(const Name: string; Attr: Integer): Boolean;
    begin
      Result := (Name <> '.') and (Name <> '..') and (Attr and faDirectory <> 0);
    end;

  begin
    { Add Folders }
    FR := FindFirst(Dir + '\*.*', faAnyFile and not faVolumeId, SR);
    try
      while FR = 0 do
      begin
        if IsFolder(SR.Name, SR.Attr) then
        begin
          SR.Name := Dir + '\' + SR.Name;
          SearchDir(SR.Name, AddNode(SR.Name, Node));
        end;
        FR := FindNext(SR);
      end;
    finally
      FindClose(SR);
    end;
    { Add Files }
    FR := FindFirst(Dir + '\*.pas', faAnyFile and not faVolumeId, SR);
    try
      while FR = 0 do
      begin
        SR.Name := Dir + '\' + SR.Name;
        AddNode(SR.Name, Node);
        FR := FindNext(SR);
      end;
    finally
      FindClose(SR);
    end;
  end;

begin
  SCursor := Screen.Cursor;
  Screen.Cursor := crHourGlass;
  StatusBar.SimpleText := 'Updating view...';
  StatusBar.Update;
  try
    TreeView.Items.BeginUpdate;
    try
      TreeView.Items.Clear;
      Searchdir(FRootDir + '\Source', nil);
    finally
      TreeView.Items.EndUpdate;
    end;
  finally
    StatusBar.SimpleText := 'Ready';
    Screen.Cursor := SCursor;
  end;
end;

procedure TSourceForm.FormCreate(Sender: TObject);
const
  SDelphi2 = 'SOFTWARE\Borland\Delphi\2.0';
  SRootDir = 'RootDir';
begin
  with TRegIniFile.Create('') do
  try
    RootKey := HKEY_LOCAL_MACHINE;
    FRootDir := ReadString(SDelphi2, SRootDir, '');
  finally
    Free;
  end;
  RefreshView;
  RefreshMenu;
end;

procedure TSourceForm.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  case Key of
    VK_F5: RefreshView;
    VK_RETURN: OpenNodeFile(TreeView.Selected);
  end;
end;

procedure TSourceForm.TreeViewDblClick(Sender: TObject);
begin
  OpenNodeFile(TreeView.Selected);
end;

procedure TSourceForm.TreeViewMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Node: TTreeNode;
begin
  if Button = mbRight then
    with TreeView do
    begin
      Node := GetNodeAt(X, Y);
      Selected := Node;
    end;
end;

procedure TSourceForm.SourceMenuPopup(Sender: TObject);
var
  Node: TTreeNode;
  Attr: DWORD;
begin
  Node := TreeView.Selected;
  if Node <> nil then
    Attr := DWORD(Node.Data) else
    Attr := 0;
  SourceOpenItem.Enabled := (Attr <> 0) and (Attr and SFGAO_FOLDER = 0);
  SourceExploreItem.Enabled := (Attr <> 0) and (Attr and SFGAO_FOLDER <> 0);
end;

procedure TSourceForm.SourceOpenItemClick(Sender: TObject);
begin
  OpenNodeFile(TreeView.Selected);
end;

procedure TSourceForm.SourceExploreItemClick(Sender: TObject);
var
  Node: TTreeNode;
  FileName: string;
begin
  Node := TreeView.Selected;
  if Node <> nil then
  begin
    FileName := GetNodeFile(Node);
    ShellExecute(Handle, 'explore', PChar(FileName), nil, nil, SW_SHOW);
  end;
end;

initialization

finalization
  FSourceForm.Free;
  FSourceForm := nil;

end.
