{
  Source Expert 1.0
  
  Allow open *.pas files from Delphi 2.0 Source folder

  To install the Source Expert simply add it like you would a new
  component from the Components|Install menu

  Roman M. Mochalov
  E-mail: roman@infra.sar.nnov.ru
}

unit SrcExp;

interface

uses
  Forms, ExptIntf, ToolIntf, SrcFrm;

type

{ SourceExpert }

  SourceExpert = class(TIExpert)
  private
    FExpertItem: TIMenuItemIntf;
    procedure ExpertItemClick(Sender: TIMenuItemIntf);
  public
    constructor Create;
    destructor Destroy; override;
    function GetName: string; override;
    function GetStyle: TExpertStyle; override;
    function GetState: TExpertState; override;
    function GetIDString: string; override;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterLibraryExpert(SourceExpert.Create);
end;

{ SourceExpert }

const
  ExpertName = 'Source Expert v1.0 by Roman Mochalov';
  ExpertID= 'Roman Mochalov.Source Expert';

procedure HandleException;
begin
  ToolServices.RaiseException(ReleaseException);
end;

constructor SourceExpert.Create;
var
  MainMenu: TIMainMenuIntf;
  MenuItems, ViewObjInspItem, ViewMenu: TIMenuItemIntf;
begin
  inherited Create;
  MainMenu := ToolServices.GetMainMenu;
  if MainMenu <> nil then
  try
    MenuItems := MainMenu.GetMenuItems;
    if MenuItems <> nil then
    try
      ViewObjInspItem := MainMenu.FindMenuItem('ViewObjInspItem');
      if ViewObjInspItem <> nil then
      try
        ViewMenu := ViewObjInspItem.GetParent;
        if ViewMenu <> nil then
        try
          FExpertItem := ViewMenu.InsertItem(ViewObjInspItem.GetIndex + 1,
            'So&urce Inspector', 'ViewSrcInspItem', '', 0, 0, 0,
            [mfVisible, mfEnabled], ExpertItemClick);
        finally
          ViewMenu.Free;
        end;
      finally
        ViewObjInspItem.Free;
      end;
    finally
      MenuItems.Free;
    end;
  finally;
    MainMenu.Free;
  end;
end;

destructor SourceExpert.Destroy;
begin
  FExpertItem.Free;
  inherited Destroy;
end;

procedure SourceExpert.ExpertItemClick(Sender: TIMenuItemIntf);
begin
  try
    SourceForm.Show;
    SourceForm.SetFocus;
  except
    HandleException;
  end;
end;

function SourceExpert.GetName: String;
begin
  try
    Result := ExpertName;
  except
    HandleException;
  end;
end;

function SourceExpert.GetStyle: TExpertStyle;
begin
  try
    Result := esAddIn;
  except
    HandleException;
  end;
end;

function SourceExpert.GetState: TExpertState;
begin
  try
    Result := [esEnabled];
  except
    HandleException;
  end;
end;

function SourceExpert.GetIDString: string;
begin
  try
    Result := ExpertID;
  except
    HandleException;
  end;
end;

end.
