{This LookupComboBox like component is written for use with SQL
 statements like
   SELECT DISTINCT Field1, Field2,.. FieldN FROM Table1 ORDER BY Field1
 where Field1 contains values for DataField. This allows to insert values in
 table taken from itself.
 After selection other Query fields are available in manner
   MyField.AsString:=DBEditSQL.Query.FieldByName('Field2').asstring;
 it supports also incremental search through the first field and direct
 typing into Edit box.
 It is freeware, you can do with it what you want, but I give no warranty and don't
 support it, so use at your own risk.   }
unit SQLEdit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, dbgrids, db, dbtables, dbctrls, buttons;

type
  TPGrid=class(TDBGrid)
   Public
   Constructor Create(AOwner:Tcomponent); override;
   procedure CreateWnd; override;
  end;

  TDbEditSQL = class(TPanel)
  private
    { Private declarations }
    fdbedit:Tdbedit;
    fbutton:TSpeedButton;
    fgrid:TPGrid;
    fdsource:TDatasource;
    fondropdown:tnotifyevent;
    foncloseup:tnotifyevent;
    Procedure Clicking(Sender:TObject);
    Procedure Gclick(Sender:TColumn);
    Procedure DClick(Sender:TObject);
    Procedure GridShow;
    Procedure GridHide;
    procedure CMExit(var Message: TCMExit); message CM_EXIT;
  protected
    { Protected declarations }
    procedure setdataField(df:string);
    function  getdataField:string;
    procedure setdatatext(df:string);
    function  getdatatext:string;
    procedure setdataSource(ds:TDataSource);
    function  getdataSource:TDatasource;
    procedure setsql(ds:TStrings);
    function  getsql:TStrings;
    procedure setdataBase(ds:string);
    function  getdataBase:string;
    procedure KeyDownl(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Keypres(Sender: TObject; var Key: Char);
    Property DatabaseName:String read getDataBase write setDataBase;
  public
    { Public declarations }
    Query:TQuery;
    Constructor Create(AOwner:Tcomponent); override;
    Property caption;
    Property Text:string read GetDataText write SetDataText;
  published
    { Published declarations }
    Property DataField:string read getdataField write setDataField;
    Property DataSource:TDataSource read getDataSource write setDataSource;
    Property OnDropDown:Tnotifyevent read fondropdown write fondropdown;
    Property OnCloseUp:Tnotifyevent read fonCloseup write foncloseup;
    property SQL: TStrings read getsql write setsql; //Query.SQL
  end;

procedure Register;
{$R *.res}
implementation
Constructor TDbEditSQL.Create(AOwner:Tcomponent);
begin
 Inherited Create(AOwner);
 caption:='';
 height:=21;
 BorderStyle:=bsSingle;
 fbutton:=TSpeedbutton.Create(Self);
 fbutton.width:=height-4;
 fbutton.align:=alRight;
 fbutton.parent:=self;
 fbutton.visible:=true;
 fbutton.Glyph.Handle := LoadBitmap(0, PChar(32738));
 fbutton.onclick:=Clicking;
 fdbedit:=Tdbedit.Create(Self);
 fdbedit.align:=alClient;
 fdbedit.borderstyle:=bsNone;
 fdbedit.parent:=self;
 fdbedit.onkeydown:=keydownl;
 fdbedit.OnKeyPress:=keypres;
 Query:=TQuery.Create(Self);
 Query.active:=false;
 fdsource:=TDatasource.Create(Self);
 fdsource.dataset:=query;
 fgrid:=tPgrid.Create(self);
 fgrid.visible:=false;
 fgrid.readonly:=true;
 fgrid.tabstop:=false;
// fgrid.OnCellClick:=GClick;
 fgrid.OnDblClick:=DClick;
 fgrid.options:=[dgAlwaysShowSelection,dgColumnResize,dgColLines,dgRowLines,dgTabs,dgRowSelect,dgConfirmDelete,dgCancelOnExit];
 fgrid.DataSource:=fdsource;
end;

Procedure TDbEditSQL.GridShow;
var p:tpoint;
begin
 Query.DatabaseName:=(fdbedit.DataSource.DataSet as TDBDataSet).DatabaseName;
 if not Query.Active then Query.Open;
 if not (csDesigning in ComponentState) then Windows.SetParent(FGrid.Handle, 0);
 p.y:=height;
 p.x:=0;
 p:=Clienttoscreen(p);
 FGrid.top:=p.y-2;
 fgrid.left:=p.x-2;
 SetActiveWindow(FGrid.Handle);
 if not fgrid.visible then fgrid.visible:=true;
end;

Procedure TDbEditSQL.GridHide;
begin
if fgrid.visible then fgrid.visible:=false;
if Query.Active then Query.Close;
end;

procedure TDbEditSQL.setdataField(df:string);
var
    p:tpoint;
begin
 fdbedit.DataField:=df;
 fgrid.parent:=parent;
 if (csDesigning in ComponentState) then fgrid.height:=0 else
       fgrid.height:=127;
 fgrid.width:=width;
 p.y:=height;
 p.x:=0;
 p:=Clienttoscreen(p);
 FGrid.top:=p.y-2;
 fgrid.left:=p.x-2;
 fgrid.Visible:=false;
end;
function  TDbEditSQL.getdataField:string;
begin
 getdatafield:=fdbedit.DataField;
end;

procedure TDbEditSQL.setdatatext(df:string);
begin
 fdbedit.text:=df;
end;

function  TDbEditSQL.getdatatext:string;
begin
 getdatatext:=fdbedit.text;
end;

procedure TDbEditSQL.setdataSource(ds:tDatasource);
begin
 fdbedit.DataSource:=ds;
end;

function  TDbEditSQL.getdataSource:TDatasource;
begin
 getdataSource:=fdbedit.DataSource;
end;

procedure TDbEditSQL.setdataBase(ds:String);
begin
 Query.DatabaseName:=ds;
end;

function  TDbEditSQL.getdataBase:String;
begin
 getdataBase:=(fdbedit.DataSource.DataSet as TDBDataSet).DatabaseName;
end;

Procedure TDbEditSQL.Clicking(Sender:TObject);
begin
 if not(csdesigning in componentstate) then begin
 if fgrid.visible then gridhide else begin
     if assigned(fondropdown) then fondropdown(sender);
     gridshow end;
 fdbedit.setfocus;
 end;
end;

Procedure TDbEditSQL.Gclick(Sender:TColumn);
begin
 inherited;
// fdbedit.setfocus;
end;

Procedure TDbEditSQL.DClick(Sender:TObject);
begin
  if not( DataSource.DataSet.State in [dsEdit, dsinsert])  then
              DataSource.DataSet.Edit;
  DataSource.DataSet.Fieldbyname(DataField).asstring:=
         Query.{Fields.}Fields[0].asstring;
  if assigned(foncloseup) then foncloseup(sender);
  GridHide;
end;

procedure TDbEditSQL.setsql(ds:TStrings);
var wact:boolean;
begin
 wact:=query.active;
 if query.active then query.close;
 query.SQL:=ds;
 if query.databasename='' then
 query.databasename:=(fdbedit.DataSource.DataSet as TDBDataSet).DatabaseName;
 if (query.SQL.count>0)and wact then query.open;
end;

function  TDbEditSQL.getsql:TStrings;
begin
 getsql:=query.SQL;
end;

procedure TDbEditSQL.CMExit(var Message: TCMExit);
begin
 inherited;
 GridHide;
end;

procedure TDbEditSQL.KeyDownl(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if (Key in [VK_UP,VK_HOME, VK_END, VK_DOWN, VK_NEXT, VK_PRIOR]) then
  begin
    if not FGrid.Visible then begin
      if assigned(fondropdown) then fondropdown(sender);
      GridShow; end else
     case key of
      VK_HOME: Query.First;
      VK_UP  : Query.Prior;
      VK_DOWN: Query.Next;
      VK_END : Query.Last;
      end;
    if key in [VK_DOWN, VK_UP] then key:=0;
  end;
  if (Key in [VK_RETURN])and FGrid.Visible  then  begin
     if not( DataSource.DataSet.State in [dsEdit, dsinsert])  then
              DataSource.DataSet.Edit;
     DataSource.DataSet.Fieldbyname(DataField).asstring:=
         Query.{Fields.}Fields[0].asstring;
     if assigned(foncloseup) then foncloseup(sender);
     GridHide;
     end;
  if (Key in [VK_ESCAPE]) then
  begin
    if FGrid.Visible then GridHide;// else fdbedit.UnDo;
    key:=0;
  end;
  inherited KeyDown(Key, Shift);
end;
procedure TDbEditSQL.Keypres(Sender: TObject; var Key: Char);
var ss:string;
    SString:String;
begin
 if fgrid.visible then begin
  if fdbedit.SelLength=length(fdbedit.text) then
   SString:=Key else SString:=fdbedit.text+Key;
  ss:=Copy(Query.{Fields.}Fields[0].asstring,1,length(SString));
  if AnsiCompareText(SS,SString)<0 then begin
   repeat
    Query.Next;
    ss:=Copy(Query.{Fields.}Fields[0].asstring,1,length(SString));
   until (Query.EOF)or(AnsiCompareText(SS,SString)>=0);
   exit;
   end;
  if AnsiCompareText(SS,SString)>0 then begin
   repeat
    Query.Prior;
    ss:=Copy(Query.{Fields.}Fields[0].asstring,1,length(SString));
   until (Query.BOF)or(AnsiCompareText(SS,SString)<=0);
   if AnsiCompareText(SS,SString)<0 then Query.Next;
   end;
 end else inherited;
end;

Constructor TPGrid.Create(AOwner:Tcomponent);
begin
inherited;
 facquirefocus:=false;
end;
procedure TPGrid.CreateWnd;
begin
  inherited CreateWnd;
  if not (csDesigning in ComponentState) then Windows.SetParent(Handle, 0);
  CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);

end;

procedure Register;
begin
  RegisterComponents('My Data Controls', [TDbEditSQL]);
end;

end.
