unit Splites;
(***********************************************************************
 *                                                                     *
 *  Copyright (C) 1996-2000                                            *
 *  Erol S. Uzuner                                                     *
 *                                                                     *
 *  Modul       :       Splites                                        *
 *  Version     :       1.0 (14.04.00)                                 *
 *                                                                     *
 *  Beschreibung:      TSplitter Komponente (like java-JSplitPane)     *
 *                                                                     *
 *  Autor       :       Erol S. Uzuner                                 *
 *                                                                     *
 *  Datum       :       23.03.00  20:45:00 2000                        *
 *                                                                     *
 *                                                                     *
 *  Aenderungen :                                                      *
 *  Datum      Autor          Beschreibung                             *
 *  14.04.00  Erol S. Uzuner  Pattern bug on Win95/98, painting Pattern*
 *                            doesnt worked, pattern Bitmap size was 4,4*
 *                            filling with Brush.Bitmap works only with *
 *                            Bitmap size of 8,8. Doesnt know why.      *
 *                                                                      *
 *  14.04.00  Erol S. Uzuner  Added two propertys, ArrowPlace and       *
 *                            ArrowBackgr                               *
 ***********************************************************************)


interface
uses Windows, Controls, Graphics, Classes, extctrls;

type

   TArrowPlace = (apCenter, apLeftOrTop, apRightOrBottom);

   TSplites = class(TSplitter)
     private
       FPattern    : TBitmap;
       FArrows     : TBitmap;
       FArrowPlace : TArrowPlace;
       FArrowBackGr: Boolean;
      {dont want to overwrite setAlign, we check current Align with
       the last Align to paint the Arrows and the Pattern }
       FLastAlign : TAlign;
     protected
       procedure Paint; override;
       procedure CreatePatterns;
       procedure setArrowPlace(value : TArrowPlace);
       function getArrowPlace : TArrowPlace;
       procedure setArrowBackGr(value : Boolean);
       function getArrowBackGr : Boolean;

     public
       constructor Create(AOwner : TComponent); override;
       destructor Destroy; override;
     published
       property ArrowPlace : TArrowPlace read getArrowPlace write setArrowPlace default apCenter;
       property ArrowBackgr: Boolean read getArrowBackgr write setArrowBackGr  default true;
   end;

procedure Register;

implementation

const DEFAULT_WIDTH = 10; {Width or Height of Splitter}
      ARROW_WIDTH   = 24; // DONT CHANGE
      ARROW_HEIGHT  = 5;  // DONT CHANGE

procedure Register;
begin
  RegisterComponents('sarcon', [TSplites]);
end;

constructor TSplites.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  FPattern := TBitmap.Create;;
  FArrows  := TBitmap.Create;
  FArrowPlace := apCenter;
  FArrowBackgr := true;
  case Align of
    alLeft,  alRight : Width := DEFAULT_WIDTH;
    alTop, AlBottom  : Height := DEFAULT_WIDTH;
  end;
  FLastAlign := alClient; // we do this to force Pattern createing
end;

destructor TSplites.Destroy;
begin
  FPattern.Free;
  FArrows.Free;
  inherited Destroy;
end;

procedure TSplites.CreatePatterns;
const
  PointColor  = clWhite;
  ShadowColor = clGray;
var
  points     : array[0..4] of TPoint;
  bw, bh     : Integer;

  procedure PaintPattern;
  begin
    {Height and Width = 8, see Help, dont change,
     another values doesnt work under win95/98}
    FPattern.width  := 8;  FPattern.height := 8;
    with FPattern.Canvas do begin
      Brush.Color := Color;
      FillRect(Rect(0,0,4,4));
      Pixels[0,0] := PointColor;
      Pixels[1,1] := ShadowColor;
      Pixels[2,2] := PointColor;
      Pixels[3,3] := ShadowColor;
      {Copying painted part to the hole Bitmap, wee need this cause
       height and width of 4 doent works under win95/98}
       {   _________
          |  1 | 2  |   First copy 1 to 2
          |----|----|
          |  3 | 4  |   then copy 1&2 to 3&4
          -----------
       }
      CopyMode := cmSrcCopy;
       // Copying 1 to 2
      CopyRect(Bounds(4,0,4,4), FPattern.Canvas, Bounds(0,0,4,4));
      // Copying 1&2 to 3&4
      CopyRect(Bounds(0,4,8,4), FPattern.Canvas, Bounds(0,0,8,4));
    end;
  end;

  procedure PaintArrows;
  begin
    { Pfeile }
    case align of
      alLeft,
      alRight : begin
           bw := ARROW_HEIGHT; bh := ARROW_WIDTH;
           FArrows.width  := bw;  FArrows.height := bh;
           with FArrows.Canvas do begin
             Brush.Color := Color;
             FillRect(Rect(0,0,bw,bh));
           end;
           points[0] := Point(1, 3);
           points[1] := Point(3, 5);
           points[2] := Point(3, 7);
           points[3] := Point(1, 9);
           points[4] := Point(1, 3);
           with FArrows.Canvas do begin
             Brush.Color := ShadowColor;
             Pen.Color   := ShadowColor;
             Polygon(points);
             Pen.Color := clBlack;
             MoveTo(0,3); LineTo(0,11);
             Pen.Color := PointColor;
             MoveTo(1,10); LineTo(6,5); //5,6); //LineTo(3,6);
           end;

           points[0] := Point(3, 15);
           points[1] := Point(1, 17);
           points[2] := Point(1, 18);
           points[3] := Point(3, 20);
           points[4] := Point(3, 15);
           with FArrows.Canvas do begin
             Brush.Color := ShadowColor;
             Pen.Color   := ShadowColor;
             Polygon(points);
             Pen.Color := PointColor;
             MoveTo(4,14); LineTo(4,22);
             Pen.Color := clBlack;
             MoveTo(0,17); LineTo(4,13);
           end;

       end;
      alBottom,
      alTop    : begin
           bw := ARROW_WIDTH; bh := ARROW_HEIGHT;
           FArrows.width  := bw;  FArrows.height := bh;
           with FArrows.Canvas do begin
             Brush.Color := Color;
             FillRect(Rect(0,0,bw,bh));
           end;
           points[0] := Point(4, 3);
           points[1] := Point(5, 1);
           points[2] := Point(7, 1);
           points[3] := Point(9, 3);
           points[4] := Point(3, 3);
           with FArrows.Canvas do begin
             Brush.Color := ShadowColor;
             Pen.Color   := ShadowColor;
             Polygon(points);
             Pen.Color := PointColor;
             MoveTo(3,4); LineTo(11,4);
             Pen.Color := clBlack;
             MoveTo(2,3); LineTo(5,0); LineTo(7,0);
           end;

           points[0] := Point(15, 1);
           points[1] := Point(20, 1);
           points[2] := Point(18, 3);
           points[3] := Point(17, 3);
           points[4] := Point(15, 1);
           with FArrows.Canvas do begin
             Brush.Color := ShadowColor;
             Pen.Color   := ShadowColor;
             Polygon(points);
             Pen.Color := clBlack;
             MoveTo(14,0); LineTo(22,0);
             Pen.Color := PointColor;
             MoveTo(21,1); LineTo(17,5);
           end;
       end;
    end; {case}
  end;

begin
   PaintPattern;
   PaintArrows;
   FLastAlign := Align;
end;

procedure TSplites.Paint;
const
  XorColor = $00FFD8CE;
var
  FrameBrush : HBRUSH;
  R          : TRect;
  bw, bh     : Integer;

  procedure PaintPattern;
  begin
     FrameBrush := CreatePatternBrush(FPattern.Handle);
     FillRect(Canvas.Handle, R, FrameBrush);
     DeleteObject(FrameBrush);
  end;

  procedure PaintArrows;
  var tr, ar : TRect; {Arrow Rect}
      rh, rw : Integer;
  begin
    rw := R.Right - R.Left;
    rh := R.Bottom - R.Top;
    case Align of
      alLeft, alRight : begin
        bw := ARROW_HEIGHT; bh := ARROW_WIDTH;
        case FArrowPlace of
          apCenter        : ar:=Bounds( R.Left+((rw-bw) shr 1),
                                        R.Top +((rh-bh) shr 1), bw, bh);
          apLeftOrTop     : ar:=Bounds( R.Left+((rw-bw) shr 1),
                                        R.Top, bw, bh);

          apRightOrBottom : ar:=Bounds( R.Left  +((rw-bw) shr 1),
                                        R.Top+rh-bh, bw, bh);
        end;
       end;
      alBottom, alTop : begin
         bw := ARROW_WIDTH;  bh := ARROW_HEIGHT;
        case FArrowPlace of
          apCenter        : ar:=Bounds( R.Left+((rw-bw) shr 1),
                                        R.Top+((rh-bh) shr 1), bw, bh);
          apLeftOrTop     : ar:=Bounds( R.Left,
                                        R.Top+((rh-bh) shr 1), bw, bh);
          apRightOrBottom : ar:=Bounds( R.Left+rw-bw,
                                        R.Top+((rh-bh) shr 1), bw, bh);
        end;
       end;
    end;

    if FArrowBackGr then begin
      {Drawing Arrow Background, to overpaint the Point-Pattern}
      Canvas.Brush.Color := Color;
      tr := ar;
      case Align of
        alLeft, alRight : begin
            tr.Left := R.Left; tr.Right := R.Right;
          end;
        alBottom, alTop : begin
           tr.Top := R.Top; tr.Bottom := R.Bottom;
          end;
      end;
      Canvas.FillRect(tr); {Arrow Background}
    end;
    Canvas.CopyRect(ar, FArrows.Canvas, Bounds(0, 0, bw, bh));

    { Pfeile }
{    case align of
      alLeft,   alRight : InflateRect(R, -1, 0);
      alBottom, alTop   : InflateRect(R, 0, -1);
    end; }{case}
  end;

  procedure PaintBevel;
  begin
    if Align in [alLeft, alRight] then
         InflateRect(R, -1, 2)
    else InflateRect(R, 2, -1);
    OffsetRect(R, 1, 1);
    FrameBrush := CreateSolidBrush(ColorToRGB(clBtnHighlight));
    FrameRect(Canvas.Handle, R, FrameBrush);
    DeleteObject(FrameBrush);
    OffsetRect(R, -2, -2);
    FrameBrush := CreateSolidBrush(ColorToRGB(clBtnShadow));
    FrameRect(Canvas.Handle, R, FrameBrush);
    DeleteObject(FrameBrush);

  { Point-Pattern - Rect}
    R := ClientRect;
    case Align of
      alLeft,   alRight  : InflateRect(R, -4, -2);
      alBottom, alTop    : InflateRect(R, -2, -4);
      alClient           : InflateRect(R, -4, -4);
    end;
  end;

begin
  R := ClientRect;
  if Beveled then
    PaintBevel;
  if FLastAlign <> Align then
    CreatePatterns;
  { Painting Pattern}
  PaintPattern;
  { Pfeile Zeichnen , in dieser reihenfolge weil R wird verschoben}
  PaintArrows;

 { Umrahmung whrend des IDE-Designers }
  if csDesigning in ComponentState then
    { Draw outline }
    with Canvas do begin
      Pen.Style   := psDot;
      Pen.Mode    := pmXor;
      Pen.Color   := XorColor;
      Brush.Style := bsClear;
      Rectangle(0, 0, ClientWidth, ClientHeight);
    end;
  if Assigned(OnPaint) then OnPaint(Self);
end;

procedure TSplites.setArrowPlace(value : TArrowPlace);
begin
  if FArrowPlace <> value then begin
    FArrowPlace := value;
    invalidate;
  end;
end;

function TSplites.getArrowPlace : TArrowPlace;
begin Result := FArrowPlace;
end;

procedure TSplites.setArrowBackGr(value : Boolean);
begin
  if FArrowBackGr <> value then begin
    FArrowBackGr := value;
    invalidate;
  end;
end;

function TSplites.getArrowBackGr : Boolean;
begin Result := FArrowBackGr;
end;

end.
