unit fmSortPascal;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ExtCtrls;

type
  TfrmSortPascal = class(TForm)
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Open1: TMenuItem;
    Close1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Help1: TMenuItem;
    Contents1: TMenuItem;
    N2: TMenuItem;
    About1: TMenuItem;
    N3: TMenuItem;
    Sort1: TMenuItem;
    Panel1: TPanel;
    ListBox1: TListBox;
    Label1: TLabel;
    Panel2: TPanel;
    ListBox2: TListBox;
    Label2: TLabel;
    Label4: TLabel;
    Panel3: TPanel;
    ListBox3: TListBox;
    Label3: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Memo1: TMemo;
    procedure btnLoadFileClick(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure ListBox2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Open1Click(Sender: TObject);
    procedure Close1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Sort1Click(Sender: TObject);
    procedure ListBox3Click(Sender: TObject);
    procedure Contents1Click(Sender: TObject);
  private
    { Private declarations }
    procedure ProcessNewBlock(unit_line_number: integer);
    procedure ParseUnitHeader(unit_line_number: integer);
    function FindBegining(line_number: integer): integer;
    procedure WriteItOut;
    procedure SetUpLabels;
    procedure ResetVariables;
    procedure ShowLineNumberInHint(sender: TObject);
  public
    { Public declarations }
  end;

var
  frmSortPascal: TfrmSortPascal;
  imp_start, first_unit, unit_start, unit_end, end_statement: integer;
  code_line, unit_type, unit_object, unit_name, unsorted_filename: string;

implementation

uses fmAbout, fmHelp;

{$R *.DFM}


{**********************************************************************
 Returns the requested blank delimited word from the string passed
**********************************************************************}
function GetWord(s: string; w: integer): string;
var
  z, x: integer;

begin
  x := 0;
  result := '';
   for z := 1 to length(s) do
  begin
    if s[z] <> ' '
    then begin
           x := x + 1;
           if x = w
           then begin
                  for z := z to length(s) do
                  begin
                      if s[z] = ' ' then break;
                      result := result + s[z];
                  end;      // for z := z to length(s) do
                  exit;
                end
           else begin
                  for z := z to length(s) do
                  begin
                      if s[z] = ' ' then break;
                  end;      // for z := z to length(s) do
                end;
         end;
  end;      // for z := 1 to length(s) do
end;      // function word(s: string, w: integer): string;
//
//
//



{**********************************************************************
 Let the user choose which file to work with and if they do choose one
 we load it into the first listbox.
**********************************************************************}
procedure TfrmSortPascal.btnLoadFileClick(Sender: TObject);
begin
  if OpenDialog1.Execute
  then listbox1.items.loadfromfile(OpenDialog1.FileName);
end;      // procedure TfrmSortPascal.btnLoadFileClick(Sender: TObject);
//
//
//



{**********************************************************************
  process the proc/func/construct/destruct just found

  if we have been processing a previous unit then
  - work back to find the first blank line before this header or before the
    comment block that ends immediately before this one, that is the end of
    the previous unit.

  - if code_line is not empty
    - save the information about the previous code line
      (type, object, name start, end)
    - set code_line to blank

  - then
    - the parse out the current line and save as code_line
    - save start address
**********************************************************************}
procedure TfrmSortPascal.ProcessNewBlock(unit_line_number: integer);
begin

  if length(code_line) > 0
  then begin
// process previous unit first
         unit_end := FindBegining(unit_line_number) - 1;
         listbox2.items.add(code_line + ' ' + inttostr(unit_end));
         listbox2.topindex := listbox2.items.count - 3;
         application.processmessages;
         code_line := '';
       end;

// process this new unit
  unit_start := FindBegining(unit_line_number);
  if first_unit = 0 then first_unit := unit_start;    

  ParseUnitHeader(unit_line_number);

end;      // procedure TfrmSortPascal.ProcessNewBlock(unit_line_number: integer);
//
//
//



{**********************************************************************
 Locate the blank line above the unit header. It is either
 1) the line above the unit
 2) the line above the comment block located immediately above this unit
**********************************************************************}
function TfrmSortPascal.FindBegining(line_number: integer): integer;
var
  j: integer;

  // strip leading and trailing spaces from the line passed.
  function strip(aline: string): string;
  var
    j, start_pos, end_pos: integer;

  begin
    result := '';
    start_pos := 0;
    end_pos := length(aline) - 1;

    for j := 0 to pred(length(aline)) do    {Iterate}
    begin
        if (start_pos = 0) and
           (aline[j] <> ' ')
        then start_pos := j;

        if aline[j] <> ' ' then end_pos := j;
    end;    {for}

    if start_pos + end_pos > 0
    then result := copy(aline, start_pos, end_pos);
  end;

begin
  result := line_number;

//  if length(listbox1.items[line_number - 1]) > 0 // is the preceeding line a blank?
if length(strip(listbox1.items[line_number - 1])) > 0
  then begin
         for j := (line_number - 1) downto 0 do
             if (copy(getword(listbox1.items[j], 1), 0, 2) = '//') or
                (copy(getword(listbox1.items[j], 1), 0, 1) = '{') or
                (copy(getword(listbox1.items[j], 1), 0, 2) = '(*')
             then if length(strip(listbox1.items[j-1])) = 0 // is the preceeding line a blank?
                  then begin
                         result := j;
                         exit;
                       end
                  else continue;
       end;
end;      // function TfrmSortPascal.FindBegining(line_number: integer): integer;
//
//
//



{**********************************************************************
  Set the variables unit_type, unit_object, unit_name
  If this unit does not have a object, use the '.'
**********************************************************************}
procedure TfrmSortPascal.ParseUnitHeader(unit_line_number: integer);
var
  hold_line: string;
  start_of_dross, period_location: integer;

begin
  if (strlcomp(pchar('INITIALIZATION'), pchar(UpperCase(listbox1.items[unit_line_number])), length('initialization')) = 0) or
     (strlcomp(pchar('FINALIZATION'), pchar(UpperCase(listbox1.items[unit_line_number])), length('finalization')) = 0)
  then hold_line := ', ' + listbox1.items[unit_line_number] + ';'
  else hold_line := listbox1.items[unit_line_number];

  unit_type := getword(hold_line, 1);

// find the first character after this unit's name '(', ':' or ';'
  start_of_dross := pos('(', hold_line);

  if start_of_dross = 0
  then start_of_dross := pos(':', hold_line);

  if start_of_dross = 0
  then start_of_dross := pos(';', hold_line);

(*
  unit_type := getword(listbox1.items[unit_line_number], 1);

// find the first character after this unit's name '(', ':' or ';'
  start_of_dross := pos('(', listbox1.items[unit_line_number]);

  if start_of_dross = 0
  then start_of_dross := pos(':', listbox1.items[unit_line_number]);

  if start_of_dross = 0
  then start_of_dross := pos(';', listbox1.items[unit_line_number]);
*)

  hold_line := copy(hold_line, 0, start_of_dross - 1);

  period_location := pos('.', hold_line);
  if period_location > 0
  then begin
         hold_line[period_location] := ' ';
         unit_object := getword(hold_line, 2);
         unit_name := getword(hold_line, 3);
       end
  else begin
         unit_object := '.';
         unit_name := getword(hold_line, 2);
       end;

  code_line := unit_object + ' ' + unit_type + ' ' + unit_name + ' ' +
               inttostr(unit_start);
end;      // procedure TfrmSortPascal.ParseUnitHeader(unit_line_number: integer);
//
//
//



{**********************************************************************
 When the listbox is clicked on, show what line it is
**********************************************************************}
procedure TfrmSortPascal.ListBox1Click(Sender: TObject);
begin
  ShowLineNumberInHint(sender);
end;      // procedure TfrmSortPascal.ListBox1Click(Sender: TObject);
//
//
//



{**********************************************************************
 Sets the hint for the calling listbox so that the user knows what line
 number they just clicked on.
**********************************************************************}
procedure TfrmSortPascal.ShowLineNumberInHint(sender: TObject);
begin
  with sender as tlistbox do
  begin
       hint := inttostr(itemindex);
  end;    { with }
end;      // procedure TfrmSortPascal.ShowLineNumberInHint;
//
//
//



{**********************************************************************
 Find and show, in listbox 1 and 3, the unit selected
**********************************************************************}
procedure TfrmSortPascal.ListBox2Click(Sender: TObject);
var
  j: integer;

begin
  listbox1.itemindex := strtoint(getword(listbox2.items[listbox2.itemindex], 4));
  listbox1.topindex := strtoint(getword(listbox2.items[listbox2.itemindex], 4)) - 3;

(*  for j := (first_unit - 1) to pred(listbox3.items.count) do
  begin
      if (getword(listbox3.items[j], 1) = getword(listbox2.items[listbox2.itemindex], 2)) and
         (pos(getword(listbox2.items[listbox2.itemindex], 3), listbox3.items[j]) > 0)
      then listbox3.itemindex := j;
  end;      // for j := (first_unit - 1) to pred(listbox3.items.count) do

  listbox3.topindex := listbox3.itemindex - 3;
*)

  listbox3.itemindex := strtoint(getword(listbox2.items[listbox2.itemindex],6));
  listbox3.topindex := listbox3.itemindex - 3;

  if memo1.visible = true
  then begin
         memo1.Lines.clear;

         for j := strtoint(getword(listbox2.items[listbox2.itemindex], 4)) to strtoint(getword(listbox2.items[listbox2.itemindex], 5)) do
         begin
             memo1.lines.add(listbox1.items[j])
         end;    {for}
       end;
end;      // procedure TfrmSortPascal.ListBox2Click(Sender: TObject);
//
//
//



{**********************************************************************
 Turn off the labels that only apply after files are selected
**********************************************************************}
procedure TfrmSortPascal.FormShow(Sender: TObject);
begin
  SetUpLabels;
  first_unit := 0;
end;      // procedure TfrmSortPascal.FormShow(Sender: TObject);
//
//
//



{**********************************************************************
 Sets the labels to their initial values/settings
**********************************************************************}
procedure TfrmSortPascal.SetUpLabels;
begin
  label1.caption := '';
  label2.caption := '';
  label3.caption := '';

  label4.visible := false;
  label5.visible := false;
  label6.visible := false;
end;      // procedure TfrmSortPascal.SetUpLabels;
//
//
//



{**********************************************************************
 Take and write out the source code into the sorted file
**********************************************************************}
procedure TfrmSortPascal.WriteItOut;
var
  k: integer;
  j: integer;
  
begin

  listbox3.clear;

// get the lines of code before the first unit
  for j := 0 to pred(first_unit) do
  begin
      listbox3.items.add(listbox1.items[j]);
  end;      //  for j := 0 to pred(first_unit) do

// put each of the sorted units out
  for j := 0 to pred(listbox2.items.count) do
  begin
      Unit_start := strtoint(getword(listbox2.items[j], 4));
      Unit_end := strtoint(getword(listbox2.items[j], 5));

      listbox2.items[j] := listbox2.items[j] + ' ' + IntToStr(listbox3.items.count);

      for k := unit_start to unit_end do
      begin
          listbox3.items.add(listbox1.items[k]);
      end;      // listbox3.items.add(listbox1.items[j]);
  end;      // for j := 0 to pred(listbox2.itemcount) do

// add in everything from the 'end.' to the end of file.  
  for j := end_statement to pred(listbox1.items.count) do    {Iterate}
  begin
      listbox3.items.add(listbox1.items[j]);
  end;    {for}
//  listbox3.items.add('end.');      // Got to have one of these

  label3.caption := 'Post-sorted line count - ' + inttostr(listbox3.items.count);

// Either we get the same amount of lines or we don't write anything
// This doesn't mean something messed up though.
  if (listbox1.items.count = listbox3.items.count) and
     (length(listbox1.items.text) = length(listbox3.items.text))
  then begin
         listbox3.Items.SaveToFile(unsorted_FileName + ' - sorted');
         MessageDlg('The sorted file'+#13+#10+unsorted_filename + ' - sorted'+#13+#10+'has been written out.',mtInformation,[mbOK],0);
       end
  else begin
         MessageDlg('The input and sorted file sizes are not the same,'+#13+#10+'the output file will not be written out.'+#13+#10+
                    'The sorted file has ' + IntToStr(listbox3.items.count) + ' lines,'+#13+#10+'The input file has ' + IntToStr(listbox1.items.count) + ' lines,'+#13+#10+
                    'The sorted file has ' + IntToStr(length(listbox3.items.text)) + ' bytes,'+#13+#10+'The input file has ' + IntToStr(length(listbox1.items.text)) + ' bytes,',mtError,[mbOK],0);
         memo1.Visible := true;
         memo1.Lines.clear;
       end;
end;      // procedure TfrmSortPascal.WriteItOut;
//
//
//



{**********************************************************************
 The time had come, so Marvin went.
**********************************************************************}
procedure TfrmSortPascal.Exit1Click(Sender: TObject);
begin
  close;
end;      // procedure TfrmSortPascal.Exit1Click(Sender: TObject);
//
//
//



{**********************************************************************
 Let the user choose a file to open and open it.
**********************************************************************}
procedure TfrmSortPascal.Open1Click(Sender: TObject);
begin
  if OpenDialog1.Execute
  then begin
         listbox1.Items.clear;
         listbox2.items.clear;
         listbox3.items.clear;
         SetUpLabels;
         listbox1.items.loadfromfile(OpenDialog1.FileName);
         unsorted_filename := OpenDialog1.FileName;

         label1.caption := 'Pre-sorted line count - ' + inttostr(listbox1.items.count);
         frmSortPascal.caption :=  'SortPascal - ' + OpenDialog1.FileName;

         ResetVariables;

         label5.visible := true;

         close1.enabled := true;
         sort1.enabled := true;
         sort1.Default := true;
       end;
end;      // procedure TfrmSortPascal.Open1Click(Sender: TObject);
//
//
//



{**********************************************************************
 Reset the variables that we are going to use
**********************************************************************}
procedure TfrmSortPascal.ResetVariables;
begin
  imp_start := 0;
  first_unit := 0;
  unit_start := 0;
  unit_end := 0;
  code_line := '';
  unit_type := '';
  unit_object := '';
  unit_name := '';
end;      // procedure TfrmSortPascal.ResetVariables;
//
//
//



{**********************************************************************
 Close the file and reset the labels
**********************************************************************}
procedure TfrmSortPascal.Close1Click(Sender: TObject);
begin
  listbox1.clear;
  listbox2.clear;
  listbox2.sorted := false;
  listbox3.clear;

  SetupLabels;

  close1.enabled := false;
  sort1.enabled := false;
  open1.Default := true;
end;      // procedure TfrmSortPascal.Close1Click(Sender: TObject);
//
//
//



{**********************************************************************
 For all the good it will do them, show the about box
**********************************************************************}
procedure TfrmSortPascal.About1Click(Sender: TObject);
var
  f: TForm;

begin
  f := TfrmAbout.create(self);
  f.showmodal;
  f.free;
end;      // procedure TfrmSortPascal.About1Click(Sender: TObject);
//
//
//



{**********************************************************************
  find all proc/func/con/destructors and their line numbers (start and
  end)
**********************************************************************}
procedure TfrmSortPascal.Sort1Click(Sender: TObject);
var
  j: integer;

begin
  Screen.Cursor := crHourGlass;
  try
          imp_start := 0;
        
          listbox2.clear;
          listbox3.clear;
        
        // go through each line of the file
          for j := 0 to pred(listbox1.items.count) do
          begin
        // note the location of the implementation keyword
              if getword(listbox1.items[j], 1) + ' ' = 'implementation '
              then imp_start := j;
        
        // If we have the end. statement, we are almost done.
              if copy(listbox1.items[j], 0, 4) + ' ' = 'end. '
              then begin
                     end_statement := j;
                     break;
                   end;
        
        // once the implementation keyword is found, process each section of code
              if (imp_start > 0) and
                 (
                 (strlcomp(pchar('INITIALIZATION '), pchar(UpperCase(listbox1.items[j])), length('initialization ')) = 0) or
                 (strlcomp(pchar('FINALIZATION '), pchar(UpperCase(listbox1.items[j])), length('finalization ')) = 0) or
                 (strlcomp(pchar('PROCEDURE '), pchar(UpperCase(listbox1.items[j])), length('procedure ')) = 0) or
                 (strlcomp(pchar('CLASS PROCEDURE '), pchar(UpperCase(listbox1.items[j])), length('class procedure ')) = 0) or
                 (strlcomp(pchar('FUNCTION '), pchar(UpperCase(listbox1.items[j])), length('function ')) = 0) or
                 (strlcomp(pchar('CLASS FUNCTION '), pchar(UpperCase(listbox1.items[j])), length('class function ')) = 0) or
                 (strlcomp(pchar('CONSTRUCTOR '), pchar(UpperCase(listbox1.items[j])), length('constructor ')) = 0) or
                 (strlcomp(pchar('DESTRUCTOR '), pchar(UpperCase(listbox1.items[j])), length('destructor ')) = 0)
                 )
              then ProcessNewBlock(j);
          end;      //   for j := 0 to pred(listbox1.items.count) do
        
        //  ProcessNewBlock(listbox1.Items.count - 1);
          ProcessNewBlock(end_statement);
        
          listbox1.ItemIndex := imp_start;
          listbox1.ItemIndex := first_unit;
        
          listbox2.Sorted := true;
          application.processmessages;
        
          label2.caption := 'Unit count - ' + inttostr(listbox2.items.count);
        
          WriteItOut;
        
          label4.Visible := true;
          label6.visible := true;
  finally
  	Screen.Cursor := crDefault;
  end;  { try/finally }
end;      // procedure TfrmSortPascal.Sort1Click(Sender: TObject);
//
//
//



{**********************************************************************
 If they click in listbox3 they want to see the line number they clicked
 on
**********************************************************************}
procedure TfrmSortPascal.ListBox3Click(Sender: TObject);
begin
  ShowLineNumberInHint(sender);
end;      // procedure TfrmSortPascal.ListBox3Click(Sender: TObject);
//
//
//



procedure TfrmSortPascal.Contents1Click(Sender: TObject);
var
  f: TForm;

begin
  f := TfrmHelp.create(self);
  f.showmodal;
  f.free;
end;

end.
