unit fmAbout;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons;

type
  TfrmAbout = class(TForm)
    Memo1: TMemo;
    BitBtn1: TBitBtn;
    Label1: TLabel;
    procedure BitBtn1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure GetBuildInfo(var V1, V2, V3, V4: Word); 
  public
    { Public declarations }
  end;

var
  frmAbout: TfrmAbout;

implementation

{$R *.DFM}

procedure TfrmAbout.BitBtn1Click(Sender: TObject);
begin
  close;
end;

procedure TfrmAbout.GetBuildInfo(var V1, V2, V3, V4: Word);
var
  VerInfoSize: DWORD;
  VerInfo: Pointer;
  VerValueSize: DWORD;
  VerValue: PVSFixedFileInfo;
  Dummy: DWORD;
begin
  VerInfoSize := GetFileVersionInfoSize(PChar(ParamStr(0)), Dummy);
  if VerInfoSize = 0 then begin
    Dummy := GetLastError;
    ShowMessage(IntToStr(Dummy));
  end; {if}
  GetMem(VerInfo, VerInfoSize);
  GetFileVersionInfo(PChar(ParamStr(0)), 0, VerInfoSize, VerInfo);
  VerQueryValue(VerInfo, '\', Pointer(VerValue), VerValueSize);
  with VerValue^ do begin
    V1 := dwFileVersionMS shr 16;
    V2 := dwFileVersionMS and $FFFF;
    V3 := dwFileVersionLS shr 16;
    V4 := dwFileVersionLS and $FFFF;
  end;
  FreeMem(VerInfo, VerInfoSize);
end;

{coded by Steve Schafer (TeamB)}
procedure TfrmAbout.FormCreate(Sender: TObject);
var
vv1, vv2, vv3, vv4: word;

begin
  getbuildinfo(vv1, vv2, vv3, vv4);
  label1.caption := 'Version ' + IntToStr(vv1)  + '.' + IntToStr(vv2) + '  Release ' + IntToStr(vv3) + '  Build ' + IntToStr(vv4) ;
end;

end.
