PAGE 58,132

.386p

;******************************************************************************
;                I N C L U D E S
;******************************************************************************

    .xlist
    include vmm.inc
    include vwin32.inc
    .list

; the following equate makes the VXD dynamically loadable.
SMPORT_DYNAMIC EQU 1

SMPORT_DEVICE_ID EQU UNDEFINED_DEVICE_ID

;============================================================================
;        V I R T U A L   D E V I C E   D E C L A R A T I O N
;============================================================================

DECLARE_VIRTUAL_DEVICE    SMPORT, 1, 0, SMPORT_Control, SMPORT_DEVICE_ID, \
                        UNDEFINED_INIT_ORDER, ,

VxD_LOCKED_DATA_SEG

VMHnd dd 0 

VxD_LOCKED_DATA_ENDS

VxD_ICODE_SEG


;******************************************************************************
;
;   SMPORT_Device_Init
;
;   DESCRIPTION:
;
;       This function is called during enhanced mode startup. 
;
;==============================================================================

BeginProc SMPORT_Dynamic_Init
          clc
          ret
EndProc  SMPORT_Dynamic_Init

VxD_ICODE_ENDS

VxD_LOCKED_CODE_SEG

;===========================================================================
;
;   PROCEDURE: SMPORT_Control
;
;   DESCRIPTION:
;    Device control procedure for the SMPORT VxD
;
;   ENTRY:
;    EAX = Control call ID
;
;   EXIT:
;    If carry clear then
;        Successful
;    else
;        Control call failed
;
;   USES:
;    EAX, EBX, ECX, EDX, ESI, EDI, Flags
;
;============================================================================

BeginProc SMPORT_Control
    Control_Dispatch SYS_DYNAMIC_DEVICE_INIT, SMPORT_Dynamic_Init
    Control_Dispatch SYS_DYNAMIC_DEVICE_EXIT, SMPORT_Dynamic_Exit
    Control_Dispatch W32_DEVICEIOCONTROL,     SMPORT_W32_DeviceIOControl, sCall, <ecx, ebx, edx, esi>
    clc
    ret
EndProc SMPORT_Control

;===========================================================================
;
;   PROCEDURE: SMPORT_Dynamic_Exit
;
;===========================================================================
BeginProc SMPORT_Dynamic_Exit
    xor	 eax, eax
    ret
EndProc SMPORT_Dynamic_Exit

VxD_LOCKED_CODE_ENDS

END

						 
