unit About;

interface

uses
  Windows, Controls, StdCtrls, Buttons, Classes, Forms, Graphics, ExtCtrls;

const
  Margin = 6;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    BitBtn1: TBitBtn;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label6: TLabel;
    procedure Image1DblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Panel1Click(Sender: TObject);
  private
    { Private declarations }
    Earthmap: HBitmap;
    procedure DrawBitmap(PaintDC: HDC; Bitmap: HBitMap; XVal, YVal: Integer);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  AWidth, AHeight: Integer;

implementation

uses Main;

{$R *.DFM}

procedure TForm1.DrawBitmap(PaintDC: HDC; Bitmap: HBitMap; XVal, yVal: Integer);
var
  MemDC: HDC;
  OldBitmap: HBitmap;
begin
  MemDC := CreateCompatibleDC(PaintDC);
  OldBitmap:= SelectObject(MemDC, Bitmap);
  BitBlt(PaintDC, XVal, YVal, AWidth, AHeight, MemDC, 0, 0, SRCCOPY);
  if OldBitmap = 0 then Label6.Visible := False; 
  SelectObject(MemDC, OldBitmap);
  DeleteObject(MemDC);
end;

procedure TForm1.Image1DblClick(Sender: TObject);
begin
  MainForm.Unlimited.Visible := True;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  BSTRUCT: Windows.TBitmap;
  hLib2: THandle;
  {verSize: Integer;}
begin
  hLib2 := LoadLibrary('option');
    if hLib2 > 32  then begin
  Earthmap := LoadBitmap(hLib2, 'James');
  GetObject(Earthmap, sizeof(Windows.TBitmap), @BSTRUCT);
  AWidth := BSTRUCT.bmWidth;
  AHeight := BSTRUCT.bmHeight;
  if AWidth > 0 then Label6.Visible := False;
  {GetFileVersionInfoSize('Slow.exe',VerSize);
  GetFileVersionInfo}
end;
end;

procedure TForm1.FormPaint(Sender: TObject);
begin
  if Earthmap <> 0 then
    DrawBitmap(GetDC(Handle), Earthmap, Margin, 0);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  MainForm.Menu:=MainForm.MainMenu2;
end;

procedure TForm1.Panel1Click(Sender: TObject);
begin
  MainForm.Menu:=MainForm.MainMenu2;
end;

end.
