unit pie_form;

// simple program to test and demonstrator the PieChart unit

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, PieChart;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    PieChart1: TPieChart;
    ListBox2: TListBox;
    procedure FormCreate(Sender: TObject);
    procedure PieChart1DblClick(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
var
  str: TStringList;
  i: integer;
begin
  str := TStringList.Create;
  with ListBox2.Items do
    begin
    for i := 0 to Count-1 do
      // Add the string, and an object.  Here the object is just
      // an integer used to record the index of the string in the
      // list box.  It is type-cast into an object (pointer).
      str.AddObject (Strings [i], pointer (i));
    end;
  PieChart1.SetDataAndLabels (str);
  str.Free;
end;

procedure TForm1.PieChart1DblClick(Sender: TObject);
var
  i: integer;
begin
  // Convert object pointer back to useful information, here the index
  // into a TStrings object attached to a list box.  Note that the full
  // string as stored is displayed, including the number part
  i := integer(PieChart1.ClickedObject);
  ShowMessage (ListBox2.Items.strings [i]);
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
var
  s: string;
  space: integer;
begin
  // if the list box is doubled clicked, find the item currently
  // selected (i.e. at ItemIndex), and remove any numeric part
  with ListBox1 do
    begin
    s := Items [ItemIndex];
    space := Pos (' ', s);
    if space = 0
    then s := ''
    else s := Trim (Copy (s, space, 999));
    ShowMessage (s);
    end;
end;

end.

