unit OptnDlg;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, ComCtrls;

type
  // putting the type definitons here allows sharing of data types
  // between the main form and this options dialog
  Tdisplay_mode = (show_actual, show_allocated, show_slack);
  Tdisplay_units = (show_bytes, show_KB, show_MB);

type
  TOptionsDialog = class(TForm)
    Button1: TButton;
    Button2: TButton;
    PageControl1: TPageControl;
    SpaceSheet: TTabSheet;
    RadioGroup1: TRadioGroup;
    btnActual: TRadioButton;
    btnAllocated: TRadioButton;
    Label1: TLabel;
    btnSlack: TRadioButton;
    UnitsSheet: TTabSheet;
    RadioGroup2: TRadioGroup;
    btnBytes: TRadioButton;
    btnKB: TRadioButton;
    btnMB: TRadioButton;
    Label2: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
  public
    { Public declarations }
    display_mode: Tdisplay_mode;        // variables to set initial options
    display_units: Tdisplay_units;      // and recover any changes
  end;

var
  OptionsDialog: TOptionsDialog;


implementation

{$R *.DFM}

procedure TOptionsDialog.FormShow(Sender: TObject);
begin
  // on showing this dialog, ensure the buttons are set according
  // to the options that the main program is currently using
  btnAllocated.Checked := False;
  btnSlack.Checked := False;
  btnActual.Checked := False;
  case display_mode of
       show_actual: btnActual.Checked := True;
    show_allocated: btnAllocated.Checked := True;
        show_slack: btnSlack.Checked := True;
  end;
  btnBytes.Checked := False;
  btnKB.Checked := False;
  btnMB.Checked := False;
  case display_units of
    show_bytes: btnBytes.Checked := True;
       show_KB: btnKB.Checked := True;
       show_MB: btnMB.Checked := True;
  end;
end;

procedure TOptionsDialog.Button1Click(Sender: TObject);
begin
  // code for the OK button being clicked, decode the radio
  // buttons into the enuerated type variables
  if btnAllocated.Checked
  then display_mode := show_allocated
  else if btnSlack.Checked
       then display_mode := show_slack
       else display_mode := show_actual;
  if btnBytes.Checked
  then display_units := show_bytes
  else if btnKB.Checked
       then display_units := show_KB
       else display_units := show_MB;
end;

end.
