unit LogoMain;

{
Program to show disk usage as a pie-chart

Revision history:

1.0    1993 Feb 08  First version for Boralnd's Turbo Pascal for Windows
2.0.0  1996 Apr 14  Version for Borland's Delphi 2.0
2.0.2  1996 Apr 16  Pre-load Open dialog with '*.*' file name
                    Add number of files and directories display
2.0.4  1996 May 26  Add E-mail address to About box
}

interface

uses Windows, Classes, Graphics, Forms, Controls, Menus,
  Dialogs, StdCtrls, Buttons, ExtCtrls, ComCtrls, PieChart,
  FileInfo;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileMenu: TMenuItem;
    FileOpenItem: TMenuItem;
    FileExitItem: TMenuItem;
    OpenDialog: TOpenDialog;
    Help1: TMenuItem;
    AboutItem: TMenuItem;
    SpeedPanel: TPanel;
    OpenBtn: TSpeedButton;
    ExitBtn: TSpeedButton;
    StatusBar: TStatusBar;
    PieChart1: TPieChart;
    ListBox1: TListBox;
    Timer1: TTimer;
    btnStop: TButton;
    BitBtn1: TBitBtn;
    btnUp: TButton;
    View1: TMenuItem;
    Options1: TMenuItem;
    Refresh1: TMenuItem;
    N2: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure FileOpen(Sender: TObject);
    procedure About(Sender: TObject);
    procedure ShowHint(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure PieChart1DblClick(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnUpClick(Sender: TObject);
    procedure Options1Click(Sender: TObject);
    procedure Refresh1Click(Sender: TObject);
  private
    dir_list: TDirectoryList;
    scanning: boolean;
    stop_requested: boolean;
    show_allocated: boolean;
    procedure scan_tree;
    procedure display_list (const list: TDirectoryList);
    procedure handle_double_click (entry: TDirectoryData);
  public
    { Public declarations }
  end;

procedure set_status_text (const s: string);  stdcall;

var
  MainForm: TMainForm;

implementation

uses SysUtils, About, LogoStrs, OptnDlg;

const
  product_name = 'David''s ShowMan program';
  product_version = 'Version 2.0.4';
  product_copyright = 'Copyright '#169' David J Taylor, Edinburgh, 1993-1996';
  product_comments = 'Delphi 2.0 - 32-bit version'#10'david.taylor@gecm.com';

{$R *.DFM}

{$R version.res}

procedure set_status_text (const s: string);
begin
  MainForm.StatusBar.Panels[1].Text := s;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  dir_list := TDirectoryList.Create (nil, '.');
  scanning := False;
  stop_requested := False;
  show_allocated := True;
  Timer1.Enabled := True;
end;

procedure TMainForm.FileOpen(Sender: TObject);
begin
  // rely on the OpenDialog function changing the current directory
  with OpenDialog do
    begin
    FileName := '*.*';
    if Execute then scan_tree;
    end;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.About(Sender: TObject);
begin
  with AboutBox do
    begin
    ProductName.Caption := product_name;
    Version.Caption := product_version;
    Copyright.Caption := product_copyright;
    Comments.Caption := product_comments;
    ProgramIcon.Picture.Icon := Application.Icon;
    ShowModal;
    end;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.Panels[0].Text := Application.Hint;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  dir_list.Free;
end;

procedure TMainForm.scan_tree;
var
  sectors_per_cluster: integer;
  bytes_per_sector: integer;
  free_clusters: integer;
  total_clusters: integer;
  cluster_bytes: integer;
  disk: array [0..3] of char;
  root: string;
begin
  if scanning then Exit;
  PieChart1.Clear;
  root := GetCurrentDir;
  if root [Length (root)] <> '\' then root := root + '\';
  StrPLcopy (disk, root, 3);
  if not show_allocated
  then cluster_bytes := 1
  else if GetDiskFreeSpace (disk, sectors_per_cluster, bytes_per_sector,
                            free_clusters, total_clusters)
       then cluster_bytes := bytes_per_sector * sectors_per_cluster
       else cluster_bytes := 1;
  try
    stop_requested := false;
    btnStop.Enabled := True;
    dir_list.SetDirectoryName (root);
    scanning := true;
    dir_list.scan (stop_requested, cluster_bytes, set_status_text);
    display_list (dir_list);
    scanning := false;
    stop_requested := false;
    btnStop.Enabled := False;
  finally
  end;
end;

procedure TMainForm.Timer1Timer(Sender: TObject);
begin
  Timer1.Enabled := False;
  if ParamCount > 0 then SetCurrentDir (ParamStr (1));
  scan_tree;
end;

procedure TMainForm.display_list (const list: TDirectoryList);
var
  str_list: TStringList;
  index: integer;
  size: integer;
  total_size: integer;
  s: string;
begin
  // prepare a string list with the sizes (numeric) and names
  // of the files and directories in this part of the tree
  str_list := TStringList.Create;
  total_size := 0;
  for index := 0 to list.Count-1 do
    begin
    size := TDirectoryData (list.Objects[index]).GetBytes;
    Str (size, s);
    str_list.AddObject (s + '   ' + LowerCase (list.Strings[index]),
                        list.Objects[index]);
    Inc (total_size, size);
    end;
  // compute and show the pie-chart
  PieChart1.SetDataAndLabels (str_list);
  str_list.Free;
  // compute the status line
  with list do
    begin
    StatusBar.Panels[1].Text :=
      Format ('%s ... contains %1.n bytes in %1.n files and %1.n directories',
      [GetDirectoryName, GetTotalBytes + 0.0,
       GetTotalFiles + 0.0, GetTotalDirectories + 0.0]);
    Caption := 'ShowMan - ' + GetDirectoryName;
    btnUp.Enabled := GetParentDirectoryList <> nil;
    end;
end;

procedure TMainForm.PieChart1DblClick(Sender: TObject);
var
  lst: TDirectoryList;
begin
  handle_double_click (PieChart1.ClickedObject as TDirectoryData);
end;

procedure TMainForm.ListBox1DblClick(Sender: TObject);
var
  entry: TDirectoryData;
begin
  entry := TDirectoryData (ListBox1.Items.Objects [ListBox1.ItemIndex]);
  handle_double_click (entry);
end;

procedure TMainForm.handle_double_click (entry: TDirectoryData);
var
  lst: TDirectoryList;
begin
  if entry <> nil then
    with entry do
      begin
      lst := GetSubDirectoryList;
      if lst <> nil
      then
        display_list (lst)
      else
        begin
        lst := GetParentDirectoryList;
        if lst <> nil then
          display_list (lst)
        end;
      end;
end;

procedure TMainForm.btnStopClick(Sender: TObject);
begin
  stop_requested := True;
end;

procedure TMainForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  stop_requested := True;
end;

procedure TMainForm.btnUpClick(Sender: TObject);
var
  lst: TDirectoryList;
begin
  if ListBox1.Items.Count <> 0 then
    with TDirectoryData (ListBox1.Items.Objects [0]) do
    begin
    lst := GetParentDirectoryList;
    if lst <> nil then
      display_list (lst)
    end;
end;

procedure TMainForm.Options1Click(Sender: TObject);
begin
  // use present setting of SHOW_ALLOCATED for the options dialog
  OptionsDialog.show_allocated := show_allocated;
  if OptionsDialog.ShowModal = mrOK then
    if show_allocated <> OptionsDialog.show_allocated then
      begin
      // settings have changed, save the setting and re-scan
      show_allocated := OptionsDialog.show_allocated;
      scan_tree;
      end;
end;

procedure TMainForm.Refresh1Click(Sender: TObject);
begin
  scan_tree;
end;

end.

