(***************************************************************************************
 Copyright Ken_Miles 2000

 For conditions of use please see TShellCommandInterface_ReadMe.Txt or
 copyright in TShellCommandInterface.hlp
****************************************************************************************)
unit DupExtDialog;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, Grids, ExtCtrls;

type
(***************************************************************************************
  Object:   TDuplicateExts

  Description: A form for showing any duplicates file associations
               for file extensions

  Version:  1.00
  Date Last Modified: 28 May 2000
****************************************************************************************)

  TDuplicateExts = class(TForm)
    sgDuplicateExts: TStringGrid;
    Panel1: TPanel;
    Panel2: TPanel;
    btnOK: TBitBtn;
    procedure FormResize(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    // Show the list - modal
    Procedure DisplayDuplicates(Exts, FileAssoc: TStrings);
  public
    { Public declarations }
  end;

// Create dialog and Show the list
Procedure DisplayDuplicates(Exts, FileAssoc: TStrings);

{---------------------------------------------------------------------------

---------------------------------------------------------------------------}

implementation

{$R *.DFM}

{---------------------------------------------------------------------------

---------------------------------------------------------------------------}

(***************************************************************************************
  Object:   TDuplicateExts

  Procedure: FormResize

  Description: Size the string grid columns as appropriate

  Version:  1.00
  Date Last Modified: 28 May 2000
****************************************************************************************)

procedure TDuplicateExts.FormResize(Sender: TObject);
begin
  sgDuplicateExts.ColWidths[0]:= 50;
  sgDuplicateExts.ColWidths[1]:= sgDuplicateExts.ClientWidth - 55;
end;

(***************************************************************************************
  Object:   TDuplicateExts

  Procedure: DisplayDuplicates

  Description: Fills the string grid with exts and assocaitions so user can
               identify where the duplicates are

  Version:  1.00
  Date Last Modified: 28 May 2000
****************************************************************************************)

Procedure TDuplicateExts.DisplayDuplicates(Exts, FileAssoc: TStrings);

Begin
  // Set size - remember first/header row
  sgDuplicateExts.RowCount:= Exts.Count + 1;
  // Display deatils in grid
  sgDuplicateExts.Cols[0].AddStrings(Exts);
  sgDuplicateExts.Cols[1].AddStrings(FileAssoc);
  // Has exceeded scrollbar size?
  FormResize(Self);
  // App modal
  ShowModal;
End;

Procedure DisplayDuplicates(Exts, FileAssoc: TStrings);

Begin
  // Create form, display details and free
  With TDuplicateExts.Create(Application) Do Begin
    Try
      DisplayDuplicates(Exts, FileAssoc);
    Finally
      free;
    End;
  End;
End;

(***************************************************************************************
  Object:   TDuplicateExts

  Procedure: FormCreate

  Description: Set top row/header in string grid

  Version:  1.00
  Date Last Modified: 28 May 2000
****************************************************************************************)


procedure TDuplicateExts.FormCreate(Sender: TObject);
begin
  sgDuplicateExts.Rows[0].CommaText:= 'Extension,"File Assocations"';
end;

end.
