unit Sharing;

{ Sharing 98 v2.0
  Encapsulation of the NetShare functions for win95/98. By Jerry Ryle.
  This is free stuff, but I'll take donations ;)

  Notes: This implementation will only work on Windows 95/98
         since it imports the svrapi.dll directly. I do not
         have Windows NT, so I do not intend on supporting
         it any time soon.

         I have tested these functions thoroughly, but
         I will accept no responsibility if they harm you,
         your computer, or your pets.

         Read the sharing.txt for a little more info.

  email me if you make it better -- gryle@calpoly.edu
}


interface
uses ShareErr, {Look in ShareErr for Error codes and a nifty function}
     Sysutils;

Type

  Share_Info50 = Packed Record
                   shi50_netname : Array[0..12] of Char; {13}
                   shi50_type    : Byte;
                   shi50_flags   : Word;
                   shi50_remark  : PChar;
                   shi50_path    : PChar;
                   shi50_rw_password : Array[0..8] of Char; {9}
                   shi50_ro_password : Array[0..8] of Char;
                 End;

Const
{Use ShareErr for Error Constants & Error functions}

{Resource Type Constants}
  STYPE_DISKTREE = 0; {Directory Share}
  STYPE_PRINTQ   = 1; {Printer Share}

{Flag Constants}
  SHI50F_RDONLY  = 1;  { Share is Read Only}
  SHI50F_FULL    = 2;  { Share is Full Access}
  SHI50F_DEPENDSON = (SHI50F_RDONLY or SHI50F_FULL); {Access depends upon password entered by user}

  {OR the following with access constants to use them.
   I.E.: flags := (SHI50F_RDONLY OR SHI50F_SYSTEM) }
  SHI50F_PERSIST = 256; {The share is restored on system startup}
  SHI50F_SYSTEM  = 512; {The share is not normally visible}


{ ShareResource: Shares a resource on the specified machine.
  Parameters:
    ServerName= Name of server on which to share resource. Nil = Local Machine.
    FilePath  = Path to the resource to be shared. (This should be ALL upper-case);
    NetName   = Network Name to give the shared resource. Must be 12 characters or less.
    Remark    = Comment. Can be an empty string.
    ShareType = Type of resource. See Constants declared above.
    Flags     = Sharing flags. See Constants declared above.
    RWPass    = Full Access Password - Must be 8 characters or less. Can be an empty string.
    ROPass    = Read Only Password - Must be 8 characters or less. Can be an empty string.

  Example Call: ShareResource(Nil, 'C:\TEMP', 'TESTING', 'My Comment', STYPE_DISKTREE, SHI50F_RDONLY, '','MYPASS');
    This Shares Disk Resource C:\TEMP as 'TESTING' with comment 'My Comment' on the local machine.
    Access is Read Only, with Read Only password = 'MYPASS'. No Full Access Password specified.
    (It would be ignored if specified) }
function ShareResource(ServerName : PChar; FilePath : PChar;
                       NetName : PChar; Remark : PChar;
                       ShareType : Byte; Flags : Word;
                       RWPass : PChar; ROPass : PChar ) : Integer;



{ DeleteShare: Deletes a shared resource on the specified machine.
  Parameters:
    ServerName= Name of server on which to share resource. Nil = Local Machine.
    NetName   = Network Name of the shared resource.

  Example Call: DeleteShare(Nil, 'TESTING');
    This Deletes The network share named 'TESTING' on the local machine.}
function DeleteShare(ServerName : PChar; NetName : PChar) : Integer;


{ GetShareInfo: Gets information about a shared resource on the specified machine.
  Parameters:
    ServerName  = Name of server where the shared resource resides. Nil = Local Machine.
    NetName     = Network Name of the shared resource. Must be 12 characters or less.
    ShareStruct = Share_Info50. This structure will be filled with information on the
                  specified share if the function succeeds.

  Example Call:
    var MyShareStruct : Share_Info50;
    GetShareInfo(Nil, 'TESTING', MyShareStruct);

    This fills MyShareStruct with share information about 'TESTING' on the local machine.}
function GetShareInfo(ServerName : PChar; NetName : PChar; Var ShareStruct : Share_Info50) : Integer;

{ SetShareInfo: Sets information for a shared resource on the specified machine.
  Parameters:
    ServerName  = Name of server where the shared resource resides. Nil = Local Machine.
    NetName     = Network Name of the shared resource. Must be 12 characters or less.
    ShareStruct = Share_Info50. This structure contains the new information for the shared
                  resource. It is easiest to fill this structure first with GetShareInfo and
                  then change desired parameters; however you may fill it completely yourself.
                  You may not change the path of a shared resource, if you change this
                  parameter in the structure, it will be ignored.

  Example Call: SetShareInfo(Nil, 'TESTING', MyShareStruct);
    This changes the share information for 'TESTING' to reflect the data in MyShareStruct}
function SetShareInfo(ServerName : PChar; NetName : PChar; ShareStruct : Share_Info50) : Integer;

{These are the translated SVRAPI exports. I suggest you not use them yourself. Rather, use
 the encapsulated versions I have written for you. If you wish to learn more about these
 functions, browse the win32.hlp file.}
function NetShareAdd(ServerName : PChar; ShareLevel : SmallInt; Buffer : Pointer; Size : Word) : Integer; StdCall;
function NetShareDel(ServerName : PChar; NetName : PChar; Reserved : Word) : Integer; StdCall;
function NetShareGetInfo(ServerName : PChar; NetName : PChar; ShareLevel : SmallInt; Buffer : Pointer; Size : Word; Var Used : Word) : Integer; StdCall;
function NetShareSetInfo(ServerName : PChar; NetName : PChar; ShareLevel : SmallInt; Buffer : Pointer; Size : Word; Reserved : SmallInt) : Integer; StdCall;


implementation

function ShareResource(ServerName : PChar; FilePath : PChar;
                       NetName : PChar; Remark : PChar;
                       ShareType : Byte; Flags : Word;
                       RWPass : PChar; ROPass : PChar ) : Integer;
 var MyShare : Share_Info50;
     PMyShare : ^Share_Info50;
begin
  strLcopy(MyShare.shi50_netname,NetName,13);
  MyShare.shi50_type := ShareType;
  MyShare.shi50_flags := Flags;
  MyShare.shi50_remark := Remark;
  MyShare.shi50_path := FilePath;
  strLcopy(MyShare.shi50_rw_password,RWPass,9);
  strLcopy(MyShare.shi50_ro_password,ROPass,9);
  PMyShare := @MyShare;
  Result := NetShareAdd(ServerName,50,PMyShare,SizeOf(MyShare));
end;

function DeleteShare(ServerName : PChar; NetName : PChar) : Integer;
begin
  Result := NetShareDel(ServerName,NetName,0);
end;

function GetShareInfo(ServerName : PChar; NetName : PChar; Var ShareStruct : Share_Info50) : Integer;
 var PMyShare : ^Share_Info50;
     AmountUsed : Word;
     Error : Integer;
begin
  PMyShare := AllocMem(255);
  Error := NetShareGetInfo(ServerName,NetName,50,PMyShare,255,AmountUsed);
  If Error = 0 Then
    Begin
      ShareStruct.shi50_netname := PMyShare.shi50_netname;
      ShareStruct.shi50_type := PMyShare.shi50_type;
      ShareStruct.shi50_flags := PMyShare.shi50_flags;
      ShareStruct.shi50_remark := PMyShare.shi50_remark;
      ShareStruct.shi50_path := PMyShare.shi50_path;
      ShareStruct.shi50_rw_password := PMyShare.shi50_rw_password;
      ShareStruct.shi50_ro_password := PMyShare.shi50_ro_password;
    End;
  FreeMem(PMyShare);
  Result := Error;
end;

function SetShareInfo(ServerName : PChar; NetName : PChar; ShareStruct : Share_Info50) : Integer;
 var PMyShare : ^Share_Info50;
begin
  PMyShare := @ShareStruct;
  Result := NetShareSetInfo(ServerName,NetName,50,PMyShare,SizeOf(ShareStruct),0);
end;

function NetShareAdd;     external 'SVRAPI.DLL';
function NetShareDel;     external 'SVRAPI.DLL';
function NetShareGetInfo; external 'SVRAPI.DLL';
function NetShareSetInfo; external 'SVRAPI.DLL';

end.
