unit ShareErr;

{ ShareErr v2.0
 Translation of lmerr.h with a nice little function at
 the end...  By Jerry Ryle. This is free stuff, but I'll
 take donations ;)

 email me if you make it better -- gryle@.calpoly.edu
}

interface

CONST

  NERR_Success = 0; { Success -- No Error }

  NERR_BASE = 2100;

{**********WARNING *****************
 * The range 2750-2799 has been    *
 * allocated to the IBM LAN Server *
 ***********************************}

{**********WARNING *****************
 * The range 2900-2999 has been    *
 * reserved for Microsoft OEMs     *
 ***********************************}

  { UNUSED BASE+0 }
  { UNUSED BASE+1 }
  NERR_NetNotStarted = (NERR_BASE + 2);
  NERR_UnknownServer = (NERR_BASE + 3);
  NERR_ShareMem = (NERR_BASE + 4);
  NERR_NoNetworkResource = (NERR_BASE + 5);
  NERR_RemoteOnly = (NERR_BASE + 6);
  NERR_DevNotRedirected = (NERR_BASE + 7);
  { UNUSED BASE+8 }
  { UNUSED BASE+9 }
  { UNUSED BASE+10 }
  { UNUSED BASE+11 }
  { UNUSED BASE+12 }
  { UNUSED BASE+13 }
  NERR_ServerNotStarted = (NERR_BASE + 14);
  NERR_ItemNotFound = (NERR_BASE + 15);
  NERR_UnknownDevDir = (NERR_BASE + 16);
  NERR_RedirectedPath = (NERR_BASE + 17);
  NERR_DuplicateShare = (NERR_BASE + 18);
  NERR_NoRoom = (NERR_BASE + 19);
  { UNUSED BASE+20 }
  NERR_TooManyItems = (NERR_BASE + 21);
  NERR_InvalidMaxUsers = (NERR_BASE + 22);
  NERR_BufTooSmall = (NERR_BASE + 23);
  { UNUSED BASE+24 }
  { UNUSED BASE+25 }
  { UNUSED BASE+26 }
  NERR_RemoteErr = (NERR_BASE + 27);
  { UNUSED BASE+28 }
  { UNUSED BASE+29 }
  { UNUSED BASE+30 }
  NERR_LanmanIniError = (NERR_BASE + 31);
  { UNUSED BASE+32 }
  { UNUSED BASE+33 }
  { UNUSED BASE+34 }
  { UNUSED BASE+35 }
  NERR_NetworkError = (NERR_BASE + 36);
  NERR_WkstaInconsistentState = (NERR_BASE + 37);
  NERR_WkstaNotStarted = (NERR_BASE + 38);
  NERR_BrowserNotStarted = (NERR_BASE + 39);
  NERR_InternalError = (NERR_BASE + 40);
  NERR_BadTransactConfig = (NERR_BASE + 41);
  NERR_InvalidAPI = (NERR_BASE + 42);
  NERR_BadEventName = (NERR_BASE + 43);
  NERR_DupNameReboot = (NERR_BASE + 44);

{Config API related -- Error codes from BASE+45 to BASE+49 }
  { UNUSED BASE+45 }
  NERR_CfgCompNotFound = (NERR_BASE + 46);
  NERR_CfgParamNotFound = (NERR_BASE + 47);
  NERR_LineTooLong = (NERR_BASE + 49);

{Spooler API related -- Error codes from BASE+50 to BASE+79 }
  NERR_QNotFound = (NERR_BASE + 50);
  NERR_JobNotFound = (NERR_BASE + 51);
  NERR_DestNotFound = (NERR_BASE + 52);
  NERR_DestExists = (NERR_BASE + 53);
  NERR_QExists = (NERR_BASE + 54);
  NERR_QNoRoom = (NERR_BASE + 55);
  NERR_JobNoRoom = (NERR_BASE + 56);
  NERR_DestNoRoom = (NERR_BASE + 57);
  NERR_DestIdle = (NERR_BASE + 58);
  NERR_DestInvalidOp = (NERR_BASE + 59);
  NERR_ProcNoRespond = (NERR_BASE + 60);
  NERR_SpoolerNotLoaded = (NERR_BASE + 61);
  NERR_DestInvalidState = (NERR_BASE + 62);
  NERR_QInvalidState = (NERR_BASE + 63);
  NERR_JobInvalidState = (NERR_BASE + 64);
  NERR_SpoolNoMemory = (NERR_BASE + 65);
  NERR_DriverNotFound = (NERR_BASE + 66);
  NERR_DataTypeInvalid = (NERR_BASE + 67);
  NERR_ProcNotFound = (NERR_BASE + 68);

{Service API related -- Error codes from BASE+80 to BASE+99 }
  NERR_ServiceTableLocked = (NERR_BASE + 80);
  NERR_ServiceTableFull = (NERR_BASE + 81);
  NERR_ServiceInstalled = (NERR_BASE + 82);
  NERR_ServiceEntryLocked = (NERR_BASE + 83);
  NERR_ServiceNotInstalled = (NERR_BASE + 84);
  NERR_BadServiceName = (NERR_BASE + 85);
  NERR_ServiceCtlTimeout = (NERR_BASE + 86);
  NERR_ServiceCtlBusy = (NERR_BASE + 87);
  NERR_BadServiceProgName = (NERR_BASE + 88);
  NERR_ServiceNotCtrl = (NERR_BASE + 89);
  NERR_ServiceKillProc = (NERR_BASE + 90);
  NERR_ServiceCtlNotValid = (NERR_BASE + 91);
  NERR_NotInDispatchTbl = (NERR_BASE + 92);
  NERR_BadControlRecv = (NERR_BASE + 93);
  NERR_ServiceNotStarting = (NERR_BASE + 94);

{Wksta and Logon API related -- Error codes from BASE+100 to BASE+118 }
  NERR_AlreadyLoggedOn = (NERR_BASE + 100);
  NERR_NotLoggedOn = (NERR_BASE + 101);
  NERR_BadUsername = (NERR_BASE + 102);
  NERR_BadPassword = (NERR_BASE + 103);
  NERR_UnableToAddName_W = (NERR_BASE + 104);
  NERR_UnableToAddName_F = (NERR_BASE + 105);
  NERR_UnableToDelName_W = (NERR_BASE + 106);
  NERR_UnableToDelName_F = (NERR_BASE + 107);
  { UNUSED BASE+108 }
  NERR_LogonsPaused = (NERR_BASE + 109);
  NERR_LogonServerConflict = (NERR_BASE + 110);
  NERR_LogonNoUserPath = (NERR_BASE + 111);
  NERR_LogonScriptError = (NERR_BASE + 112);
  { UNUSED BASE+113 }
  NERR_StandaloneLogon = (NERR_BASE + 114);
  NERR_LogonServerNotFound = (NERR_BASE + 115);
  NERR_LogonDomainExists = (NERR_BASE + 116);
  NERR_NonValidatedLogon = (NERR_BASE + 117);

{ACF API related (access, user, group) -- Error codes from BASE+119 to BASE+149 }
  NERR_ACFNotFound = (NERR_BASE + 119);
  NERR_GroupNotFound = (NERR_BASE + 120);
  NERR_UserNotFound = (NERR_BASE + 121);
  NERR_ResourceNotFound = (NERR_BASE + 122);
  NERR_GroupExists = (NERR_BASE + 123);
  NERR_UserExists = (NERR_BASE + 124);
  NERR_ResourceExists = (NERR_BASE + 125);
  NERR_NotPrimary = (NERR_BASE + 126);
  NERR_ACFNotLoaded = (NERR_BASE + 127);
  NERR_ACFNoRoom = (NERR_BASE + 128);
  NERR_ACFFileIOFail = (NERR_BASE + 129);
  NERR_ACFTooManyLists = (NERR_BASE + 130);
  NERR_UserLogon = (NERR_BASE + 131);
  NERR_ACFNoParent = (NERR_BASE + 132);
  NERR_CanNotGrowSegment = (NERR_BASE + 133);
  NERR_SpeGroupOp = (NERR_BASE + 134);
  NERR_NotInCache = (NERR_BASE + 135);
  NERR_UserInGroup = (NERR_BASE + 136);
  NERR_UserNotInGroup = (NERR_BASE + 137);
  NERR_AccountUndefined = (NERR_BASE + 138);
  NERR_AccountExpired = (NERR_BASE + 139);
  NERR_InvalidWorkstation = (NERR_BASE + 140);
  NERR_InvalidLogonHours = (NERR_BASE + 141);
  NERR_PasswordExpired = (NERR_BASE + 142);
  NERR_PasswordCantChange = (NERR_BASE + 143);
  NERR_PasswordHistConflict = (NERR_BASE + 144);
  NERR_PasswordTooShort = (NERR_BASE + 145);
  NERR_PasswordTooRecent = (NERR_BASE + 146);
  NERR_InvalidDatabase = (NERR_BASE + 147);
  NERR_DatabaseUpToDate = (NERR_BASE + 148);
  NERR_SyncRequired = (NERR_BASE + 149);

{Use API related -- Error codes from BASE+150 to BASE+169}
  NERR_UseNotFound = (NERR_BASE + 150);
  NERR_BadAsgType = (NERR_BASE + 151);
  NERR_DeviceIsShared = (NERR_BASE + 152);

{Message Server related -- Error codes BASE+170 to BASE+209 }
  NERR_NoComputerName = (NERR_BASE + 170);
  NERR_MsgAlreadyStarted = (NERR_BASE + 171);
  NERR_MsgInitFailed = (NERR_BASE + 172);
  NERR_NameNotFound = (NERR_BASE + 173);
  NERR_AlreadyForwarded = (NERR_BASE + 174);
  NERR_AddForwarded = (NERR_BASE + 175);
  NERR_AlreadyExists = (NERR_BASE + 176);
  NERR_TooManyNames = (NERR_BASE + 177);
  NERR_DelComputerName = (NERR_BASE + 178);
  NERR_LocalForward = (NERR_BASE + 179);
  NERR_GrpMsgProcessor = (NERR_BASE + 180);
  NERR_PausedRemote = (NERR_BASE + 181);
  NERR_BadReceive = (NERR_BASE + 182);
  NERR_NameInUse = (NERR_BASE + 183);
  NERR_MsgNotStarted = (NERR_BASE + 184);
  NERR_NotLocalName = (NERR_BASE + 185);
  NERR_NoForwardName = (NERR_BASE + 186);
  NERR_RemoteFull = (NERR_BASE + 187);
  NERR_NameNotForwarded = (NERR_BASE + 188);
  NERR_TruncatedBroadcast = (NERR_BASE + 189);
  NERR_InvalidDevice = (NERR_BASE + 194);
  NERR_WriteFault = (NERR_BASE + 195);
  { UNUSED BASE+196 }
  NERR_DuplicateName = (NERR_BASE + 197);
  NERR_DeleteLater = (NERR_BASE + 198);
  NERR_IncompleteDel = (NERR_BASE + 199);
  NERR_MultipleNets = (NERR_BASE + 200);

{Server API related -- Error codes BASE+210 to BASE+229 }
  NERR_NetNameNotFound = (NERR_BASE + 210);
  NERR_DeviceNotShared = (NERR_BASE + 211);
  NERR_ClientNameNotFound = (NERR_BASE + 212);
  NERR_FileIdNotFound = (NERR_BASE + 214);
  NERR_ExecFailure = (NERR_BASE + 215);
  NERR_TmpFile = (NERR_BASE + 216);
  NERR_TooMuchData = (NERR_BASE + 217);
  NERR_DeviceShareConflict = (NERR_BASE + 218);
  NERR_BrowserTableIncomplete = (NERR_BASE + 219);
  NERR_NotLocalDomain = (NERR_BASE + 220);
  NERR_IsDfsShare = (NERR_BASE + 221);

{CharDev API related -- Error codes BASE+230 to BASE+249 }
  { UNUSED BASE+230 }
  NERR_DevInvalidOpCode = (NERR_BASE + 231);
  NERR_DevNotFound = (NERR_BASE + 232);
  NERR_DevNotOpen = (NERR_BASE + 233);
  NERR_BadQueueDevString = (NERR_BASE + 234);
  NERR_BadQueuePriority = (NERR_BASE + 235);
  NERR_NoCommDevs = (NERR_BASE + 237);
  NERR_QueueNotFound = (NERR_BASE + 238);
  NERR_BadDevString = (NERR_BASE + 240);
  NERR_BadDev = (NERR_BASE + 241);
  NERR_InUseBySpooler = (NERR_BASE + 242);
  NERR_CommDevInUse = (NERR_BASE + 243);

{NetICanonicalize and NetIType and NetIMakeLMFileName
 NetIListCanon and NetINameCheck -- Error codes BASE+250 to BASE+269 }
  NERR_InvalidComputer = (NERR_BASE + 251);
  { UNUSED BASE+252 }
  { UNUSED BASE+253 }
  NERR_MaxLenExceeded = (NERR_BASE + 254);
  { UNUSED BASE+255 }
  NERR_BadComponent = (NERR_BASE + 256);
  NERR_CantType = (NERR_BASE + 257);
  { UNUSED BASE+258 }
  { UNUSED BASE+259 }
  NERR_TooManyEntries = (NERR_BASE + 262);

{NetProfile Error codes BASE+270 to BASE+276 }
  NERR_ProfileFileTooBig = (NERR_BASE + 270);
  NERR_ProfileOffset = (NERR_BASE + 271);
  NERR_ProfileCleanup = (NERR_BASE + 272);
  NERR_ProfileUnknownCmd = (NERR_BASE + 273);
  NERR_ProfileLoadErr = (NERR_BASE + 274);
  NERR_ProfileSaveErr = (NERR_BASE + 275);

{NetAudit and NetErrorLog -- Error codes BASE+277 to BASE+279}
  NERR_LogOverflow = (NERR_BASE + 277);
  NERR_LogFileChanged = (NERR_BASE + 278);
  NERR_LogFileCorrupt = (NERR_BASE + 279);

{NetRemote Error codes -- BASE+280 to BASE+299}
  NERR_SourceIsDir = (NERR_BASE + 280);
  NERR_BadSource = (NERR_BASE + 281);
  NERR_BadDest = (NERR_BASE + 282);
  NERR_DifferentServers = (NERR_BASE + 283);
  { UNUSED BASE+284 }
  NERR_RunSrvPaused = (NERR_BASE + 285);
  { UNUSED BASE+286 }
  { UNUSED BASE+287 }
  { UNUSED BASE+288 }
  NERR_ErrCommRunSrv = (NERR_BASE + 289);
  { UNUSED BASE+290 }
  NERR_ErrorExecingGhost = (NERR_BASE + 291);
  NERR_ShareNotFound = (NERR_BASE + 292);
  { UNUSED BASE+293 }
  { UNUSED BASE+294 }

{NetWksta.sys (redir) returned error codes-- NERR_BASE + (300-329)}
  NERR_InvalidLana = (NERR_BASE + 300);
  NERR_OpenFiles = (NERR_BASE + 301);
  NERR_ActiveConns = (NERR_BASE + 302);
  NERR_BadPasswordCore = (NERR_BASE + 303);
  NERR_DevInUse = (NERR_BASE + 304);
  NERR_LocalDrive = (NERR_BASE + 305);

{Alert error codes -- NERR_BASE + (330-339)}
  NERR_AlertExists = (NERR_BASE + 330);
  NERR_TooManyAlerts = (NERR_BASE + 331);
  NERR_NoSuchAlert = (NERR_BASE + 332);
  NERR_BadRecipient = (NERR_BASE + 333);
  NERR_AcctLimitExceeded = (NERR_BASE + 334);

{Additional Error and Audit log codes -- NERR_BASE +(340-343)}
  NERR_InvalidLogSeek = (NERR_BASE + 340);
  { UNUSED BASE+341 }
  { UNUSED BASE+342 }
  { UNUSED BASE+343 }

{Additional UAS and NETLOGON codes -- NERR_BASE +(350-359)}
  NERR_BadUasConfig = (NERR_BASE + 350);
  NERR_InvalidUASOp = (NERR_BASE + 351);
  NERR_LastAdmin = (NERR_BASE + 352);
  NERR_DCNotFound = (NERR_BASE + 353);
  NERR_LogonTrackingError = (NERR_BASE + 354);
  NERR_NetlogonNotStarted = (NERR_BASE + 355);
  NERR_CanNotGrowUASFile = (NERR_BASE + 356);
  NERR_TimeDiffAtDC = (NERR_BASE + 357);
  NERR_PasswordMismatch = (NERR_BASE + 358);

{Server Integration error codes-- NERR_BASE +(360-369)}
  NERR_NoSuchServer = (NERR_BASE + 360);
  NERR_NoSuchSession = (NERR_BASE + 361);
  NERR_NoSuchConnection = (NERR_BASE + 362);
  NERR_TooManyServers = (NERR_BASE + 363);
  NERR_TooManySessions = (NERR_BASE + 364);
  NERR_TooManyConnections = (NERR_BASE + 365);
  NERR_TooManyFiles = (NERR_BASE + 366);
  NERR_NoAlternateServers = (NERR_BASE + 367);
  { UNUSED BASE+368 }
  { UNUSED BASE+369 }
  NERR_TryDownLevel = (NERR_BASE + 370);

{UPS error codes-- NERR_BASE + (380-384) }
  NERR_UPSDriverNotStarted = (NERR_BASE + 380);
  NERR_UPSInvalidConfig = (NERR_BASE + 381);
  NERR_UPSInvalidCommPort = (NERR_BASE + 382);
  NERR_UPSSignalAsserted = (NERR_BASE + 383);
  NERR_UPSShutdownFailed = (NERR_BASE + 384);

{Remoteboot error codes.
  NERR_BASE + (400-419)
  Error codes 400 - 405 are used by RPLBOOT.SYS.
  Error codes 403, 407 - 416 are used by RPLLOADR.COM,
  Error code 417 is the alerter message of REMOTEBOOT (RPLSERVR.EXE).
  Error code 418 is for when REMOTEBOOT can't start
  Error code 419 is for a disallowed 2nd rpl connection }
  NERR_BadDosRetCode = (NERR_BASE + 400);
  NERR_ProgNeedsExtraMem = (NERR_BASE + 401);
  NERR_BadDosFunction = (NERR_BASE + 402);
  NERR_RemoteBootFailed = (NERR_BASE + 403);
  NERR_BadFileCheckSum = (NERR_BASE + 404);
  NERR_NoRplBootSystem = (NERR_BASE + 405);
  NERR_RplLoadrNetBiosErr = (NERR_BASE + 406);
  NERR_RplLoadrDiskErr = (NERR_BASE + 407);
  NERR_ImageParamErr = (NERR_BASE + 408);
  NERR_TooManyImageParams = (NERR_BASE + 409);
  NERR_NonDosFloppyUsed = (NERR_BASE + 410);
  NERR_RplBootRestart = (NERR_BASE + 411);
  NERR_RplSrvrCallFailed = (NERR_BASE + 412);
  NERR_CantConnectRplSrvr = (NERR_BASE + 413);
  NERR_CantOpenImageFile = (NERR_BASE + 414);
  NERR_CallingRplSrvr = (NERR_BASE + 415);
  NERR_StartingRplBoot = (NERR_BASE + 416);
  NERR_RplBootServiceTerm = (NERR_BASE + 417);
  NERR_RplBootStartFailed = (NERR_BASE + 418);
  NERR_RPL_CONNECTED = (NERR_BASE + 419);

{Browser service API error codes -- NERR_BASE + (450-475) }
  NERR_BrowserConfiguredToNotRun = (NERR_BASE + 450);

{Additional Remoteboot error codes -- NERR_BASE + (510-550) }
  NERR_RplNoAdaptersStarted = (NERR_BASE + 510);
  NERR_RplBadRegistry = (NERR_BASE + 511);
  NERR_RplBadDatabase = (NERR_BASE + 512);
  NERR_RplRplfilesShare = (NERR_BASE + 513);
  NERR_RplNotRplServer = (NERR_BASE + 514);
  NERR_RplCannotEnum = (NERR_BASE + 515);
  NERR_RplWkstaInfoCorrupted = (NERR_BASE + 516);
  NERR_RplWkstaNotFound = (NERR_BASE + 517);
  NERR_RplWkstaNameUnavailable = (NERR_BASE + 518);
  NERR_RplProfileInfoCorrupted = (NERR_BASE + 519);
  NERR_RplProfileNotFound = (NERR_BASE + 520);
  NERR_RplProfileNameUnavailable = (NERR_BASE + 521);
  NERR_RplProfileNotEmpty = (NERR_BASE + 522);
  NERR_RplConfigInfoCorrupted = (NERR_BASE + 523);
  NERR_RplConfigNotFound = (NERR_BASE + 524);
  NERR_RplAdapterInfoCorrupted = (NERR_BASE + 525);
  NERR_RplInternal = (NERR_BASE + 526);
  NERR_RplVendorInfoCorrupted = (NERR_BASE + 527);
  NERR_RplBootInfoCorrupted = (NERR_BASE + 528);
  NERR_RplWkstaNeedsUserAcct = (NERR_BASE + 529);
  NERR_RplNeedsRPLUSERAcct = (NERR_BASE + 530);
  NERR_RplBootNotFound = (NERR_BASE + 531);
  NERR_RplIncompatibleProfile = (NERR_BASE + 532);
  NERR_RplAdapterNameUnavailable = (NERR_BASE + 533);
  NERR_RplConfigNotEmpty = (NERR_BASE + 534);
  NERR_RplBootInUse = (NERR_BASE + 535);
  NERR_RplBackupDatabase = (NERR_BASE + 536);
  NERR_RplAdapterNotFound = (NERR_BASE + 537);
  NERR_RplVendorNotFound = (NERR_BASE + 538);
  NERR_RplVendorNameUnavailable = (NERR_BASE + 539);
  NERR_RplBootNameUnavailable = (NERR_BASE + 540);
  NERR_RplConfigNameUnavailable = (NERR_BASE + 541);

{Dfs API error codes. -- NERR_BASE + (560-590) }
  NERR_DfsInternalCorruption = (NERR_BASE + 560);
  NERR_DfsVolumeDataCorrupt = (NERR_BASE + 561);
  NERR_DfsNoSuchVolume = (NERR_BASE + 562);
  NERR_DfsVolumeAlreadyExists = (NERR_BASE + 563);
  NERR_DfsAlreadyShared = (NERR_BASE + 564);
  NERR_DfsNoSuchShare = (NERR_BASE + 565);
  NERR_DfsNotALeafVolume = (NERR_BASE + 566);
  NERR_DfsLeafVolume = (NERR_BASE + 567);
  NERR_DfsVolumeHasMultipleServers = (NERR_BASE + 568);
  NERR_DfsCantCreateJunctionPoint = (NERR_BASE + 569);
  NERR_DfsServerNotDfsAware = (NERR_BASE + 570);
  NERR_DfsBadRenamePath = (NERR_BASE + 571);
  NERR_DfsVolumeIsOffline = (NERR_BASE + 572);
  NERR_DfsNoSuchServer = (NERR_BASE + 573);
  NERR_DfsCyclicalName = (NERR_BASE + 574);
  NERR_DfsNotSupportedInServerDfs = (NERR_BASE + 575);
  NERR_DfsInternalError = (NERR_BASE + 590);

{**********WARNING *****************
 * The range 2750-2799 has been    *
 * allocated to the IBM LAN Server *
 ***********************************}

{**********WARNING *****************
 * The range 2900-2999 has been    *
 * reserved for Microsoft OEMs     *
 ***********************************}

  MAX_NERR = (NERR_BASE + 899);

Function GetNetErrorString(ErrorNumber : Integer) : String;

implementation

Uses SysUtils;

Function GetNetErrorString(ErrorNumber : Integer) : String;
 Begin
   Case ErrorNumber Of
  NERR_Success                     : Result := ('No Error.');
  NERR_NetNotStarted               : Result := ('The workstation driver is not installed.');
  NERR_UnknownServer               : Result := ('The server could not be located.');
  NERR_ShareMem                    : Result := ('An internal error occurred.  The network cannot access a shared memory segment.');
  NERR_NoNetworkResource           : Result := ('A network resource shortage occurred.');
  NERR_RemoteOnly                  : Result := ('This operation is not supported on workstations.');
  NERR_DevNotRedirected            : Result := ('The device is not connected.');
  NERR_ServerNotStarted            : Result := ('The Server service is not started.');
  NERR_ItemNotFound                : Result := ('The queue is empty.');
  NERR_UnknownDevDir               : Result := ('The device or directory does not exist.');
  NERR_RedirectedPath              : Result := ('The operation is invalid on a redirected resource.');
  NERR_DuplicateShare              : Result := ('The name has already been shared.');
  NERR_NoRoom                      : Result := ('The server is currently out of the requested resource.');
  NERR_TooManyItems                : Result := ('Requested addition of items exceeds the maximum allowed.');
  NERR_InvalidMaxUsers             : Result := ('The Peer service supports only two simultaneous users.');
  NERR_BufTooSmall                 : Result := ('The API return buffer is too small.');
  NERR_RemoteErr                   : Result := ('A remote API error occurred.');
  NERR_LanmanIniError              : Result := ('An error occurred when opening or reading the configuration file.');
  NERR_NetworkError                : Result := ('A general network error occurred.');
  NERR_WkstaInconsistentState      : Result := ('The Workstation service is in an inconsistent state. Restart the computer before restarting the Workstation service.');
  NERR_WkstaNotStarted             : Result := ('The Workstation service has not been started.');
  NERR_BrowserNotStarted           : Result := ('The requested information is not available.');
  NERR_InternalError               : Result := ('An internal Windows NT error occurred.');
  NERR_BadTransactConfig           : Result := ('The server is not configured for transactions.');
  NERR_InvalidAPI                  : Result := ('The requested API is not supported on the remote server.');
  NERR_BadEventName                : Result := ('The event name is invalid.');
  NERR_DupNameReboot               : Result := ('The computer name already exists on the network. Change it and restart the computer.');
  NERR_CfgCompNotFound             : Result := ('The specified component could not be found in the configuration information.');
  NERR_CfgParamNotFound            : Result := ('The specified parameter could not be found in the configuration information.');
  NERR_LineTooLong                 : Result := ('A line in the configuration file is too long.');
  NERR_QNotFound                   : Result := ('The printer does not exist.');
  NERR_JobNotFound                 : Result := ('The print job does not exist.');
  NERR_DestNotFound                : Result := ('The printer destination cannot be found.');
  NERR_DestExists                  : Result := ('The printer destination already exists.');
  NERR_QExists                     : Result := ('The printer queue already exists.');
  NERR_QNoRoom                     : Result := ('No more printers can be added.');
  NERR_JobNoRoom                   : Result := ('No more print jobs can be added.');
  NERR_DestNoRoom                  : Result := ('No more printer destinations can be added.');
  NERR_DestIdle                    : Result := ('This printer destination is idle and cannot accept control operations.');
  NERR_DestInvalidOp               : Result := ('This printer destination request contains an invalid control function.');
  NERR_ProcNoRespond               : Result := ('The print processor is not responding.');
  NERR_SpoolerNotLoaded            : Result := ('The spooler is not running.');
  NERR_DestInvalidState            : Result := ('This operation cannot be performed on the print destination in its current state.');
  NERR_QInvalidState               : Result := ('This operation cannot be performed on the printer queue in its current state.');
  NERR_JobInvalidState             : Result := ('This operation cannot be performed on the print job in its current state.');
  NERR_SpoolNoMemory               : Result := ('A spooler memory allocation failure occurred.');
  NERR_DriverNotFound              : Result := ('The device driver does not exist.');
  NERR_DataTypeInvalid             : Result := ('The data type is not supported by the print processor.');
  NERR_ProcNotFound                : Result := ('The print processor is not installed.');
  NERR_ServiceTableLocked          : Result := ('The service database is locked.');
  NERR_ServiceTableFull            : Result := ('The service table is full.');
  NERR_ServiceInstalled            : Result := ('The requested service has already been started.');
  NERR_ServiceEntryLocked          : Result := ('The service does not respond to control actions.');
  NERR_ServiceNotInstalled         : Result := ('The service has not been started.');
  NERR_BadServiceName              : Result := ('The service name is invalid.');
  NERR_ServiceCtlTimeout           : Result := ('The service is not responding to the control function.');
  NERR_ServiceCtlBusy              : Result := ('The service control is busy.');
  NERR_BadServiceProgName          : Result := ('The configuration file contains an invalid service program name.');
  NERR_ServiceNotCtrl              : Result := ('The service could not be controlled in its present state.');
  NERR_ServiceKillProc             : Result := ('The service ended abnormally.');
  NERR_ServiceCtlNotValid          : Result := ('The requested pause or stop is not valid for this service.');
  NERR_NotInDispatchTbl            : Result := ('The service control dispatcher could not find the service name in the dispatch table.');
  NERR_BadControlRecv              : Result := ('The service control dispatcher pipe read failed.');
  NERR_ServiceNotStarting          : Result := ('A thread for the new service could not be created.');
  NERR_AlreadyLoggedOn             : Result := ('This workstation is already logged on to the local-area network.');
  NERR_NotLoggedOn                 : Result := ('The workstation is not logged on to the local-area network.');
  NERR_BadUsername                 : Result := ('The user name or group name parameter is invalid.');
  NERR_BadPassword                 : Result := ('The password parameter is invalid.');
  NERR_UnableToAddName_W           : Result := ('@W The logon processor did not add the message alias.');
  NERR_UnableToAddName_F           : Result := ('The logon processor did not add the message alias.');
  NERR_UnableToDelName_W           : Result := ('@W The logoff processor did not delete the message alias.');
  NERR_UnableToDelName_F           : Result := ('The logoff processor did not delete the message alias.');
  NERR_LogonsPaused                : Result := ('Network logons are paused.');
  NERR_LogonServerConflict         : Result := ('A centralized logon-server conflict occurred.');
  NERR_LogonNoUserPath             : Result := ('The server is configured without a valid user path.');
  NERR_LogonScriptError            : Result := ('An error occurred while loading or running the logon script.');
  NERR_StandaloneLogon             : Result := ('The logon server was not specified.  Your computer will be logged on as STANDALONE.');
  NERR_LogonServerNotFound         : Result := ('The logon server could not be found.');
  NERR_LogonDomainExists           : Result := ('There is already a logon domain for this computer.');
  NERR_NonValidatedLogon           : Result := ('The logon server could not validate the logon.');
  NERR_ACFNotFound                 : Result := ('The security database could not be found.');
  NERR_GroupNotFound               : Result := ('The group name could not be found.');
  NERR_UserNotFound                : Result := ('The user name could not be found.');
  NERR_ResourceNotFound            : Result := ('The resource name could not be found.');
  NERR_GroupExists                 : Result := ('The group already exists.');
  NERR_UserExists                  : Result := ('The user account already exists.');
  NERR_ResourceExists              : Result := ('The resource permission list already exists.');
  NERR_NotPrimary                  : Result := ('This operation is only allowed on the primary domain controller of the domain.');
  NERR_ACFNotLoaded                : Result := ('The security database has not been started.');
  NERR_ACFNoRoom                   : Result := ('There are too many names in the user accounts database.');
  NERR_ACFFileIOFail               : Result := ('A disk I/O failure occurred.');
  NERR_ACFTooManyLists             : Result := ('The limit of 64 entries per resource was exceeded.');
  NERR_UserLogon                   : Result := ('Deleting a user with a session is not allowed.');
  NERR_ACFNoParent                 : Result := ('The parent directory could not be located.');
  NERR_CanNotGrowSegment           : Result := ('Unable to add to the security database session cache segment.');
  NERR_SpeGroupOp                  : Result := ('This operation is not allowed on this special group.');
  NERR_NotInCache                  : Result := ('This user is not cached in user accounts database session cache.');
  NERR_UserInGroup                 : Result := ('The user already belongs to this group.');
  NERR_UserNotInGroup              : Result := ('The user does not belong to this group.');
  NERR_AccountUndefined            : Result := ('This user account is undefined.');
  NERR_AccountExpired              : Result := ('This user account has expired.');
  NERR_InvalidWorkstation          : Result := ('The user is not allowed to log on from this workstation.');
  NERR_InvalidLogonHours           : Result := ('The user is not allowed to log on at this time.');
  NERR_PasswordExpired             : Result := ('The password of this user has expired.');
  NERR_PasswordCantChange          : Result := ('The password of this user cannot change.');
  NERR_PasswordHistConflict        : Result := ('This password cannot be used now.');
  NERR_PasswordTooShort            : Result := ('The password is shorter than required.');
  NERR_PasswordTooRecent           : Result := ('The password of this user is too recent to change.');
  NERR_InvalidDatabase             : Result := ('The security database is corrupted.');
  NERR_DatabaseUpToDate            : Result := ('No updates are necessary to this replicant network/local security database.');
  NERR_SyncRequired                : Result := ('This replicant database is outdated; synchronization is required.');
  NERR_UseNotFound                 : Result := ('The network connection could not be found.');
  NERR_BadAsgType                  : Result := ('This asg_type is invalid.');
  NERR_DeviceIsShared              : Result := ('This device is currently being shared.');
  NERR_NoComputerName              : Result := ('The computer name could not be added as a message alias. The name may already exist on the network.');
  NERR_MsgAlreadyStarted           : Result := ('The Messenger service is already started.');
  NERR_MsgInitFailed               : Result := ('The Messenger service failed to start.');
  NERR_NameNotFound                : Result := ('The message alias could not be found on the network.');
  NERR_AlreadyForwarded            : Result := ('This message alias has already been forwarded.');
  NERR_AddForwarded                : Result := ('This message alias has been added but is still forwarded.');
  NERR_AlreadyExists               : Result := ('This message alias already exists locally.');
  NERR_TooManyNames                : Result := ('The maximum number of added message aliases has been exceeded.');
  NERR_DelComputerName             : Result := ('The computer name could not be deleted.');
  NERR_LocalForward                : Result := ('Messages cannot be forwarded back to the same workstation.');
  NERR_GrpMsgProcessor             : Result := ('An error occurred in the domain message processor.');
  NERR_PausedRemote                : Result := ('The message was sent, but the recipient has paused the Messenger service.');
  NERR_BadReceive                  : Result := ('The message was sent but not received.');
  NERR_NameInUse                   : Result := ('The message alias is currently in use. Try again later.');
  NERR_MsgNotStarted               : Result := ('The Messenger service has not been started.');
  NERR_NotLocalName                : Result := ('The name is not on the local computer.');
  NERR_NoForwardName               : Result := ('The forwarded message alias could not be found on the network.');
  NERR_RemoteFull                  : Result := ('The message alias table on the remote station is full.');
  NERR_NameNotForwarded            : Result := ('Messages for this alias are not currently being forwarded.');
  NERR_TruncatedBroadcast          : Result := ('The broadcast message was truncated.');
  NERR_InvalidDevice               : Result := ('This is an invalid device name.');
  NERR_WriteFault                  : Result := ('A write fault occurred.');
  NERR_DuplicateName               : Result := ('A duplicate message alias exists on the network.');
  NERR_DeleteLater                 : Result := ('@W This message alias will be deleted later.');
  NERR_IncompleteDel               : Result := ('The message alias was not successfully deleted from all networks.');
  NERR_MultipleNets                : Result := ('This operation is not supported on computers with multiple networks.');
  NERR_NetNameNotFound             : Result := ('This shared resource does not exist.');
  NERR_DeviceNotShared             : Result := ('This device is not shared.');
  NERR_ClientNameNotFound          : Result := ('A session does not exist with that computer name.');
  NERR_FileIdNotFound              : Result := ('There is not an open file with that identification number.');
  NERR_ExecFailure                 : Result := ('A failure occurred when executing a remote administration command.');
  NERR_TmpFile                     : Result := ('A failure occurred when opening a remote temporary file.');
  NERR_TooMuchData                 : Result := ('The data returned from a remote administration command has been truncated to 64K.');
  NERR_DeviceShareConflict         : Result := ('This device cannot be shared as both a spooled and a non-spooled resource.');
  NERR_BrowserTableIncomplete      : Result := ('The information in the list of servers may be incorrect.');
  NERR_NotLocalDomain              : Result := ('The computer is not active in this domain.');
  NERR_IsDfsShare                  : Result := ('The share must be removed from the Distributed File System before it can be deleted.');
  NERR_DevInvalidOpCode            : Result := ('The operation is invalid for this device.');
  NERR_DevNotFound                 : Result := ('This device cannot be shared.');
  NERR_DevNotOpen                  : Result := ('This device was not open.');
  NERR_BadQueueDevString           : Result := ('This device name list is invalid.');
  NERR_BadQueuePriority            : Result := ('The queue priority is invalid.');
  NERR_NoCommDevs                  : Result := ('There are no shared communication devices.');
  NERR_QueueNotFound               : Result := ('The queue you specified does not exist.');
  NERR_BadDevString                : Result := ('This list of devices is invalid.');
  NERR_BadDev                      : Result := ('The requested device is invalid.');
  NERR_InUseBySpooler              : Result := ('This device is already in use by the spooler.');
  NERR_CommDevInUse                : Result := ('This device is already in use as a communication device.');
  NERR_InvalidComputer             : Result := ('This computer name is invalid.');
  NERR_MaxLenExceeded              : Result := ('The string and prefix specified are too long.');
  NERR_BadComponent                : Result := ('This path component is invalid.');
  NERR_CantType                    : Result := ('Could not determine the type of input.');
  NERR_TooManyEntries              : Result := ('The buffer for types is not big enough.');
  NERR_ProfileFileTooBig           : Result := ('Profile files cannot exceed 64K.');
  NERR_ProfileOffset               : Result := ('The start offset is out of range.');
  NERR_ProfileCleanup              : Result := ('The system cannot delete current connections to network resources.');
  NERR_ProfileUnknownCmd           : Result := ('The system was unable to parse the command line in this file.');
  NERR_ProfileLoadErr              : Result := ('An error occurred while loading the profile file.');
  NERR_ProfileSaveErr              : Result := ('@W Errors occurred while saving the profile file. The profile was partially saved.');
  NERR_LogOverflow                 : Result := ('Log file %1 is full.');
  NERR_LogFileChanged              : Result := ('This log file has changed between reads.');
  NERR_LogFileCorrupt              : Result := ('Log file %1 is corrupt.');
  NERR_SourceIsDir                 : Result := ('The source path cannot be a directory.');
  NERR_BadSource                   : Result := ('The source path is illegal.');
  NERR_BadDest                     : Result := ('The destination path is illegal.');
  NERR_DifferentServers            : Result := ('The source and destination paths are on different servers.');
  NERR_RunSrvPaused                : Result := ('The Run server you requested is paused.');
  NERR_ErrCommRunSrv               : Result := ('An error occurred when communicating with a Run server.');
  NERR_ErrorExecingGhost           : Result := ('An error occurred when starting a background process.');
  NERR_ShareNotFound               : Result := ('The shared resource could not be found.');
  NERR_InvalidLana                 : Result := ('The LAN adapter number is invalid.');
  NERR_OpenFiles                   : Result := ('There are open files on the connection.');
  NERR_ActiveConns                 : Result := ('Active connections still exist.');
  NERR_BadPasswordCore             : Result := ('This share name or password is invalid.');
  NERR_DevInUse                    : Result := ('The device is being accessed by an active process.');
  NERR_LocalDrive                  : Result := ('The drive letter is in use locally.');
  NERR_AlertExists                 : Result := ('The specified client is already registered for the specified event.');
  NERR_TooManyAlerts               : Result := ('The alert table is full.');
  NERR_NoSuchAlert                 : Result := ('An invalid or nonexistent alert name was raised.');
  NERR_BadRecipient                : Result := ('The alert recipient is invalid.');
  NERR_AcctLimitExceeded           : Result := ('A user''s session with this server has been deleted because the user''s logon hours are no longer valid.');
  NERR_InvalidLogSeek              : Result := ('The log file does not contain the requested record number.');
  NERR_BadUasConfig                : Result := ('The user accounts database is not configured correctly.');
  NERR_InvalidUASOp                : Result := ('This operation is not permitted when the Netlogon service is running.');
  NERR_LastAdmin                   : Result := ('This operation is not allowed on the last administrative account.');
  NERR_DCNotFound                  : Result := ('Could not find domain controller for this domain.');
  NERR_LogonTrackingError          : Result := ('Could not set logon information for this user.');
  NERR_NetlogonNotStarted          : Result := ('The Netlogon service has not been started.');
  NERR_CanNotGrowUASFile           : Result := ('Unable to add to the user accounts database.');
  NERR_TimeDiffAtDC                : Result := ('This server''s clock is not synchronized with the primary domain controller''s clock.');
  NERR_PasswordMismatch            : Result := ('A password mismatch has been detected.');
  NERR_NoSuchServer                : Result := ('The server identification does not specify a valid server.');
  NERR_NoSuchSession               : Result := ('The session identification does not specify a valid session.');
  NERR_NoSuchConnection            : Result := ('The connection identification does not specify a valid connection.');
  NERR_TooManyServers              : Result := ('There is no space for another entry in the table of available servers.');
  NERR_TooManySessions             : Result := ('The server has reached the maximum number of sessions it supports.');
  NERR_TooManyConnections          : Result := ('The server has reached the maximum number of connections it supports.');
  NERR_TooManyFiles                : Result := ('The server cannot open more files because it has reached its maximum number.');
  NERR_NoAlternateServers          : Result := ('There are no alternate servers registered on this server.');
  NERR_TryDownLevel                : Result := ('Try down-level (remote admin protocol) version of API instead.');
  NERR_UPSDriverNotStarted         : Result := ('The UPS driver could not be accessed by the UPS service.');
  NERR_UPSInvalidConfig            : Result := ('The UPS service is not configured correctly.');
  NERR_UPSInvalidCommPort          : Result := ('The UPS service could not access the specified Comm Port.');
  NERR_UPSSignalAsserted           : Result := ('The UPS indicated a line fail or low battery situation. Service not started.');
  NERR_UPSShutdownFailed           : Result := ('The UPS service failed to perform a system shut down.');
  NERR_BadDosRetCode               : Result := ('The called program returned an MS-DOS error code.');
  NERR_ProgNeedsExtraMem           : Result := ('The called program needs more memory');
  NERR_BadDosFunction              : Result := ('The called program called an unsupported MS-DOS function.');
  NERR_RemoteBootFailed            : Result := ('The workstation failed to boot.');
  NERR_BadFileCheckSum             : Result := ('The file is corrupt.');
  NERR_NoRplBootSystem             : Result := ('No loader is specified in the boot-block definition file.');
  NERR_RplLoadrNetBiosErr          : Result := ('NetBIOS returned an error.');
  NERR_RplLoadrDiskErr             : Result := ('A disk I/O error occurred.');
  NERR_ImageParamErr               : Result := ('Image parameter substitution failed.');
  NERR_TooManyImageParams          : Result := ('Too many image parameters cross disk sector boundaries.');
  NERR_NonDosFloppyUsed            : Result := ('The image was not generated from an MS-DOS diskette formatted with /S.');
  NERR_RplBootRestart              : Result := ('Remote boot will be restarted later.');
  NERR_RplSrvrCallFailed           : Result := ('The call to the Remoteboot server failed.');
  NERR_CantConnectRplSrvr          : Result := ('Cannot connect to the Remoteboot server.');
  NERR_CantOpenImageFile           : Result := ('Cannot open image file on the Remoteboot server.');
  NERR_CallingRplSrvr              : Result := ('Connecting to the Remoteboot server...');
  NERR_StartingRplBoot             : Result := ('Connecting to the Remoteboot server...');
  NERR_RplBootServiceTerm          : Result := ('Remote boot service was stopped; check the error log for the cause of the problem.');
  NERR_RplBootStartFailed          : Result := ('Remote boot startup failed; check the error log for the cause of the problem.');
  NERR_RPL_CONNECTED               : Result := ('A second connection to a Remoteboot resource is not allowed.');
  NERR_BrowserConfiguredToNotRun   : Result := ('The browser service was configured with MaintainServerList=No.');
  NERR_RplNoAdaptersStarted        : Result := ('Service failed to start since none of the network adapters started with this service.');
  NERR_RplBadRegistry              : Result := ('Service failed to start due to bad startup information in the registry.');
  NERR_RplBadDatabase              : Result := ('Service failed to start because its database is absent or corrupt.');
  NERR_RplRplfilesShare            : Result := ('Service failed to start because RPLFILES share is absent.');
  NERR_RplNotRplServer             : Result := ('Service failed to start because RPLUSER group is absent.');
  NERR_RplCannotEnum               : Result := ('Cannot enumerate service records.');
  NERR_RplWkstaInfoCorrupted       : Result := ('Workstation record information has been corrupted.');
  NERR_RplWkstaNotFound            : Result := ('Workstation record was not found.');
  NERR_RplWkstaNameUnavailable     : Result := ('Workstation name is in use by some other workstation.');
  NERR_RplProfileInfoCorrupted     : Result := ('Profile record information has been corrupted.');
  NERR_RplProfileNotFound          : Result := ('Profile record was not found.');
  NERR_RplProfileNameUnavailable   : Result := ('Profile name is in use by some other profile.');
  NERR_RplProfileNotEmpty          : Result := ('There are workstations using this profile.');
  NERR_RplConfigInfoCorrupted      : Result := ('Configuration record information has been corrupted.');
  NERR_RplConfigNotFound           : Result := ('Configuration record was not found.');
  NERR_RplAdapterInfoCorrupted     : Result := ('Adapter id record information has been corrupted.');
  NERR_RplInternal                 : Result := ('An internal service error has occured.');
  NERR_RplVendorInfoCorrupted      : Result := ('Vendor id record information has been corrupted.');
  NERR_RplBootInfoCorrupted        : Result := ('Boot block record information has been corrupted.');
  NERR_RplWkstaNeedsUserAcct       : Result := ('The user account for this workstation record is missing.');
  NERR_RplNeedsRPLUSERAcct         : Result := ('The RPLUSER local group could not be found.');
  NERR_RplBootNotFound             : Result := ('Boot block record was not found.');
  NERR_RplIncompatibleProfile      : Result := ('Chosen profile is incompatible with this workstation.');
  NERR_RplAdapterNameUnavailable   : Result := ('Chosen network adapter id is in use by some other workstation.');
  NERR_RplConfigNotEmpty           : Result := ('There are profiles using this configuration.');
  NERR_RplBootInUse                : Result := ('There are workstations, profiles or configurations using this boot block.');
  NERR_RplBackupDatabase           : Result := ('Service failed to backup remoteboot database.');
  NERR_RplAdapterNotFound          : Result := ('Adapter record was not found.');
  NERR_RplVendorNotFound           : Result := ('Vendor record was not found.');
  NERR_RplVendorNameUnavailable    : Result := ('Vendor name is in use by some other vendor record.');
  NERR_RplBootNameUnavailable      : Result := ('(boot name, vendor id) is in use by some other boot block record.');
  NERR_RplConfigNameUnavailable    : Result := ('Configuration name is in use by some other configuration.');
  NERR_DfsInternalCorruption       : Result := ('The internal database maintained by the Dfs service is corrupt');
  NERR_DfsVolumeDataCorrupt        : Result := ('One of the records in the internal Dfs database is corrupt');
  NERR_DfsNoSuchVolume             : Result := ('There is no volume whose entry path matches the input Entry Path');
  NERR_DfsVolumeAlreadyExists      : Result := ('A volume with the given name already exists');
  NERR_DfsAlreadyShared            : Result := ('The server share specified is already shared in the Dfs');
  NERR_DfsNoSuchShare              : Result := ('The indicated server share does not support the indicated Dfs volume');
  NERR_DfsNotALeafVolume           : Result := ('The operation is not valid on a non-leaf volume');
  NERR_DfsLeafVolume               : Result := ('The operation is not valid on a leaf volume');
  NERR_DfsVolumeHasMultipleServers : Result := ('The operation is ambiguous because the volume has multiple servers');
  NERR_DfsCantCreateJunctionPoint  : Result := ('Unable to create a junction point');
  NERR_DfsServerNotDfsAware        : Result := ('The server is not Dfs Aware');
  NERR_DfsBadRenamePath            : Result := ('The specified rename target path is invalid');
  NERR_DfsVolumeIsOffline          : Result := ('The specified Dfs volume is offline');
  NERR_DfsNoSuchServer             : Result := ('The specified server is not a server for this volume');
  NERR_DfsCyclicalName             : Result := ('A cycle in the Dfs name was detected');
  NERR_DfsNotSupportedInServerDfs  : Result := ('The operation is not supported on a server-based Dfs');
  NERR_DfsInternalError            : Result := ('Dfs internal error');
 Else Result := 'Unknown Error Code: ' + IntToStr(ErrorNumber);
 End;
End;

end.
