unit Recorder;
{ MainForm }

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, ExtCtrls, ComCtrls, Printers,
  sgr_def, sgr_data,
  MMSystem, Spin;

Const
 WM_DANI=WM_USER+2;

Type
  TMainForm = class(TForm)
    BackPanel: TPanel;
    MainMenu1: TMainMenu;
    mbFile: TMenuItem;
    mbCopy: TMenuItem;
    mCopyPlotDIB: TMenuItem;
    mExit: TMenuItem;
    mbHelp: TMenuItem;
    mAbout: TMenuItem;
    N3: TMenuItem;
    mStartScan: TMenuItem;
    mAbortScan: TMenuItem;
    mScanParams: TMenuItem;
    mSaveData: TMenuItem;
    N7: TMenuItem;
    mCopyPlotMF: TMenuItem;
    StatusBar: TStatusBar;
    mbView: TMenuItem;
    mStndLimits: TMenuItem;
    mSetLimits: TMenuItem;
    mShowAllCurves: TMenuItem;
    mHideAllCurves: TMenuItem;
    Panelcb: TPanel;
    GroupBox1: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    XYPlot: Tsp_XYPlot;
    Timer: TTimer;
    N4: TMenuItem;
    N1: TMenuItem;
    mBufferedDisplay: TMenuItem;
    mOnDrawEnd: TMenuItem;
    mOnFieldDraw: TMenuItem;
    SpinEdit1: TSpinEdit;
    Label1: TLabel;
    mbZoom: TMenuItem;
    mZH: TMenuItem;
    mZV: TMenuItem;
    mZB: TMenuItem;
    mZN: TMenuItem;
    mShowpoints: TMenuItem;
    ImgLst: TImageList;
    mShowlines: TMenuItem;
    N2: TMenuItem;
    mPrint: TMenuItem;
    PrintDialog1: TPrintDialog;
    BottomAxis1: TMenuItem;
    mShowticks: TMenuItem;
    mShowtikslabel: TMenuItem;
    mInversion: TMenuItem;
    N5: TMenuItem;
    mShowcaption: TMenuItem;
    N6: TMenuItem;
    procedure mAboutClick(Sender: TObject);

    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure TimerTimer(Sender: TObject);

    procedure XYPlotDrawEnd(Sender: TObject);
    procedure XYPlotMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure XYPlotAxisZoom(Sender: Tsp_Axis; var min, max: Double;
      var CanZoom: Boolean);
    procedure XYPlotFieldDraw(Sender: TObject);

    procedure SpinEdit1Change(Sender: TObject);
    procedure CheckBoxClick(Sender: TObject);
    procedure chkbInvXClick(Sender: TObject);

    procedure mPrintClick(Sender: TObject);
    procedure mExitClick(Sender: TObject);

    procedure mCopyPlotMFClick(Sender: TObject);
    procedure mCopyPlotDIBClick(Sender: TObject);

    procedure mStndLimitsClick(Sender: TObject);
    procedure mSetLimitsClick(Sender: TObject);
    procedure mShowAllCurvesClick(Sender: TObject);
    procedure mHideAllCurvesClick(Sender: TObject);
    procedure mBufferedDisplayClick(Sender: TObject);
    procedure mShowpointsClick(Sender: TObject);
    procedure mShowlinesClick(Sender: TObject);

    procedure mOnDrawEndClick(Sender: TObject);
    procedure mOnFieldDrawClick(Sender: TObject);

    procedure mStartScanClick(Sender: TObject);
    procedure mAbortScanClick(Sender: TObject);
    procedure mScanParamsClick(Sender: TObject);

    procedure mZVClick(Sender: TObject);
    procedure mZHClick(Sender: TObject);
    procedure mZBClick(Sender: TObject);
    procedure mZNClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure mShowticksClick(Sender: TObject);
    procedure mShowtikslabelClick(Sender: TObject);
    procedure mInversionClick(Sender: TObject);
    procedure mShowcaptionClick(Sender: TObject);

  private
    { Private declarations }
    Checks: array [0..4] of TCheckBox;
    DANI:boolean;
    procedure ShowHint(Sender: TObject);
    procedure EndScan;
    procedure PrepareToScan;
    procedure NewTimerScan;
    procedure WMDANI;
  public
    { Public declarations }
   procedure StopTimerScan;
   procedure OnCustomPoint(x,y:integer);
{   procedure StartScan;}
  end;

var
  MainForm: TMainForm;

IMPLEMENTATION

uses About, AxisDlg, ScnPrmsDlg;

{$R *.DFM}

//procedure for quasi scan
var
 PntNum:integer;
 Cntr:integer;

procedure TMainForm.PrepareToScan;
var  j:integer;
begin
 StatusBar.Panels[0].Text:='';
 with SP do
 begin
  if bCod>eCod then  PntNum:=bCod-eCod+1
  else PntNum:=eCod-bCod+1;
 end;
 for j:=0 to 4 do with XYPlot.Series[j] as Tsp_xyLine do
 begin
  Clear;
  SetCapacity(PntNum);
 end;
 Cntr:=0;
 mStartScan.Enabled:=False;
 mScanParams.Enabled:=False;
end;

procedure TMainForm.EndScan;
begin
 mStartScan.Enabled:=True;
 mScanParams.Enabled:=True;
end;

procedure TMainForm.NewTimerScan;
var j:integer;
begin
 for j:=0 to 4 do with XYPlot.Series[j] as Tsp_xyLine do Clear;
 Cntr:=0;
 Timer.Enabled:=True;
end;

procedure TMainForm.StopTimerScan;
begin
 Timer.Enabled:=False;
 EndScan;
end;

procedure TMainForm.TimerTimer(Sender: TObject);
var j:integer;
//Random(4095)
begin
 if DANI then
 begin
   Timer.Enabled:=False;   DANI:=False;   WMDANI;
 end else
 try
   Inc(Cntr);
   for j:=0 to 4 do Tsp_xyLine(XYPlot.Series[j]).AddXY(Cntr, (j-2)*Cntr+Random(2));
   if Cntr=PntNum then StopTimerScan;
 except
  StopTimerScan;
  raise;
 end;
end;

//plot line animation
const sn=32;

procedure TMainForm.WMDANI;
var j:integer;  ts:integer;
begin
 with XYPlot.BottomAxis do for j:=0 to 63 do
 begin
  ts:=timeGetTime;
  MoveMinMax(0.5);
  XYPlot.Update;
  while (timeGetTime-ts)<20 do begin end;
 end;
 Tsp_XYLine(XYPlot.Series[4]).PointAttr.Visible:=True;
 XYPlot.Update;
 ts:=timeGetTime; while (timeGetTime-ts)<800 do begin end;
 Tsp_XYLine(XYPlot.Series[4]).PointAttr.Visible:=False;
  XYPlot.Update;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var j:integer;
 procedure CreateCurve(gb: TCheckBox);
 begin
   with Tsp_XYLine.Create(gb.Owner) do begin
    LineAttr.Color:=gb.Font.Color;
    Active:=gb.Checked;
    Plot:=XYPlot;
    AddXY(3,0.1); AddXY(11,0.1);
    AddXY(19,0.1); AddXY(29,0.1);
   end;
 end;
 procedure FillChecks;
 begin
  Checks[0]:=CheckBox1;
  Checks[1]:=CheckBox2;
  Checks[2]:=CheckBox3;
  Checks[3]:=CheckBox4;
  Checks[4]:=CheckBox5;
 end;
 procedure FillBySin;
 var j:integer;  d:double;
 begin
   d:=4*Pi/31;
   (XYPlot.Series[4] as Tsp_XYLine).Clear;
   for j:=0 to 31 do with XYPlot.Series[4] as Tsp_XYLine do
   begin
     AddXY(j,8*sin(d*j));
   end;
 end;
begin //FormCreate
 FillChecks;
 for j:=0 to 4 do CreateCurve(Checks[j]);
 mBufferedDisplay.Checked:=XYPlot.BufferedDisplay;
 Application.OnHint:=ShowHint;
 for j:=0 to 3 do with XYPlot.Series[j] as Tsp_XYLine do
 with PointAttr do begin
  Kind:=TPointKind(j);
  HSize:=9; VSize:=9;
  Color:=clOlive;
 end;
 with XYPlot.Series[4] as Tsp_XYLine do
 begin
  OnDrawCustomPoint:=OnCustomPoint;
  with PointAttr do Kind:=ptCustom;
 end;
 with SpinEdit1, XYPlot do
 begin
  LeftAxis.TicksCount:=Value;
  BottomAxis.TicksCount:=Value;
 end;
 FillBySin;
end;  //FormCreate

procedure TMainForm.FormShow(Sender: TObject);
begin
 DANI:=True;
 Timer.Enabled:=True;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 //stop scan on exit
 if not mStartScan.Enabled then  mAbortScanClick(Sender);
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
 StatusBar.Panels[1].Text:=GetLongHint(Application.Hint);
end;

procedure TMainForm.CheckBoxClick(Sender: TObject);
begin
 with Sender as TCheckBox do
 begin
  XYPlot.Series[Tag].Active:=Checked;
 end;
end;

procedure TMainForm.SpinEdit1Change(Sender: TObject);
begin
  with Sender as TSpinEdit, XYPlot do
  begin
   LeftAxis.TicksCount:=Value;
   BottomAxis.TicksCount:=Value;
  end;
end;

procedure TMainForm.chkbInvXClick(Sender: TObject);
begin
  with Sender as TCheckBox, XYPlot do
   BottomAxis.Inversed:=Checked;
end;

{* draw custom points handler *}

procedure TMainForm.OnCustomPoint(x,y:integer);
begin
 with ImgLst do
 begin
  Draw(XYPlot.DCanvas, x-width div 2, y-height div 2, 0);
 end;
end;

{* XYPlot events handlers*}

procedure TMainForm.XYPlotMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
 with StatusBar, XYPlot do
  Panels[0].Text:=Format('X %3.1f  Y %3.1f',
  [BottomAxis.P2V(X), LeftAxis.P2V(Y)])
end;

const
 EDS='Title is drawn by OnDrawEnd Event Handler';


procedure TMainForm.XYPlotFieldDraw(Sender: TObject);
begin
  if Not mOnFieldDraw.Checked then Exit;
  with Sender as Tsp_xyPlot do
  with DCanvas do
  begin
    Pen.Color:=clYellow;
    Pen.Width:=1;
    with FieldRect do
    begin
      MoveTo((Left+Right) div 2+2, Top+1);
      LineTo((Left+Right) div 2+2, Bottom-1);
      MoveTo(Left+1, (Bottom+Top) div 2+1);
      LineTo(Right-1, (Bottom+Top) div 2+1);
      Font.Color:=clTeal;
      Font.Style:=[fsBold];
      TextOut((Left+Right) div 2+3, (Bottom+Top) div 2+3, 'OnFieldDraw');
    end;
  end
end;


procedure TMainForm.XYPlotDrawEnd(Sender: TObject);
begin
 if Not mOnDrawEnd.Checked then Exit;
 with Sender as Tsp_xyPlot do
  with DCanvas do
  begin
    Brush.Style:=bsClear;
    Font.Color:=clNavy;//clBlack;
    Font.Size:=10;
    Font.Style:=[fsBold];
    TextOut((Width-TextWidth(EDS))div 2,
             (TopAxis.Margin-TextHeight(EDS))div 2  , EDS);
  end;
end;

//disable zoom RightAxis and TopAxis - we don't use them
procedure TMainForm.XYPlotAxisZoom(Sender: Tsp_Axis; var min, max: Double;
  var CanZoom: Boolean);
begin
 with XYPlot do
  if (Sender=RightAxis) or (Sender=TopAxis) then CanZoom:=False;
end;

{* Menu handlers *}

//File

procedure TMainForm.mExitClick(Sender: TObject);
begin
 Close;
end;

//Copy

procedure TMainForm.mCopyPlotMFClick(Sender: TObject);
begin
 XYPlot.CopyToClipboardMetafile;
end;

procedure TMainForm.mCopyPlotDIBClick(Sender: TObject);
begin
 XYPlot.CopyToClipboardBitmap;
end;

//View

procedure TMainForm.mStndLimitsClick(Sender: TObject);
begin
 with XYPlot.BottomAxis, SP do
 begin
  SetMinMax(1,abs(SP.eCod-SP.bCod)+1);
 end;
 with XYPlot.LeftAxis do
 begin
  Min:=-XYPlot.BottomAxis.Max*2; Max:=-Min;
 end;
end;

procedure TMainForm.mSetLimitsClick(Sender: TObject);
begin
 SetPlotLimits(XYPlot);
end;

procedure TMainForm.mShowAllCurvesClick(Sender: TObject);
var j:integer;
begin
 for j:=0 to 4 do Checks[j].Checked:=True;
end;

procedure TMainForm.mHideAllCurvesClick(Sender: TObject);
 var j:integer;
begin
 for j:=0 to 4 do Checks[j].Checked:=False;
end;

procedure TMainForm.mBufferedDisplayClick(Sender: TObject);
begin
 mBufferedDisplay.Checked:=Not mBufferedDisplay.Checked;
 XYPlot.BufferedDisplay:=mBufferedDisplay.Checked;
end;

procedure TMainForm.mOnDrawEndClick(Sender: TObject);
begin
 mOnDrawEnd.Checked:=Not mOnDrawEnd.Checked;
 XYPlot.Invalidate;
end;

procedure TMainForm.mOnFieldDrawClick(Sender: TObject);
begin
 mOnFieldDraw.Checked:=Not mOnFieldDraw.Checked;
 XYPlot.Invalidate;
end;

procedure TMainForm.mShowpointsClick(Sender: TObject);
var pon:boolean; j:integer;
begin
 pon:=not(Sender as TMenuItem).Checked;
 (Sender as TMenuItem).Checked:=pon;
 for j:=0 to 4 do with XYPlot.Series[j] as Tsp_XYLine do
     PointAttr.Visible:=pon;
end;

procedure TMainForm.mShowlinesClick(Sender: TObject);
var pon:boolean; j:integer;
begin
 pon:=not(Sender as TMenuItem).Checked;
 (Sender as TMenuItem).Checked:=pon;
 for j:=0 to 4 do with XYPlot.Series[j] as Tsp_XYLine do
     LineAttr.Visible:=pon;
end;

//Record

procedure TMainForm.mStartScanClick(Sender: TObject);
begin
 mStndLimitsClick(Self);
 PrepareToScan;
 NewTimerScan;
end;

procedure TMainForm.mAbortScanClick(Sender: TObject);
begin
 StopTimerScan;
end;

procedure TMainForm.mScanParamsClick(Sender: TObject);
begin
 RunParamsDlg;
end;

//Zoom

procedure TMainForm.mZVClick(Sender: TObject);
begin
 mZV.Checked:=True;
 if mZV.Checked then XYPlot.Zoom:=zpdVertical
end;

procedure TMainForm.mZHClick(Sender: TObject);
begin
 mZH.Checked:=True;
 if mZH.Checked then XYPlot.Zoom:=zpdHorizontal;
end;

procedure TMainForm.mZBClick(Sender: TObject);
begin
 mZB.Checked:=True;
 if mZB.Checked then XYPlot.Zoom:=zpdBoth;
end;

procedure TMainForm.mZNClick(Sender: TObject);
begin
 mZN.Checked :=True;
 if mZN.Checked then XYPlot.Zoom:=zpdNone;
end;

//?
procedure TMainForm.mAboutClick(Sender: TObject);
begin
 AboutBox.ShowModal;
end;


procedure TMainForm.mPrintClick(Sender: TObject);
var EMF: TMetafile; MC: TMetafileCanvas;
    ar:double; R:TRect;
begin
 if Not PrintDialog1.Execute then Exit;
 EMF := TMetafile.Create;
 try
   with XYPlot do
   begin
     EMF.Width:=Width;    EMF.Height:=Height;
     MC:=TMetafileCanvas.Create(EMF, Canvas.Handle);
     try
       DrawPlot(MC, Width, Height);
     finally
       MC.Free;
     end;
     ar:=Height/Width;
   end;
   with Printer, R do
   begin
     Top:=0;     Left:=0;
     if ar<1 then
     begin
       Right:=round(PageWidth*0.4);
       Bottom:=round(Right*ar);
     end else
     begin
       Bottom:=round(PageHeight*0.4);
       Right:=round(Bottom/ar);
     end;
     OffsetRect(R,(PageWidth - Right) div 2, (PageHeight - Bottom) div 2);
   end;
   with Printer do
   begin
     BeginDoc;
     Canvas.StretchDraw(R, EMF);
     EndDoc;
   end;
 finally
   EMF.Free;
 end;
end;




procedure TMainForm.mShowticksClick(Sender: TObject);
begin
 with Sender as TMenuItem do
 begin
  Checked:=Not(Checked);
  XYPlot.BottomAxis.NoTicks:=Not(Checked);
 end;
end;

procedure TMainForm.mShowtikslabelClick(Sender: TObject);
begin
 with Sender as TMenuItem do
 begin
  Checked:=Not(Checked);
  XYPlot.BottomAxis.NoTicksLabel:=Not(Checked);
 end;
end;

procedure TMainForm.mInversionClick(Sender: TObject);
begin
 with Sender as TMenuItem do
 begin
  Checked:=Not(Checked);
  XYPlot.BottomAxis.Inversed:=Checked;
 end;
end;

const s='Bottom Axis';

procedure TMainForm.mShowcaptionClick(Sender: TObject);
begin
 with Sender as TMenuItem do
 begin
  Checked:=Not(Checked);
  if Checked then XYPlot.BottomAxis.Caption:=s
  else XYPlot.BottomAxis.Caption:='';
 end;
end;

END.

